/*
 * Decompiled with CFR 0.152.
 */
package com.imin.printerlib;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresApi;
import b.a.a.a;
import b.a.a.e.b;
import com.imin.printerlib.Callback;
import com.imin.printerlib.QRCodeInfo;
import com.imin.printerlib.print.PrintUtils;
import com.imin.printerlib.util.BluetoothUtil;
import com.imin.printerlib.util.BmpUtils;
import com.imin.printerlib.util.BytesUtil;
import com.imin.printerlib.util.Utils;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class IminPrintUtils {
    public static final String TAG = "IminPrintUtils";
    public static int textWidth = 384;
    public static int bitmapWidth = 576;
    public static b.a.a.i.c usbPrinter;
    public static IminPrintUtils iminPrintUtils;
    public static a bluetoothPrintUtil;
    public static int connectType = -1;
    public static Context mContext;
    public static volatile int printerStatus = -1;
    public static ConcurrentLinkedQueue<b> printQueueList;
    public static volatile int statusUsb;
    public static boolean isInitSpi;
    public static volatile int printResult;
    public TextPaint textPaint;
    public int textSize = 28;
    public int defaultTextSize = 28;
    public boolean haveUnderline = false;
    public boolean haveBold = false;
    public float lineHeightRatio;
    public int fontSizeStyle = 0;
    public int underlineStyle;
    public int lineHeighSize;
    public float textLineSpacing = 1.0f;
    public String sModel = "";
    public e sOnBroadcastReciver;
    public Typeface textTypeface = Typeface.DEFAULT;
    public int textStyle = 0;
    public Layout.Alignment textAlignment = Layout.Alignment.ALIGN_NORMAL;
    public List<Layout.Alignment> mAlignments = new ArrayList<Layout.Alignment>();
    public StringBuilder stringBuilder;
    public List<b.a.a.e.c> textBean = new ArrayList<b.a.a.e.c>();
    public BluetoothSocket mSocket;
    public b.a.a.k.c mComPort;
    public boolean serialInit = false;
    public volatile boolean haveCache;
    public Disposable statusDisposable;
    public b.a.a.b printThread;
    public f statusThread;
    public boolean initIminPrinter = true;
    public Callback mCallBack;
    public Callback mCallBack1;
    public Bitmap bitmapTab;
    public byte[] antiWhite;
    public byte[] printBmpBytes;
    public List<b> printBeanList;
    public int result = -1;
    public int tQRSize = 4;
    public int tQR1MaginLeft = 32;
    public int tQR2MaginLeft = -64;
    public int tQR1Level = 0;
    public int tQR2Level = 0;
    public int tQR1Version = 0;
    public int tQR2Version = 0;
    public Disposable disposable;

    public static int getBitmapWidth() {
        return bitmapWidth;
    }

    public static synchronized void setPrinterStatus(int n2) {
        printerStatus = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IminPrintUtils getInstance(Context context) {
        Class<IminPrintUtils> clazz = IminPrintUtils.class;
        synchronized (IminPrintUtils.class) {
            if (iminPrintUtils == null) {
                iminPrintUtils = new IminPrintUtils(context);
                return iminPrintUtils;
            }
        }
    }

    public IminPrintUtils(Context context) {
        if (usbPrinter == null) {
            usbPrinter = new b.a.a.i.c(context);
        }
        IminPrintUtils iminPrintUtils = this;
        mContext = context;
        iminPrintUtils.serialInit = false;
        isInitSpi = false;
        iminPrintUtils.sModel = Utils.getModel();
        iminPrintUtils.initParams();
        if (iminPrintUtils.sModel.startsWith("M2-Max") || this.sModel.startsWith("Swift 1")) {
            IntentFilter intentFilter;
            this.sOnBroadcastReciver = new e();
            context = intentFilter;
            new IntentFilter().addAction("android.intent.action.SCREEN_ON");
            context.addAction("android.intent.action.SCREEN_OFF");
            mContext.registerReceiver((BroadcastReceiver)this.sOnBroadcastReciver, (IntentFilter)context);
        }
    }

    private void initPort() {
        Log.d((String)TAG, (String)("  serialInit:" + this.serialInit));
        if (this.serialInit) {
            return;
        }
        IminPrintUtils iminPrintUtils = this;
        String string = Build.MODEL;
        iminPrintUtils.serialInit = true;
        Log.i((String)TAG, (String)"  initPort");
        b.a.a.k.e.b();
        iminPrintUtils.mComPort = b.a.a.k.c.j();
        if (TextUtils.equals((CharSequence)"M2-Pro", (CharSequence)string)) {
            this.mComPort.e("/dev/ttyS0");
        } else {
            this.mComPort.e("/dev/ttyMT1");
        }
        IminPrintUtils iminPrintUtils2 = this;
        iminPrintUtils2.mComPort.c("115200");
        b.a.a.k.e.a(iminPrintUtils2.mComPort, mContext);
        Log.d((String)TAG, (String)("  initPort:" + this.mComPort.f()));
    }

    public static b.a.a.i.c getUsbPrinter() {
        if (usbPrinter == null) {
            usbPrinter = new b.a.a.i.c(mContext);
            IminPrintUtils.initializePrinter();
        }
        return usbPrinter;
    }

    private void initModel() {
        String string = Utils.getModel();
        if (!(string.contains("M2") || string.equals("D1") || Utils.getModel().equals("D1-Pro") || string.contains("Swift") || string.contains("D3-510"))) {
            this.setPageFormat(0);
        } else {
            this.setPageFormat(1);
        }
    }

    public static void initializePrinter() {
        Log.i((String)TAG, (String)"initializePrinter");
        int n2 = connectType;
        if (n2 == 0) {
            if (usbPrinter == null) {
                usbPrinter = new b.a.a.i.c(mContext);
            }
            n2 = 2;
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = 27;
            nArray[1] = 64;
            byte[] byArray = new byte[2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = (byte)nArray2[i2];
            }
            Utils.addPrintList(byArray, usbPrinter, 1);
        } else if (2 == n2) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(27, 64));
        } else if (3 == n2) {
            Utils.addPrintList(IminPrintUtils.intToByte(27, 64), null, 1);
            if (!isInitSpi) {
                PrintUtils.printSPISelfByte(new byte[]{29, 2, 9, 0});
                PrintUtils.printSPISelfByte(new byte[]{29, 2, 10, 1});
                isInitSpi = true;
            }
        }
    }

    public static void checkLegality(int n2) throws IllegalArgumentException {
        if (n2 >= 0 && n2 <= 255) {
            return;
        }
        throw new IllegalArgumentException("Parameter invalid " + n2);
    }

    private void printBitmapText(String string, boolean n2) {
        Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 printBitmapText  " + string));
        Log.d((String)TAG, (String)"getPrinterStatus spi    \u9a8c\u8bc1\u7a0b\u5e8f\u7684\u521d\u59cb   printBitmapText\u3001\u3001\u3001\u3001\u3001\u3001\u3001");
        string = n2 == 1 ? this.getAntiWhiteTextBitmap(string) : this.getTextBitmap(string);
        this.bitmapTab = string;
        n2 = connectType;
        if (n2 != 0 && 3 != n2) {
            this.printBitmaps(Collections.singletonList(string));
        } else {
            Utils.addPrintListBitmap((Bitmap)string, usbPrinter, 26);
        }
    }

    private void printCache() {
        StringBuilder stringBuilder = this.stringBuilder;
        if (stringBuilder != null && stringBuilder.length() > 0 && this.haveCache) {
            IminPrintUtils iminPrintUtils = this;
            iminPrintUtils.printBitmapText(iminPrintUtils.stringBuilder.toString(), false);
            StringBuilder stringBuilder2 = iminPrintUtils.stringBuilder;
            stringBuilder2.delete(0, stringBuilder2.length());
            iminPrintUtils.haveCache = false;
        }
    }

    public static byte[] PrintNvbmp(int n2, int n3) {
        byte[] byArray = new byte[4];
        int n4 = n3 < 48 ? 48 : n3;
        if (n3 > 51) {
            n4 = 51;
        }
        byArray[0] = 28;
        byArray[1] = 112;
        byArray[2] = (byte)n2;
        byArray[3] = (byte)n4;
        return byArray;
    }

    public static byte[] SetNvbmp(int n2, String string) {
        Log.i((String)"xgh****", (String)("var1==> " + string + "   ,var0==> " + n2));
        byte[] byArray = new QRCodeInfo().SetNvbmp(n2, string);
        if (byArray == null) {
            byArray = null;
        }
        return byArray;
    }

    private void printBitmaps(List<Bitmap> object, int n2) {
        object = object.iterator();
        while (object.hasNext()) {
            int n3;
            Object object2 = (Bitmap)object.next();
            int n4 = object2.getHeight();
            int n5 = object2.getWidth();
            if (n5 > (n3 = bitmapWidth)) {
                int n6 = n5 > n3 ? n3 : n5;
                if (n5 > n3) {
                    n4 = n4 * n3 / n5;
                }
                object2 = Bitmap.createScaledBitmap((Bitmap)object2, (int)n6, (int)n4, (boolean)true);
            }
            if (n2 == 0) {
                this.setLeftMargin(0);
            } else if (1 == n2) {
                this.setLeftMargin((bitmapWidth - object2.getWidth()) / 2);
            } else if (2 == n2) {
                this.setLeftMargin(bitmapWidth - object2.getWidth());
            }
            object2 = BmpUtils.cutBitmap(120, (Bitmap)object2).iterator();
            while (object2.hasNext()) {
                a a2;
                b.a.a.k.c c2;
                Bitmap bitmap;
                Bitmap bitmap2 = bitmap = (Bitmap)object2.next();
                int n7 = bitmap2.getWidth();
                byte[] byArray = BmpUtils.printDiskImagefile(BmpUtils.getPixelsByBitmap(bitmap), n7, bitmap2.getHeight());
                n5 = connectType;
                if (n5 == 0) continue;
                if (1 == n5 && (c2 = this.mComPort) != null && c2.f() && b.a.a.k.d.o) {
                    this.mComPort.a(byArray);
                    continue;
                }
                if (2 == connectType && (a2 = bluetoothPrintUtil) != null) {
                    a2.b(byArray);
                    continue;
                }
                if (3 != connectType) continue;
                PrintUtils.printSPISelfByte(byArray);
            }
        }
    }

    private void printBitmaps(List<Bitmap> object) {
        Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()===  " + object.size()));
        object = object.iterator();
        while (object.hasNext()) {
            int n2;
            Object object2 = (Bitmap)object.next();
            int n3 = object2.getHeight();
            int n4 = object2.getWidth();
            if (n4 > (n2 = bitmapWidth)) {
                int n5 = n4 > n2 ? n2 : n4;
                if (n4 > n2) {
                    n3 = n3 * n2 / n4;
                }
                object2 = Bitmap.createScaledBitmap((Bitmap)object2, (int)n5, (int)n3, (boolean)true);
            }
            object2 = BmpUtils.cutBitmap(120, (Bitmap)object2).iterator();
            while (object2.hasNext()) {
                a a2;
                b.a.a.k.c c2;
                Bitmap bitmap;
                Bitmap bitmap2 = bitmap = (Bitmap)object2.next();
                int n6 = bitmap2.getWidth();
                byte[] byArray = BmpUtils.printDiskImagefile(BmpUtils.getPixelsByBitmap(bitmap), n6, bitmap2.getHeight());
                n4 = connectType;
                if (n4 == 0) continue;
                if (1 == n4 && (c2 = this.mComPort) != null && c2.f() && b.a.a.k.d.o) {
                    this.mComPort.a(byArray);
                    continue;
                }
                if (2 != connectType || (a2 = bluetoothPrintUtil) == null) continue;
                a2.b(byArray);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void storeQrCodeDataInStorage(String object) {
        byte[] byArray;
        block26: {
            block25: {
                block24: {
                    if (TextUtils.isEmpty((CharSequence)object)) throw new NullPointerException("Qr code data cannot be empty");
                    byte[] byArray2 = ((String)object).getBytes("GBK");
                    object = byArray2;
                    if (byArray2.length > 255) throw new IllegalArgumentException("The length of the qr code data exceeds 255");
                    Object object2 = object;
                    Object object3 = object2;
                    Object object4 = object2;
                    int n2 = ((Object)object2).length + 3;
                    int n3 = n2 >> 8;
                    int n4 = n2 & 0xFF;
                    byte[] byArray3 = new byte[n2 + 5];
                    byArray = byArray3;
                    int n5 = n3;
                    byte[] byArray4 = byArray;
                    byte[] byArray5 = byArray;
                    byArray5[0] = 29;
                    byArray5[1] = 40;
                    byArray[2] = 107;
                    byte by = (byte)n4;
                    byArray4[3] = by;
                    byArray3[4] = (byte)n5;
                    byArray3[5] = 49;
                    byArray3[6] = 80;
                    byArray3[7] = 48;
                    n3 = 0;
                    n4 = 8;
                    int n6 = ((Object)object4).length;
                    System.arraycopy(object3, n3, byArray, n4, n6);
                    Log.d((String)TAG, (String)("usbPrinter  QrCodeData ==> " + Arrays.toString(byArray)));
                    if (connectType != 0) break block24;
                    Utils.addPrintList(byArray, usbPrinter, -1);
                    return;
                }
                if (1 != connectType) break block25;
                if (this.mComPort == null) break block25;
                if (!this.mComPort.f()) break block25;
                if (!b.a.a.k.d.o) break block25;
                this.mComPort.a(byArray);
                return;
            }
            if (2 != connectType) break block26;
            if (bluetoothPrintUtil == null) break block26;
            bluetoothPrintUtil.b(byArray);
            return;
        }
        if (3 != connectType) return;
        try {
            PrintUtils.printSPISelfByte(byArray);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    private Bitmap getTableBitMap(String[] stringArray, int[] nArray, int[] object, int n2, int[] nArray2, int n3) {
        Canvas canvas;
        Object object2;
        int n4;
        int n5;
        this.mAlignments.clear();
        for (n5 = 0; n5 < ((int[])object).length; ++n5) {
            n4 = object[n5];
            if (n4 != 0) {
                if (n4 != 1) {
                    if (n4 != 2) continue;
                    this.mAlignments.add(Layout.Alignment.ALIGN_OPPOSITE);
                    continue;
                }
                this.mAlignments.add(Layout.Alignment.ALIGN_CENTER);
                continue;
            }
            this.mAlignments.add(Layout.Alignment.ALIGN_NORMAL);
        }
        if (this.textPaint == null) {
            TextPaint textPaint;
            object = textPaint;
            textPaint = new TextPaint();
            this.textPaint = (TextPaint)object;
        }
        object = new int[n3];
        n5 = this.getTotal(nArray);
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray2 != null && nArray2.length == nArray.length) {
                this.setTextSize(nArray2[n4]);
            } else {
                this.setTextSize(28);
            }
            IminPrintUtils iminPrintUtils = this;
            String string = stringArray[n4];
            object2 = this.textPaint;
            int n6 = n2 * nArray[n4] / n5;
            Layout.Alignment alignment = iminPrintUtils.mAlignments.get(n4);
            float f2 = iminPrintUtils.textLineSpacing;
            object[n4] = new StaticLayout((CharSequence)string, object2, n6, alignment, f2, 0.0f, false).getHeight();
        }
        object = Bitmap.createBitmap((int)n2, (int)this.getMax((int[])object), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas2 = canvas;
        canvas = new Canvas((Bitmap)object);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray2 != null && nArray2.length == n3) {
                this.setTextSize(nArray2[i2]);
            } else {
                this.setTextSize(28);
            }
            IminPrintUtils iminPrintUtils = this;
            object2 = stringArray[i2];
            TextPaint textPaint = this.textPaint;
            int n7 = n2 * nArray[i2] / n5;
            Layout.Alignment alignment = iminPrintUtils.mAlignments.get(i2);
            float f3 = iminPrintUtils.textLineSpacing;
            new StaticLayout((CharSequence)object2, textPaint, n7, alignment, f3, 0.0f, false).draw(canvas2);
            canvas2.translate((float)(n2 * nArray[i2] / n5), 0.0f);
        }
        return object;
    }

    private Bitmap getAntiWhiteTextBitmap(String string) {
        StaticLayout staticLayout;
        if (iminPrintUtils4.textPaint == null) {
            TextPaint textPaint;
            TextPaint textPaint2 = textPaint;
            textPaint = new TextPaint();
            iminPrintUtils4.textPaint = textPaint2;
        }
        IminPrintUtils iminPrintUtils = iminPrintUtils4;
        iminPrintUtils.textPaint.setTextSize((float)iminPrintUtils4.textSize);
        iminPrintUtils.textPaint.setTypeface(iminPrintUtils4.textTypeface);
        iminPrintUtils.textPaint.setUnderlineText(iminPrintUtils4.haveUnderline);
        iminPrintUtils.textPaint.setFakeBoldText(iminPrintUtils4.haveBold);
        iminPrintUtils.setTextSize(iminPrintUtils.defaultTextSize);
        iminPrintUtils.sethaveBold(iminPrintUtils.haveBold);
        boolean bl = iminPrintUtils.underlineStyle == 1;
        IminPrintUtils iminPrintUtils2 = iminPrintUtils4;
        iminPrintUtils2.setUnderline(bl);
        iminPrintUtils2.setHaveLineHeight((float)(iminPrintUtils2.lineHeighSize + 100) / 100.0f);
        iminPrintUtils2.textPaint.setColor(-1);
        StaticLayout staticLayout2 = staticLayout;
        IminPrintUtils iminPrintUtils3 = iminPrintUtils4;
        IminPrintUtils iminPrintUtils4 = iminPrintUtils3.textPaint;
        int n2 = textWidth;
        Layout.Alignment alignment = iminPrintUtils3.textAlignment;
        float f2 = iminPrintUtils3.textLineSpacing;
        staticLayout = new StaticLayout((CharSequence)string, (TextPaint)iminPrintUtils4, n2, alignment, f2, 1.0f, false);
        iminPrintUtils4 = Bitmap.createBitmap((int)textWidth, (int)staticLayout2.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas((Bitmap)iminPrintUtils4);
        canvas.drawColor(-16777216);
        staticLayout2.draw(canvas);
        return iminPrintUtils4;
    }

    private Bitmap getTextBitmap(String string) {
        StaticLayout staticLayout;
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("getTextBitmap spi    \u9a8c\u8bc1\u7a0b\u5e8f\u7684\u521d\u59cb   printBitmapText\u3001\u3001\u5f00\u59cb\u5236\u4f5c\u6587\u5b57\u56fe\u7247\u3001\u3001\u3001\u3001\u3001");
        boolean bl = iminPrintUtils3.textPaint == null;
        Log.d((String)string2, (String)stringBuilder.append(bl).toString());
        if (iminPrintUtils3.textPaint == null) {
            TextPaint textPaint;
            string2 = textPaint;
            textPaint = new TextPaint();
            iminPrintUtils3.textPaint = string2;
        }
        IminPrintUtils iminPrintUtils = iminPrintUtils3;
        Log.i((String)TAG, (String)("textSize:" + iminPrintUtils3.textSize + " fontSizeStyle:=>" + iminPrintUtils3.fontSizeStyle + "  textTypeface:=>" + iminPrintUtils3.textTypeface.getStyle() + "haveUnderline=>" + iminPrintUtils3.haveUnderline + " ,textWidth=> " + textWidth + " ,haveBold=>  " + iminPrintUtils3.haveBold));
        iminPrintUtils.textPaint.setTextSize((float)iminPrintUtils3.textSize);
        iminPrintUtils.textPaint.setTypeface(iminPrintUtils3.textTypeface);
        iminPrintUtils.textPaint.setUnderlineText(iminPrintUtils3.haveUnderline);
        iminPrintUtils.textPaint.setFakeBoldText(iminPrintUtils3.haveBold);
        iminPrintUtils.textPaint.setColor(-16777216);
        string2 = staticLayout;
        IminPrintUtils iminPrintUtils2 = iminPrintUtils3;
        IminPrintUtils iminPrintUtils3 = iminPrintUtils2.textPaint;
        int n2 = textWidth;
        stringBuilder = iminPrintUtils2.textAlignment;
        float f2 = iminPrintUtils2.textLineSpacing;
        staticLayout = new StaticLayout((CharSequence)string, (TextPaint)iminPrintUtils3, n2, (Layout.Alignment)stringBuilder, f2, 1.0f, false);
        iminPrintUtils3 = Bitmap.createBitmap((int)textWidth, (int)string2.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        string2.draw(new Canvas((Bitmap)iminPrintUtils3));
        return iminPrintUtils3;
    }

    private String byte2HexStr(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2] & 0xFF);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuilder2.append(string);
        }
        return stringBuilder2.toString().toUpperCase().trim();
    }

    private byte[] PrintDiskImagefile(int[] nArray, int n2, int n3) {
        byte[] byArray = ((IminPrintUtils)object).getBMPImageFileByte(nArray, n2, n3);
        Object object = byArray;
        int n4 = byArray.length;
        if (n4 == 0) {
            return null;
        }
        byte[] byArray2 = new byte[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray2[n3] = (byte)object[n3];
        }
        return byArray2;
    }

    public static byte[] printDiskImagefile(int[] nArray, int n2, int n3) {
        byte[] byArray;
        int n4 = n2;
        n2 = n4 / 8;
        int n5 = n4 % 8;
        if (n5 > 0) {
            ++n2;
        }
        byte[] byArray2 = new byte[n2 * n3 + 8];
        byte[] byArray3 = byArray = byArray2;
        byte[] byArray4 = byArray;
        byArray3[0] = 29;
        byArray4[1] = 118;
        byArray3[2] = 48;
        byArray4[3] = 0;
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)n3;
        int n6 = 8;
        byArray2[7] = (byte)(n3 >> 8);
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            int n9;
            for (n9 = 0; n9 < n2 - 1; ++n9) {
                n8 = 0;
                if (nArray[n7++] < -1) {
                    n8 = 128;
                }
                if (nArray[n7++] < -1) {
                    n8 += 64;
                }
                if (nArray[n7++] < -1) {
                    n8 += 32;
                }
                if (nArray[n7++] < -1) {
                    n8 += 16;
                }
                if (nArray[n7++] < -1) {
                    n8 += 8;
                }
                if (nArray[n7++] < -1) {
                    n8 += 4;
                }
                if (nArray[n7++] < -1) {
                    n8 += 2;
                }
                if (nArray[n7++] < -1) {
                    // empty if block
                }
                int n10 = ++n8;
                n8 = n6 + 1;
                byArray[n6] = (byte)n10;
                n6 = n8;
            }
            n9 = 0;
            if (n5 == 0) {
                for (n8 = 8; n8 > n5; --n8) {
                    if (nArray[n7++] >= -1) continue;
                    n9 += 1 << n8;
                }
            } else {
                for (n8 = 0; n8 < n5; ++n8) {
                    if (nArray[n7++] >= -1) continue;
                    n9 += 1 << 8 - n8;
                }
            }
            int n11 = n9;
            n9 = n6 + 1;
            byArray[n6] = (byte)n11;
            n6 = n9;
        }
        return byArray;
    }

    private byte[] getBMPImageFileByte(int[] nArray, int n2, int n3) {
        byte[] byArray;
        int n4 = n2;
        int n5 = n4 / 8;
        n2 = n4 % 8;
        if (n2 > 0) {
            ++n5;
        }
        byte[] byArray2 = new byte[n5 * n3 + 8];
        byte[] byArray3 = byArray = byArray2;
        byte[] byArray4 = byArray;
        byArray3[0] = 29;
        byArray4[1] = 118;
        byArray3[2] = 48;
        byArray4[3] = 0;
        byArray[4] = (byte)n5;
        byArray[5] = (byte)(n5 >> 8);
        byArray[6] = (byte)n3;
        int n6 = 8;
        byArray2[7] = (byte)(n3 >> 8);
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            int n9;
            for (n9 = 0; n9 < n5 - 1; ++n9) {
                n8 = 0;
                if (nArray[n7++] < -1) {
                    n8 = 128;
                }
                if (nArray[n7++] < -1) {
                    n8 += 64;
                }
                if (nArray[n7++] < -1) {
                    n8 += 32;
                }
                if (nArray[n7++] < -1) {
                    n8 += 16;
                }
                if (nArray[n7++] < -1) {
                    n8 += 8;
                }
                if (nArray[n7++] < -1) {
                    n8 += 4;
                }
                if (nArray[n7++] < -1) {
                    n8 += 2;
                }
                if (nArray[n7++] < -1) {
                    // empty if block
                }
                int n10 = ++n8;
                n8 = n6 + 1;
                byArray[n6] = (byte)n10;
                n6 = n8;
            }
            n9 = 0;
            if (n2 == 0) {
                for (n8 = 8; n8 > n2; --n8) {
                    if (nArray[n7++] >= -1) continue;
                    n9 += 1 << n8;
                }
            } else {
                for (n8 = 0; n8 < n2; ++n8) {
                    if (nArray[n7++] >= -1) continue;
                    n9 += 1 << 8 - n8;
                }
            }
            int n11 = n9;
            n9 = n6 + 1;
            byArray[n6] = (byte)n11;
            n6 = n9;
        }
        return byArray;
    }

    private int getMax(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n2 > nArray[i2]) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    private int getTotal(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 += nArray[i2];
        }
        return n2;
    }

    public static byte[] intToByte(int ... nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            byArray[i2] = (byte)nArray[i2];
        }
        return byArray;
    }

    public static int getPrintResultStatus() {
        return printResult;
    }

    public static void setPrintResultStatus(int n2) {
        printResult = n2;
    }

    private int changeCommonStatus(int n2) {
        block10: {
            block7: {
                block8: {
                    block9: {
                        if (n2 == 0) break block7;
                        if (n2 == 1) break block8;
                        if (n2 == 3) break block9;
                        if (n2 == 18) break block7;
                        if (n2 != 22) {
                            if (n2 != 26) {
                                if (n2 != 7) {
                                    if (n2 == 8) {
                                        n2 = 8;
                                    }
                                } else {
                                    n2 = 7;
                                }
                            } else {
                                n2 = 5;
                            }
                        } else {
                            n2 = 99;
                        }
                        break block10;
                    }
                    n2 = 3;
                    break block10;
                }
                n2 = 1;
                break block10;
            }
            n2 = 0;
        }
        return n2;
    }

    public static /* synthetic */ Disposable access$202(IminPrintUtils iminPrintUtils, Disposable disposable) {
        iminPrintUtils.statusDisposable = disposable;
        return disposable;
    }

    public static /* synthetic */ b.a.a.k.c access$400(IminPrintUtils iminPrintUtils) {
        return iminPrintUtils.mComPort;
    }

    public static /* synthetic */ int access$002(int n2) {
        printerStatus = n2;
        return printerStatus;
    }

    public static /* synthetic */ int access$500(IminPrintUtils iminPrintUtils, int n2) {
        return iminPrintUtils.changeCommonStatus(n2);
    }

    public static /* synthetic */ boolean access$602(IminPrintUtils iminPrintUtils, boolean bl) {
        iminPrintUtils.serialInit = bl;
        return bl;
    }

    public static /* synthetic */ b.a.a.b access$302(IminPrintUtils iminPrintUtils, b.a.a.b b2) {
        iminPrintUtils.printThread = b2;
        return b2;
    }

    static {
        printQueueList = new ConcurrentLinkedQueue();
        statusUsb = -1;
        isInitSpi = false;
        printResult = 0;
    }

    public synchronized int getPrinterStatus() {
        return printerStatus;
    }

    public String getModel() {
        String string = this.sModel;
        if (string != null && string.length() > 0) {
            return this.sModel;
        }
        return Utils.getModel();
    }

    public boolean isInitIminPrinter() {
        return this.initIminPrinter;
    }

    public IminPrintUtils setInitIminPrinter(boolean bl) {
        this.initIminPrinter = bl;
        return this;
    }

    public void unRegisterReceiver() {
        e e2;
        if ((this.sModel.startsWith("M2-Max") || this.sModel.startsWith("Swift 1")) && (e2 = this.sOnBroadcastReciver) != null) {
            mContext.unregisterReceiver((BroadcastReceiver)e2);
        }
    }

    public void initPrinter(PrintConnectType printConnectType) {
        int n2;
        StringBuilder stringBuilder;
        Log.i((String)TAG, (String)(" SDK initPrinter:" + (Object)((Object)printConnectType)));
        if (this.printThread == null) {
            this.printThread = new b.a.a.b(mContext);
            this.printThread.start();
        }
        if ((stringBuilder = this.stringBuilder) != null) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        if ((n2 = c.a[printConnectType.ordinal()]) != 1) {
            if (n2 == 3) {
                connectType = 3;
                if (!this.serialInit) {
                    this.initPort();
                }
                IminPrintUtils.initializePrinter();
                if (this.statusThread == null) {
                    f f2;
                    f f3 = f2;
                    f3();
                    this.statusThread = f3;
                    f2.start();
                }
            }
        } else {
            String string = TAG;
            stringBuilder = new StringBuilder().append(" SDK initPrinter:8888==");
            ConcurrentLinkedQueue<b> concurrentLinkedQueue = printQueueList;
            boolean bl = concurrentLinkedQueue == null || concurrentLinkedQueue.size() == 0;
            Log.i((String)string, (String)stringBuilder.append(bl).toString());
            connectType = 0;
            if (usbPrinter == null) {
                usbPrinter = new b.a.a.i.c(mContext);
                usbPrinter.m();
            }
            IminPrintUtils.initializePrinter();
        }
        this.initModel();
    }

    public void initPrinter(PrintConnectType printConnectType, BluetoothDevice bluetoothDevice) throws IOException {
        if (printConnectType == PrintConnectType.BLUETOOTH) {
            connectType = 2;
            if (bluetoothDevice != null) {
                printConnectType = this.mSocket;
                if (printConnectType != null) {
                    printConnectType.close();
                }
                printConnectType = BluetoothUtil.connectDevice(bluetoothDevice);
                this.mSocket = printConnectType;
                if (printConnectType != null) {
                    bluetoothPrintUtil = new a(printConnectType.getOutputStream(), "GBK");
                    IminPrintUtils.initializePrinter();
                }
            }
        }
        this.initModel();
    }

    public void release() {
        this.serialInit = false;
        b.a.a.k.e.a();
        b.a.a.k.e.a(this.mComPort);
    }

    public void resetUSBDevice() {
        Object object = usbPrinter;
        if (object != null) {
            if (((b.a.a.i.c)object).n()) {
                usbPrinter.b();
            }
            usbPrinter = null;
        }
        if ((object = this.printThread) != null) {
            ((b.a.a.b)object).interrupt();
            this.printThread = null;
        }
    }

    public void resetDevice() {
        Object object = printQueueList;
        if (object == null || ((ConcurrentLinkedQueue)object).size() == 0) {
            object = usbPrinter;
            if (object != null) {
                if (((b.a.a.i.c)object).n()) {
                    usbPrinter.b();
                }
                usbPrinter = null;
            }
            if ((object = this.printThread) != null) {
                ((b.a.a.b)object).interrupt();
                this.printThread = null;
            }
            this.release();
        }
    }

    public void sendCommonCmd(int[] nArray) {
        b.a.a.k.c c2;
        int n2 = connectType;
        if (n2 == 0) {
            Utils.sendCommonCmd(usbPrinter, nArray);
        } else if (1 == n2 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils = object;
            Object object = IminPrintUtils.intToByte(nArray);
            iminPrintUtils.mComPort.a((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(nArray));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(nArray));
        }
    }

    public void openPower() {
        b.a.a.k.e.b();
    }

    public void closePower() {
        b.a.a.k.e.a();
    }

    public void printerPowerOff() {
        int n2 = connectType;
        if (n2 == 0) {
            Utils.sendCommonCmd(usbPrinter, 16, 20, 2, 1, 8);
        } else if (2 == n2) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(16, 20, 2, 1, 8));
        } else if (3 == n2) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(16, 20, 2, 1, 8));
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isSPIPrint() {
        if (TextUtils.equals((CharSequence)"M2-202", (CharSequence)Build.MODEL)) {
            return Utils.getSystemPropertiesBoolean("persist.sys.isSPI");
        }
        if (TextUtils.equals((CharSequence)"M2-Pro", (CharSequence)Build.MODEL)) {
            return true;
        }
        this = v0;
        var1_1 = new BufferedReader(new FileReader("/proc/neostra_hw_info")).readLine();
        if (var1_1 == null) ** GOTO lbl14
        Log.d((String)"IminPrintUtils", (String)("hasSPI" + var1_1.contains("SPI=ON")));
        try {
            return var1_1.contains("SPI=ON");
lbl14:
            // 1 sources

            this.close();
        }
        catch (Exception v1) {
            v1.printStackTrace();
        }
        return false;
    }

    public int getPrinterStatus(PrintConnectType printConnectType) {
        int n2 = c.a[printConnectType.ordinal()];
        if (n2 != 1) {
            if (n2 != 3) {
                return -1;
            }
            return printerStatus;
        }
        Log.d((String)TAG, (String)("\u83b7\u53d6\u6253\u5370\u72b6\u6001    usbPrinter    1  5555 IminPrintUtils.connectType== " + connectType));
        if (connectType == 0) {
            return IminPrintUtils.getUsbPrinter().l();
        }
        return -1;
    }

    public void setmCallBack(Callback callback) {
        this.mCallBack = callback;
    }

    public void getPrinterStatus(PrintConnectType enum_, final Callback callback) {
        if (enum_ != PrintConnectType.SPI) {
            return;
        }
        if (this.statusDisposable != null) {
            Log.d((String)TAG, (String)("getPrinterStatus spi 3333-->" + printerStatus));
            this.statusDisposable.dispose();
            this.statusDisposable = null;
        }
        Log.d((String)TAG, (String)"getPrinterStatus spi 44444   3333-->\u67e5\u8be2\u6253\u5370\u673a\u72b6\u6001\u67e5\u8be2\u67e5\u8be2\u67e5\u8be2\u3001\u3001\u3001\u3001\u3001\u3001\u3001");
        printResult = 0;
        IminPrintUtils.setPrintResultStatus(0);
        PrintUtils.printSPISelfByte(new byte[]{16, 4, 1});
        enum_ = TimeUnit.MILLISECONDS;
        this.statusDisposable = Observable.timer((long)500L, (TimeUnit)enum_).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void a(Long l2) throws Exception {
                if (IminPrintUtils.this.mCallBack != null) {
                    Log.d((String)IminPrintUtils.TAG, (String)("getPrinterStatus spi 22-->" + IminPrintUtils.this.getPrinterStatus() + "   ,printerStatus==> " + printerStatus + " ,statusThread  " + ((IminPrintUtils)IminPrintUtils.this).statusThread.b));
                    Log.d((String)IminPrintUtils.TAG, (String)("getPrinterStatus spi 22-status->" + PrintUtils.getPrintStatus()));
                    if (printerStatus == -1 && PrintUtils.getPrintStatus() == -1) {
                        callback.callback(-1);
                    } else if (printerStatus == -1) {
                        callback.callback(PrintUtils.getPrintStatus());
                    } else if (PrintUtils.getPrintStatus() == -1) {
                        callback.callback(printerStatus);
                    } else {
                        callback.callback(PrintUtils.getPrintStatus());
                    }
                }
                IminPrintUtils.access$202(IminPrintUtils.this, null);
            }
        });
    }

    public void getPrinterStatus(PrintConnectType enum_, boolean bl, final Callback callback) {
        if (enum_ != PrintConnectType.SPI) {
            return;
        }
        if (this.statusDisposable != null) {
            Log.d((String)TAG, (String)("getPrinterStatus spi 3333-->" + printerStatus));
            this.statusDisposable.dispose();
            this.statusDisposable = null;
        }
        Log.d((String)TAG, (String)"getPrinterStatus spi 44444   3333-->\u67e5\u8be2\u6253\u5370\u673a\u72b6\u6001\u67e5\u8be2\u67e5\u8be2\u67e5\u8be2\u3001\u3001\u3001\u3001\u3001\u3001\u3001");
        if (bl) {
            printerStatus = -1;
            PrintUtils.setPrintStatus(printerStatus);
            printResult = 0;
            IminPrintUtils.setPrintResultStatus(0);
        }
        PrintUtils.printSPISelfByte(new byte[]{16, 4, 1});
        enum_ = TimeUnit.MILLISECONDS;
        this.statusDisposable = Observable.timer((long)500L, (TimeUnit)enum_).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void a(Long l2) throws Exception {
                if (callback != null) {
                    Log.d((String)IminPrintUtils.TAG, (String)("getPrinterStatus spi 22-->" + IminPrintUtils.this.getPrinterStatus() + "   ,printerStatus==> " + printerStatus));
                    Log.d((String)IminPrintUtils.TAG, (String)("getPrinterStatus spi 22-status->" + PrintUtils.getPrintStatus()));
                    if (printerStatus == -1 && PrintUtils.getPrintStatus() == -1 && ((IminPrintUtils)IminPrintUtils.this).printThread.f == -1) {
                        callback.callback(-1);
                    } else if (printerStatus == -1) {
                        callback.callback(PrintUtils.getPrintStatus());
                    } else if (PrintUtils.getPrintStatus() == -1) {
                        callback.callback(printerStatus);
                    } else {
                        callback.callback(((IminPrintUtils)IminPrintUtils.this).printThread.f);
                    }
                }
                IminPrintUtils.access$202(IminPrintUtils.this, null);
            }
        });
    }

    public void printAndLineFeed() {
        b.a.a.k.c c2;
        int n2 = connectType;
        if (n2 == 0) {
            Utils.sendCommonCmd(IminPrintUtils.getUsbPrinter(), 10);
        } else if (1 == n2 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils = object;
            Object object = IminPrintUtils.intToByte(10);
            iminPrintUtils.mComPort.a((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(10));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(10));
        }
    }

    public void printAndFeedPaper(int n2) {
        b.a.a.k.c c2;
        Log.d((String)TAG, (String)"getPrinterStatus spi    \u9a8c\u8bc1\u7a0b\u5e8f\u7684\u521d\u59cb   printAndFeedPaper\u3001\u3001\u3001\u3001\u3001\u3001\u3001");
        IminPrintUtils.checkLegality(n2);
        int n3 = connectType;
        if (n3 == 0) {
            Utils.sendCommonCmd(usbPrinter, 27, 74, n2);
        } else if (1 == n3 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils = object;
            Object object = IminPrintUtils.intToByte(27, 74, n2);
            iminPrintUtils.mComPort.a((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(27, 74, n2));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(27, 74, n2));
        }
    }

    public void fullCut() {
        b.a.a.k.c c2;
        int n2 = connectType;
        if (n2 == 0) {
            Utils.sendCommonCmd(usbPrinter, 29, 86, 0);
        } else if (1 == n2 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils = object;
            Object object = IminPrintUtils.intToByte(29, 86, 0);
            iminPrintUtils.mComPort.a((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(29, 86, 0));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(29, 86, 0));
        }
    }

    public void partialCut() {
        b.a.a.k.c c2;
        int n2 = connectType;
        if (n2 == 0) {
            Utils.sendCommonCmd(usbPrinter, 29, 86, 1);
        } else if (1 == n2 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils = object;
            Object object = IminPrintUtils.intToByte(29, 86, 1);
            iminPrintUtils.mComPort.a((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(29, 86, 1));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(29, 86, 1));
        }
    }

    public void sendRAWData(int[] objectArray) {
        objectArray = IminPrintUtils.intToByte(objectArray);
        int n2 = connectType;
        if (n2 == 0) {
            Utils.addPrintList((byte[])objectArray, usbPrinter, -1);
        } else if (1 == n2) {
            b.a.a.k.c c2 = ((IminPrintUtils)((Object)a2)).mComPort;
            if (c2 != null && c2.f() && b.a.a.k.d.o) {
                ((IminPrintUtils)((Object)a2)).mComPort.a((byte[])objectArray);
            }
        } else if (2 == n2) {
            a a2 = bluetoothPrintUtil;
            if (a2 != null) {
                a2.b((byte[])objectArray);
            }
        } else if (3 == n2) {
            PrintUtils.printSPISelfByte((byte[])objectArray);
        }
    }

    public void sendRAWData(String object) {
        object = a.a.a.a((String)object);
        int n2 = connectType;
        if (n2 == 0) {
            Utils.addPrintList((byte[])object, usbPrinter, -1);
        } else if (1 == n2) {
            b.a.a.k.c c2 = ((IminPrintUtils)((Object)a2)).mComPort;
            if (c2 != null && c2.f() && b.a.a.k.d.o) {
                ((IminPrintUtils)((Object)a2)).mComPort.a((byte[])object);
            }
        } else if (2 == n2) {
            a a2 = bluetoothPrintUtil;
            if (a2 != null) {
                a2.b((byte[])object);
            }
        } else if (3 == n2) {
            PrintUtils.printSPISelfByte((byte[])object);
        }
    }

    public void sendRAWData(byte[] byArray) {
        int n2 = connectType;
        if (n2 == 0) {
            Utils.addPrintList(byArray, usbPrinter, -1);
        } else if (1 == n2) {
            b.a.a.k.c c2 = ((IminPrintUtils)((Object)a2)).mComPort;
            if (c2 != null && c2.f() && b.a.a.k.d.o) {
                ((IminPrintUtils)((Object)a2)).mComPort.a(byArray);
            }
        } else if (2 == n2) {
            a a2 = bluetoothPrintUtil;
            if (a2 != null) {
                a2.b(byArray);
            }
        } else if (3 == n2) {
            PrintUtils.printSPISelfByte(byArray);
        }
    }

    public Bitmap getPrintTabBitmap() {
        return this.bitmapTab;
    }

    public void printText(String string, int n2) {
        if (string != null && string.length() != 0 && !string.equals("") && !string.equals("null")) {
            if (n2 == 0) {
                this.printText(string);
            } else if (1 == n2) {
                this.printBitmapText(string, false);
            }
            return;
        }
    }

    public void printAntiWhiteText(String string, int n2) {
        if (string != null && string.length() != 0 && !string.equals("") && !string.equals("null")) {
            if (n2 == 0) {
                this.printAntiWhiteText(string);
            } else if (1 == n2) {
                this.printBitmapText(string, true);
            }
            return;
        }
    }

    public void printText(String string) {
        Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 printText1111  " + string));
        if (string != null && string.length() != 0 && !string.equals("") && !string.equals("null")) {
            if (string.contains("\n") && string.endsWith("\n")) {
                if (this.haveCache) {
                    this.printCache();
                }
                if (string.length() > 1) {
                    String string2 = string;
                    string = string2.substring(0, string2.length() - 1);
                }
                Log.e((String)TAG, (String)("printText2222  " + string));
                this.printBitmapText(string, false);
            } else {
                if (this.stringBuilder == null) {
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder = new StringBuilder();
                    this.stringBuilder = stringBuilder2;
                }
                this.haveCache = true;
                this.stringBuilder.append(string);
            }
            return;
        }
    }

    public void printAntiWhiteTextToRAW(String[] stringArray) {
        Log.e((String)TAG, (String)"\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 ooooo 1111  ");
        if (stringArray != null && stringArray.length > 0) {
            this.sendRAWData("1D42011B3300");
            this.antiWhite = new byte[0];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                byte[] byArray = stringArray[i2].getBytes();
                this.antiWhite = BytesUtil.mergeBytes(this.antiWhite, byArray);
                this.antiWhite = BytesUtil.mergeBytes(this.antiWhite, new byte[]{10});
            }
            IminPrintUtils iminPrintUtils = this;
            Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 ooooo   " + BytesUtil.getHexStringFromBytes(this.antiWhite)));
            iminPrintUtils.sendRAWData(iminPrintUtils.antiWhite);
            iminPrintUtils.sendRAWData("1D4200");
        }
    }

    public void printAntiWhiteText(String string) {
        Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 printText1111  " + string));
        if (string != null && string.length() != 0 && !string.equals("") && !string.equals("null")) {
            if (string.contains("\n") && string.endsWith("\n")) {
                if (this.haveCache) {
                    this.printCache();
                }
                if (string.length() > 1) {
                    String string2 = string;
                    string = string2.substring(0, string2.length() - 1);
                }
                Log.e((String)TAG, (String)("printText2222  " + string));
                this.printBitmapText(string, true);
            } else {
                if (this.stringBuilder == null) {
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder = new StringBuilder();
                    this.stringBuilder = stringBuilder2;
                }
                this.haveCache = true;
                this.stringBuilder.append(string);
            }
            return;
        }
    }

    public void setCodeAlignment(int n2) {
        b.a.a.k.c c2;
        int n3;
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            n2 = 0;
        }
        if ((n3 = connectType) == 0) {
            PrintUtils.setAlignment(usbPrinter, n2);
        } else if (1 == n3 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils = object;
            Object object = IminPrintUtils.intToByte(27, 97, n2);
            iminPrintUtils.mComPort.b((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(27, 97, n2));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(27, 97, n2));
        }
    }

    public IminPrintUtils setAlignment(int n2) {
        Log.d((String)"test_1_22", (String)("setAlignment   " + n2));
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    this.textAlignment = Layout.Alignment.ALIGN_OPPOSITE;
                }
            } else {
                this.textAlignment = Layout.Alignment.ALIGN_CENTER;
            }
        } else {
            this.textAlignment = Layout.Alignment.ALIGN_NORMAL;
        }
        return this;
    }

    public IminPrintUtils setUnderline(boolean bl) {
        this.haveUnderline = bl;
        if (this.textPaint == null) {
            TextPaint textPaint;
            TextPaint textPaint2 = textPaint;
            textPaint = new TextPaint();
            this.textPaint = textPaint2;
        }
        if (this.underlineStyle == 1) {
            this.textPaint.setUnderlineText(true);
        } else {
            this.textPaint.setUnderlineText(bl);
        }
        return this;
    }

    public IminPrintUtils sethaveBold(boolean bl) {
        this.haveBold = bl;
        if (this.textPaint == null) {
            TextPaint textPaint;
            TextPaint textPaint2 = textPaint;
            textPaint = new TextPaint();
            this.textPaint = textPaint2;
        }
        IminPrintUtils iminPrintUtils = this;
        iminPrintUtils.textPaint.setFakeBoldText(bl);
        return iminPrintUtils;
    }

    public IminPrintUtils setHaveLineHeight(float f2) {
        if (f2 < 0.0f || f2 == 0.0f) {
            f2 = 1.0f;
        }
        this.lineHeightRatio = f2;
        Log.d((String)TAG, (String)("textLineSpacing:" + f2));
        return this;
    }

    public IminPrintUtils setTextSize(int n2) {
        this.defaultTextSize = n2;
        if (this.textPaint == null) {
            TextPaint textPaint;
            TextPaint textPaint2 = textPaint;
            textPaint = new TextPaint();
            this.textPaint = textPaint2;
        }
        if ((n2 = this.fontSizeStyle) == 0) {
            this.textSize = this.defaultTextSize;
        } else if (n2 == 1) {
            this.textSize = this.defaultTextSize + 10;
        } else if (n2 == 2) {
            this.textSize = this.defaultTextSize + 20;
        }
        IminPrintUtils iminPrintUtils = this;
        iminPrintUtils.textPaint.setTextSize((float)this.textSize);
        return iminPrintUtils;
    }

    public IminPrintUtils setTextTypeface(Typeface typeface) {
        if (typeface == null) {
            typeface = Typeface.DEFAULT;
        }
        this.textTypeface = typeface;
        if (this.textPaint == null) {
            TextPaint textPaint;
            typeface = textPaint;
            textPaint = new TextPaint();
            this.textPaint = typeface;
        }
        IminPrintUtils iminPrintUtils = this;
        iminPrintUtils.textPaint.setTypeface(this.textTypeface);
        return iminPrintUtils;
    }

    public IminPrintUtils setTextStyle(int n2) {
        iminPrintUtils2.textStyle = n2;
        if (iminPrintUtils2.textPaint == null) {
            TextPaint textPaint;
            TextPaint textPaint2 = textPaint;
            textPaint = new TextPaint();
            iminPrintUtils2.textPaint = textPaint2;
        }
        IminPrintUtils iminPrintUtils = iminPrintUtils2;
        IminPrintUtils iminPrintUtils2 = Typeface.create((Typeface)iminPrintUtils.textTypeface, (int)iminPrintUtils2.textStyle);
        iminPrintUtils.textPaint.setTypeface((Typeface)iminPrintUtils2);
        return iminPrintUtils;
    }

    public IminPrintUtils setTextLineSpacing(float f2) {
        if (f2 < 0.0f || f2 == 0.0f) {
            f2 = 1.0f;
        }
        this.textLineSpacing = f2;
        return this;
    }

    public IminPrintUtils setTextWidth(int n2) {
        textWidth = n2;
        return this;
    }

    public IminPrintUtils setBitmapWidth(int n2) {
        bitmapWidth = n2;
        return this;
    }

    public IminPrintUtils setPageFormat(int n2) {
        if (n2 == 0) {
            textWidth = 576;
            bitmapWidth = 576;
        } else {
            textWidth = 384;
            bitmapWidth = 384;
        }
        Log.e((String)TAG, (String)("textWidth==   " + textWidth + "  bitmapWidth==\u300b " + bitmapWidth));
        return this;
    }

    @RequiresApi(api=23)
    public void printColumnsText(String[] bitmap, int[] nArray, int[] nArray2, int[] nArray3) {
        if (((String[])bitmap).length == nArray.length && nArray.length == nArray2.length && nArray2.length == nArray3.length) {
            IminPrintUtils iminPrintUtils = this;
            int n2 = textWidth;
            int n3 = ((String[])bitmap).length;
            bitmap = iminPrintUtils.getTableBitMap((String[])bitmap, nArray, nArray2, n2, nArray3, n3);
            iminPrintUtils.printCache();
            int n4 = connectType;
            if (n4 != 0 && 3 != n4) {
                this.printBitmaps(Collections.singletonList(bitmap));
            } else {
                Utils.addPrintListBitmap(bitmap, usbPrinter, 26);
            }
            return;
        }
        Log.i((String)TAG, (String)"incorrect parameter length");
    }

    public void printNvBitmap(int n2) {
        b.a.a.k.c c2;
        byte[] byArray = IminPrintUtils.PrintNvbmp(n2, 48);
        int n3 = connectType;
        if (n3 == 0) {
            Utils.addPrintList(byArray, usbPrinter, -1);
        } else if (1 == n3 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            ((IminPrintUtils)this).mComPort.b(byArray);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            ((a)this).b(byArray);
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(byArray);
        }
    }

    public boolean setDownloadNvBmp(String object) {
        if (!"".equalsIgnoreCase((String)object)) {
            byte[] byArray = IminPrintUtils.SetNvbmp(((IminPrintUtils)this).Count((String)object, ";"), (String)object);
            object = byArray;
            if (byArray != null) {
                b.a.a.k.c c2;
                int n2 = connectType;
                if (n2 == 0) {
                    Utils.addPrintList((byte[])object, usbPrinter, -1);
                } else if (1 == n2 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
                    ((IminPrintUtils)this).mComPort.b((byte[])object);
                } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
                    ((a)this).b((byte[])object);
                } else if (3 == connectType) {
                    PrintUtils.printSPISelfByte((byte[])object);
                }
                return true;
            }
        }
        return false;
    }

    public int Count(String string, String string2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            if (!string.substring(n3++, n3).equals(string2)) continue;
            ++n2;
        }
        return n2;
    }

    public void printSingleBitmap(Bitmap bitmap, int n2) {
        bitmap = BmpUtils.compressImage(bitmap, 200);
        this.printCache();
        int n3 = connectType;
        if (n3 != 0 && 3 != n3) {
            this.printBitmaps(Collections.singletonList(bitmap), n2);
        } else {
            Utils.addPrintListBitmap(bitmap, usbPrinter, 26, n2);
        }
        this.setLeftMargin(0);
    }

    public void printMultiBitmap(List<Bitmap> list, int n2) {
        this.printCache();
        int n3 = connectType;
        if (n3 != 0 && 3 != n3) {
            this.printBitmaps(list, n2);
        } else {
            Utils.addPrintListBitmap(list, usbPrinter, 39, n2);
        }
        this.setLeftMargin(0);
    }

    public void printSingleBitmap(Bitmap bitmap) {
        bitmap = BmpUtils.compressImage(bitmap, 200);
        this.printCache();
        int n2 = connectType;
        if (n2 != 0 && 3 != n2) {
            this.printBitmaps(Collections.singletonList(bitmap));
        } else {
            Utils.addPrintListBitmap(bitmap, usbPrinter, 26);
        }
    }

    public void printSingleBitmapBlackWhite(Bitmap bitmap) {
        Bitmap bitmap2 = BmpUtils.compressImage(bitmap, 200);
        this.printCache();
        bitmap = BmpUtils.getBlackWhiteBitmap(bitmap2);
        int n2 = connectType;
        if (n2 != 0 && 3 != n2) {
            this.printBitmaps(Collections.singletonList(bitmap));
        } else {
            Utils.addPrintListBitmap(bitmap, usbPrinter, 26);
        }
    }

    public int printerBitmaps(List<Bitmap> object, int n2) {
        int n3;
        IminPrintUtils iminPrintUtils = this;
        Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()===  \u56fe\u7247\u56fe\u7247\u56fe\u7247" + object.size() + "  ,alignmentMode==> " + n2));
        iminPrintUtils.printBmpBytes = new byte[0];
        iminPrintUtils.printBeanList = new ArrayList<b>();
        object = object.iterator();
        while (object.hasNext()) {
            int n4;
            Object object2 = (Bitmap)object.next();
            int n5 = object2.getHeight();
            b.a.a.i.c.E = n5 > 6000;
            int n6 = object2.getWidth();
            if (n6 > (n4 = bitmapWidth)) {
                int n7 = n6 > n4 ? n4 : n6;
                if (n6 > n4) {
                    n5 = n5 * n4 / n6;
                }
                object2 = Bitmap.createScaledBitmap((Bitmap)object2, (int)n7, (int)n5, (boolean)true);
            }
            if (n2 != -1) {
                if (n2 == 0) {
                    this.setLeftPrintMargin(0);
                } else if (1 == n2) {
                    this.setLeftPrintMargin((bitmapWidth - object2.getWidth()) / 2);
                } else if (2 == n2) {
                    this.setLeftPrintMargin(bitmapWidth - object2.getWidth());
                }
            }
            ArrayList<Bitmap> arrayList = BmpUtils.cutBitmap(120, (Bitmap)object2);
            Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 4444444  cutBitmap.size=> " + arrayList.size()));
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                Bitmap bitmap;
                Bitmap bitmap2 = bitmap = (Bitmap)object2.next();
                int n8 = bitmap2.getWidth();
                byte[] byArray = BmpUtils.printDiskImagefile(BmpUtils.getPixelsByBitmap(bitmap), n8, bitmap2.getHeight());
                n6 = connectType;
                if (n6 != 0 && 3 != n6) {
                    a a2;
                    b.a.a.k.c c2;
                    if (1 == n6 && (c2 = this.mComPort) != null && c2.f() && b.a.a.k.d.o) {
                        this.mComPort.a(byArray);
                        continue;
                    }
                    if (2 != connectType || (a2 = bluetoothPrintUtil) == null) continue;
                    a2.b(byArray);
                    continue;
                }
                if (3 == connectType) {
                    PrintUtils.printSPISelfBytePrint(byArray);
                    continue;
                }
                if (Build.VERSION.SDK_INT >= 26) {
                    b b2;
                    b b3 = b2;
                    b3();
                    b2.a(byArray);
                    this.printBeanList.add(b3);
                    continue;
                }
                if (connectType == 0) {
                    this.result = IminPrintUtils.getUsbPrinter().c(byArray, byArray.length);
                    continue;
                }
                PrintUtils.printSPISelfBytePrint(byArray);
            }
        }
        if (this.printBeanList.size() > 0 && ((n3 = connectType) == 0 || 3 == n3)) {
            Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 4444444 " + this.printBeanList.size()));
            for (n3 = 0; n3 < this.printBeanList.size(); ++n3) {
                if (this.printBeanList.size() > 3) {
                    byte[] byArray = this.printBmpBytes;
                    if (this.printBmpBytes.length > 3072) {
                        if (connectType == 0) {
                            this.result = IminPrintUtils.getUsbPrinter().c(this.printBmpBytes, this.printBmpBytes.length);
                        } else {
                            PrintUtils.printSPISelfBytePrint(byArray);
                        }
                        this.printBmpBytes = new byte[0];
                    }
                }
                this.printBmpBytes = BytesUtil.mergeBytes(this.printBmpBytes, this.printBeanList.get(n3).d());
            }
            Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 4444444  connectType== " + connectType + "  " + this.printBmpBytes.length));
            if (connectType == 0) {
                this.result = IminPrintUtils.getUsbPrinter().c(this.printBmpBytes, this.printBmpBytes.length);
            } else {
                PrintUtils.printSPISelfBytePrint(this.printBmpBytes);
            }
        }
        Log.e((String)TAG, (String)"\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 6666666  connectType== ");
        return this.result;
    }

    public void setLeftPrintMargin(int n2) {
        b.a.a.k.c c2;
        int n3 = n2;
        n2 = n3 >> 8;
        int n4 = n3 & 0xFF;
        IminPrintUtils.checkLegality(n2);
        IminPrintUtils.checkLegality(n4);
        int n5 = connectType;
        if (n5 == 0) {
            byte[] byArray = IminPrintUtils.intToByte(29, 76, n4, n2);
            IminPrintUtils.getUsbPrinter().a(byArray, byArray.length);
        } else if (1 == n5 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils = object;
            Object object = IminPrintUtils.intToByte(29, 76, n4, n2);
            iminPrintUtils.mComPort.a((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(29, 76, n4, n2));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfBytePrint(IminPrintUtils.intToByte(29, 76, n4, n2));
        }
    }

    public void printBMPBitmap(Bitmap bitmap) {
        a a2;
        b.a.a.k.c c2;
        Bitmap bitmap2 = bitmap;
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        byte[] byArray = BmpUtils.printDiskImagefile(BmpUtils.getPixelsByBitmap(bitmap2), n2, n3);
        n3 = connectType;
        if (n3 == 0) {
            Utils.addPrintList(byArray, usbPrinter, -1);
        } else if (1 == n3 && (c2 = this.mComPort) != null && c2.f() && b.a.a.k.d.o) {
            this.mComPort.a(byArray);
        } else if (2 == connectType && (a2 = bluetoothPrintUtil) != null) {
            a2.b(byArray);
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(byArray);
        }
        this.setLeftMargin(0);
    }

    public void printSingleBitmapNoCache(Bitmap bitmap) {
        b.a.a.k.c c2;
        Bitmap bitmap2 = bitmap;
        int n2 = bitmap2.getWidth();
        byte[] byArray = BmpUtils.printDiskImagefile(BmpUtils.getPixelsByBitmap(bitmap), n2, bitmap2.getHeight());
        int n3 = connectType;
        if (n3 == 0) {
            Utils.addPrintList(byArray, IminPrintUtils.getUsbPrinter(), -1);
        } else if (1 == n3 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            ((IminPrintUtils)this).mComPort.a(byArray);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            ((a)this).b(byArray);
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(byArray);
        }
    }

    public void printSingleBitmapNoCache(Bitmap bitmap, int n2) {
        b.a.a.k.c c2;
        if (n2 == 0) {
            ((IminPrintUtils)this).setLeftMargin(0);
        } else if (1 == n2) {
            Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 77373r6r6r6  777  connectType==     " + (bitmapWidth - bitmap.getWidth()) / 2));
            ((IminPrintUtils)this).setLeftMargin((bitmapWidth - bitmap.getWidth()) / 2);
        } else if (2 == n2) {
            ((IminPrintUtils)this).setLeftMargin(bitmapWidth - bitmap.getWidth());
        }
        Log.e((String)TAG, (String)"\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 77373r6r6r6  888  connectType==     ");
        Bitmap bitmap2 = bitmap;
        int n3 = bitmap2.getWidth();
        byte[] byArray = BmpUtils.printDiskImagefile(BmpUtils.getPixelsByBitmap(bitmap), n3, bitmap2.getHeight());
        n2 = connectType;
        if (n2 == 0) {
            Log.e((String)TAG, (String)"\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 77373r6r6r6  9999  connectType==     ");
            Utils.addPrintList(byArray, IminPrintUtils.getUsbPrinter(), -1);
        } else if (1 == n2 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            ((IminPrintUtils)this).mComPort.a(byArray);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            ((a)this).b(byArray);
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(byArray);
        }
    }

    public void printMultiBitmap(List<Bitmap> list) {
        this.printCache();
        int n2 = connectType;
        if (n2 != 0 && 3 != n2) {
            this.printBitmaps(list);
        } else {
            Utils.addPrintListBitmap(list, usbPrinter, 39);
        }
    }

    public void printBarCode39ToBitmap(String string, int n2, int n3) {
        if (n2 == 0) {
            n2 = textWidth;
        }
        Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 77373r6r6r6  connectType==     " + n2 + "   " + n3));
        string = Utils.createBarCode39Bitmap(string, n2, n3);
        if (string != null) {
            this.printSingleBitmap(BmpUtils.getBlackWhiteBitmap((Bitmap)string));
        }
    }

    public void printBarCode39ToBitmapWithAlign(String string, int n2, int n3, int n4) {
        if (n2 == 0) {
            n2 = textWidth;
        }
        Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 77373r6r6r6  connectType==     " + n2 + "   " + n3));
        string = Utils.createBarCode39Bitmap(string, n2, n3);
        if (string != null) {
            Log.e((String)TAG, (String)("\u63a5\u6536\u5230\u8981\u6253\u5370\u7684\u6587\u5b57 bitmaps.size()=== 77373r6r6r6  connectType==     " + n2 + "   " + n3));
            this.printSingleBitmap(BmpUtils.getBlackWhiteBitmap((Bitmap)string), n4);
        }
    }

    public void printBarCodeToBitmapFormatToAlign(String string, int n2, int n3, int n4, int n5) {
        Utils.getModel();
        if (n2 == 0) {
            n2 = textWidth;
        }
        if ((string = Utils.createBarCodeToBitmap(string, n2, n3, b.a.a.l.a.c.get(n5))) != null) {
            this.printSingleBitmap(BmpUtils.getBlackWhiteBitmap((Bitmap)string), n4);
        }
    }

    public void printBarCodeToBitmapFormat(String string, int n2, int n3, int n4) {
        Utils.getModel();
        if (n2 == 0) {
            n2 = textWidth;
        }
        if ((string = Utils.createBarCodeToBitmap(string, n2, n3, b.a.a.l.a.c.get(n4))) != null) {
            this.printSingleBitmap(BmpUtils.getBlackWhiteBitmap((Bitmap)string));
        }
    }

    public void printBarCode(int n2, String string) throws UnsupportedEncodingException {
        b.a.a.k.c c2;
        ((IminPrintUtils)this).printCache();
        int n3 = connectType;
        if (n3 == 0) {
            PrintUtils.printBarCode(usbPrinter, n2, string);
        } else if (1 == n3 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            PrintUtils.printBarCode(((IminPrintUtils)this).mComPort, n2, string);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            PrintUtils.printBarCode((a)this, n2, string);
        } else if (3 == connectType) {
            PrintUtils.printBarCode(n2, string);
        }
    }

    public void printBarCode(int n2, String string, int n3) throws UnsupportedEncodingException {
        if (string != null && string.length() != 0 && !string.equals("null")) {
            a a2;
            b.a.a.k.c c2;
            this.printCache();
            this.setCodeAlignment(n3);
            Log.d((String)TAG, (String)("usbPrinter spi print128  connectType ==> " + connectType));
            n3 = connectType;
            if (n3 == 0) {
                PrintUtils.printBarCode(usbPrinter, n2, string);
            } else if (1 == n3 && (c2 = this.mComPort) != null && c2.f() && b.a.a.k.d.o) {
                PrintUtils.printBarCode(this.mComPort, n2, string);
            } else if (2 == connectType && (a2 = bluetoothPrintUtil) != null) {
                PrintUtils.printBarCode(a2, n2, string);
            } else if (3 == connectType) {
                PrintUtils.printBarCode(n2, string);
            }
            this.setCodeAlignment(0);
            return;
        }
        throw new NullPointerException("Bar code data cannot be empty");
    }

    public boolean getPrintPower() {
        return Utils.getSystemProperties("persist.sys.imin.printPower").equals("1");
    }

    public void setBarCodeWidth(int n2) {
        b.a.a.k.c c2;
        int n3;
        if (n2 < 2 || n2 > 6) {
            n2 = 2;
        }
        if ((n3 = connectType) == 0) {
            PrintUtils.setBarCodeWidth(IminPrintUtils.getUsbPrinter(), n2);
        } else if (1 == n3 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            PrintUtils.setBarCodeContentPrintPos(((IminPrintUtils)this).mComPort, n2);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            PrintUtils.setBarCodeWidth((a)this, n2);
        } else if (3 == connectType) {
            PrintUtils.setBarCodeWidth(n2);
        }
    }

    public void setBarCodeHeight(int n2) {
        b.a.a.k.c c2;
        Log.d((String)TAG, (String)("  setBarCodeHeight ==> " + n2));
        if ((Utils.getModel().contains("M2") || Utils.getModel().equals("D1") || Utils.getModel().equals("D1-Pro") || Utils.getModel().contains("Swift")) && n2 > 247) {
            n2 = 247;
        }
        if (n2 < 1 || n2 > 255) {
            n2 = 70;
        }
        Log.d((String)TAG, (String)("  setBarCodeHeight 11==> " + n2));
        int n3 = connectType;
        if (n3 == 0) {
            PrintUtils.setBarCodeHeight(IminPrintUtils.getUsbPrinter(), n2);
        } else if (1 == n3 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            PrintUtils.setBarCodeHeight(((IminPrintUtils)this).mComPort, n2);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            PrintUtils.setBarCodeHeight((a)this, n2);
        } else if (3 == connectType) {
            PrintUtils.setBarCodeHeight(n2);
        }
    }

    public void setBarCodeContentPrintPos(int n2) {
        b.a.a.k.c c2;
        int n3 = connectType;
        if (n3 == 0) {
            PrintUtils.setBarCodeContentPrintPos(IminPrintUtils.getUsbPrinter(), n2);
        } else if (1 == n3 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            PrintUtils.setBarCodeContentPrintPos(((IminPrintUtils)this).mComPort, n2);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            PrintUtils.setBarCodeContentPrintPos((a)this, n2);
        } else if (3 == connectType) {
            PrintUtils.setBarCodeContentPrintPos(n2);
        }
    }

    public void printQrCode(String string) {
        b.a.a.k.c c2;
        IminPrintUtils iminPrintUtils = object;
        iminPrintUtils.printCache();
        iminPrintUtils.storeQrCodeDataInStorage(string);
        int n2 = connectType;
        if (n2 == 0) {
            Utils.sendCommonCmd(IminPrintUtils.getUsbPrinter(), 29, 40, 107, 3, 0, 49, 81, 48);
        } else if (1 == n2 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils2 = object;
            Object object = IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 81, 48);
            iminPrintUtils2.mComPort.a((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 81, 48));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 81, 48));
        }
    }

    public void printQrCode(String string, int n2) {
        if (string != null && string.length() != 0 && !string.equals("null")) {
            Object object;
            IminPrintUtils iminPrintUtils = this;
            iminPrintUtils.printCache();
            iminPrintUtils.setCodeAlignment(n2);
            iminPrintUtils.storeQrCodeDataInStorage(string);
            int n3 = connectType;
            if (n3 == 0) {
                Utils.sendCommonCmd(IminPrintUtils.getUsbPrinter(), 29, 40, 107, 3, 0, 49, 81, 48);
            } else if (1 == n3 && (object = this.mComPort) != null && ((b.a.a.k.d)object).f() && b.a.a.k.d.o) {
                object = IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 81, 48);
                Log.d((String)TAG, (String)("usbPrinter ==> " + Arrays.toString((byte[])object)));
                this.mComPort.a((byte[])object);
            } else if (2 == connectType && bluetoothPrintUtil != null) {
                byte[] byArray = IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 81, 48);
                Log.d((String)TAG, (String)("usbPrinter ==> " + byArray));
                bluetoothPrintUtil.b(byArray);
            } else if (3 == connectType) {
                byte[] byArray = IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 81, 48);
                Log.d((String)TAG, (String)("usbPrinter ==> " + Arrays.toString(byArray)));
                PrintUtils.printSPISelfByte(byArray);
            }
            this.setCodeAlignment(0);
            return;
        }
        throw new NullPointerException("Qr code data cannot be empty");
    }

    public void setQrCodeSize(int n2) {
        if (n2 >= 1 && n2 <= 13) {
            b.a.a.k.c c2;
            int n3 = connectType;
            if (n3 == 0) {
                Utils.sendCommonCmd(IminPrintUtils.getUsbPrinter(), 29, 40, 107, 3, 0, 49, 67, n2);
            } else if (1 == n3 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
                IminPrintUtils iminPrintUtils = object;
                Object object = IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 67, n2);
                iminPrintUtils.mComPort.a((byte[])object);
            } else if (2 == connectType && bluetoothPrintUtil != null) {
                bluetoothPrintUtil.b(IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 67, n2));
            } else if (3 == connectType) {
                PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 67, n2));
            }
            return;
        }
        throw new IllegalArgumentException("Parameter violation : " + n2);
    }

    public void setLeftMargin(int n2) {
        b.a.a.k.c c2;
        int n3 = n2;
        n2 = n3 >> 8;
        int n4 = n3 & 0xFF;
        IminPrintUtils.checkLegality(n2);
        IminPrintUtils.checkLegality(n4);
        int n5 = connectType;
        if (n5 == 0) {
            Utils.sendCommonCmd(IminPrintUtils.getUsbPrinter(), 29, 76, n4, n2);
        } else if (1 == n5 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            IminPrintUtils iminPrintUtils = object;
            Object object = IminPrintUtils.intToByte(29, 76, n4, n2);
            iminPrintUtils.mComPort.a((byte[])object);
        } else if (2 == connectType && bluetoothPrintUtil != null) {
            bluetoothPrintUtil.b(IminPrintUtils.intToByte(29, 76, n4, n2));
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(29, 76, n4, n2));
        }
    }

    public void setQrCodeErrorCorrectionLev(int n2) {
        if (n2 >= 48 && n2 <= 51) {
            b.a.a.k.c c2;
            int n3 = connectType;
            if (n3 == 0) {
                Utils.sendCommonCmd(IminPrintUtils.getUsbPrinter(), 29, 40, 107, 3, 0, 49, 69, n2);
            } else if (1 == n3 && (c2 = ((IminPrintUtils)object).mComPort) != null && c2.f() && b.a.a.k.d.o) {
                IminPrintUtils iminPrintUtils = object;
                Object object = IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 69, n2);
                iminPrintUtils.mComPort.a((byte[])object);
            } else if (2 == connectType && bluetoothPrintUtil != null) {
                bluetoothPrintUtil.b(IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 69, n2));
            } else if (3 == connectType) {
                PrintUtils.printSPISelfByte(IminPrintUtils.intToByte(29, 40, 107, 3, 0, 49, 69, n2));
            }
            return;
        }
        throw new IllegalArgumentException("Parameter violation : " + n2);
    }

    public void printerByte(byte[] byArray) {
        Log.e((String)TAG, (String)("printerByte  " + connectType));
        if (byArray != null && byArray.length != 0) {
            b.a.a.k.c c2;
            int n2 = connectType;
            if (n2 == 0) {
                Utils.addPrintList(byArray, usbPrinter, -1);
            } else if (1 == n2 && (c2 = this.mComPort) != null && c2.f() && b.a.a.k.d.o) {
                this.mComPort.a(byArray);
            } else {
                int n3 = connectType;
                if (2 == n3) {
                    a a2 = bluetoothPrintUtil;
                    if (a2 == null) {
                        return;
                    }
                    a2.b(byArray);
                } else if (3 == n3) {
                    PrintUtils.printSPISelfByte(byArray);
                }
            }
            return;
        }
    }

    public void printerByte() {
        Log.e((String)TAG, (String)"printerByte  ");
        byte[] byArray = new byte[2];
        Object object = byArray;
        byArray[0] = 27;
        byArray[1] = 64;
        bluetoothPrintUtil.b((byte[])object);
    }

    public void setDoubleQRSize(int n2) {
        if (Utils.isDoubleQRDev()) {
            if (n2 < 1) {
                n2 = 1;
            }
            if (n2 > 8) {
                n2 = 8;
            }
            if (n2 >= 1 && n2 <= 8) {
                this.tQRSize = n2;
            }
        }
    }

    public void setDoubleQR1MarginLeft(int n2) {
        this.tQR1MaginLeft = n2;
    }

    public void setDoubleQR2MarginLeft(int n2) {
        this.tQR2MaginLeft = n2;
    }

    public void setDoubleQR1Level(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 3) {
            n2 = 3;
        }
        this.tQR1Level = n2;
    }

    public void setDoubleQR2Level(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 3) {
            n2 = 3;
        }
        this.tQR2Level = n2;
    }

    public void setDoubleQR1Version(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 40) {
            n2 = 40;
        }
        this.tQR1Version = n2;
    }

    public void setDoubleQR2Version(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 40) {
            n2 = 40;
        }
        this.tQR2Version = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printDoubleQR(String object, String object2) {
        byte[] byArray;
        block52: {
            block51: {
                block50: {
                    if (!Utils.isDoubleQRDev()) {
                        return;
                    }
                    this.printCache();
                    if (TextUtils.isEmpty((CharSequence)object)) throw new NullPointerException("Qr code data cannot be empty");
                    if (TextUtils.isEmpty((CharSequence)object2)) throw new NullPointerException("Qr code data cannot be empty");
                    Object object3 = object2;
                    object = ((String)object).getBytes("GBK");
                    object2 = ((String)object3).getBytes("GBK");
                    if (((Object)object).length > 255) throw new IllegalArgumentException("The length of the qr code data exceeds 255");
                    if (((Object)object2).length > 255) throw new IllegalArgumentException("The length of the qr code data exceeds 255");
                    Object object4 = object2;
                    int n2 = ((Object)object).length + 6;
                    int n3 = ((Object)object4).length + 6;
                    Object object5 = object;
                    byte[] byArray2 = new byte[n2 + n3 + 4];
                    byArray = byArray2;
                    byArray2[0] = 31;
                    byArray2[1] = 81;
                    byArray2[2] = 2;
                    byte by = (byte)this.tQRSize;
                    byArray2[3] = by;
                    byArray2[4] = 0;
                    byte by2 = (byte)this.tQR1MaginLeft;
                    byArray2[5] = by2;
                    byArray2[6] = 0;
                    byte by3 = (byte)((Object)object).length;
                    byArray2[7] = by3;
                    byte by4 = (byte)this.tQR1Level;
                    byArray2[8] = by4;
                    byte by5 = (byte)this.tQR1Version;
                    byArray2[9] = by5;
                    int n4 = 0;
                    int n5 = 10;
                    int n6 = ((Object)object5).length;
                    System.arraycopy(object5, n4, byArray, n5, n6);
                    byte[] byArray3 = new byte[n3];
                    Object object6 = object2;
                    Object object7 = object6;
                    Object object8 = object6;
                    byte[] byArray4 = byArray3;
                    byte[] byArray5 = byArray4;
                    byte[] byArray6 = byArray3;
                    byte[] byArray7 = byArray3;
                    byte[] byArray8 = byArray4;
                    byte[] byArray9 = byArray3;
                    byArray4[0] = 0;
                    byte by6 = (byte)this.tQR2MaginLeft;
                    byArray7[1] = by6;
                    byArray8[2] = 0;
                    byte by7 = (byte)((Object)object2).length;
                    byArray9[3] = by7;
                    byte by8 = (byte)this.tQR2Level;
                    byArray5[4] = by8;
                    byte by9 = (byte)this.tQR2Version;
                    byArray6[5] = by9;
                    int n7 = 0;
                    n5 = 6;
                    n6 = ((Object)object7).length;
                    System.arraycopy(object8, n7, byArray3, n5, n6);
                    byte[] byArray10 = byArray;
                    int n8 = ((Object)object).length;
                    System.arraycopy(byArray3, 0, byArray10, n8 + 10, n3);
                    Log.d((String)TAG, (String)("usbPrinter  printTQRCode ==> " + Arrays.toString(byArray)));
                    if (connectType != 0) break block50;
                    Utils.addPrintList(byArray, usbPrinter, -1);
                    return;
                }
                if (1 != connectType) break block51;
                if (this.mComPort == null) break block51;
                if (!this.mComPort.f()) break block51;
                if (!b.a.a.k.d.o) break block51;
                this.mComPort.a(byArray);
                return;
            }
            if (2 != connectType) break block52;
            if (bluetoothPrintUtil == null) break block52;
            bluetoothPrintUtil.b(byArray);
            return;
        }
        if (3 != connectType) return;
        try {
            PrintUtils.printSPISelfByte(byArray);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startPrintTicket() {
        b.a.a.k.c c2;
        int n2 = connectType;
        if (3 != n2) {
            return;
        }
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray[0] = 29;
        byArray[1] = 0;
        byArray[2] = 33;
        if (n2 == 0) {
            Utils.addPrintList(byArray2, usbPrinter, -1);
        } else if (1 == n2 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            ((IminPrintUtils)this).mComPort.a(byArray2);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            ((a)this).b(byArray2);
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte(byArray2);
        }
    }

    public int getPrintResult(Callback object) {
        b.a.a.k.c c2;
        if (3 != connectType) {
            return 0;
        }
        byte[] byArray = new byte[3];
        object = byArray;
        byArray[0] = 29;
        byArray[1] = 114;
        byArray[2] = 1;
        Log.d((String)TAG, (String)("iminprinterutil   checkPrintResult ==> " + Arrays.toString((byte[])object)));
        int n2 = connectType;
        if (n2 == 0) {
            Utils.addPrintList((byte[])object, usbPrinter, -1);
        } else if (1 == n2 && (c2 = ((IminPrintUtils)this).mComPort) != null && c2.f() && b.a.a.k.d.o) {
            ((IminPrintUtils)this).mComPort.a((byte[])object);
        } else if (2 == connectType && (this = bluetoothPrintUtil) != null) {
            ((a)this).b((byte[])object);
        } else if (3 == connectType) {
            PrintUtils.printSPISelfByte((byte[])object);
        }
        return IminPrintUtils.getPrintResultStatus();
    }

    public void printSelfPageENTest() {
        b.a.a.k.c c2 = this.mComPort;
        if (c2 != null && c2.f()) {
            IminPrintUtils iminPrintUtils = this;
            iminPrintUtils.mComPort.a("1B401D7630000100170000000000000000000000000000000000000000000000001D7630002A00580000000000000000FE0000000007FFFFFFFFC00007FFFFFFFFE000000000FE000000000FFFFFFFFFC0000000000000000003FF800000007FFFFFFFFFF8003FFFFFFFFFFC00000003FF800000007FFFFFFFFFF8000000000000000007FFC0000000FFFFFFFFFFFE00FFFFFFFFFFFF00000007FFC0000001FFFFFFFFFFFE00000000000000000FFFE0000003FFFFFFFFFFFF83FFFFFFFFFFFF8000000FFFE0000003FFFFFFFFFFFF80000000000000001FFFF000000FFFFFFFFFFFFFC7FFFFFFFFFFFFE000001FFFF000000FFFFFFFFFFFFFC0000000000000001FFFF000001FFFFFFFFFFFFFFFFFFFFFFFFFFFF000001FFFF000001FFFFFFFFFFFFFF0000000000000001FFFF800003FFFFFFFFFFFFFFFFFFFFFFFFFFFF800001FFFF000003FFFFFFFFFFFFFF8000000000000003FFFF800007FFFFFFFFFFFFFFFFFFFFFFFFFFFFC00003FFFF800007FFFFFFFFFFFFFFC000000000000003FFFF80000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFE00003FFFF80000FFFFFFFFFFFFFFFE000000000000003FFFF80001FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00003FFFF80001FFFFFFFFFFFFFFFE000000000000003FFFF80003FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF80003FFFF80003FFFFFFFFFFFFFFFF000000000000001FFFF80007FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0003FFFF80007FFFFFFFFFFFFFFFF800000000000001FFFF00007FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC0001FFFF00007FFFFFFFFFFFFFFFFC00000000000001FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0001FFFF0000FFFFFFFFFFFFFFFFFC00000000000000FFFE0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE0000FFFE0000FFFFFFFFFFFFFFFFFE000000000000007FFE0001FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFC0001FFFFFFFFFFFFFFFFFE000000000000003FFC0001FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00003FF80001FFFFFFFFFFFFFFFFFE000000000000001FF00001FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00001FF00001FFFFFFFFFFFFFFFFFF0000000000000007C00001FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF800007C00003FFFFFFFFFFFFFFFFFF0000000000000000000003FFFFF00000001FFFFFF00000001FFFFF800000000003FFFFF00000001FFFFF0000000000000000000003FFFFC00000000FFFFFE000000007FFFF800000000003FFFFC00000000FFFFF0000000000000000000003FFFF8000000007FFFFC000000003FFFF800000000003FFFF8000000007FFFF0000000000000000000003FFFF8000000003FFFF8000000003FFFF800000000003FFFF8000000003FFFF8000000000000000000003FFFF0000000003FFFF8000000001FFFF800000000003FFFF0000000003FFFF8000000000000000000003FFFF0000000003FFFF8000000001FFFF800000000003FFFF0000000003FFFF800000000000000FE00003FFFF0000000003FFFF8000000001FFFF80000FE00003FFFF0000000003FFFF800000000000003FF80003FFFF0000000003FFFF8000000001FFFF80003FF80003FFFF0000000003FFFF800000000000007FFC0003FFFF0000000003FFFF8000000001FFFF80007FFC0003FFFF0000000003FFFF80000000000000FFFE0003FFFF0000000003FFFF8000000001FFFF8000FFFE0003FFFF0000000003FFFF80000000000000FFFF0003FFFF0000000003FFFF8000000001FFFF8001FFFF0003FFFF0000000003FFFF80000000000001FFFF0003FFFF0000000003FFFF8000000001FFFF8001FFFF0003FFFF0000000003FFFF80000000000001FFFF0003FFFF0000000003FFFF8000000001FFFF8001FFFF0003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000003FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF80000000000001FFFF8003FFFF0000000003FFFF8000000001FFFF8003FFFF8003FFFF0000000003FFFF00000000000001FFFF0003FFFF0000000001FFFF0000000001FFFF8001FFFF0003FFFF0000000001FFFF00000000000001FFFF0001FFFE0000000001FFFF0000000000FFFF0001FFFF0001FFFE0000000001FFFF00000000000000FFFE0001FFFE0000000000FFFE0000000000FFFF0000FFFE0001FFFE0000000000FFFE000000000000007FFC0000FFFC00000000007FFC00000000007FFE00007FFC0000FFFC00000000007FFC000000000000003FFC00007FF800000000003FF800000000003FFC00003FF800007FF800000000003FF8000000000000001FF800003FF000000000001FF000000000001FF800001FF000003FE000000000003FF00000000000000003C000000780000000000007C0000000000003C0000007C0000007800000000000078000A0A");
            iminPrintUtils.mComPort.a("1B6101");
            iminPrintUtils.mComPort.a("1D2101");
            iminPrintUtils.mComPort.b("Welcome to printer test\n\n\n");
            iminPrintUtils.mComPort.a("1B3301");
            iminPrintUtils.mComPort.b("This is aline of normal fontsThis is aline of normal fonts\n");
            iminPrintUtils.mComPort.a("1B331E");
            iminPrintUtils.mComPort.b("This is aline of normal fontsThis is aline of normal fonts\n");
            iminPrintUtils.mComPort.a("1B3364");
            iminPrintUtils.mComPort.b("This is aline of normal fontsThis is aline of normal fonts\n");
            iminPrintUtils.mComPort.a("1B6101");
            iminPrintUtils.mComPort.a("1D2100");
            iminPrintUtils.mComPort.b("******************************\n\n");
            iminPrintUtils.mComPort.a("1B6100");
            iminPrintUtils.mComPort.a("1D2100");
            iminPrintUtils.mComPort.b("This is aline of normal fonts\n\n");
            iminPrintUtils.mComPort.a("1B6100");
            iminPrintUtils.mComPort.a("1D2101");
            iminPrintUtils.mComPort.b("This is aline of 30-point fonts\n\n");
            iminPrintUtils.mComPort.a("1B6100");
            iminPrintUtils.mComPort.a("1D2102");
            iminPrintUtils.mComPort.b("This is aline of 36-point fonts\n\n");
            iminPrintUtils.mComPort.a("1B6100");
            iminPrintUtils.mComPort.a("1D2103");
            iminPrintUtils.mComPort.b("This is aline of 42-point fonts\n\n");
            iminPrintUtils.mComPort.a("1B6101");
            iminPrintUtils.mComPort.a("1D2100");
            iminPrintUtils.mComPort.b("******************************\n\n");
            iminPrintUtils.mComPort.a("1B6101");
            iminPrintUtils.mComPort.a("1D2100");
            iminPrintUtils.mComPort.b("***Completed***\n\n\n\n\n");
        }
    }

    public void printSelfPageTest() {
        b.a.a.k.c c2 = this.mComPort;
        if (c2 != null && c2.f()) {
            IminPrintUtils iminPrintUtils = this;
            iminPrintUtils.mComPort.a("1B6101");
            iminPrintUtils.mComPort.a("1D2101");
            iminPrintUtils.mComPort.b("SELF-TEST\n\n");
            iminPrintUtils.mComPort.a("1B6101");
            iminPrintUtils.mComPort.a("1D2104");
            iminPrintUtils.mComPort.a("1D2140");
            iminPrintUtils.mComPort.a("1B4501");
            iminPrintUtils.mComPort.b("iMin\n\n");
            iminPrintUtils.mComPort.a("1B6100");
            iminPrintUtils.mComPort.a("1D2100");
            iminPrintUtils.mComPort.b("\u8fd9\u662f\u4e00\u884c24\u53f7\u5b57\u4f53\n\n");
            iminPrintUtils.mComPort.a("1B6100");
            iminPrintUtils.mComPort.a("1D2101");
            iminPrintUtils.mComPort.b("\u8fd9\u662f\u4e00\u884c30\u53f7\u5b57\u4f53\n\n");
            iminPrintUtils.mComPort.a("1B6100");
            iminPrintUtils.mComPort.a("1D2102");
            iminPrintUtils.mComPort.b("\u8fd9\u662f\u4e00\u884c36\u53f7\u5b57\u4f53\n\n");
            iminPrintUtils.mComPort.a("1B6100");
            iminPrintUtils.mComPort.a("1D2103");
            iminPrintUtils.mComPort.b("\u8fd9\u662f\u4e00\u884c42\u53f7\u5b57\u4f53\n\n");
            iminPrintUtils.mComPort.a("1B6101");
            iminPrintUtils.mComPort.a("1D286B0300314308");
            iminPrintUtils.mComPort.a("1B6402");
            iminPrintUtils.mComPort.a("1D286B14003150304E454F5354524130313233343536373839");
            iminPrintUtils.mComPort.a("1D286B0D00315130");
            iminPrintUtils.mComPort.a("1B6402");
            iminPrintUtils.mComPort.a("1B6402");
        }
    }

    public void initParams() {
        Log.d((String)TAG, (String)"initParams \u521d\u59cb\u5316\u53c2\u6570:");
        this.textSize = 28;
        this.defaultTextSize = 28;
        this.haveUnderline = false;
        this.haveBold = false;
        this.lineHeightRatio = 0.0f;
        this.fontSizeStyle = 0;
        this.underlineStyle = 0;
        this.lineHeighSize = 0;
        this.textLineSpacing = 1.0f;
        Log.e((String)"Build.MODEL", (String)(" Build.MODEL==   " + Build.MODEL));
        if (!(this.sModel.contains("M2") || this.sModel.equals("D1") || Utils.getModel().equals("D1-Pro") || this.sModel.contains("Swift") || this.sModel.contains("D3-510"))) {
            textWidth = 576;
            bitmapWidth = 576;
        } else {
            textWidth = 384;
            bitmapWidth = 384;
        }
        IminPrintUtils iminPrintUtils = this;
        iminPrintUtils.textTypeface = Typeface.DEFAULT;
        iminPrintUtils.textStyle = 0;
        iminPrintUtils.textAlignment = Layout.Alignment.ALIGN_NORMAL;
        iminPrintUtils.mAlignments.clear();
        StringBuilder stringBuilder = iminPrintUtils.stringBuilder;
        if (stringBuilder != null) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        IminPrintUtils iminPrintUtils2 = this;
        iminPrintUtils2.lineHeightRatio = (float)(iminPrintUtils2.lineHeighSize + 100) / 100.0f;
        Log.d((String)TAG, (String)("fontSizeStyle:" + this.fontSizeStyle + " textSize:" + this.textSize + "boldStyle:" + this.haveBold + "underlineStyle:" + this.underlineStyle + "lineHeighSize:" + this.lineHeighSize));
        iminPrintUtils2.setTextSize(iminPrintUtils2.defaultTextSize);
        iminPrintUtils2.sethaveBold(iminPrintUtils2.haveBold);
        iminPrintUtils2.setUnderline(iminPrintUtils2.haveUnderline);
        iminPrintUtils2.setHaveLineHeight(iminPrintUtils2.lineHeightRatio);
        iminPrintUtils2.setBarCodeWidth(3);
        iminPrintUtils2.setBarCodeHeight(100);
        iminPrintUtils2.setBarCodeContentPrintPos(0);
        iminPrintUtils2.setLeftMargin(0);
        if (!Utils.getModel().startsWith("D3-510")) {
            IminPrintUtils iminPrintUtils3 = this;
            iminPrintUtils3.setQrCodeSize(9);
            iminPrintUtils3.setQrCodeErrorCorrectionLev(51);
            iminPrintUtils3.setDoubleQRSize(4);
            iminPrintUtils3.setDoubleQR1Level(1);
            iminPrintUtils3.setDoubleQR2Level(2);
            iminPrintUtils3.setDoubleQR1MarginLeft(10);
            iminPrintUtils3.setDoubleQR2MarginLeft(200);
            iminPrintUtils3.setDoubleQR1Version(0);
            iminPrintUtils3.setDoubleQR2Version(6);
        }
    }

    public void initParams(boolean bl) {
        StringBuilder stringBuilder;
        Log.d((String)TAG, (String)"initParams \u521d\u59cb\u5316\u53c2\u6570:");
        this.textSize = 28;
        this.defaultTextSize = 28;
        this.haveUnderline = false;
        this.haveBold = false;
        this.lineHeightRatio = 0.0f;
        this.fontSizeStyle = 0;
        this.underlineStyle = 0;
        this.lineHeighSize = 0;
        this.textLineSpacing = 1.0f;
        this.sModel = Utils.getModel();
        Log.e((String)"Build.MODEL", (String)(" Build.MODEL==   " + Build.MODEL));
        if (!(this.sModel.contains("M2") || this.sModel.equals("D1") || Utils.getModel().equals("D1-Pro") || this.sModel.contains("Swift") || this.sModel.contains("D3-510"))) {
            textWidth = 576;
            bitmapWidth = 576;
        } else {
            textWidth = 384;
            bitmapWidth = 384;
        }
        this.textTypeface = Typeface.DEFAULT;
        this.textStyle = 0;
        this.textAlignment = Layout.Alignment.ALIGN_NORMAL;
        this.mAlignments.clear();
        if (bl && (stringBuilder = this.stringBuilder) != null) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.delete(0, stringBuilder2.length());
        }
        IminPrintUtils iminPrintUtils = this;
        iminPrintUtils.lineHeightRatio = (float)(iminPrintUtils.lineHeighSize + 100) / 100.0f;
        Log.d((String)TAG, (String)("fontSizeStyle:" + this.fontSizeStyle + " textSize:" + this.textSize + "boldStyle:" + this.haveBold + "underlineStyle:" + this.underlineStyle + "lineHeighSize:" + this.lineHeighSize));
        iminPrintUtils.setTextSize(iminPrintUtils.defaultTextSize);
        iminPrintUtils.sethaveBold(iminPrintUtils.haveBold);
        iminPrintUtils.setUnderline(iminPrintUtils.haveUnderline);
        iminPrintUtils.setHaveLineHeight(iminPrintUtils.lineHeightRatio);
        iminPrintUtils.setBarCodeWidth(3);
        iminPrintUtils.setBarCodeHeight(100);
        iminPrintUtils.setBarCodeContentPrintPos(0);
        iminPrintUtils.setLeftMargin(0);
        if (!Utils.getModel().startsWith("D3-510")) {
            IminPrintUtils iminPrintUtils2 = this;
            iminPrintUtils2.setQrCodeSize(9);
            iminPrintUtils2.setQrCodeErrorCorrectionLev(51);
            iminPrintUtils2.setDoubleQRSize(4);
            iminPrintUtils2.setDoubleQR1Level(1);
            iminPrintUtils2.setDoubleQR2Level(2);
            iminPrintUtils2.setDoubleQR1MarginLeft(10);
            iminPrintUtils2.setDoubleQR2MarginLeft(200);
            iminPrintUtils2.setDoubleQR1Version(0);
            iminPrintUtils2.setDoubleQR2Version(6);
        }
    }

    public int getForcedRowHeight() {
        return (int)this.textLineSpacing;
    }

    public boolean isForcedBold() {
        return this.haveBold;
    }

    public boolean isForcedUnderline() {
        return this.haveUnderline;
    }

    public int getPrinterDensity() {
        return 1;
    }

    public String getPrinterPaperDistance() {
        return IminPrintUtils.getUsbPrinter().j();
    }

    public String getPrintCutterNumber() {
        return IminPrintUtils.getUsbPrinter().i();
    }

    public String getPrinterSerialNumber() {
        return IminPrintUtils.getUsbPrinter().k();
    }

    public class e
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                if (intent.getAction() == "android.intent.action.SCREEN_ON") {
                    Log.e((String)"Build.MODEL", (String)" \u4eae\u5c4f==   ");
                    connectType = -1;
                    if (IminPrintUtils.this.printThread != null) {
                        e e2 = this;
                        e2.IminPrintUtils.this.printThread.interrupt();
                        IminPrintUtils.access$302(e2.IminPrintUtils.this, null);
                    }
                } else if (intent.getAction() == "android.intent.action.SCREEN_OFF") {
                    Log.e((String)"Build.MODEL", (String)" \u706d\u5c4f==   ");
                }
            }
        }
    }

    public static class d
    extends Handler {
        public final WeakReference<Context> a;

        public d(Context context) {
            WeakReference<Context> weakReference;
            Object object = weakReference;
            weakReference = new WeakReference<Context>(context);
            v1.a = object;
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            if (message.what == 5) {
                statusUsb = message.arg1;
                IminPrintUtils.setPrinterStatus(statusUsb);
            }
        }
    }

    public class f
    extends Thread {
        public boolean a = false;
        public int b = -1;

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (!this.a) {
                block22: {
                    block23: {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v0) {
                            v0.printStackTrace();
                        }
                        if (IminPrintUtils.access$400(IminPrintUtils.this) == null || !IminPrintUtils.access$400(IminPrintUtils.this).f()) break block22;
                        if (IminPrintUtils.access$400((IminPrintUtils)IminPrintUtils.this).c == null) {
                            Log.d((String)"IminPrintUtils", (String)("getPrinterStatus spi 4444   -->" + IminPrintUtils.access$000()));
                            IminPrintUtils.access$002(-1);
                            PrintUtils.setPrintStatus(IminPrintUtils.access$000());
                            IminPrintUtils.setPrintResultStatus(0);
                        }
                        try {
                            v1 = this;
                            var1_1 = new byte[10];
                        }
                        catch (IOException var1_2) {
                            Log.d((String)"IminPrintUtils", (String)("\u67e5\u8be2\u6253\u5370\u673a\u72b6\u6001\u6216\u8005 \u67e5\u8be2\u6253\u5370\u7ed3\u679c\u6307\u4ee4  getPrinterStatus   IOException " + var1_2.getMessage()));
                            continue;
                        }
                        if (IminPrintUtils.access$400((IminPrintUtils)v1.IminPrintUtils.this).c.available() <= 0) continue;
                        v2 = var1_1;
                        IminPrintUtils.access$400((IminPrintUtils)IminPrintUtils.this).c.read(var1_1);
                        Log.d((String)"IminPrintUtils", (String)("\u67e5\u8be2\u6253\u5370\u673a\u72b6\u6001\u6216\u8005 \u67e5\u8be2\u6253\u5370\u7ed3\u679c\u6307\u4ee4 getPrinterStatus spi 5555-->" + IminPrintUtils.access$000() + " \uff0c\u63a5\u6536\u5230\u7684\u6307\u4ee4==\u300b " + Arrays.toString(var1_1)));
                        if (v2[0] != 16) ** GOTO lbl42
                        var2_3 = IminPrintUtils.access$500(IminPrintUtils.this, var1_1[1]);
                        PrintUtils.setPrintStatus(var2_3);
                        IminPrintUtils.access$002(var2_3);
                        IminPrintUtils.setPrinterStatus(var2_3);
                        break block23;
lbl42:
                        // 1 sources

                        var2_3 = IminPrintUtils.access$500(IminPrintUtils.this, var1_1[0]);
                    }
                    var3_4 = "IminPrintUtils";
                    var4_5 = new StringBuilder().append("  getPrinterStatus values = ").append(var1_1[0]).append(" (mCallBack != null):");
                    var5_6 = IminPrintUtils.this.mCallBack != null;
                    v3 = this;
                    Log.d((String)var3_4, (String)var4_5.append(var5_6).toString());
                    if (v3.IminPrintUtils.this.mCallBack == null) ** GOTO lbl57
                    IminPrintUtils.this.mCallBack.callback(var2_3);
lbl57:
                    // 2 sources

                    if (IminPrintUtils.this.mCallBack1 == null) ** GOTO lbl60
                    IminPrintUtils.this.mCallBack1.callback(var2_3);
lbl60:
                    // 2 sources

                    v4 = var2_3;
                    v5 = v4;
                    v6 = v4;
                    this.b = var2_3;
                    IminPrintUtils.access$002(v4);
                    PrintUtils.setPrintStatus(v6);
                    IminPrintUtils.setPrinterStatus(v5);
                    Log.d((String)"IminPrintUtils", (String)("  getPrinterStatus values = " + var1_1[0] + " printerStatus:" + IminPrintUtils.access$000()));
                    Log.d((String)"IminPrintUtils", (String)("getPrinterStatus spi 6666-->" + IminPrintUtils.access$000()));
                    continue;
                }
                if (IminPrintUtils.connectType != 3) continue;
                IminPrintUtils.access$602(IminPrintUtils.this, false);
            }
        }

        @Override
        public void interrupt() {
            this.a = true;
            super.interrupt();
        }
    }

    public static final class PrintConnectType
    extends Enum<PrintConnectType> {
        public static final /* enum */ PrintConnectType USB;
        public static final /* enum */ PrintConnectType BLUETOOTH;
        public static final /* enum */ PrintConnectType SPI;
        public static final /* synthetic */ PrintConnectType[] $VALUES;

        public static PrintConnectType[] values() {
            return (PrintConnectType[])$VALUES.clone();
        }

        public static PrintConnectType valueOf(String string) {
            return Enum.valueOf(PrintConnectType.class, string);
        }

        static {
            PrintConnectType printConnectType;
            USB = new PrintConnectType();
            BLUETOOTH = new PrintConnectType();
            PrintConnectType printConnectType2 = printConnectType;
            SPI = new PrintConnectType();
            $VALUES = new PrintConnectType[]{USB, BLUETOOTH, printConnectType2};
        }
    }
}

