package com.ubsidi.epos_2021;

import static com.ubsidi.epos_2021.utils.Constants.BUSINESS_EVENING_END_TIME;
import static com.ubsidi.epos_2021.utils.Constants.DDMMYYYY;
import static com.ubsidi.epos_2021.utils.Constants.DDMMYYYYHHMMA;

import android.app.Activity;
import android.app.Application;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.room.Room;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.gson.Gson;
import com.imin.library.IminSDKManager;
import com.imin.library.SystemPropManager;
import com.sunmi.printerx.PrinterSdk;
import com.sunmi.printerx.SdkException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.activities.HomeActivity;
import com.ubsidi.epos_2021.callerid.CALLERID;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MyExceptionHandler;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.IMinPrinterUtils;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.daos.relations.CategoryWithChildren;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.fragment.NewOrderDialogFragment;
import com.ubsidi.epos_2021.fragment.NewReservationFragment;
import com.ubsidi.epos_2021.fragment.OrderTypeSelectionDialogFragment;
import com.ubsidi.epos_2021.fragment.PrintOptionsDialogFragment;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Category;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.DeviceInfo;
import com.ubsidi.epos_2021.models.EposUserPermission;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderStatuses;
import com.ubsidi.epos_2021.models.OrderType;
import com.ubsidi.epos_2021.models.PaymentMethod;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.Product;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.models.User;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.network.NetworkInterceptor;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.online.fragments.OnlineOrderViewFragment;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.online.models.OrderDetail;
import com.ubsidi.epos_2021.online.services_receivers.TiffintomPartnerJobService;
import com.ubsidi.epos_2021.online.services_receivers.TiffintomPartnerService;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.InternetUtils;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.zj.wfsdk.WifiCommunication;

import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;

/**
 * Created by Amrish on 23-04-2021.
 */
public class MyApp extends Application {
    public PrinterSdk.Printer selectPrinter;
    public static String currencySymbol = "£";
    public int screenWidth = 0;
    public boolean isAddIMinDevice = false;
    public static int screenHeight = 0;
    public static EposUserPermission userPermission;
    public static int printerStatus = -1;
    public static String openedOrderTypeId;
    private static MyApp ourInstance;
    public MyPreferences myPreferences;
    public boolean kitchenCopy;
    public OrderDetail orderDetail;
    public ArrayList<Category> categories = new ArrayList<>();
    public ArrayList<OrderItem> orderItems = new ArrayList<>();
    public ArrayList<PaymentMethod> paymentMethods = new ArrayList<>();
    public ArrayList<SiteSetting> siteSettings = new ArrayList<>();
    public ArrayList<TableStatus> tableStatuses = new ArrayList<>();
    public ArrayList<OrderStatuses> orderStatuses = new ArrayList<>();
    public AppDatabase appDatabase;
    public boolean isInternetAvailable = true;
    public String restaurant_id;
    public boolean orderTiffinTomLogo = false;
    public Bitmap businessLogo, tiffintomLogo, tiffintomLogoSmall;
    public boolean needToPrint = false;
    public boolean isPaymentLinkSent = false;
    public boolean isCashDrawerOpen = false;
    public boolean shallWeRefreshOrders = true, isReservationOpen = false, isFromDeleteOrder = false;
    public boolean showBanquetPorducts = false;
    public String current_day;
    public String banquetDay, banquetOrderTypes;
    public WifiPrinter wifiPrinter;
    public boolean drawerCollapsed = true;
    private MediaPlayer mp, delayedOrderMP, paymentSuccessMP, paymentFailedMP, newMessageMP, mpReservations;
    public boolean isFactoryResetData = false;
    private Printer defaultPrinter;
    private String lastPrintIp;
    private OrderDetail orderDetailPrint;
    protected Printer defaultOnlineKitchenPrinter;
    private SiteSetting kitchenCopyType, buzzerSetting;
    boolean isOpenCashDrawer = false;
    boolean isOpenCashDrawerDefault = false;
    private ZoneRichPrinter zoneRichPrinter;
    public IMinPrinterUtils iMinPrinterUtils;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    public BluetoothPrinter bluetoothPrinter;
    private int headerAlignment = 0;
    public Bitmap paymentLinkBitmap;

    public static MyApp getInstance() {
        return ourInstance;
    }

    public static float calculatedAddonPrice(String orderTypeId, Addon addon) {
        if (orderTypeId == null) return addon.price;
        if (orderTypeId.equalsIgnoreCase("3")) return addon.delivery_price;
        if (orderTypeId.equalsIgnoreCase("5")) return addon.takeaway_price;
        if (orderTypeId.equalsIgnoreCase("2")) return addon.takeaway_price;
        return addon.price;
    }

    public static float calculatedProductPrice(String orderTypeId, Product product) {
        MyApp myApp = MyApp.getInstance();
        if (!Validators.isNullOrEmpty(myApp.banquetDay) && !Validators.isNullOrEmpty(myApp.banquetOrderTypes) && product.is_banquet) {

            if (orderTypeId == null) return product.price;
            if (orderTypeId.equalsIgnoreCase("3")) {
                if (myApp.banquetOrderTypes.contains("delivery"))
                    return product.waiting_price;
                else return product.delivery_price;
            }
            if (orderTypeId.equalsIgnoreCase("5")) {
                if (myApp.banquetOrderTypes.contains("waiting"))
                    return product.waiting_price;
                else
                    return product.takeaway_price;
            }
            if (orderTypeId.equalsIgnoreCase("2")) {
                if (myApp.banquetOrderTypes.contains("collection"))
                    return product.waiting_price;
                else
                    return product.takeaway_price;
            }
            if (orderTypeId.equalsIgnoreCase("1")) {
                if (myApp.banquetOrderTypes.contains("dinein"))
                    return product.waiting_price;
                else
                    return product.price;
            }
            return product.price;
        } else {
            if (orderTypeId == null) return product.price;
            if (orderTypeId.equalsIgnoreCase("3")) return product.delivery_price;
            if (orderTypeId.equalsIgnoreCase("5")) return product.takeaway_price;
            if (orderTypeId.equalsIgnoreCase("2")) return product.takeaway_price;
            return product.price;
        }
    }

    @Override
    public void onCreate() {
        super.onCreate();
        isAddIMinDevice = isAddImInPrint();
        buzzerSetting = findSetting("open_cash_drawer_after_send_to_kitchen");
        ourInstance = this;
        restaurant_id = null;
        getRestaurantId();
        //  CrashReporter.initialize(this); Only for debug purpose , uncomment it releasing apk
        appDatabase = Room.databaseBuilder(getApplicationContext(),
                        AppDatabase.class, "epos_2021-database")
                .addMigrations(AppDatabase.MIGRATION_1_2)
                .addMigrations(AppDatabase.MIGRATION_2_3)
                .addMigrations(AppDatabase.MIGRATION_3_4)
                .addMigrations(AppDatabase.MIGRATION_4_5)
                .addMigrations(AppDatabase.MIGRATION_5_6)
                .addMigrations(AppDatabase.MIGRATION_6_7)
                .addMigrations(AppDatabase.MIGRATION_7_8)
                .addMigrations(AppDatabase.MIGRATION_8_9)
                .addMigrations(AppDatabase.MIGRATION_9_10)
                .addMigrations(AppDatabase.MIGRATION_10_11)
                .addMigrations(AppDatabase.MIGRATION_11_12)
                .addMigrations(AppDatabase.MIGRATION_12_13)
                .addMigrations(AppDatabase.MIGRATION_13_14)
                .addMigrations(AppDatabase.MIGRATION_14_15)
                .addMigrations(AppDatabase.MIGRATION_15_16)
                .addMigrations(AppDatabase.MIGRATION_16_17)
                .addMigrations(AppDatabase.MIGRATION_17_18)
                .addMigrations(AppDatabase.MIGRATION_18_19)
                .addMigrations(AppDatabase.MIGRATION_19_20)
                .addMigrations(AppDatabase.MIGRATION_20_21)
                .addMigrations(AppDatabase.MIGRATION_21_22)
                .addMigrations(AppDatabase.MIGRATION_22_23)
                .addMigrations(AppDatabase.MIGRATION_23_24)
                .addMigrations(AppDatabase.MIGRATION_24_25)
                .addMigrations(AppDatabase.MIGRATION_25_26)
                .addMigrations(AppDatabase.MIGRATION_26_27)
                .addMigrations(AppDatabase.MIGRATION_27_28)
                .addMigrations(AppDatabase.MIGRATION_28_29)
                .addMigrations(AppDatabase.MIGRATION_29_30)
                .addMigrations(AppDatabase.MIGRATION_30_31)
                .addMigrations(AppDatabase.MIGRATION_31_32)
                .addMigrations(AppDatabase.MIGRATION_32_33)
                .addMigrations(AppDatabase.MIGRATION_33_34)
                .fallbackToDestructiveMigration()
                .allowMainThreadQueries()
                .build();
        new Thread(() -> {
            myPreferences = new MyPreferences(this);
            FirebaseCrashlytics.getInstance().setCrashlyticsCollectionEnabled(true);
            initNetwork();
        }).start();
        Thread.setDefaultUncaughtExceptionHandler(new MyExceptionHandler(this));
        getFirebaseToken();
        initOrderSoundMP();
        initReservationsSoundMP();
        initPaymentFailedMP();
        initPaymentSuccessMP();
        initDelayedOrderSoundMP();
        initNewMessageSoundMP();
        setupData();
        CALLERID.getInstance().ConnectCallerId(this);
        current_day = CommonFunctions.getCurrentTimeFormatted("EEEE");
        new Thread(() -> iMinPrinterUtils = new IMinPrinterUtils(this)).start();
    }

    public void setupData() {
        new DataSetupAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private void initNetwork() {
        OkHttpClient okHttpClient = new OkHttpClient().newBuilder()
                .connectTimeout(1, TimeUnit.MINUTES)
                .readTimeout(1, TimeUnit.MINUTES)
                .writeTimeout(1, TimeUnit.MINUTES)
                .addInterceptor(new NetworkInterceptor())
                .build();
        AndroidNetworking.initialize(getApplicationContext(), okHttpClient);
        new Timer().schedule(new CheckConnection(ourInstance), 0, 40000);
    }

    public void setOrderItems(ArrayList<OrderItem> orderItems) {
        this.orderItems.clear();
        this.orderItems.addAll(orderItems);
    }

    public void setPaymentMethods(ArrayList<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    public int getCartProductsCount(String productId) {
        int count = 0;
        for (OrderItem orderItem : orderItems) {
            if (!Validators.isNullOrEmpty(orderItem.product_id) && orderItem.product_id.equalsIgnoreCase(productId) && Validators.isNullOrEmpty(orderItem.order_split_id)) {
                count = count + orderItem.sent_to_kitchen_quantity;
            }

        }
        return count;

    }

    public void notifyCart(Context context, Intent intent) {
        LocalBroadcastManager.getInstance(context).sendBroadcast(intent);
    }

    public void notifyCallReceived(Context context, Intent intent) {
        if (context == null) context = this;
        LocalBroadcastManager.getInstance(context).sendBroadcast(intent);
    }

    public String getDeviceId() {
        return Settings.Secure.getString(getContentResolver(), Settings.Secure.ANDROID_ID);
    }

    public SiteSetting findSetting(String key) {
        SiteSetting siteSetting = new SiteSetting();
        siteSetting.key = key;
        int index = siteSettings.indexOf(siteSetting);
        if (index == -1) return null;
        if (siteSettings.size() == 0 || siteSettings.size() - 1 < index) return null;
        return siteSettings.get(index);
    }

    public void checkDeviceDataReset(Callable<Void> nextMethod) {
        new Thread(() -> {
            SiteSetting bussinessSiteSetting = findSetting(BUSINESS_EVENING_END_TIME);
            if (bussinessSiteSetting != null && bussinessSiteSetting.value != null) {
                Calendar currentCalender = Calendar.getInstance(Locale.getDefault());
                Calendar deviceResetTime = Calendar.getInstance(Locale.getDefault());
                String currentDate = CommonFunctions.formatMiliToDesireFormat(deviceResetTime.getTimeInMillis(), DDMMYYYY);
                deviceResetTime.setTime(CommonFunctions.convertStringDateToDate(currentDate + " " + bussinessSiteSetting.value, DDMMYYYYHHMMA));
                deviceResetTime.add(Calendar.HOUR, 3);
                Log.e("getLocalTime", "currentCompareTime " + deviceResetTime.getTime() + " currentCalender " + currentCalender.getTime() + " comapre " + (currentCalender.getTimeInMillis() >= deviceResetTime.getTimeInMillis()));
                if (currentCalender.getTimeInMillis() >= deviceResetTime.getTimeInMillis()) {
                    DeviceInfo deviceInfo = appDatabase.resetDeviceOnDailyDao().findByDate(currentDate);
                    if (deviceInfo == null) {
                        try {
                            deviceInfo = new DeviceInfo();
                            deviceInfo.resetDate = currentDate;
                            appDatabase.resetDeviceOnDailyDao().insert(deviceInfo);
                            nextMethod.call();
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }).start();
    }

    public boolean getSubAddonStatus() {
        try {
            SiteSetting prep_location_subaddon_status = MyApp.getInstance().findSetting("prep_location_subaddon_status");
            if (prep_location_subaddon_status == null) return false;
            return prep_location_subaddon_status.value != null && prep_location_subaddon_status.value.equalsIgnoreCase("show");
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }


    public TableStatus findStatus(String status) {
        TableStatus tableStatus = new TableStatus();
        tableStatus.status = status;
        int index = tableStatuses.indexOf(tableStatus);
        if (index == -1) return null;
        if (tableStatuses.size() == 0 || tableStatuses.size() - 1 < index) return null;
        return tableStatuses.get(index);
    }

    private void performUserLogin() {
        if (myPreferences.getLoggedInUser() == null) return;
        LogUtils.e("Performing user login in background");
        String username = myPreferences.getLoggedInUser().username;
        String password = myPreferences.getLoggedInUser().password;
        AndroidNetworking.post(ApiEndPoints.user_login)
                .addBodyParameter("username", username)
                .addBodyParameter("password", password)
                .build()
                .getAsObject(User.class, new ParsedRequestListener<User>() {
                    @Override
                    public void onResponse(User response) {
                        LogUtils.e("User loging done in background");
                        myPreferences.saveEposUserPermission(new Gson().toJson(response.permissions));
                        MyApp.userPermission = response.permissions;
                        response.permissions = null;
                        response.password = password;
                        myPreferences.saveLoggedInUser(response);
                        myPreferences.userLoggedInWithoutInternet(false);
                    }

                    @Override
                    public void onError(ANError anError) {
                    }
                });
    }

    private void performAdminLogin() {
        try {
            //progressDialog.show();
            AndroidNetworking.post(ApiEndPoints.admin_login)
                    .addQueryParameter("request_for", "admin")
                    .addBodyParameter("username", myPreferences.getUserNameAdmin())
                    .addBodyParameter("password", myPreferences.getEposAdminPassword())
                    .build()
                    .getAsObject(Admin.class, new ParsedRequestListener<Admin>() {
                        @Override
                        public void onResponse(Admin response) {
                            response.businesses = null;
                            MyApp.getInstance().myPreferences.saveLoggedInAdmin(response);
                            MyApp.getInstance().myPreferences.saveForOfflineLoginLoggedInAdmin(response);
                            MyApp.getInstance().myPreferences.adminLoggedInWithoutInternet(false);
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getApplicationContext(), apiError.getMessage());
                            } else if (anError.getErrorCode() >= 500) {
                                ToastUtils.makeSnackToast(getApplicationContext(), "Error occurred while login");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // Checking Internet connectivity
    public boolean isConnected(Context context) {
        return isInternetAvailable;
    }

    private boolean hasNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
//
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    private boolean hasInternetConnected(Context context) {
        if (hasNetworkAvailable(context)) {
            try {
                HttpURLConnection connection = (HttpURLConnection) new URL("https://www.google.com").openConnection();

                connection.setRequestProperty("User-Agent", "Test");
                connection.setRequestProperty("Connection", "close");
                connection.setConnectTimeout(1500);
                connection.connect();

                boolean internetAvailable = (connection.getResponseCode() == 200);
                if (internetAvailable && myPreferences.isUserLoginWithoutInternet()) {
                    performUserLogin();
                }
                return internetAvailable;
            } catch (MalformedURLException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String getRestaurantId() {
        if (!Validators.isNullOrEmpty(restaurant_id) && !restaurant_id.equalsIgnoreCase("null")) {
            return restaurant_id;
        }
        SiteSetting resIdSetting = findSetting("res_id");
        if (resIdSetting == null || Validators.isNullOrEmpty(resIdSetting.value) || resIdSetting.value.equals("null")) {
            restaurant_id = "";
            return "";
        } else {
            restaurant_id = resIdSetting.value;
            return restaurant_id;
        }
    }

    private void getFirebaseToken() {
        FirebaseApp.initializeApp(ourInstance);
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener(task -> {
            if (!task.isSuccessful()) {
                return;
            }
            String token = task.getResult();
            myPreferences.setUserFCMToken(token);
        });
    }

    public void generateTiffintomLogoBitmap() {
        new Thread(() -> {
            tiffintomLogo = BitmapFactory.decodeResource(this.getResources(), R.drawable.printer_tiffinotom_logo);
            // change logo as asked by kamal sir at 02-01-2023
            //tiffintomLogoSmall = BitmapFactory.decodeResource(this.getResources(), R.drawable.printer_tiffinotom_logo_small);
            tiffintomLogoSmall = BitmapFactory.decodeResource(this.getResources(), R.drawable.printer_tiffinotom_logo_medium);
        }).start();
    }

    public void getOnlineOrderTiffinTomLogo(boolean orderTiffinTomLogo) {
        this.orderTiffinTomLogo = orderTiffinTomLogo;
        /*SiteSetting logoSetting = findSetting("online_order_tiffintom_logo");
        if (logoSetting == null || Validators.isNullOrEmpty(logoSetting.value)) {
            orderTiffinTomLogo = "no";
        } else {
            orderTiffinTomLogo = logoSetting.value;
        }*/
    }

    public void generateBusinessLogoBitmap() {
        new Thread(() -> {
            SiteSetting logoSetting = findSetting("logo");
            if (logoSetting == null || Validators.isNullOrEmpty(logoSetting.value))
                businessLogo = null;
            else {
                try {
                    URL url = new URL(logoSetting.value);
                    businessLogo = BitmapFactory.decodeStream(url.openConnection().getInputStream());
                    LogUtils.e("BITMAP::", "PRINT::", "URL::", url.toString());
                } catch (IOException e) {
                    e.printStackTrace();
                    LogUtils.e("BITMAP::", "PRINT::", Log.getStackTraceString(e));
                }
            }
        }).start();

    }

    public void noInternet(Activity activity) {
//        if (activity != null)
//            startActivity(new Intent(activity, NoInternetActivity.class).setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK | Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
    }

    public void initService() {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                //schedulerJob(getApplicationContext());
                startService(new Intent(getApplicationContext(), TiffintomPartnerService.class));
            } else {
                startService(new Intent(getApplicationContext(), TiffintomPartnerService.class));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void schedulerJob(Context context) {
        try {
            ComponentName serviceComponent = new ComponentName(context, TiffintomPartnerJobService.class);
            JobInfo.Builder builder = new JobInfo.Builder(0, serviceComponent);
            builder.setMinimumLatency(5000);    // wait at least
            builder.setOverrideDeadline(5 * 1000);  //delay time
            builder.setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY);  // require unmetered network
            builder.setRequiresCharging(false);  // we don't care if the device is charging or not
            builder.setRequiresDeviceIdle(false); // device should be idle
            System.out.println("(scheduler Job");
            JobScheduler jobScheduler = null;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
                jobScheduler = context.getSystemService(JobScheduler.class);
            }
            jobScheduler.schedule(builder.build());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void saveScreenWidth(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        screenWidth = displayMetrics.widthPixels;
        screenHeight = displayMetrics.heightPixels;
    }

    public boolean productImageEnabled() {
        SiteSetting productImageSetting = findSetting("product_image_visible");
        if (productImageSetting == null) return false;
        return !productImageSetting.value.equalsIgnoreCase("no");
    }

    private void initOrderSoundMP() {
        mp = MediaPlayer.create(this, R.raw.notification);
    }

    public void initReservationsSoundMP() {
        try {
            if (myPreferences.getSelectedReservationFileUri() != null) {
                mpReservations = MediaPlayer.create(this, Uri.parse(myPreferences.getSelectedReservationFileUri()));
            } else {
                mpReservations = MediaPlayer.create(this, R.raw.notification);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDelayedOrderSoundMP() {
        delayedOrderMP = MediaPlayer.create(this, R.raw.delayed_order);
    }

    private void initPaymentSuccessMP() {
        paymentSuccessMP = MediaPlayer.create(this, R.raw.payment_approval_sound);
    }

    private void initNewMessageSoundMP() {
        newMessageMP = MediaPlayer.create(this, R.raw.new_message);
    }

    public void startOrderSound() {
        if (mp != null) {
            mp.start();
            mp.setLooping(false);
            mp.setVolume(100, 100);
        }
    }

    public void stopOrderSound() {
        if (mp != null && mp.isPlaying()) {
            mp.stop();
            mp.reset();
            mp.release();
            initOrderSoundMP();
        }
    }

    public void startReservationsSound() {
        if (mpReservations != null) {
            mpReservations.start();
            mpReservations.setLooping(false);
            mpReservations.setVolume(100, 100);
        }
    }

    public void stopReservationsSound() {
        try {
            if (mpReservations != null && mpReservations.isPlaying()) {
                mpReservations.stop();
                //mpReservations.reset();
                mpReservations.release();
                mpReservations = null;
                initReservationsSoundMP();
            }
        } catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void resetReservationsSound() {
        if (mpReservations != null) {
            mpReservations.stop();
            //mpReservations.reset();
            mpReservations.release();
            mpReservations = null;
            initReservationsSoundMP();
        }
    }

    public void startDelayedOrderSound() {
        if (delayedOrderMP != null) {
            delayedOrderMP.start();
            delayedOrderMP.setLooping(true);
            delayedOrderMP.setVolume(100, 100);
        }
    }

    public void stopDelayedOrderSound() {
        if (delayedOrderMP != null && delayedOrderMP.isPlaying()) {
            delayedOrderMP.stop();
            delayedOrderMP.reset();
            delayedOrderMP.release();
            initDelayedOrderSoundMP();
        }
    }

    public void startPaymentSuccessSound() {
        if (paymentSuccessMP != null) {
            paymentSuccessMP.start();
            paymentSuccessMP.setVolume(100, 100);
        }
    }

    public void stopPaymentSuccessSound() {
        if (paymentSuccessMP != null && paymentSuccessMP.isPlaying()) {
            paymentSuccessMP.stop();
            paymentSuccessMP.reset();
            paymentSuccessMP.release();
            initPaymentSuccessMP();
        }
    }

    public void startNewMessageSound() {
        if (newMessageMP != null) {
            newMessageMP.start();
            newMessageMP.setVolume(100, 100);
        }
    }

    public void stopNewMessageSound() {
        if (newMessageMP != null && newMessageMP.isPlaying()) {
            newMessageMP.stop();
            newMessageMP.reset();
            newMessageMP.release();
            initNewMessageSoundMP();
        }
    }

    private void initPaymentFailedMP() {
        paymentFailedMP = MediaPlayer.create(this, R.raw.decline_sound);
    }

    public void startPaymentFailedSound() {
        if (paymentFailedMP != null) {
            paymentFailedMP.start();
            paymentFailedMP.setVolume(100, 100);
        }
    }

    public void stopPaymentFailedSound() {
        if (paymentFailedMP != null && paymentFailedMP.isPlaying()) {
            paymentFailedMP.stop();
            paymentFailedMP.reset();
            paymentFailedMP.release();
            initPaymentFailedMP();
        }
    }

    // Checking Printer connection
    public void checkPrinterIP(String ip, int port) {
        boolean exists = false;
        LogUtils.e("Cheking iP ");
        try {
            SocketAddress sockaddr = new InetSocketAddress(ip, port);
            // Create an unbound socket
            Socket sock = new Socket();
            LogUtils.e("Cheking iP inside");
            // This method will block no more than timeoutMs.
            // If the timeout occurs, SocketTimeoutException is thrown.
            int timeoutMs = 2000;   // 100 miliseconds
            sock.connect(sockaddr, timeoutMs);
            exists = true;
            LogUtils.e("IP Exists " + exists);
            printerStatus = 1;
//            ToastUtils.makeSnackToast(activity, "Printer connectable");
        } catch (IOException e) {
            printerStatus = 0;
            // Handle exception
            LogUtils.e("Cheking iP socket exception");
            e.printStackTrace();
            LogUtils.e(e.getMessage());
//            ToastUtils.makeSnackToast(activity, "Printer is not connected");
        }
    }

    public ZoneRichPrinter connectZonerich(ZoneRichPrinter zoneRichPrinter, Printer printer) {
//        if (printer != null && (printer.printer_model_name.contains("yoke4") || printer.printer_model_name.contains("pos 80") || printer.printer_model_name.contains("pos-80")))
//            zoneRichPrinter.connectPrinterForWifi(printer.ip);
        return zoneRichPrinter;
    }

    public static class df {
        public static String format(float value) {
            return String.format("%.2f", value);
        }

        public static String format(double value) {
            return String.format("%.2f", value);
        }
    }

    private class DataSetupAsync extends AsyncTask<Void, Void, String> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Void... lists) {
            ArrayList<Category> tempCategories = new ArrayList<>();
            LogUtils.e("Settingup data");

            ArrayList<CategoryWithChildren> categoryWithChildren = (ArrayList<CategoryWithChildren>) appDatabase.categoryDao().listWithChild();
            for (CategoryWithChildren c : categoryWithChildren) {
                Category category = c.category;
                category.children = (ArrayList<Category>) c.children;
                ArrayList<Category> childs = new ArrayList<>();
                for (Category childCategory : category.children) {
                    if (!childCategory.disabled) {
                        childs.add(childCategory);
                    }
                }
                category.children = childs;
                tempCategories.add(category);
            }
            categories.clear();
            categories.addAll(tempCategories);

            generateBusinessLogoBitmap();
            //getOnlineOrderTiffinTomLogo();
            generateTiffintomLogoBitmap();
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            LogUtils.e("Settingup data finished");
        }
    }

    class CheckConnection extends TimerTask {
        private final Context context;

        public CheckConnection(Context context) {
            this.context = context;
        }

        public void run() {
            if (InternetUtils.isNetworkConnected(getApplicationContext())) {
                isInternetAvailable = true;
                if (myPreferences.isUserLoginWithoutInternet()) {
                    performUserLogin();
                }
                if (myPreferences.isAdminLoginWithoutInternet() && !Validators.isNullOrEmpty(myPreferences.getUserNameAdmin()) && !Validators.isNullOrEmpty(myPreferences.getEposAdminPassword())) {
                    performAdminLogin();
                }
            } else {
                isInternetAvailable = false;
            }
            //isInternetAvailable = hasInternetConnected(context);
        }
    }

    /*private void registerInternetCheckReceiver() {
        IntentFilter internetFilter = new IntentFilter();
        internetFilter.addAction("android.net.wifi.STATE_CHANGE");
        internetFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        registerReceiver(broadcastReceiver, internetFilter);
    }

    BroadcastReceiver broadcastReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            // internet lost alert dialog method call from here...
            final ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            final NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetInfo == null) {
                isInternetAvailable=false;
            } else {
                // AlertUtils.showSimpleAlert(BaseActivity.this, "Internet start working");
                isInternetAvailable=true;
                if (myPreferences.isUserLoginWithoutInternet()) {
                    performUserLogin();
                }
            }
        }
    };*/

    public void changeStatusOnlineReservation(OnlineReservation reservation, Activity currentActivity) {
        try {
            Log.e("reservation", "" + reservation.status);

            ANRequest.PostRequestBuilder anRequest;
            anRequest = AndroidNetworking.post(ApiEndPoints.online_reservations_status_change)
                    .addPathParameter("id", String.valueOf(reservation.id))
                    .addBodyParameter("status", reservation.status);
            if (reservation.status.equalsIgnoreCase("cancel"))
                anRequest.addBodyParameter("cancel_reason", reservation.cancel_reason);
            anRequest.build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (reservation.status.equalsIgnoreCase("approved")) {
                                    OnlineReservation onlineReservation = new OnlineReservation();
                                    if (response.has("id")) {
                                        onlineReservation.id = response.getInt("id");
                                    }
                                    if (response.has("customer_name")) {
                                        onlineReservation.customer_name = response.getString("customer_name");
                                    }
                                    if (response.has("booking_phone")) {
                                        onlineReservation.booking_phone = response.getString("booking_phone");
                                    }
                                    if (response.has("customer_name")) {
                                        onlineReservation.customer_name = response.getString("customer_name");
                                    }
                                    if (response.has("status")) {
                                        onlineReservation.status = response.getString("status");
                                    }
                                    if (response.has("booking_date")) {
                                        onlineReservation.booking_date = response.getString("booking_date");
                                    }
                                    if (response.has("booking_time")) {
                                        onlineReservation.booking_time = response.getString("booking_time");
                                    }
                                    if (response.has("guest_count")) {
                                        onlineReservation.guest_count = response.getString("guest_count");
                                    }
                                    if (response.has("booking_instruction")) {
                                        onlineReservation.booking_instruction = response.getString("booking_instruction");
                                    }
                                    printReservation(onlineReservation, currentActivity);
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getApplicationContext(), apiError.getMessage());
                                } else if (anError.getErrorCode() >= 500) {
                                    ToastUtils.makeSnackToast(getApplicationContext(), "Error occurred while login");
                                }
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printReservation(OnlineReservation reservation, Activity currentActivity) {
        try {
            SiteSetting ticketHeaderSetting = findSetting("ticket_header");
            SiteSetting footerASetting = findSetting("footer_a");
            SiteSetting ticketHeaderTypeSetting = findSetting("ticket_header_type");
            SiteSetting footerBSetting = findSetting("footer_b");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = new ZoneRichPrinter(currentActivity);
            sunmiPrinter = new SunmiPrinter(currentActivity);
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(this);
            }
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(currentActivity);
            Reservation eposReservation = new Reservation();
            eposReservation.customer = new Customer();
            eposReservation.id = String.valueOf(reservation.id);
            eposReservation.customer.name = reservation.customer_name;
            eposReservation.customer.mobile = reservation.booking_phone;
            eposReservation.customer_name = reservation.customer_name;
            eposReservation.telephone = reservation.booking_phone;
            eposReservation.reservation_status = reservation.status;
            //eposReservation.reservation_date_time = reservation.booking_date + " " + CommonFunctions.formatUnknownDateTime(reservation.booking_time, "EEE hh:mm a", "HH:mm") + ":00";
            if (!Validators.isNullOrEmpty(reservation.booking_date) && !Validators.isNullOrEmpty(reservation.booking_time)) {
                eposReservation.reservation_date_time = reservation.booking_date + " " + CommonFunctions.formatUnknownDateTime(reservation.booking_time, "EEE hh:mm a", "HH:mm") + ":00";
            } else {
                eposReservation.reservation_date_time = reservation.booking_date;
            }
            eposReservation.online_reservation = true;
            if (!Validators.isNullOrEmpty(reservation.guest_count)) {
                eposReservation.diners = Integer.parseInt(reservation.guest_count);
            }
            if (!Validators.isNullOrEmpty(reservation.booking_instruction)) {
                eposReservation.special_instruction = reservation.booking_instruction;
            }
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                    zoneRichPrinter.printReservation(businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                        sunmiPrinterV3Mix.printReservation(businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    } else {
                        sunmiPrinter.printReservation(businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        iMinPrinterUtils.printReservation(eposReservation, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", tiffintomLogoSmall);
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            wifiPrinter.connect(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(200);
                            wifiPrinter.printReservation(businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        bluetoothPrinter.printReservation(businessLogo, "Reservation-" + reservation.id, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, eposReservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                    } else {
                                        ToastUtils.makeSnackToast(this, "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(this, "No printer model found");
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    // accept online order
    public void acceptOrder(String status, String order_id, String preparation, Activity currentActivity) {
        try {
            String url = ApiEndPoints.online_orders_status_change;
            /*if (order_type == 0) {
                url = ApiEndPoints.online_dinein_orders_status_change;
            }*/
            orderDetail = new OrderDetail();
            // if(orderDetail==null){
            orderDetail.preparation = preparation;
            //}
            Log.e("Test", " " + url);
            Log.e("Test", " " + order_id);
            Log.e("Test", " " + orderDetail.preparation);
            Log.e("Test", " " + status);
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = new ZoneRichPrinter(currentActivity);
            AndroidNetworking.post(url)
                    .addPathParameter("id", order_id)
                    .addBodyParameter("order_id", order_id)
                    .addBodyParameter("preparation", orderDetail.preparation)
                    .addBodyParameter("status", status)
                    .build()
                    .getAsObject(OrderDetail.class, new ParsedRequestListener<OrderDetail>() {
                        @Override
                        public void onResponse(OrderDetail response) {
                            //orderDetail.status = status;
                            try {
                                if (status.equalsIgnoreCase("accepted")) {
                                    orderDetail = response;
                                    orderDetail.status = "Accepted";
                                    if (defaultPrinter != null) {
                                        continueOnlineOrderPrint();
                                    }
                                }
                            } catch (Exception e) {
                                Log.e("ExceptionException", "Exception " + e.getMessage());
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    Log.e("onErroronError", "onError " + apiError.getMessage());
                                    ToastUtils.makeToast(getApplicationContext(), apiError.getMessage());
                                } else if (anError.getErrorCode() >= 500) {
                                    ToastUtils.makeToast(getApplicationContext(), "Error occurred while login");
                                }
                                Log.e("onErroronError", "ANError " + anError.getMessage());
                                anError.printStackTrace();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // print online order
    private void continueOnlineOrderPrint() {
        try {
            Log.e("continueOnlineOrderPrint", "continueOnlineOrderPrint " + (defaultPrinter != null && defaultPrinter.printer_model_name != null));
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                lastPrintIp = defaultPrinter.ip;
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        if (zoneRichPrinter == null) {
                            ToastUtils.makeToast(this, "Printer is null");
                        } else {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            printZonerich(orderDetail, false, defaultPrinter.ip);
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    printBTZonerich(orderDetail, false);
                                } else {
                                    ToastUtils.makeToast(this, "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    if (sunmiPrinter == null) {
                        ToastUtils.makeToast(this, "Printer is null");
                    } else {
                        printSunmi(orderDetail, false);
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin(orderDetail, false);
                    } else {
                        if (wifiPrinter == null) {
                            ToastUtils.makeToast(this, "Printer is null");
                        } else {
                            wifiPrinter.disconnect();
                            CommonFunctions.functionThatDelay(100);
                            wifiPrinter.connect(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            printWifi(orderDetail, false);
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(this, "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void continueForKitchenCopy(OrderDetail orderDetail, String printerType) {
//        if (true) {
//            goBack();
//            return;
//        }
//        defaultOnlineKitchenPrinter = defaultPrinter;
        try {

            try {
                new Thread(() -> {
                    ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) appDatabase.prepLocationDao().list();
                    isOpenCashDrawer = false;
                    if (prepLocations != null && prepLocations.size() > 0 && defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.id)) {
                        for (int i = 0; i < prepLocations.size(); i++) {
                            if (prepLocations.get(i).printer_id.equalsIgnoreCase(defaultOnlineKitchenPrinter.id) && prepLocations.get(i).cash_draw) {
                                isOpenCashDrawer = true;
                                break;
                            }
                        }
                    }
                }).start();
            } catch (Exception e) {
                e.printStackTrace();
                isOpenCashDrawer = false;
            }
            if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if (defaultOnlineKitchenPrinter.ip != null && !defaultOnlineKitchenPrinter.ip.equalsIgnoreCase("")) {
                    zoneRichPrinter.connectPrinter(defaultOnlineKitchenPrinter.ip);
                    CommonFunctions.functionThatDelay(100);
                    printZonerich(orderDetail, true, defaultOnlineKitchenPrinter.ip);

                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        zoneRichPrinter.connectPrinter(defaultOnlineKitchenPrinter.ip);
                        CommonFunctions.functionThatDelay(100);
                        zoneRichPrinter.openCashDrawer();
                    }
                } else {
                    try {
                        if (bluetoothPrinter != null) {
                            BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                            if (device != null) {
                                CommonFunctions.functionThatDelay(100);
                                printBTZonerich(orderDetail, true);
                                CommonFunctions.functionThatDelay(100);
                                bluetoothPrinter.openCashDrawer();
                            } else {
                                ToastUtils.makeToast(this, "No bluetooth device found.");
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                printSunmi(orderDetail, true);
                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                        sunmiPrinterV3Mix.openCashDrawer();
                    } else {
                        sunmiPrinter.openCashDrawer();
                    }
                }
            } else if (defaultOnlineKitchenPrinter != null && !Validators.isNullOrEmpty(defaultOnlineKitchenPrinter.printer_model_name) && (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if (defaultOnlineKitchenPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                    printIMin(orderDetail, true);
                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        IminSDKManager.opencashBox();
                    }
                } else {
                    if (lastPrintIp != null && !lastPrintIp.equalsIgnoreCase(defaultOnlineKitchenPrinter.ip)) {
                        wifiPrinter.disconnect();
                        CommonFunctions.functionThatDelay(100);
                        wifiPrinter.connect(defaultOnlineKitchenPrinter.ip);
                    } else {
                        if (defaultOnlineKitchenPrinter.ip != null) {
                            wifiPrinter.disconnect();
                            CommonFunctions.functionThatDelay(100);
                            wifiPrinter.connect(defaultOnlineKitchenPrinter.ip);
                        }
                    }
                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawer) {
                        CommonFunctions.functionThatDelay(500);
                        wifiPrinter.openCashDrawer(false);
                    }
                    CommonFunctions.functionThatDelay(500);
                    printWifi(orderDetail, true);
                }
            } else if (defaultPrinter != null && !Validators.isNullOrEmpty(defaultPrinter.printer_model_name)) {
                try {
                    new Thread(() -> {
                        ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) appDatabase.prepLocationDao().list();
                        isOpenCashDrawerDefault = false;
                        if (prepLocations != null && prepLocations.size() > 0) {
                            for (int i = 0; i < prepLocations.size(); i++) {
                                if (prepLocations.get(i).printer_id.equalsIgnoreCase(defaultPrinter.id) && prepLocations.get(i).cash_draw) {
                                    isOpenCashDrawerDefault = true;
                                    break;
                                }
                            }
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                    isOpenCashDrawerDefault = false;
                }
                CommonFunctions.functionThatDelay(200);
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                        zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                        CommonFunctions.functionThatDelay(100);
                        printZonerich(orderDetail, true, defaultPrinter.ip);

                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            zoneRichPrinter.openCashDrawer();
                        }
                    } else {
                        try {
                            if (bluetoothPrinter != null) {
                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                if (device != null) {
                                    CommonFunctions.functionThatDelay(100);
                                    printBTZonerich(orderDetail, true);
                                    CommonFunctions.functionThatDelay(100);
                                    bluetoothPrinter.openCashDrawer();
                                } else {
                                    ToastUtils.makeToast(this, "No bluetooth device found.");
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printSunmi(orderDetail, true);

                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                        if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                            sunmiPrinterV3Mix.openCashDrawer();
                        } else {
                            sunmiPrinter.openCashDrawer();
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin(orderDetail, true);
                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                            IminSDKManager.opencashBox();
                        }
                    } else {
                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && isOpenCashDrawerDefault) {
                            wifiPrinter.openCashDrawer(false);
                        }
                        CommonFunctions.functionThatDelay(500);
                        printWifi(orderDetail, true);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printIMin(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            String onlineOrderPrintCount;
            onlineOrderPrintCount = myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print;
            List<PrintSetting> printSettings = myPreferences.getPrintSetting();
            String printSettingName = "";
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                iMinPrinterUtils.printOrderFoodHub(listPrintStructure, tiffintomLogoSmall, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, onlineOrderPrintCount, () -> null);
            } else {
                iMinPrinterUtils.printOrder(tiffintomLogoSmall, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, onlineOrderPrintCount, () -> null);
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(500);
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    continueForKitchenCopy(orderDetail, "zonerich");
                }

            } else {
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printZonerich(OrderDetail orderDetail, boolean kitchenCopy, String defaultPrinterId) {
        try {
            List<PrintSetting> printSettings = myPreferences.getPrintSetting();
            String printSettingName = "";
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }

            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                zoneRichPrinter.printOrderFoodHub(listPrintStructure, printSettings, tiffintomLogoSmall, businessLogo, orderDetail, kitchenCopy, myPreferences, orderTiffinTomLogo, myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, defaultPrinterId, () -> null);
            } else {
                zoneRichPrinter.printOrder(structure, printSettings, tiffintomLogoSmall, businessLogo, orderDetail, kitchenCopy, myPreferences, orderTiffinTomLogo, myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, defaultPrinterId, () -> null);
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(500);
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    continueForKitchenCopy(orderDetail, "zonerich");
                   /* ConfirmationDialogFragment confirmationDialogFragment = ConfirmationDialogFragment.getInstance("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(, "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            } else {
                               *//* sendStatusChangeEvent();
                                goBack();*//*
                            }
                        }
                    });*/
                }

            } else {
               /* goBack();
                sendStatusChangeEvent();*/

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBTZonerich(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            bluetoothPrinter.printOrderZoneRich(tiffintomLogoSmall, orderDetail, kitchenCopy);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(500);
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "zonerich");
                } else {
                    continueForKitchenCopy(orderDetail, "zonerich");
                   /* ConfirmationDialogFragment confirmationDialogFragment = ConfirmationDialogFragment.getInstance("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "zonerich");
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });*/
                }

            } else {
               /* goBack();
                sendStatusChangeEvent();*/

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printWifi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            wifiPrinter.printOrder(tiffintomLogoSmall, businessLogo, orderDetail, myPreferences.getPrintSetting(), kitchenCopy, kitchenCopy, myPreferences, orderTiffinTomLogo);
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(500);
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "wifi");
                } else {
                    /*ConfirmationDialogFragment confirmationDialogFragment = ConfirmationDialogFragment.getInstance("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "wifi");
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });*/
                    continueForKitchenCopy(orderDetail, "wifi");
                }

            } else {
               /* goBack();
                sendStatusChangeEvent();*/

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSunmi(OrderDetail orderDetail, boolean kitchenCopy) {
        try {
            List<PrintSetting> printSettings = myPreferences.getPrintSetting();
            ArrayList<PrintStyle> listPrintStructure = new ArrayList<>();
            PrintStructure structure = null;
            String printSettingName = "";
            if (kitchenCopy) {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Kitchen") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Kitchen")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            } else {
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Online Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Online Bill")) {
                        printSettingName = printSettings.get(i).name;
                        structure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
            }
            if (printSettingName.equalsIgnoreCase("Custom Online Bill") || printSettingName.equalsIgnoreCase("Custom Online Kitchen")) {
                if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                    sunmiPrinterV3Mix.printOrderFoodHub(listPrintStructure, printSettings, tiffintomLogoSmall, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                } else {
                    sunmiPrinter.printOrderFoodHub(listPrintStructure, printSettings, tiffintomLogoSmall, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }
            } else {
                if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                    sunmiPrinterV3Mix.printOrder(structure, printSettings, tiffintomLogoSmall, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                } else {
                    sunmiPrinter.printOrder(structure, printSettings, tiffintomLogoSmall, businessLogo, orderDetail, kitchenCopy, orderTiffinTomLogo, myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print, () -> null);
                }
            }
            if (!kitchenCopy && !orderDetail.status.equalsIgnoreCase("failed")) {
                CommonFunctions.functionThatDelay(500);
                if (kitchenCopyType != null && kitchenCopyType.value.equalsIgnoreCase("auto")) {
                    continueForKitchenCopy(orderDetail, "sunmi");
                } else {
                    continueForKitchenCopy(orderDetail, "sunmi");
                    /*ConfirmationDialogFragment confirmationDialogFragment = ConfirmationDialogFragment.getInstance("Confirmation", "You want kitchen copy?", 0, "Confirm", "Cancel");
                    confirmationDialogFragment.setCancelable(false);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                continueForKitchenCopy(orderDetail, "sunmi");
                            } else {
                                sendStatusChangeEvent();
                                goBack();
                            }
                        }
                    });*/
                }

            } else {
               /* sendStatusChangeEvent();
                goBack();*/
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printOrder(OrderDetail orderDetail, boolean kitchenCopy) {
        String onlineOrderPrintCount = myPreferences.getLoggedInAdmin().selected_business.online_order_number_of_print;
        this.orderDetailPrint = new OrderDetail(orderDetail);
        this.kitchenCopy = kitchenCopy ? true : false;
        iMinPrinterUtils.printOrder(tiffintomLogoSmall, businessLogo, orderDetailPrint, kitchenCopy, orderTiffinTomLogo, onlineOrderPrintCount, null);
    }

    private boolean isAddImInPrint() {
        final String deviceModel = SystemPropManager.getModel();
        return TextUtils.equals("D1p-601", deviceModel) || TextUtils.equals("D1p-602", deviceModel)
                || TextUtils.equals("D1p-603", deviceModel) || TextUtils.equals("D1p-604", deviceModel)
                || TextUtils.equals("D1w-701", deviceModel) || TextUtils.equals("D1w-702", deviceModel)
                || TextUtils.equals("D1w-703", deviceModel) || TextUtils.equals("D1w-704", deviceModel)
                || TextUtils.equals("D4-501", deviceModel) || TextUtils.equals("D4-502", deviceModel)
                || TextUtils.equals("D4-503", deviceModel) || TextUtils.equals("D4-504", deviceModel)
                || deviceModel.startsWith("D4-505") || TextUtils.equals("M2-Max", deviceModel)
                || TextUtils.equals("D1", deviceModel) || TextUtils.equals("D1-Pro", deviceModel)
                || TextUtils.equals("Swift 1", deviceModel) || TextUtils.equals("I22T01", deviceModel)
                || TextUtils.equals("TF1-11", deviceModel) || TextUtils.equals("D3-510", deviceModel) || TextUtils.equals("S1-701", deviceModel) || TextUtils.equals("S1-702", deviceModel)
                || TextUtils.equals("M2-202", deviceModel) || TextUtils.equals("M2-203", deviceModel) || TextUtils.equals("M2-Pro", deviceModel);
    }

    public void clearCache() {
        deleteDir(getExternalCacheDir());
        if (getExternalCacheDirs() != null) {
            for (File file : getExternalCacheDirs()) {
                deleteDir(file);
            }
        }
        deleteDir(getCacheDir());
        deleteDir(getCodeCacheDir());
        triggerRebirth(this);
    }

    private Boolean deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            String[] children = dir.list();
            if (children != null) {
                for (String child : children) {
                    boolean success = deleteDir(new File(dir, child));
                    if (!success) {
                        return false;
                    }
                }
            }
            dir.delete();
        } else if (dir != null && dir.isFile()) {
            return dir.delete();
        } else {
            return false;
        }
        return false;
    }

    public void triggerRebirth(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(context.getPackageName());
        ComponentName componentName = intent.getComponent();
        Intent mainIntent = Intent.makeRestartActivityTask(componentName);
        context.startActivity(mainIntent);
        Runtime.getRuntime().exit(0);
    }

    public boolean isNewOrderVisible() {
        boolean isAddNewOrder = false;
        SiteSetting collectionSetting = findSetting("is_collection");
        SiteSetting deliverySetting = findSetting("is_delivery");
        SiteSetting waitingSetting = findSetting("is_waiting");
        SiteSetting webSetting = findSetting("is_weborder");
        if (collectionSetting != null && (collectionSetting.value.equals("true") || collectionSetting.value.equals("1")) && (userPermission != null && userPermission.collection.actions.list)) {
            isAddNewOrder = true;
        }
        if (deliverySetting != null && (deliverySetting.value.equals("true") || deliverySetting.value.equals("1")) && (userPermission != null && userPermission.delivery.actions.list)) {
            isAddNewOrder = true;
        }
        if (waitingSetting != null && (waitingSetting.value.equals("true") || waitingSetting.value.equals("1")) && (userPermission != null && userPermission.waiting.actions.list)) {
            isAddNewOrder = true;
        }
        if (webSetting != null && (webSetting.value.equalsIgnoreCase("true") || webSetting.value.equalsIgnoreCase("1")) && (userPermission != null && userPermission.web_orders.actions.list)) {
            isAddNewOrder = true;
        }
        return isAddNewOrder;
    }

    public ConfirmationDialogFragment getInstanceConfirmationDialog(String title, String info, int type, String positiveButton, String negativeButton) {
        ConfirmationDialogFragment rejectReasonDialog = new ConfirmationDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putString("positive_button", positiveButton);
        bundle.putString("negative_button", negativeButton);
        bundle.putInt("type", type);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public NewOrderDialogFragment getInstanceNewOrder(CallLogs callLogs, String orderTypeId) {
        NewOrderDialogFragment fragment = new NewOrderDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("calllogs", new Gson().toJson(callLogs));
        bundle.putString("order_type_id", orderTypeId);
        fragment.setArguments(bundle);
        return fragment;
    }

    public NewReservationFragment getInstanceNewReservation(CallLogs callLogs) {
        Bundle bundle = new Bundle();
        NewReservationFragment fragment = new NewReservationFragment();
        bundle.putString("calllogs", new Gson().toJson(callLogs));
        fragment.setArguments(bundle);
        return fragment;
    }

    public OrderTypeSelectionDialogFragment getInstanceOrderTypeSelection(CallLogs callLogs) {
        OrderTypeSelectionDialogFragment fragment = new OrderTypeSelectionDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("calllogs", new Gson().toJson(callLogs));
        fragment.setArguments(bundle);
        return fragment;
    }

    public PrintOptionsDialogFragment getInstancePrintOptions(SiteSetting printBillMainSetting, SiteSetting printAllMainSetting) {
        PrintOptionsDialogFragment fragment = new PrintOptionsDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("printBillSetting", new Gson().toJson(printBillMainSetting));
        bundle.putString("printAllSetting", new Gson().toJson(printAllMainSetting));
        fragment.setArguments(bundle);
        return fragment;
    }

    public EnterPasswordDialogFragment getInstanceEnterPassword(String for_what, String title, String info) {
        EnterPasswordDialogFragment rejectReasonDialog = new EnterPasswordDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("for_what", for_what);
        bundle.putString("title", title);
        bundle.putString("info", info);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public OnlineOrderViewFragment getInstanceOnlineOrder(String order_id, int order_type) {
        OnlineOrderViewFragment fragment = new OnlineOrderViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_id", order_id);
        bundle.putInt("order_type", order_type);
        fragment.setArguments(bundle);
        return fragment;
    }

    private class OrderSaveAsyncTask_ extends AsyncTask<String, String, String> {
        int _order_id;
        String uniqueId;
        String amount;

        public OrderSaveAsyncTask_(String uniqueId, String amount) {
            this.uniqueId = uniqueId;
            this.amount = amount;
        }

        @Override
        protected String doInBackground(String... orders) {
            try {
                Order dbOrder = appDatabase.orderDao().viewByUniqueId(uniqueId);
                if (dbOrder != null) {
                    _order_id = dbOrder._id;
                    dbOrder.order_status_id = "5";
                    dbOrder.order_status = "Order Completed";
                    // Update payment model in order
                    OrderPayment orderPayment = new OrderPayment();
                    orderPayment.payment_method_id = "11";
                    orderPayment.updater_id = myPreferences.getLoggedInUser().id;
                    orderPayment.amount = Float.parseFloat(amount);
                    if (Validators.isNullOrEmpty(dbOrder.id)) {
                        orderPayment.order_id = String.valueOf(dbOrder._id);
                    } else {
                        orderPayment.order_id = dbOrder.id;
                    }
                    orderPayment.payment_method_name = "Pay By Link";
                    orderPayment._order_id = dbOrder._id;
                    appDatabase.orderPaymentDao().insert(orderPayment);

                    // Complete order
                    dbOrder.total = Float.parseFloat(amount);
                    dbOrder.total_paid = Float.parseFloat(amount);

                    dbOrder.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);

                    appDatabase.orderDao().update(dbOrder);
                }
                /*if (dbOrder == null) {
                    dbOrder = appDatabase.orderDao().view(orderId);
                }*/
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String order_) {
            super.onPostExecute(null);
            try {
                // Upload order in background
                Intent intent = new Intent(MyApp.this, SingleOrderUploaderService.class);
                intent.putExtra("_order_id", _order_id);
                startService(intent);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    public void doOrderUpdateAndUpload(String order_id, String amount) {
        try {
            new OrderSaveAsyncTask_(order_id, amount).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initPrinter() {
        try {
            PrinterSdk.getInstance().getPrinter(this, new PrinterSdk.PrinterListen() {
                @Override
                public void onDefPrinter(PrinterSdk.Printer printer) {
                    selectPrinter = printer;
                }

                @Override
                public void onPrinters(List<PrinterSdk.Printer> printers) {

                }
            });
        } catch (SdkException e) {
            e.printStackTrace();
        }
    }

    public String getVersionName() {
        PackageManager manager = getPackageManager();
        PackageInfo info;
        try {
            info = manager.getPackageInfo(getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        return (info == null) ? "" : info.versionName;
    }

    public String getBlockText(int numberOfCharInLine, String textToPrint) {
        StringBuilder textToPrintReturn = new StringBuilder();
        textToPrint = " "+textToPrint+" ";
        int difference = numberOfCharInLine - textToPrint.length();
        difference = difference / 2;
        for (int i=0; i<difference;i++) {
            textToPrintReturn.append("-");
        }
        textToPrintReturn.append(textToPrint);
        for (int i=0; i<difference;i++) {
            textToPrintReturn.append("-");
        }
        difference = numberOfCharInLine - textToPrintReturn.length();
        if(difference>0){
            for (int i=0; i<difference;i++) {
                textToPrintReturn.append("-");
            }
        }
        return textToPrintReturn.toString();
    }
}
