package com.ubsidi.epos_2021.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.ToastUtils;

/**
 * Created by Amrish on 23-04-2021.
 */
public class AdminLoginActivity extends BaseActivity {
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;
    EditText etUsername, etPassword;
    MaterialButton btnLogin;
    AlertDialog progressDialog;

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_admin_login);
    }

    @Override
    protected void initViews() {
        super.initViews();
        progressDialog = CommonFunctions.customProgressDialog(this);
        etUsername = findViewById(R.id.input_username);
        etPassword = findViewById(R.id.input_password);
        btnLogin = findViewById(R.id.btn_login);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setListener();
    }

    private void setListener() {
        try {
            btnLogin.setOnClickListener(view -> {
                if (isValid()) {
                    if (myApp.isConnected(AdminLoginActivity.this)) {
                        performAdminLogin();
                    } else {
                        doOfflineLogin();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doOfflineLogin() {
        try {
            new Thread(() -> {
                if (myApp.appDatabase.productDao().list() != null && !myApp.appDatabase.productDao().list().isEmpty() && myApp.appDatabase.categoryDao().listAll() != null && !myApp.appDatabase.categoryDao().listAll().isEmpty()
                        && !Validators.isNullOrEmpty(myPreferences.getUserNameAdmin()) && !Validators.isNullOrEmpty(myPreferences.getEposAdminPassword())) {
                    String userName = etUsername.getText().toString();
                    String password = etPassword.getText().toString();
                    if (!userName.equalsIgnoreCase(myPreferences.getUserNameAdmin())) {
                        ToastUtils.makeSnackToast(AdminLoginActivity.this, "Invalid username");
                    } else if (!password.equalsIgnoreCase(myPreferences.getEposAdminPassword())) {
                        ToastUtils.makeSnackToast(AdminLoginActivity.this, "Invalid password");
                    } else {
                        MyApp.getInstance().myPreferences.saveLoggedInAdmin(MyApp.getInstance().myPreferences.getForOfflineLoginLoggedInAdmin());
                        MyApp.getInstance().myPreferences.saveBusinessId(MyApp.getInstance().myPreferences.getForOfflineLoginBusinessId());
                        MyApp.getInstance().myPreferences.adminLoggedInWithoutInternet(true);
                        myPreferences.savePullStatus(true);
                        if (myPreferences.getRegisteredDevice().disabled || Validators.isNullOrEmpty(myPreferences.getRegisteredDevice().status) || !myPreferences.getRegisteredDevice().status.equalsIgnoreCase("approved")) {
                            startActivity(new Intent(AdminLoginActivity.this, RegisterDeviceActivity.class));
                            finish();
                        } else {
                            startActivity(new Intent(AdminLoginActivity.this, LoginActivity.class));
                            finish();
                        }
                    }
                } else {
                    ToastUtils.makeToast(AdminLoginActivity.this, "Please check your internet connection");
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValid() {
        try {
            if (Validators.isNullOrEmpty(etUsername.getText().toString())) {
                etUsername.setError("Please enter email address");
                etUsername.requestFocus();
                return false;
            }
            if (Validators.isNullOrEmpty(etPassword.getText().toString())) {
                etPassword.setError("Please enter password");
                etPassword.requestFocus();
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void performAdminLogin() {
        try {
            progressDialog.show();
            AndroidNetworking.post(ApiEndPoints.admin_login)
                    .addQueryParameter("request_for", "admin")
                    .addBodyParameter("username", etUsername.getText().toString())
                    .addBodyParameter("password", etPassword.getText().toString())
                    .build()
                    .getAsObject(Admin.class, new ParsedRequestListener<Admin>() {
                        @Override
                        public void onResponse(Admin response) {
                            progressDialog.dismiss();
                            response.businesses = null;
                            myPreferences.saveUserNameAdmin(etUsername.getText().toString());
                            myPreferences.saveEposAdminPassword(etPassword.getText().toString());
                            MyApp.getInstance().myPreferences.saveLoggedInAdmin(response);
                            MyApp.getInstance().myPreferences.saveForOfflineLoginLoggedInAdmin(response);
                            startActivity(new Intent(AdminLoginActivity.this, SelectBusinessActivity.class));
                            finish();
                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDialog.dismiss();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(AdminLoginActivity.this, apiError.getMessage());
                            }else if (anError.getErrorCode() >= 500) {
                                ToastUtils.makeSnackToast(AdminLoginActivity.this, "Error occurred while login");
                            }else {
                                doOfflineLogin();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
