package com.ubsidi.epos_2021.activities;

import static com.ubsidi.epos_2021.utils.Constants.AUTO_ACCEPT;
import static com.ubsidi.epos_2021.utils.Constants.BOOKING_ID;
import static com.ubsidi.epos_2021.utils.Constants.IS_ORDER_RESET_AUTO;
import static com.ubsidi.epos_2021.utils.Constants.PREPARATION_TIME;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.graphics.Paint;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.multidex.BuildConfig;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.bumptech.glide.Glide;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.imin.library.IminSDKManager;
import com.makeramen.roundedimageview.RoundedImageView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.LogsAdapter;
import com.ubsidi.epos_2021.adapters.RecyclerMenuAdapter;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.AidlUtil;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.fragment.AnimatedConfirmationDialogFragment;
import com.ubsidi.epos_2021.fragment.ChatHomeFragment;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.fragment.CustomersFragment;
import com.ubsidi.epos_2021.fragment.DineInFragment;
import com.ubsidi.epos_2021.fragment.EposOrdersHistoryFragment;
import com.ubsidi.epos_2021.fragment.HomeFragment;
import com.ubsidi.epos_2021.fragment.NewHomeFragment;
import com.ubsidi.epos_2021.fragment.NewOrderDialogFragment;
import com.ubsidi.epos_2021.fragment.OrderTypeSelectionDialogFragment;
import com.ubsidi.epos_2021.fragment.OrdersAllFragment;
import com.ubsidi.epos_2021.fragment.ParkCallFragment;
import com.ubsidi.epos_2021.fragment.PaymentFragment;
import com.ubsidi.epos_2021.fragment.PushDialogFragment;
import com.ubsidi.epos_2021.fragment.ReservationListFragment;
import com.ubsidi.epos_2021.fragment.ResetDeviceDialogFragment;
import com.ubsidi.epos_2021.fragment.TablesLockingStatusFragment;
import com.ubsidi.epos_2021.fragment.VoucherHistoryFragment;
import com.ubsidi.epos_2021.merchant.fragments.MerchantSettingsFragment;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Cashdraw;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.RecyclerMenuItem;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.fragments.OnlineOrderViewFragment;
import com.ubsidi.epos_2021.online.fragments.OnlineOrdersFragment;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.online.models.Counts;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.InternetUtils;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.OnSwipeTouchListener;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import io.mpos.shared.helper.Log;

public class HomeActivity extends BaseActivity {
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;
    public Business selectedBusiness;
    ProgressBar progressLoading;
    // Test
    private MaterialCardView cvCallerId;
    private LinearLayout llCallerId;
    private TextView tvCallerName, tvCallerNumber, tvCalleAddress;
    private ImageView imgCancel, imgAccept, imgHold;

    private TextView tvAuto, tvManual;
    private TextView tvBusinessName, tvUsername, tvTime, tvRestaurantLogout;
    private LinearLayout llLogout;
    private RoundedImageView ivProfile;
    private TextView tvVersion;
    private boolean showLog = BuildConfig.DEBUG;
    private TextView tvDeviceId;
    Handler mHandler;
    FragmentManager manager;
    private CallLogs callLogs;
    private ZoneRichPrinter zoneRichPrinter;
    private WifiPrinter wifiPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private Printer defaultPrinter;
    private SiteSetting webOrderSetting;
    private SiteSetting pushDataSetting;
    private RecyclerView rvLogs, rvLeftMenu;
    private ArrayList<String> logs = new ArrayList<>();
    private LogsAdapter logsAdapter;
    private String destination;
    private ArrayList<RecyclerMenuItem> leftMenuItems = new ArrayList<>();
    private RecyclerMenuAdapter leftMenuAdapter;
    private String orderTypeId;
    private SiteSetting homeTheme;

    private MaterialCardView cvCollapse, cvDrawer, cvUserSection;
    private ImageView ivCollapse;
    private boolean isCollapsed = false;
    private TextView tvLogout;
    private FloatingActionButton fab;
    private LinearLayout llSideMain;
    public BluetoothPrinter bluetoothPrinter;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getIntent() != null) {
            destination = getIntent().getStringExtra("destination");
        }
    }

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_home_new);
        manager = getSupportFragmentManager();

    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            if (myApp.selectPrinter == null && Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                myApp.initPrinter();
            }
            //new NewCidEasyBridge(HomeActivity.this);
            myApp.getRestaurantId();
            if (!Validators.isNullOrEmpty(myApp.restaurant_id) && webOrderSetting != null && (webOrderSetting.value.equalsIgnoreCase("true") || webOrderSetting.value.equalsIgnoreCase("1")) && MyApp.userPermission.web_orders.actions.list) {
                myApp.initService();
            }
            //check for reset device
            myApp.checkDeviceDataReset(() ->
            {
                SiteSetting isOrderResetAuto = myApp.findSetting(IS_ORDER_RESET_AUTO);
                if (isOrderResetAuto != null && isOrderResetAuto.value.equalsIgnoreCase("yes")) {
                    eraseData("orders", true);
                } else {
                    ResetDeviceDialogFragment resetDeviceDialogFragment = new ResetDeviceDialogFragment();
                    resetDeviceDialogFragment.setCancelable(false);
                    resetDeviceDialogFragment.show(getSupportFragmentManager(), "reset_device_dialog");
                }
                return null;
            });
            LogUtils.e("FCM", myPreferences.getUserFCMToken());
            LogUtils.e("CAllder Id::>>>>>>>>", myPreferences.getCallerIdEnableStatus() + "");

            if (myApp.tiffintomLogo == null) {
                myApp.generateTiffintomLogoBitmap();
            }
            if (myApp.businessLogo == null) {
                myApp.generateBusinessLogoBitmap();
            }
            //if (myApp.orderTiffinTomLogo == null) {
            if (selectedBusiness != null)
                myApp.getOnlineOrderTiffinTomLogo(selectedBusiness.print_logo);
            //}
            SiteSetting banquetDay = myApp.findSetting("banquet_day");
            SiteSetting banquetOrderType = myApp.findSetting("banquet_type");
            if (banquetDay != null && !Validators.isNullOrEmpty(banquetDay.value) && banquetDay.value.contains(myApp.current_day.toLowerCase())) {
                myApp.banquetDay = myApp.current_day;
                if (banquetOrderType != null && !Validators.isNullOrEmpty(banquetOrderType.value)) {
                    myApp.banquetOrderTypes = banquetOrderType.value;
                }
                myApp.showBanquetPorducts = true;
            } else {
                myApp.banquetDay = null;
                myApp.showBanquetPorducts = false;
            }
            homeTheme = myApp.findSetting("home_theme");
            updateTime();
            setListeners();

            if (Validators.isNullOrEmpty(destination)) {
                changeHome();
                leftMenuAdapter.checkedId = "home";
            } else if (destination.equalsIgnoreCase("reservations")) {
                changeFragment(myApp.getInstanceNewReservation(new Gson().fromJson(getIntent().getStringExtra("calllogs"), CallLogs.class)), true);
                leftMenuAdapter.checkedId = "reservations";
            } else {
                changeHome();
                leftMenuAdapter.checkedId = "home";
            }
            rvLeftMenu.post(() -> leftMenuAdapter.notifyDataSetChanged());
            wakeupScreen();
            fetchRestaurantDetails();
            fetchPrintSettings();
            changeHome();

            SiteSetting headerAlignmentSetting = myApp.findSetting("ticket_header_type");
            if (headerAlignmentSetting != null && headerAlignmentSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (headerAlignmentSetting != null && headerAlignmentSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchRestaurantDetails() {
        try {
            if (Validators.isNullOrEmpty(myApp.restaurant_id)) {
                LogUtils.e("HOME", "Restaurant ID not found");
                return;
            }
            LogUtils.e("HOME", "Fetching res details");
            AndroidNetworking.get(ApiEndPoints.restaurant_details + myApp.restaurant_id).build().getAsJSONObject(new JSONObjectRequestListener() {
                @Override
                public void onResponse(JSONObject response) {
                    myPreferences.saveRestaurant(response);
                    LogUtils.e("HOME", "Fetched res details");
                }

                @Override
                public void onError(ANError anError) {
                    LogUtils.e("HOME", "Error while fetching restaurant details in Splash");
                    anError.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchPrintSettings() {
        LogUtils.e("HOME", "Fetching print settings");
        AndroidNetworking.get(ApiEndPoints.print_settings).addQueryParameter("nopaginate", "1").build()
                .getAsJSONArray(new JSONArrayRequestListener() {
                    @Override
                    public void onResponse(JSONArray response) {
                        LogUtils.e("Print Setting: " + response);
                        new Thread(() -> {
                            ArrayList<PrintSetting> printSettings = new ArrayList<>();
                            for (int i = 0; i < response.length(); i++) {
                                PrintSetting printSetting = new PrintSetting();
                                try {
                                    printSetting.name = response.getJSONObject(i).getString("name");
                                    printSetting.id = response.getJSONObject(i).getString("id");
                                    printSetting.service = response.getJSONObject(i).getString("service");
                                    ArrayList<PrintStyle> list_print_structure = new ArrayList<>();
                                    JSONObject jsPrintStructure = response.getJSONObject(i).getJSONObject("print_structure");
                                    Iterator<String> itPrintStructure = jsPrintStructure.keys();
                                    while (itPrintStructure.hasNext()) {
                                        String key = itPrintStructure.next();
                                        if (jsPrintStructure.getJSONObject(key).getBoolean("visibility")) {
                                            PrintStyle printStyle = new PrintStyle();
                                            if (jsPrintStructure.getJSONObject(key).has("separator") && !Validators.isNullOrEmpty(jsPrintStructure.getJSONObject(key).getString("separator"))) {
                                                printStyle.separator = jsPrintStructure.getJSONObject(key).getBoolean("separator");
                                            } else {
                                                printStyle.separator = false;
                                            }
                                            if (jsPrintStructure.getJSONObject(key).has("sequence") && !Validators.isNullOrEmpty(jsPrintStructure.getJSONObject(key).getString("sequence"))) {
                                                printStyle.sequence = jsPrintStructure.getJSONObject(key).getInt("sequence");
                                            } else {
                                                printStyle.sequence = i;
                                            }
                                            printStyle.style = jsPrintStructure.getJSONObject(key).getString("style");
                                            printStyle.size = jsPrintStructure.getJSONObject(key).getString("size");
                                            printStyle.key = key;
                                            printStyle.visibility = jsPrintStructure.getJSONObject(key).getBoolean("visibility");
                                            printStyle.alignment = jsPrintStructure.getJSONObject(key).getString("alignment");
                                            if (jsPrintStructure.getJSONObject(key).has("price") && !Validators.isNullOrEmpty(jsPrintStructure.getJSONObject(key).getString("price"))) {
                                                printStyle.price = jsPrintStructure.getJSONObject(key).getBoolean("price");
                                                Log.e("getJSONObject", "getJSONObject " + key + " isNullOrEmpty " + printStyle.price);
                                            } else {
                                                printStyle.price = false;
                                            }
                                            if (jsPrintStructure.getJSONObject(key).has("all_separator") && !Validators.isNullOrEmpty(jsPrintStructure.getJSONObject(key).getString("all_separator"))) {
                                                printStyle.all_separator = jsPrintStructure.getJSONObject(key).getBoolean("all_separator");
                                            } else {
                                                printStyle.all_separator = false;
                                            }
                                            if (jsPrintStructure.getJSONObject(key).has("block_name") && !Validators.isNullOrEmpty(jsPrintStructure.getJSONObject(key).getString("block_name"))) {
                                                printStyle.block_name = jsPrintStructure.getJSONObject(key).getBoolean("block_name");
                                            } else {
                                                printStyle.block_name = false;
                                            }
                                            list_print_structure.add(printStyle);
                                        }
                                    }
                                    printSetting.print_structure = new Gson().fromJson(jsPrintStructure.toString(), PrintStructure.class);
                                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                                        Collections.sort(list_print_structure, Comparator.comparing(o -> o.sequence));
                                    }
                                    printSetting.list_print_structure = list_print_structure;
                                    printSettings.add(printSetting);
                                } catch (JSONException e) {
                                    throw new RuntimeException(e);
                                }

                            }
                            myPreferences.savePrintSetting(printSettings);
                        }).start();
                    }

                    @Override
                    public void onError(ANError anError) {

                    }
                });
               /* .getAsObjectList(PrintSetting.class, new ParsedRequestListener<List<PrintSetting>>() {
            @Override
            public void onResponse(List<PrintSetting> response) {
                myPreferences.savePrintSetting(response);
                LogUtils.e("Print Setting: SIZE:" + response.size());
                LogUtils.e("SAVE PRINT SETTINGS");
            }

            @Override
            public void onError(ANError anError) {
                LogUtils.e("HOME", "Error while fetching print details in Splash");
                anError.printStackTrace();
            }
        }*/
        //);
    }

    private void changeHome() {
        try {
            //theme1 - home,theme2 - new home
            if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme1")) {
                changeFragment(new HomeFragment(), false);
            } else {
                changeFragment(new NewHomeFragment(), false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void wakeupScreen() {
        try {
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
            PowerManager powerManager = (PowerManager) getSystemService(POWER_SERVICE);
            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "MyApp::MyWakelockTag");
            wakeLock.acquire();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            if (myPreferences.getLoggedInAdmin() != null)
                selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;
            showLog = false;
            FirebaseMessaging.getInstance().subscribeToTopic("business_" + myPreferences.getLoggedInAdmin().selected_business.id).addOnCompleteListener(new OnCompleteListener<Void>() {
                @Override
                public void onComplete(@NonNull Task<Void> task) {
                    //Toast.makeText(HomeActivity.this, "Subscribe Success!", Toast.LENGTH_SHORT).show();
                }
            });
            webOrderSetting = myApp.findSetting("is_weborder");
            pushDataSetting = myApp.findSetting("cloud_system");
            zoneRichPrinter = new ZoneRichPrinter(this);
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(this);
            }
            sunmiPrinter = new SunmiPrinter(this);
            wifiPrinter = WifiPrinter.getInstance();

            // Caller ID Related Starts
            cvCallerId = findViewById(R.id.cvCallerId);
            progressLoading = findViewById(R.id.progress_loading);
            llCallerId = findViewById(R.id.llCallerId);

            tvCallerNumber = findViewById(R.id.tvCallerNumber);
            tvCallerName = findViewById(R.id.tvCallerName);
            tvCalleAddress = findViewById(R.id.tvCalleAddress);

            imgHold = findViewById(R.id.imgHold);
            imgCancel = findViewById(R.id.imgCancel);
            imgAccept = findViewById(R.id.imgAccept);

            // Caller ID Related Ends
            cvDrawer = findViewById(R.id.cvDrawer);
            cvCollapse = findViewById(R.id.cvCollapse);
            cvUserSection = findViewById(R.id.cvUserSection);
            ivCollapse = findViewById(R.id.ivCollapse);

            tvAuto = findViewById(R.id.tvAuto);
            tvManual = findViewById(R.id.tvManual);
            tvVersion = findViewById(R.id.tvVersion);
            ivProfile = findViewById(R.id.ivProfile);
            tvUsername = findViewById(R.id.tvUsername);
            tvDeviceId = findViewById(R.id.tvDeviceId);
            tvBusinessName = findViewById(R.id.tvBusinessName);
            tvTime = findViewById(R.id.tvTime);
            llLogout = findViewById(R.id.llLogout);
            tvLogout = findViewById(R.id.tvLogout);
            tvRestaurantLogout = findViewById(R.id.tvRestaurantLogout);
            fab = findViewById(R.id.fab);
            llSideMain = findViewById(R.id.llSideMain);
            tvRestaurantLogout.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
            String currentTime = new SimpleDateFormat("h:mm a", Locale.getDefault()).format(new Date());
            tvTime.setText(currentTime);

            if (myPreferences.getOrderSyncMode().equalsIgnoreCase("auto")) {
                tvAuto.setVisibility(View.VISIBLE);
                tvManual.setVisibility(View.GONE);
            } else if (myPreferences.getOrderSyncMode().equalsIgnoreCase("manual")) {
                tvAuto.setVisibility(View.GONE);
                tvManual.setVisibility(View.VISIBLE);
            }

            rvLeftMenu = findViewById(R.id.rvLeftMenu);
            rvLogs = findViewById(R.id.rvLogs);
            if (showLog) rvLogs.setVisibility(View.VISIBLE);
            else rvLogs.setVisibility(View.GONE);

            logsAdapter = new LogsAdapter(logs, (position, data) -> {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Clear", null, 1, "Clear", "Cancel");
                confirmationDialogFragment.show(getSupportFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        logs.clear();
                        logsAdapter.notifyDataSetChanged();
                    }
                });
            });
            rvLogs.setLayoutManager(new LinearLayoutManager(this, RecyclerView.VERTICAL, false));
            rvLogs.setAdapter(logsAdapter);

            leftMenuAdapter = new RecyclerMenuAdapter(leftMenuItems, true, (position, data) -> {
                RecyclerMenuItem model = (RecyclerMenuItem) data;
                handleMenuClick(model);

            });
            rvLeftMenu.setLayoutManager(new LinearLayoutManager(this, RecyclerView.VERTICAL, false));
            rvLeftMenu.setAdapter(leftMenuAdapter);

            isCollapsed = myApp.drawerCollapsed;
            collapseAction();

            defaultPrinter = myPreferences.getDefaultPrinter();

            if (defaultPrinter != null && defaultPrinter.printer_model_name != null && !defaultPrinter.printer_model_name.equalsIgnoreCase("")) {
                myPreferences.saveBluetoothPrinter(defaultPrinter.printer_model_name);
            }

            bluetoothPrinter = new BluetoothPrinter(this);

            // For testing
            if (BuildConfig.DEBUG) {
                if (bluetoothPrinter != null) {
                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                    if (device != null) {
                        ToastUtils.makeToast(HomeActivity.this, device.getName() + " Connected");
                    } else {
                        ToastUtils.makeToast(HomeActivity.this, "Default printer " + myPreferences.getBluetoothPrinter());
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OrdersAllFragment getInstance(String orderTypeId) {
        OrdersAllFragment ordersAllFragment = new OrdersAllFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_type_id", orderTypeId);
        ordersAllFragment.setArguments(bundle);
        return ordersAllFragment;
    }

    private void handleMenuClick(RecyclerMenuItem model) {
        try {
            if (model.id.equalsIgnoreCase("home")) {
                changeHome();
            }
            if (model.id.equalsIgnoreCase("new_order")) {
                createNewOrder();
            }
            if (model.id.equalsIgnoreCase("active_orders")) {
                changeFragment(getInstance(orderTypeId));
                orderTypeId = null;
            }
            if (model.id.equalsIgnoreCase("online_orders")) {
                changeFragment(getInstanceOnlineOrders("from_home"));
            }
            if (model.id.equalsIgnoreCase("tables")) {
                changeFragment(new DineInFragment());
            }
            if (model.id.equalsIgnoreCase("table_status")) {
                changeFragment(new TablesLockingStatusFragment());
            }
            if (model.id.equalsIgnoreCase("reservations")) {
                changeFragment(new ReservationListFragment());
            }
            if (model.id.equalsIgnoreCase("order_history")) {
                changeFragment(getInstanceEposOrdersHistory(null, false));
            }
            if (model.id.equalsIgnoreCase("cash_drawer")) {
                openCashDrawer();
            }
            if (model.id.equalsIgnoreCase("messages")) {
                changeFragment(new ChatHomeFragment());
            }
            if (model.id.equalsIgnoreCase("payments")) {
                changeFragment(new PaymentFragment());
            }
            if (model.id.equalsIgnoreCase("customers")) {
                changeFragment(CustomersFragment.getInstance());
            }
            if (model.id.equalsIgnoreCase("vouchers")) {
                changeFragment(new VoucherHistoryFragment());
            }
            if (model.id.equalsIgnoreCase("settings")) {
                changeFragment(new MerchantSettingsFragment());
            }
            if (model.id.equalsIgnoreCase("park_calls")) {
                changeFragment(new ParkCallFragment());
            }
            if (model.id.equalsIgnoreCase("push_data")) {
                if (!InternetUtils.isNetworkConnected(this)) {
                    ToastUtils.makeSnackToast(this, "No internet connection");
                } else {
                    startActivityForResult(new Intent(this, UploadOrdersActivity.class), Constants.CODE_REFRESH);
                }
            }
            if (model.id.equalsIgnoreCase("pull_data")) {
                if (!InternetUtils.isNetworkConnected(this)) {
                    ToastUtils.makeSnackToast(this, "No internet connection");
                } else {
                    new RunningOrderCountAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                }
            }
            if (model.id.equalsIgnoreCase("pull_customers")) {
                if (!InternetUtils.isNetworkConnected(this)) {
                    ToastUtils.makeSnackToast(this, "No internet connection");
                } else {
                    finishAffinity();
                    startActivityForResult(new Intent(this, PullCustomersActivity.class).putExtra("destination", "home"), Constants.CODE_REFRESH);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EposOrdersHistoryFragment getInstanceEposOrdersHistory(String typeId, boolean isArchived) {
        Bundle bundle = new Bundle();
        EposOrdersHistoryFragment fragment = new EposOrdersHistoryFragment();
        bundle.putString("order_type_id", typeId);
        bundle.putBoolean("is_archived", isArchived);
        fragment.setArguments(bundle);
        return fragment;
    }

    private class RunningOrderCountAsync extends AsyncTask<Object, String, String> {

        @Override
        protected String doInBackground(Object... objects) {
            List<String> statusIds = new ArrayList<>();
            statusIds.add("1");
            statusIds.add("2");
            statusIds.add("3");
            statusIds.add("7");
            List<Order> orders = myApp.appDatabase.orderDao().getRunningOrder(statusIds);
            if (!orders.isEmpty()) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Please complete all order before pulling the data", null, 0, "Confirm", "");
                confirmationDialogFragment.setCancelable(false);
                confirmationDialogFragment.show(getSupportFragmentManager(), "printer");
            } else {
                if ("manual".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                    startActivityForResult(new Intent(HomeActivity.this, UploadOrdersActivity.class).putExtra("isManual", true), Constants.CODE_REFRESH);
                } else {
                    finishAffinity();
                    startActivityForResult(new Intent(HomeActivity.this, PullActivity.class).putExtra("destination", "home"), Constants.CODE_REFRESH);
                }
            }
            return null;
        }
    }

    public void getParkCalls() {
        changeFragment(new ParkCallFragment());
    }

    private void createNewOrder() {
        try {
            Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);
            String orderTypeId = null;
            if (openedFragment != null && openedFragment instanceof OrdersAllFragment) {
                orderTypeId = MyApp.openedOrderTypeId;
                if (Validators.isNullOrEmpty(MyApp.openedOrderTypeId) || MyApp.openedOrderTypeId.equalsIgnoreCase("0") || MyApp.openedOrderTypeId.equalsIgnoreCase("6")) {
                    openOrderTypeSelectionDialog(null);
                } else {
                    if (orderTypeId != null) openNewOrderDialog(orderTypeId, null);
                }
            } else {
                openOrderTypeSelectionDialog(null);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openOrderTypeSelectionDialog(CallLogs callLogs) {
        try {
            OrderTypeSelectionDialogFragment orderTypeSelectionDialog = myApp.getInstanceOrderTypeSelection(callLogs);
            orderTypeSelectionDialog.show(getSupportFragmentManager(), "order_type");
            orderTypeSelectionDialog.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    String orderTypeId = (String) o;
                    if (orderTypeId != null) openNewOrderDialog(orderTypeId, callLogs);

                } else if (o instanceof CallLogs) {
                    changeFragment(myApp.getInstanceNewReservation((CallLogs) o));
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openNewOrderDialog(String orderTypeId, CallLogs callLogs) {
        try {
            NewOrderDialogFragment newOrderDialogFragment = myApp.getInstanceNewOrder(callLogs, orderTypeId);
            newOrderDialogFragment.show(getSupportFragmentManager(), "new_order");
            newOrderDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof Order) {
                    startActivity(new Intent(HomeActivity.this, NewOrderActivity.class).putExtra("order", new Gson().toJson(o)).putExtra("fetch_delivery_charge", ((Order) o).order_type_id.equalsIgnoreCase("3")));
                } else if (o instanceof CallLogs) {
                    changeFragment(myApp.getInstanceNewReservation((CallLogs) o));
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            llLogout.setOnClickListener(v -> askForLogout(false));
            tvRestaurantLogout.setOnClickListener(v -> askForLogout(true));

            llCallerId.setOnTouchListener(new OnSwipeTouchListener(HomeActivity.this) {
                @Override
                public void onSwipeLeft() {
                    super.onSwipeLeft();
                    changeStatusCallerid("parked");
                }

                @Override
                public void onSwipeRight() {
                    super.onSwipeRight();
                    changeStatusCallerid("parked");
                }

                @Override
                public void onSwipeTop() {
                    super.onSwipeTop();
                    changeStatusCallerid("parked");
                }

                @Override
                public void onSwipeBottom() {
                    super.onSwipeBottom();
                    changeStatusCallerid("parked");
                }
            });

            imgAccept.setOnClickListener(v -> changeStatusCallerid("accepted"));
            imgCancel.setOnClickListener(v -> changeStatusCallerid("rejected"));
            imgHold.setOnClickListener(v -> changeStatusCallerid("parked"));

            cvCollapse.setOnClickListener(v -> {
                isCollapsed = !isCollapsed;
                collapseAction();
            });
            fab.setOnClickListener(v -> {
                isCollapsed = !isCollapsed;
                collapseAction();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void collapseAction() {
        try {
            leftMenuAdapter.collapsed = isCollapsed;
            myApp.drawerCollapsed = isCollapsed;
            leftMenuAdapter.notifyDataSetChanged();
            if (isCollapsed) {
                ivCollapse.setRotation(0);
                fab.setRotation(0);
                tvBusinessName.setVisibility(View.GONE);
                tvTime.setVisibility(View.GONE);
                tvDeviceId.setVisibility(View.GONE);
                tvVersion.setVisibility(View.GONE);
                tvLogout.setVisibility(View.GONE);
                tvUsername.setVisibility(View.GONE);
                tvRestaurantLogout.setTextAlignment(View.TEXT_ALIGNMENT_CENTER);
                cvDrawer.setLayoutParams(new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
                ViewGroup.MarginLayoutParams cardViewMarginParams = (ViewGroup.MarginLayoutParams) cvDrawer.getLayoutParams();
                cardViewMarginParams.setMargins(0, 0, 8, 0);
                cvDrawer.requestLayout();
                llSideMain.setLayoutParams(new RelativeLayout.LayoutParams(getResources().getDimensionPixelSize(R.dimen.width_110), ViewGroup.LayoutParams.MATCH_PARENT));

                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) ivProfile.getLayoutParams();
                layoutParams.addRule(RelativeLayout.CENTER_HORIZONTAL, RelativeLayout.TRUE);
                ivProfile.setLayoutParams(layoutParams);
            } else {
                ivCollapse.setRotation(180);
                fab.setRotation(180);
                tvBusinessName.setVisibility(View.VISIBLE);
                tvTime.setVisibility(View.VISIBLE);
                tvDeviceId.setVisibility(View.VISIBLE);
                tvVersion.setVisibility(View.VISIBLE);
                tvLogout.setVisibility(View.VISIBLE);
                tvUsername.setVisibility(View.VISIBLE);
                tvRestaurantLogout.setTextAlignment(View.TEXT_ALIGNMENT_TEXT_START);
                cvDrawer.setLayoutParams(new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
                ViewGroup.MarginLayoutParams cardViewMarginParams = (ViewGroup.MarginLayoutParams) cvDrawer.getLayoutParams();
                cardViewMarginParams.setMargins(0, 0, 8, 0);
                cvDrawer.requestLayout();
                llSideMain.setLayoutParams(new RelativeLayout.LayoutParams(getResources().getDimensionPixelSize(R.dimen.width_180), ViewGroup.LayoutParams.MATCH_PARENT));

                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) ivProfile.getLayoutParams();
                layoutParams.removeRule(RelativeLayout.CENTER_HORIZONTAL);
                ivProfile.setLayoutParams(layoutParams);
            }
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver callReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                callLogs = new Gson().fromJson(intent.getStringExtra("calllogs"), CallLogs.class);

                cvCallerId.setVisibility(View.VISIBLE);
                if (callLogs.customer != null) {
                    Customer customer = callLogs.customer;
                    if (!Validators.isNullOrEmpty(customer.name)) {
                        tvCallerName.setText(customer.name);
                    } else {
                        tvCallerName.setText("");
                    }
                    StringBuilder sb = new StringBuilder();
                    if (!Validators.isNullOrEmpty(customer.house_no)) {
                        sb.append(customer.house_no).append(", ");
                    }
                    if (!Validators.isNullOrEmpty(customer.street)) {
                        sb.append(customer.street).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.postcode)) {
                        sb.append(customer.postcode).append("\n");
                    }

                    if (!Validators.isNullOrEmpty(customer.city)) {
                        sb.append(customer.city).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.state)) {
                        sb.append(customer.state).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.distance)) {
                        sb.append(customer.distance).append(" Miles away");
                    }

                    if (!Validators.isNullOrEmpty(sb.toString())) {
                        tvCalleAddress.setText(sb.toString());
                    } else {
                        tvCalleAddress.setText("");
                    }

                } else {
                    tvCallerName.setText("");
                    tvCalleAddress.setText("");
                }
                tvCallerNumber.setText(callLogs.number);
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    };
    BroadcastReceiver logsReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (showLog) {
                    logs.add(intent.getStringExtra("log"));
                    logsAdapter.notifyDataSetChanged();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };


    BroadcastReceiver onlineOrdersNotificationReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    Counts allCounts = new Gson().fromJson(intent.getStringExtra("counts"), Counts.class);
                    if (allCounts != null) {
                        setCounts(allCounts);
                    }
                }
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    };

    BroadcastReceiver fragmentChangeReciver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                orderTypeId = intent.getStringExtra("order_type");
                String destination = intent.getStringExtra("destination");

                if (destination.equalsIgnoreCase("active_orders")) {
                    if (orderTypeId.equalsIgnoreCase("6")) {
                        leftMenuAdapter.checkedId = "online_orders";
                        handleMenuClick(leftMenuItems.get(3));
                    } else {
                        leftMenuAdapter.checkedId = "active_orders";
                        handleMenuClick(leftMenuItems.get(2));
                    }
                } else if (destination.equalsIgnoreCase("order_history")) {
                    leftMenuAdapter.checkedId = "order_history";
                } else if (destination.equalsIgnoreCase("tables")) {
                    leftMenuAdapter.checkedId = "tables";
                } else if (destination.equalsIgnoreCase("reservation_history")) {
                    leftMenuAdapter.checkedId = "reservations";
                } else if (destination.equalsIgnoreCase("voucher_history")) {
                    leftMenuAdapter.checkedId = "vouchers";
                }
                leftMenuAdapter.notifyDataSetChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void notifyMenuItem(String s) {
        try {
            leftMenuAdapter.checkedId = s;
            leftMenuAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForLogout(boolean isAdmin) {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Logout", "Are you sure you want to logout?", 1, "Confirm", "Cancel");
            confirmationDialogFragment.show(getSupportFragmentManager(), "logout");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("confirm")) {
                        Log.e("isAdmin", "" + isAdmin);
                        if (isAdmin) {
                            logout_from_app();
                        } else {
                            performUserLogout();
                        }
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performUserLogout() {

        try {
            String userId = myPreferences.getLoggedInUser().id;
            String server_URL = ApiEndPoints.users + userId + ApiEndPoints.user_logout;
            Log.e("Data", "" + server_URL);

            AndroidNetworking.get(server_URL).build().getAsJSONObject(new JSONObjectRequestListener() {
                @Override
                public void onResponse(JSONObject response) {
                    Log.e("Data", "" + response.toString());
                    doUserLogout();
                }

                @Override
                public void onError(ANError anError) {
                    Log.e("Data", "" + anError.getMessage() + "" + anError.getErrorCode());
                    anError.printStackTrace();
                    doUserLogout();
                }
            });
        } catch (Exception e) {
            doUserLogout();
            e.printStackTrace();
        }
    }

    private void logout_from_app() {
        try {
            startActivityForResult(new Intent(this, UploadOrdersActivity.class).putExtra("admin_logout", true), Constants.CODE_ADMIN_LOGOUT);
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doUserLogout() {
        try {
            myPreferences.saveLoggedInUser(null);
            myPreferences.saveUserTokens(null, null);
            startActivity(new Intent(HomeActivity.this, SplashActivity.class));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTime() {
        try {
            mHandler = new Handler();
            mHandler.postDelayed(runnable, 10);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            try {
                String currentTime = new SimpleDateFormat("hh:mm a", Locale.getDefault()).format(new Date());
                runOnUiThread(() -> tvTime.setText(currentTime));
            } catch (Exception e) {
                e.printStackTrace();
            }
            mHandler.postDelayed(this, 1000);
        }
    };

    private void setUpData() {
        try {
            leftMenuItems.clear();
            if (myPreferences.getLoggedInUser() != null) {
                tvUsername.setText(myPreferences.getLoggedInUser().username);
            }
            if (myPreferences.getLoggedInAdmin() != null) {
                tvBusinessName.setText(myPreferences.getLoggedInAdmin().selected_business.name);
            }
            tvDeviceId.setText("Device: " + myPreferences.getRegisteredDevice().name);
            PackageInfo pInfo = getPackageManager().getPackageInfo(getPackageName(), 0);
            String version = pInfo.versionName;//Version Name
            tvVersion.setText("Version " + version);

            SiteSetting logoSetting = myApp.findSetting("logo");
            if (logoSetting != null && !Validators.isNullOrEmpty(logoSetting.value)) {
                Glide.with(this).load(logoSetting.value).placeholder(R.drawable.user_profile_image_placeholder).error(R.drawable.user_profile_image_placeholder).into(ivProfile);
            } else {
                Glide.with(this).load(R.drawable.user_profile_image_placeholder).placeholder(R.drawable.user_profile_image_placeholder).error(R.drawable.user_profile_image_placeholder).into(ivProfile);
            }

            RecyclerMenuItem model = new RecyclerMenuItem();
            model.title = "Home";
            model.id = "home";
            model.drawable = R.drawable.ic_baseline_dashboard_24;
            model.isCheckable = true;
            leftMenuItems.add(model);

            if (myApp.isNewOrderVisible()) {
                model = new RecyclerMenuItem();
                model.title = "New Order";
                model.id = "new_order";
                model.drawable = R.drawable.ic_baseline_add_circle_24;
                leftMenuItems.add(model);

                model = new RecyclerMenuItem();
                model.title = "Active orders";
                model.id = "active_orders";
                model.isCheckable = true;
                model.drawable = R.drawable.ic_baseline_receipt_24;
                leftMenuItems.add(model);
            }

            if (!Validators.isNullOrEmpty(myApp.restaurant_id) && webOrderSetting != null && (webOrderSetting.value.equalsIgnoreCase("true") || webOrderSetting.value.equalsIgnoreCase("1")) && MyApp.userPermission.web_orders.actions.list) {
                model = new RecyclerMenuItem();
                model.title = "Online orders";
                model.id = "online_orders";
                model.isCheckable = true;
                model.drawable = R.drawable.icon_tiffinicon;
                leftMenuItems.add(model);
            }

            SiteSetting dineinSetting = myApp.findSetting("is_dinein");
            boolean isDinein = false;
            if (dineinSetting != null && (dineinSetting.value.equals("true") || dineinSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.dinein.actions.list)) {
                isDinein = true;
                model = new RecyclerMenuItem();
                model.title = "Tables";
                model.id = "tables";
                model.isCheckable = true;
                model.drawable = R.drawable.icon_tables;
                leftMenuItems.add(model);
            }

            SiteSetting reservationSetting = myApp.findSetting("is_reservation");
            if (reservationSetting != null && (reservationSetting.value.equals("true") || reservationSetting.value.equals("1"))) {
                if (MyApp.userPermission != null && MyApp.userPermission.reservation.actions.list) {
                    model = new RecyclerMenuItem();
                    model.title = "Reservations";
                    model.id = "reservations";
                    model.isCheckable = true;
                    model.drawable = R.drawable.reservation_icon;
                    leftMenuItems.add(model);
                }
            }
            if (MyApp.userPermission != null && MyApp.userPermission.order_history.actions.list) {
                model = new RecyclerMenuItem();
                model.title = "Order history";
                model.id = "order_history";
                model.isCheckable = true;
                model.drawable = R.drawable.ic_baseline_history_24;
                leftMenuItems.add(model);
            }
            if ((MyApp.userPermission != null && MyApp.userPermission.cash_draw.actions.list)) {
                model = new RecyclerMenuItem();
                model.title = "Cash drawer";
                model.id = "cash_drawer";
                model.drawable = R.drawable.icon_pound_sign;
                leftMenuItems.add(model);
            }
            //if (MyApp.userPermission != null && MyApp.userPermission.vouchers.actions.list && myApp.isConnected(HomeActivity.this) && !"manual".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
            if (MyApp.userPermission != null && MyApp.userPermission.vouchers.actions.list && myApp.isConnected(HomeActivity.this)) {
                model = new RecyclerMenuItem();
                model.title = "Vouchers";
                model.id = "vouchers";
                model.isCheckable = true;
                model.drawable = R.drawable.ic_baseline_payments_24;
                leftMenuItems.add(model);
            }
            if (!Validators.isNullOrEmpty(myApp.restaurant_id) && webOrderSetting != null && (webOrderSetting.value.equalsIgnoreCase("true") || webOrderSetting.value.equalsIgnoreCase("1")) && MyApp.userPermission != null && MyApp.userPermission.web_orders.actions.list && MyApp.userPermission.send_message.actions.list) {
                model = new RecyclerMenuItem();
                model.title = "Messages";
                model.id = "messages";
                model.isCheckable = true;
                model.drawable = R.drawable.ic_baseline_forum_24;
                leftMenuItems.add(model);
            }
            model = new RecyclerMenuItem();
            model.title = "Payments";
            model.id = "payments";
            model.isCheckable = true;
            model.drawable = R.drawable.ic_baseline_payment_24;
            leftMenuItems.add(model);
            if (myPreferences.getCallerIdEnableStatus()) {
                model = new RecyclerMenuItem();
                model.title = "Park Calls";
                model.id = "park_calls";
                model.isCheckable = true;
                model.drawable = R.drawable.ic_baseline_call_24;
                leftMenuItems.add(model);
            }
            if (MyApp.userPermission != null && MyApp.userPermission.customers.actions.list) {
                model = new RecyclerMenuItem();
                model.title = "Customers";
                model.id = "customers";
                model.isCheckable = true;
                model.drawable = R.drawable.user_profile_image_placeholder;
                leftMenuItems.add(model);
            }
            if (MyApp.userPermission != null && MyApp.userPermission.dinein.actions.list && isDinein) {
                model = new RecyclerMenuItem();
                model.title = "Table status";
                model.id = "table_status";
                model.isCheckable = true;
                model.drawable = R.drawable.icon_tables;
                leftMenuItems.add(model);
            }
            if (MyApp.userPermission != null && MyApp.userPermission.setting.actions.list) {
                model = new RecyclerMenuItem();
                model.title = "Settings";
                model.id = "settings";
                model.isCheckable = true;
                model.drawable = R.drawable.ic_settings;
                leftMenuItems.add(model);
            }

            model = new RecyclerMenuItem();
            model.title = "Pull data";
            model.id = "pull_data";
            model.drawable = R.drawable.ic_baseline_arrow_downward_24;
            leftMenuItems.add(model);

            model = new RecyclerMenuItem();
            model.title = "Pull customers";
            model.id = "pull_customers";
            model.drawable = R.drawable.ic_baseline_arrow_downward_24;
            leftMenuItems.add(model);

            if (pushDataSetting != null && !Validators.isNullOrEmpty(pushDataSetting.value) && pushDataSetting.value.equalsIgnoreCase("yes")) {
                model = new RecyclerMenuItem();
                model.title = "Push data";
                model.id = "push_data";
                model.drawable = R.drawable.ic_baseline_arrow_upward_24;
                leftMenuItems.add(model);
            }

            leftMenuAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentManager manager = getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.nav_host_fragment, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commit();
            invalidateOptionsMenu();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment fragment, boolean enableBackPress) {
        try {
            FragmentManager manager = getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.nav_host_fragment, fragment);
            if (enableBackPress) {
                transaction.addToBackStack("can_go_back");
            }
            transaction.commit();
            invalidateOptionsMenu();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openCashDrawer() {

        try {
            Cashdraw cashdraw = new Cashdraw();
            cashdraw.user_id = myApp.myPreferences.getLoggedInUser().id;
            cashdraw.device_id = myApp.myPreferences.getRegisteredDevice().id;
            cashdraw.value = "1";

            SiteSetting defaultCashDrawer = myApp.findSetting(Constants.DEFAULT_CASH_DRAWER_ID);
            if (defaultCashDrawer != null && !Validators.isNullOrEmpty(defaultCashDrawer.value)) {
                Printer cashDrawerDefaultPrinter = null;
                for (Printer p : myPreferences.getLoggedInAdmin().selected_business.printers) {
                    if (p.id.equalsIgnoreCase(defaultCashDrawer.value)) {
                        cashDrawerDefaultPrinter = p;
                        break;
                    }
                }
                if (cashDrawerDefaultPrinter != null) {
                    openCashDrawer(cashDrawerDefaultPrinter);
                } else {
                    ToastUtils.makeLongToast(HomeActivity.this, "No printer model found");
                }
            } else if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                openCashDrawer(defaultPrinter);
            } else {
                ToastUtils.makeLongToast(HomeActivity.this, "No printer model found");
            }

            AndroidNetworking.post(ApiEndPoints.cashdraw_log).addApplicationJsonBody(cashdraw).build().getAsObject(Cashdraw.class, new ParsedRequestListener<Cashdraw>() {
                @Override
                public void onResponse(Cashdraw response) {
                }

                @Override
                public void onError(ANError anError) {
                    anError.printStackTrace();
                    if (anError.getErrorCode() == 400) {
                        Log.e("apiError", anError.getErrorCode() + " " + anError.getMessage());
                        ApiError apiError = anError.getErrorAsObject(ApiError.class);
                        ToastUtils.makeSnackToast(HomeActivity.this, apiError.getMessage());
                    } else {
                        anError.printStackTrace();
                        ToastUtils.makeSnackToast(HomeActivity.this, "Something went wrong!");
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void openCashDrawer(Printer defaultPrinter) {
        if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
            zoneRichPrinter.openCashDrawer();
        } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix.openCashDrawer();
            } else {
                sunmiPrinter.openCashDrawer();
            }
        } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
            if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                IminSDKManager.opencashBox();
            } else {
                if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                    wifiPrinter.connect(defaultPrinter.ip);
                    CommonFunctions.functionThatDelay(200);
                    wifiPrinter.openCashDrawer();
                } else {
                    try {
                        if (bluetoothPrinter != null) {
                            BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                            if (device != null) {
                                CommonFunctions.functionThatDelay(200);
                                bluetoothPrinter.openCashDrawer();
                                CommonFunctions.functionThatDelay(200);
                            } else {
                                ToastUtils.makeToast(HomeActivity.this, "No bluetooth device found.");
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void onBackPressed() {
        try {
            Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);

            if (openedFragment instanceof NewHomeFragment || openedFragment instanceof HomeFragment) {
                finishAffinity();
            } else {
                if (manager.getBackStackEntryCount() > 0) {
                    manager.popBackStack();
                    manager.addOnBackStackChangedListener(() -> {

                        Fragment latestChangedFragment = getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);
                        if (latestChangedFragment instanceof OrdersAllFragment) {
                            notifyMenuItem("active_orders");
                        } else if (latestChangedFragment instanceof PaymentFragment) {
                            notifyMenuItem("payments");
                        } else if (latestChangedFragment instanceof OnlineOrdersFragment) {
                            notifyMenuItem("online_orders");
                        } else if (latestChangedFragment instanceof TablesLockingStatusFragment) {
                            notifyMenuItem("table_status");
                        } else if (latestChangedFragment instanceof DineInFragment) {
                            notifyMenuItem("tables");
                        } else if (latestChangedFragment instanceof VoucherHistoryFragment) {
                            notifyMenuItem("vouchers");
                        } else if (latestChangedFragment instanceof ReservationListFragment) {
                            notifyMenuItem("reservations");
                        } else if (latestChangedFragment instanceof CustomersFragment) {
                            notifyMenuItem("customers");
                        } else if (latestChangedFragment instanceof HomeFragment || latestChangedFragment instanceof NewHomeFragment) {
                            notifyMenuItem("home");
                        }

                    });
                } else {
                    finishAffinity();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void changeStatusCallerid(String status) {
        try {
            if (callLogs == null) {
                cvCallerId.setVisibility(View.GONE);
                return;
            }
            callLogs.status = status;
            cvCallerId.setVisibility(View.GONE);

            if (callLogs.status.equalsIgnoreCase("accepted")) {
                openOrderTypeSelectionDialog(callLogs);
            }
            new Thread(() -> {
                synchronized (this) {
                    if (callLogs == null) return; // From firebase issue
                    callLogs.uploadable = true;
                    appDatabase.calllogDao().insert(callLogs);
                    callLogs = null;
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCounts(Counts allCounts) {
        try {
            for (RecyclerMenuItem menuItem : leftMenuItems) {
                if (menuItem.id.equalsIgnoreCase("reservations")) {
                    menuItem.count = allCounts.pending_bookings;
                }
                if (menuItem.id.equalsIgnoreCase("messages")) {
                    menuItem.count = allCounts.unread_chat;
                }
                if (menuItem.id.equalsIgnoreCase("online_orders")) {
                    menuItem.count = allCounts.pending_orders;
                }
            }
            leftMenuAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver newOrderReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                // if notification_section equal to order_factory_reset reset the data
                if (intent.hasExtra("notification_section") && intent.getStringExtra("notification_section").equalsIgnoreCase("order_factory_reset") && intent.hasExtra("business_id") && intent.getStringExtra("business_id").equalsIgnoreCase(myPreferences.getBusinessId())
                        && intent.hasExtra("device_id") && !intent.getStringExtra("device_id").equalsIgnoreCase(myPreferences.getRegisteredDevice().device_id)) {
                    /*if (myApp.factoryResetDataTime == null) {
                        Calendar currentDate = Calendar.getInstance(Locale.getDefault());
                        currentDate.add(Calendar.MINUTE, 5);
                        myApp.factoryResetDataTime = currentDate;
                        myApp.isFactoryResetData = true;
                        eraseData("factory_reset", false);
                    } else {
                        if (Calendar.getInstance().getTimeInMillis() >= myApp.factoryResetDataTime.getTimeInMillis()) {
                            myApp.isFactoryResetData = true;
                            eraseData("factory_reset", false);
                            Calendar currentDate = Calendar.getInstance(Locale.getDefault());
                            currentDate.add(Calendar.MINUTE, 5);
                            myApp.factoryResetDataTime = currentDate;
                        }
                    }*/
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onResume() {
        super.onResume();
        try {
            /*if (myApp.isFactoryResetData) {
                eraseData("factory_reset", false);
            }*/
            MyApp.userPermission = myPreferences.getEposUserPermission();
            setUpData();
            checkPrinterConnectivity();
            LocalBroadcastManager.getInstance(HomeActivity.this).registerReceiver(bookTableSuccessReceiver, new IntentFilter(Constants.BOOK_TABLE_SUCCESS));
            LocalBroadcastManager.getInstance(HomeActivity.this).registerReceiver(push_receiver, new IntentFilter(Constants.PUSH_NOTIFICATION));
            LocalBroadcastManager.getInstance(HomeActivity.this).registerReceiver(payment_link_receiver, new IntentFilter(Constants.PAYMENT_NOTIFICATION));
            LocalBroadcastManager.getInstance(this).registerReceiver(callReceiver, new IntentFilter("call_received"));
            LocalBroadcastManager.getInstance(this).registerReceiver(logsReceiver, new IntentFilter("log"));
            LocalBroadcastManager.getInstance(this).registerReceiver(onlineOrdersNotificationReceiver, new IntentFilter(Constants.NOTIFICATION));
            LocalBroadcastManager.getInstance(this).registerReceiver(fragmentChangeReciver, new IntentFilter("order_fragment_change"));
            // register factory data Receiver
            if (newOrderReceiver != null) {
                LocalBroadcastManager.getInstance(this).registerReceiver(newOrderReceiver, new IntentFilter(Constants.EPOS_NEW_ORDER));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void checkPrinterConnectivity() {
        try {
            MyApp.printerStatus = 1;
            defaultPrinter = myPreferences.getDefaultPrinter();
            if (defaultPrinter != null) {
                new Thread(() -> {
                    if (!Validators.isNullOrEmpty(defaultPrinter.printer_model_name) && (defaultPrinter.printer_model_name.toLowerCase().contains("88 h"))) {
                        myApp.checkPrinterIP(defaultPrinter.ip, 9100);
                    } else if (!Validators.isNullOrEmpty(defaultPrinter.printer_model_name) && defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                        if (!AidlUtil.getInstance().isConnect())
                            AidlUtil.getInstance().connectPrinterService(this);
                    } else if (!Validators.isNullOrEmpty(defaultPrinter.printer_model_name) && defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                        //                    myApp.checkPrinterIP(HomeActivity.this, defaultPrinter.ip, 9100, defaultPrinter.printer_model_name.toLowerCase());
                    }
                }).start();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
//        ceBridge.Disconnect();
//        LogUtils.e("ON PAUSE");
        try {
            if (push_receiver != null) {
                LocalBroadcastManager.getInstance(HomeActivity.this).unregisterReceiver(push_receiver);
            }
            if (payment_link_receiver != null) {
                LocalBroadcastManager.getInstance(HomeActivity.this).unregisterReceiver(payment_link_receiver);
            }
            if (callReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(callReceiver);
            }
            if (logsReceiver != null)
                LocalBroadcastManager.getInstance(this).unregisterReceiver(logsReceiver);

            if (onlineOrdersNotificationReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(onlineOrdersNotificationReceiver);
            }
            if (fragmentChangeReciver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(fragmentChangeReciver);
            }
            if (newOrderReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(newOrderReceiver);
            }
        } catch (Exception e) {

        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mHandler.removeCallbacks(runnable);
        mHandler.removeCallbacks(null);
        if (bookTableSuccessReceiver != null) {
            LocalBroadcastManager.getInstance(HomeActivity.this).unregisterReceiver(bookTableSuccessReceiver);
        }
        // un register factory data receiver
        LogUtils.e("ON DESTROY");
    }

    BroadcastReceiver bookTableSuccessReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            // refersh data from the database
            //if (intent.getBooleanExtra(Constants.IS_FROM_ERROR, false) && intent.hasExtra(Constants._ORDER_ID) && intent.getIntExtra(Constants._ORDER_ID, 0) != 0) {
                /*Intent intentUploadOrder = new Intent(HomeActivity.this, SingleOrderUploaderService.class);
                intentUploadOrder.putExtra(Constants._ORDER_ID, intent.getIntExtra(Constants._ORDER_ID, 0));
                intentUploadOrder.putExtra("is_form_error", true);
                startService(intentUploadOrder);*/
            new DbSaverAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);
            //}
            /*if (intent.hasExtra(Constants.SUCCESS_MESSAGE)) {
                ToastUtils.makeSnackToast(HomeActivity.this, intent.getStringExtra(Constants.SUCCESS_MESSAGE));
            }*/
        }
    };

    BroadcastReceiver push_receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("push", true)) {
                    String title = intent.getStringExtra("title");
                    String message = intent.getStringExtra("message");
                    String order_id = intent.getStringExtra("order_id");
                    String order_type = intent.getStringExtra("order_type");
                    String payment_status = intent.getStringExtra("payment_status");
                    String preparation_time = intent.getStringExtra(PREPARATION_TIME);
                    int booking_id = intent.getIntExtra(BOOKING_ID, 0);
                    boolean auto_accept = intent.getBooleanExtra(AUTO_ACCEPT, false);
                    Log.e("auto_acceptauto_accept", "auto_accept " + auto_accept);
                    if (!Validators.isNullOrEmpty(order_id) || !auto_accept) {
                        if (!Validators.isNullOrEmpty(preparation_time)) {
                            myApp.acceptOrder("Accepted", order_id, preparation_time, HomeActivity.this);
                        } else {
                            PushDialogFragment pushDialogFragment = getInstancePushDialog(title, message, order_id, payment_status, order_type);
                            pushDialogFragment.show(getSupportFragmentManager(), "push");
                            pushDialogFragment.setDialogDismissListener(o -> {
                                if (o instanceof String) {
                                    int orderType = -1;
                                    //changed by Aradhna
                                    if (((String) o).equalsIgnoreCase("booking")) {
                                        changeFragment(new ReservationListFragment());
                                    } else {
                                        if (Validators.isNullOrEmpty(order_type)) {
                                            orderType = 0;
                                        } else if (order_type.equalsIgnoreCase("delivery")) {
                                            orderType = 1;
                                        } else if (order_type.equalsIgnoreCase("pickup")) {
                                            orderType = 2;
                                        }
                                        // online order dismiss listener in order to refresh orders after accepting the order
                                        OnlineOrderViewFragment onlineOrderViewFragment = myApp.getInstanceOnlineOrder(order_id, orderType);
                                        onlineOrderViewFragment.setDialogDismissListener(acceptOrderDialogListener);
                                        changeFragment(onlineOrderViewFragment, true);
                                    }
                                }
                            });
                        }
                    }
                    if (auto_accept && booking_id != 0) {
                        OnlineReservation onlineReservation = new OnlineReservation();
                        onlineReservation.status = "Approved";
                        onlineReservation.id = booking_id;
                        myApp.changeStatusOnlineReservation(onlineReservation, HomeActivity.this);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    DialogDismissListener acceptOrderDialogListener = o -> changeHome();


    // For payment link notification handling
    String amount = "";
    String status = "";
    String transaction_id = "";
    String phone = "";
    String email = "";
    int _order_id;

    BroadcastReceiver payment_link_receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", true)) {
                    amount = intent.getStringExtra("amount");
                    status = intent.getStringExtra("status");
                    transaction_id = intent.getStringExtra("transaction_id");
                    phone = intent.getStringExtra("phone");
                    email = intent.getStringExtra("email");
                    myApp.isPaymentLinkSent = false;
                    createPaymentLinkPrint();

                    if (intent.hasExtra("order_id")) {
                        //doOrderUpdateAndUpload(intent.getStringExtra("order_id"));
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    String title;
    String header = "", resAddress = "";
    String stripe_id;
    String entry_mod;
    String status___;
    String please;
    String date_final;
    String footerA;
    String footerB;
    String main_content;
    String print_amount, print_stripe_id, print_payment_mode, print_status;

    String mobile___;
    String email___;
    private int headerAlignment = 0;
    String amount___;

    private void createPaymentLinkPrint() {
        try {
            print_stripe_id = transaction_id;
            print_amount = MyApp.df.format(Float.parseFloat(amount));

            print_payment_mode = "Pay By Link";
            if (status.equalsIgnoreCase("Success")) {
                // Payment completed successfully
                //ToastUtils.showSnackBar(getActivity(), llMainLayout, "Payment successful", "success");
                print_status = "Approved";
                myApp.startPaymentSuccessSound();
            } else if (status.equalsIgnoreCase("Failed")) {
                // Payment failed
                print_status = "Failed";
                myApp.startPaymentFailedSound();
            }
            title = "" + "Customer Copy" + "\n";

            SiteSetting ticketHeader = myApp.findSetting("ticket_header");
            SiteSetting address = myApp.findSetting("address");

            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            amount___ = "£" + print_amount + "\n";

            mobile___ = "Mobile No. :" + phone;
            email___ = "Email      :" + email;
            stripe_id = "TID        :" + print_stripe_id;
            entry_mod = "Entry Mode :" + print_payment_mode;
            status___ = "Status     :" + print_status;

            please = "Please Retain Receipt\nFor Your Record\n";
            date_final = "" + CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a") + "\n";
            footerA = "";
            footerB = "";
            SiteSetting footerASetting = myApp.findSetting("footer_a");
            SiteSetting footerBSetting = myApp.findSetting("footer_b");

            if (footerASetting != null) footerA = footerASetting.value;

            if (footerBSetting != null) footerB = footerBSetting.value;

            main_content = mobile___ + "\n" + email___ + "\n" + stripe_id + "\n" + entry_mod + "\n" + status___ + "\n";

            String positiveButton = "Print";

            String desc = phone + " - £" + print_amount;
            AnimatedConfirmationDialogFragment animatedConfirmationDialogFragment = getInstanceAnimatedConfirmation(print_status, desc, print_status.equalsIgnoreCase("approved") ? 1 : 2, positiveButton, "Okay");
            animatedConfirmationDialogFragment.show(getSupportFragmentManager(), "show_confirm");
            animatedConfirmationDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (o instanceof String && !o.toString().equalsIgnoreCase("cancel")) {
                        if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                            if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                printMotoZonrich("Merchant Copy");
                            } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                                printMotoSunmi("Merchant Copy");
                            } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                    printIMin("Merchant Copy");
                                } else {
                                    if (defaultPrinter.ip != null && !defaultPrinter.ip.trim().equalsIgnoreCase("")) {
                                        printMotoWIfi("Merchant Copy");
                                    } else {
                                        try {
                                            if (bluetoothPrinter != null) {
                                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                if (device != null) {
                                                    printMotoBT("Merchant Copy");
                                                } else {
                                                    ToastUtils.makeToast(HomeActivity.this, "No bluetooth device found.");
                                                }
                                            }
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }

                                    }
                                }
                            }
                        } else {
                            ToastUtils.makeLongToast(HomeActivity.this, "No printer model found");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printIMin(String title) {
        try {
            title = title + "\n";
            String finalTitle = title;
            myApp.iMinPrinterUtils.printMotoReceipt(myApp.tiffintomLogoSmall, finalTitle, header, "", "", amount___, main_content, date_final, please, footerA, footerB);
            if (finalTitle.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.setCancelable(false);
                confirmationDialogFragment.show(getSupportFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printIMin("Customer Copy");
                        }
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void printMotoZonrich(String title) {
        try {
            title = title + "\n";
            String finalTitle = title;
            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
            zoneRichPrinter.printMotoReceipt(myApp.businessLogo, finalTitle, header, headerAlignment, amount___, main_content, date_final, please, footerA, footerB, myApp.myPreferences);
            if (finalTitle.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.setCancelable(false);
                confirmationDialogFragment.show(getSupportFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printMotoZonrich("Customer Copy");
                        }
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printMotoSunmi(String title) {
        try {
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount___, main_content, date_final, please, footerA, footerB, myPreferences);
            } else {
                sunmiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount___, main_content, date_final, please, footerA, footerB, myPreferences);
            }
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.setCancelable(false);
                confirmationDialogFragment.show(getSupportFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printMotoSunmi("Customer Copy");
                        }
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printMotoWIfi(String title) {
        try {
            wifiPrinter.connect(defaultPrinter.ip);
            CommonFunctions.functionThatDelay(100);
            wifiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount___, main_content, date_final, please, footerA, footerB, true, myPreferences);
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getSupportFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printMotoWIfi("Customer Copy");
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printMotoBT(String title) {
        try {
            CommonFunctions.functionThatDelay(100);
            bluetoothPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount___, main_content, date_final, please, footerA, footerB, true);
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getSupportFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printMotoBT("Customer Copy");
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        View view = getCurrentFocus();
        boolean ret = super.dispatchTouchEvent(event);

        if (view instanceof EditText) {
            View w = getCurrentFocus();
            int scrcoords[] = new int[2];
            w.getLocationOnScreen(scrcoords);
            float x = event.getRawX() + w.getLeft() - scrcoords[0];
            float y = event.getRawY() + w.getTop() - scrcoords[1];

            if (event.getAction() == MotionEvent.ACTION_UP && (x < w.getLeft() || x >= w.getRight() || y < w.getTop() || y > w.getBottom())) {
                InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                imm.hideSoftInputFromWindow(getWindow().getCurrentFocus().getWindowToken(), 0);
            }
        }
        return ret;
    }

    public class DbSaverAsync extends AsyncTask<Object, Void, String> {
        private int failedOrderCount = 0;

        @Override
        protected void onPreExecute() {
            LogUtils.e("ORDERS", "PRE EXECUTE");
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Object... lists) {
            try {
                LogUtils.e("ORDERS", "IN background start");
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
                failedOrderCount = myApp.appDatabase.orderDao().failedOrder();
                LogUtils.e("ORDERS", "IN background finish");
            } catch (Exception e) {
                e.printStackTrace();
            }
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                // if failed order count is 0 then send brodcast to dineline fragment for display count
                if ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                    android.util.Log.e("failedOrderCount", "failedOrderCount " + failedOrderCount);
                    Intent intent = new Intent(Constants.FAILED_ORDER_RECEIVER);
                    intent.putExtra(Constants.FAILED_ORDER_COUNT, failedOrderCount);
                    LocalBroadcastManager.getInstance(HomeActivity.this).sendBroadcast(intent);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
        }
    }

    private void eraseData(String type, boolean isCallApi) {
        try {
            String url = ApiEndPoints.factory_reset;
            if (type.equalsIgnoreCase("orders")) {
                url = ApiEndPoints.delete_orders;
            }
            if (type.equalsIgnoreCase("reservations")) {
                url = ApiEndPoints.delete_reservations;
            }
            if (type.equalsIgnoreCase("cashdraw")) {
                url = ApiEndPoints.delete_cash_draw_logs;
            }
            if (type.equalsIgnoreCase("calllogs")) {
                url = ApiEndPoints.delete_calllogs;
            }
            if (progressLoading != null) {
                progressLoading.setVisibility(View.VISIBLE);
            }
            if (isCallApi) {
                AndroidNetworking.delete(url).addQueryParameter("device_id", myApp.myPreferences.getRegisteredDevice().device_id).build().getAsString(new StringRequestListener() {
                    @Override
                    public void onResponse(String response) {
                        if (progressLoading != null) {
                            progressLoading.setVisibility(View.GONE);
                        }
                        clearData(type);
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (anError.getErrorCode() == 400) {

                        }
                    }
                });
            } else {
                clearData(type);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void clearData(String type) {
        String message = "Factory Reset settings done";
        if (type.equalsIgnoreCase("orders")) {
            message = "Orders deleted successfully";
        }
        if (type.equalsIgnoreCase("reservations")) {
            new Thread(() -> {
                appDatabase.emptyPulledDao().nukeReservations();
                appDatabase.reservationDao().resetReservationPrimaryKey();
            }).start();
            message = "Reservations deleted successfully";
        }
        if (type.equalsIgnoreCase("cashdraw")) {
            message = "Cash draw logs deleted successfully";
        }
        if (type.equalsIgnoreCase("calllogs")) {
            message = "Call logs deleted successfully";
        }
        ToastUtils.makeToast(HomeActivity.this, message);
        myApp.isFactoryResetData = false;
        if (type.equalsIgnoreCase("orders") || type.equalsIgnoreCase("factory_reset")) {
            new Thread(() -> {
                appDatabase.emptyPulledDao().nukeOrderItemIngredient();
                appDatabase.emptyPulledDao().nukeOrderItemAddon();
                appDatabase.emptyPulledDao().nukeOrderPayment();
                appDatabase.emptyPulledDao().nukeOrderSplit();
                appDatabase.emptyPulledDao().nukeOrder();
                appDatabase.emptyPulledDao().externalCCPayment();
                appDatabase.orderDao().resetOrderRelatedPrimaryKey();
                appDatabase.tableDao().freeAllTables();

                if (!type.equalsIgnoreCase("orders")) {
                    appDatabase.emptyPulledDao().nukeReservations();
                    appDatabase.reservationDao().resetReservationPrimaryKey();
                }

                Intent mIntent = new Intent(HomeActivity.this, HomeActivity.class);
                finishAffinity();
                startActivity(mIntent);
            }).start();
        } else {
            Intent mIntent = new Intent(HomeActivity.this, HomeActivity.class);
            finishAffinity();
            startActivity(mIntent);
        }
    }

    public AnimatedConfirmationDialogFragment getInstanceAnimatedConfirmation(String title, String info, int type, String positiveButton, String negativeButton) {
        AnimatedConfirmationDialogFragment rejectReasonDialog = new AnimatedConfirmationDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putString("positive_button", positiveButton);
        bundle.putString("negative_button", negativeButton);
        bundle.putInt("type", type);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public PushDialogFragment getInstance(String title, String subTitle, String orderId, String paymentStatus, String orderType) {
        PushDialogFragment rejectReasonDialog = new PushDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("sub_title", subTitle);
        bundle.putString("order_id", orderId);
        bundle.putString("payment_status", paymentStatus);
        bundle.putString("order_type", orderType);

        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public PushDialogFragment getInstancePushDialog(String title, String subTitle, String orderId, String paymentStatus, String orderType) {
        PushDialogFragment rejectReasonDialog = new PushDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("sub_title", subTitle);
        bundle.putString("order_id", orderId);
        bundle.putString("payment_status", paymentStatus);
        bundle.putString("order_type", orderType);

        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    public OnlineOrdersFragment getInstanceOnlineOrders(String fromHome) {
        OnlineOrdersFragment onlineOrdersFragment = new OnlineOrdersFragment();
        Bundle bundle = new Bundle();
        bundle.putString("from_home", fromHome);
        onlineOrdersFragment.setArguments(bundle);
        return onlineOrdersFragment;
    }

}
