package com.ubsidi.epos_2021.activities

import android.content.ActivityNotFoundException
import android.content.ContentValues
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.os.Environment
import android.provider.MediaStore
import android.util.Log
import android.view.View
import android.widget.ProgressBar
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.net.toUri
import androidx.lifecycle.lifecycleScope
import com.ubsidi.R
import com.ubsidi.epos_2021.MyApp
import com.ubsidi.epos_2021.comman.Validators
import com.ubsidi.epos_2021.models.SiteSetting
import com.ubsidi.epos_2021.utils.ToastUtils
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import java.io.FileOutputStream
import java.io.IOException
import java.io.InputStream
import java.io.OutputStream
import java.net.HttpURLConnection
import java.net.URL


class InAppUpdateActivity : AppCompatActivity() {
    var txtTitle :TextView?=null
    var progressBar :ProgressBar?=null
    val appVersionSetting: SiteSetting? = MyApp.getInstance().findSetting("epos_android_app_version")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_in_app_update)
        txtTitle = findViewById(R.id.txtTitle)
        progressBar = findViewById(R.id.progressBar)
        val printingAppUrl: SiteSetting? = MyApp.getInstance().findSetting("download_android_latest_app_url_link")
        if(appVersionSetting!=null){
            txtTitle!!.text = "Downloading the latest version: ${appVersionSetting.value}"
        }
        Log.e("printingAppUrl", "printingAppUrl $printingAppUrl")
        val fileUrl = if(printingAppUrl!=null && !Validators.isNullOrEmpty(printingAppUrl.value)) printingAppUrl.value else ""
        if(!Validators.isNullOrEmpty(fileUrl)){
            getSavedFileUri("Epos_Version_"+appVersionSetting?.value,".apk",fileUrl,this@InAppUpdateActivity)
        }else{
            txtTitle!!.text =" Downloading error:- Please add latest app url"
        }
    }

    private fun installApk(uri: Uri){
        lifecycleScope.launch(Dispatchers.Main) {
            txtTitle?.text="Downloading complete"
            progressBar?.visibility=View.GONE
        }
        val intent = Intent(Intent.ACTION_VIEW)
        intent.setDataAndType(uri,"application/vnd.android.package-archive")
        intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK;
        intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)
        try {
            startActivity(intent)
        }catch (e: ActivityNotFoundException){
            Toast.makeText(
                this@InAppUpdateActivity,
                "Can't open APK",
                Toast.LENGTH_SHORT
            ).show()
        }
    }

    private fun getSavedFileUri(
        fileName:String,
        fileType:String,
        fileUrl:String,
        context: Context
    ): Uri?{
        Log.e("fileType", "fileTypefileType $fileType")
        val mimeType = when(fileType){
            "PDF" -> "application/pdf"
            "PNG" -> "image/png"
            "MP4" -> "video/mp4"
            ".apk" -> "application/vnd.android.package-archive"
            else -> ""
        } // different types of files will have different mime type

        if (mimeType.isEmpty()) return null

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q){
            val contentValues = ContentValues().apply {
                put(MediaStore.MediaColumns.DISPLAY_NAME, fileName)
                put(MediaStore.MediaColumns.MIME_TYPE, mimeType)
                put(MediaStore.MediaColumns.RELATIVE_PATH, "Download/EposVersions")
            }

            val resolver = context.contentResolver

            val uri = resolver.insert(MediaStore.Downloads.EXTERNAL_CONTENT_URI, contentValues)
            Log.e("uriuri","fileTypefileType "+uri)
            return if (uri!=null){
                Log.e("fileUrlfileUrl","fileTypefileType "+fileUrl)
                /*URL(fileUrl).openStream().use { input->
                    resolver.openOutputStream(uri).use { output->
                        input.copyTo(output!!, DEFAULT_BUFFER_SIZE)
                    }
                }*/
                lifecycleScope.launch(Dispatchers.IO) {
                    var input: InputStream? = null
                    var output: OutputStream? = null
                    var connection: HttpURLConnection? = null
                    try {
                        val url = URL(fileUrl)
                        connection = url.openConnection() as HttpURLConnection
                        connection.connect()

                        // expect HTTP 200 OK, so we don't mistakenly save error report
                        // instead of the file
                        if (connection.responseCode != HttpURLConnection.HTTP_OK) {
                            /*return ("Server returned HTTP " + connection!!.responseCode
                                    + " " + connection!!.responseMessage)*/
                        }

                        // this will be useful to display download percentage
                        // might be -1: server did not report the length
                        val fileLength = connection!!.contentLength

                        // download the file
                        input = connection!!.inputStream
                        output = resolver.openOutputStream(uri)
                        val data = ByteArray(4096)
                        var total: Long = 0
                        var count: Int
                        while (input.read(data).also { count = it } != -1) {
                            // allow canceling with back button
                            total += count.toLong()
                            // publishing the progress....
                            if (fileLength > 0) // only if total length is known
                                withContext(Dispatchers.Main){
                                    txtTitle?.text ="Downloading the latest version: ${appVersionSetting?.value} \n\n${(total * 100 / fileLength)}%"
                                }
                            output?.write(data, 0, count)
                        }
                    } catch (e: Exception) {
                        Log.e("exception","exception ${e.message}")
                    } finally {
                        try {
                            output?.close()
                            input?.close()
                        } catch (ignored: IOException) {
                        }
                        connection?.disconnect()
                    }
                    Log.e("URLURLURL","fileTypefileType "+uri)
                    installApk(uri)
                }
                uri
            }else{
                null
            }

        }else{

            val target = java.io.File(
                Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS),
                fileName
            )
            URL(fileUrl).openStream().use { input->
                FileOutputStream(target).use { output ->
                    input.copyTo(output)
                }
            }

            return target.toUri()
        }
    }
}