package com.ubsidi.epos_2021.activities;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;

import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;


public class InternetCardReaderPaymentActivity extends BaseActivity {

    private WebView webView;
    private String url;
    private AlertDialog progressBarDialog;
    private Toolbar toolbar;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_webview);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getIntent() != null) {
            url = getIntent().getStringExtra("url");
        }
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            toolbar = findViewById(R.id.toolbar);
            setSupportActionBar(toolbar);
            if (getSupportActionBar() != null)
                getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            webView = findViewById(R.id.webView);
            progressBarDialog = CommonFunctions.customProgressDialog(this, "");

            webView.getSettings().setLoadsImagesAutomatically(true);
            webView.getSettings().setJavaScriptEnabled(true);
            webView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);

            webView.setWebViewClient(new WebViewClient() {
                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                    progressBarDialog.show();
                    try {
                        URL url1 = new URL(url);
                        String path = url1.getPath();
                        LogUtils.e(path);
                        if (path.toLowerCase().contains("/success")) {
                            try {
                                Intent intent = new Intent();
                                Map<String, String> quries = splitQuery(url1);
                                for (String q : quries.keySet()) {
                                    intent.putExtra(q, quries.get(q));
                                }
                                setResult(RESULT_OK, intent);
                                finish();
                            } catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }

                        if (path.toLowerCase().contains("/cancel") || path.toLowerCase().contains("/failed")) {
                            try {
                                Intent intent = new Intent();
                                Map<String, String> quries = splitQuery(url1);
                                for (String q : quries.keySet()) {
                                    intent.putExtra(q, quries.get(q));
                                }
                                setResult(RESULT_OK, intent);
                                finish();
                            } catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                    } catch (MalformedURLException e) {
                        e.printStackTrace();
                    }

                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    progressBarDialog.dismiss();
                }

                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    return (false);
                }
            });

            webView.loadUrl(url);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        Map<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        String[] pairs = query.split("&");
        for (String pair : pairs) {
            int idx = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return query_pairs;
    }

    @Override
    public void onBackPressed() {
        ToastUtils.makeSnackToast(this, "Transaction is in process please wait.");
    }
}
