package com.ubsidi.epos_2021.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.graphics.Color;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.bumptech.glide.Glide;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.gson.Gson;
import com.makeramen.roundedimageview.RoundedImageView;
import com.stripe.stripeterminal.Terminal;
import com.stripe.stripeterminal.external.callable.Callback;
import com.stripe.stripeterminal.external.models.TerminalException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.MiniUserAdapter;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.fragment.SunmiIpAddressFragment;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.BusinessCardReader;
import com.ubsidi.epos_2021.models.Device;
import com.ubsidi.epos_2021.models.EposUserPermission;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.User;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.online.fragments.RejectReasonDialogFragment;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.DownloadManager;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LoginActivity extends AppCompatActivity {
    User selectedUser;
    private RecyclerView rvUsers;
    private EditText etUsername, etPassword;
    private MaterialButton btn1, btn2, btn3, btn4, btn5, btn6, btn7, btn8, btn9, btn0, btnDot, btnClear;

    private AppCompatButton btnLogin;
    private LinearLayout llSettings;
    private LinearLayoutCompat llClear;
    private TextView tvOrderSyncMode, tvCallerId, tvRemoteDevice, tvSunmiPrinterEnable, tvSunmiDownloadPrinter, tvChangeBusiness;
    private Chip chipBack;
    private RoundedImageView ivProfile;
    private TextView tvBusinessName, tvResLogout, tvVersion;

    private ArrayList<User> users = new ArrayList<>();
    private MiniUserAdapter userAdapter;
    AlertDialog progressDialog;
    MyApp myApp = MyApp.getInstance();
    MyPreferences myPreferences = myApp.myPreferences;
    AppDatabase appDatabase = myApp.appDatabase;
    DrawerLayout drawerLayout;
    ActionBarDrawerToggle actionBarDrawerToggle;
    SwitchCompat switchCallerId, switchIsUsb;
    String callerIdStatus = "Off";
    public SiteSetting siteSetting = new SiteSetting();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login_copy);
        initViews();
        fetchMiniUsers();
        setListeners();
        callRmsSiteSettingApi();
        fetchDevice();
    }

    private void initViews() {
        try {
            progressDialog = CommonFunctions.customProgressDialog(this);
            rvUsers = findViewById(R.id.rvUsers);
            etUsername = findViewById(R.id.input_username);
            etPassword = findViewById(R.id.input_password);
            llSettings = findViewById(R.id.llSettings);
            llClear = findViewById(R.id.llClear);
            btn1 = findViewById(R.id.btn1);
            btn2 = findViewById(R.id.btn2);
            btn3 = findViewById(R.id.btn3);
            btn4 = findViewById(R.id.btn4);
            btn5 = findViewById(R.id.btn5);
            btn6 = findViewById(R.id.btn6);
            btn7 = findViewById(R.id.btn7);
            btn8 = findViewById(R.id.btn8);
            btn9 = findViewById(R.id.btn9);
            btn0 = findViewById(R.id.btn0);
            btnDot = findViewById(R.id.btnDot);
            btnLogin = findViewById(R.id.btn_login);
            btnClear = findViewById(R.id.btnClear);
            drawerLayout = findViewById(R.id.drawer_layout);
            tvOrderSyncMode = findViewById(R.id.tvOrderSyncMode);
            tvRemoteDevice = findViewById(R.id.tvRemoteDevice);
            tvSunmiPrinterEnable = findViewById(R.id.tvSunmiPrinterEnable);
            tvSunmiDownloadPrinter = findViewById(R.id.tvSunmiDownloadPrinter);
            tvChangeBusiness = findViewById(R.id.tvChangeBusiness);
            chipBack = findViewById(R.id.chipBack);
            switchCallerId = findViewById(R.id.switchCallerId);
            switchIsUsb = findViewById(R.id.switchIsUsb);
            tvCallerId = findViewById(R.id.tvCallerId);
            ivProfile = findViewById(R.id.ivProfile);
            tvBusinessName = findViewById(R.id.tvBusinessName);
            tvResLogout = findViewById(R.id.tvRestaurantLogout);
            tvVersion = findViewById(R.id.tvVersion);

            if (myApp.myPreferences.getLoggedInAdmin() != null && myApp.myPreferences.getLoggedInAdmin().selected_business != null
                    && myApp.myPreferences.getLoggedInAdmin().selected_business.card_readers != null) {
                boolean isContainsReader = false;
                for (int i = 0; i < myApp.myPreferences.getLoggedInAdmin().selected_business.card_readers.size(); i++) {
                    BusinessCardReader businessCardReader = myApp.myPreferences.getLoggedInAdmin().selected_business.card_readers.get(i);
                    if (businessCardReader.connectivity.toLowerCase().equalsIgnoreCase("stripebluetooth")
                            || businessCardReader.connectivity.toLowerCase().equalsIgnoreCase("posbluetooth")) {
                        isContainsReader = true;
                    }
                }
                if (isContainsReader) {
                    switchIsUsb.setVisibility(View.VISIBLE);
                    switchIsUsb.setChecked(myPreferences.getIsUbEnableStatus());
                }
            }
            switchIsUsb.setOnCheckedChangeListener((compoundButton, b) -> {
                if (compoundButton.isPressed()) {
                    myPreferences.saveIsUsb(b);
                    if (Terminal.isInitialized()) {
                        Terminal.getInstance().disconnectReader(new Callback() {
                            @Override
                            public void onSuccess() {

                            }

                            @Override
                            public void onFailure(@NonNull TerminalException e) {

                            }
                        });
                    }
                }
            });
            SiteSetting cloudSyncSetting = myApp.findSetting("cloud_system");

            if (cloudSyncSetting != null && !Validators.isNullOrEmpty(cloudSyncSetting.value) && cloudSyncSetting.value.equalsIgnoreCase("yes")) {
                tvOrderSyncMode.setVisibility(View.VISIBLE);
            } else {
                tvOrderSyncMode.setVisibility(View.GONE);
            }

            /*if (!Validators.isNullOrEmpty(myApp.myPreferences.getRegisteredDevice().caller_id)) {
                myPreferences.saveCallerIdEnableStatus(myApp.myPreferences.getRegisteredDevice().caller_id.equalsIgnoreCase("1"));
            } else {
                myPreferences.saveCallerIdEnableStatus(false);
            }*/
            tvResLogout.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
            PackageInfo pInfo = getPackageManager().getPackageInfo(getPackageName(), 0);
            String version = pInfo.versionName;//Version Name
            tvVersion.setText("Version " + version);
            userAdapter = new MiniUserAdapter(this, myPreferences.getOrderSyncMode(), users, (position, data) -> {
                User model = (User) data;
                selectedUser = model;
                etUsername.setText(model.username);
                etUsername.setSelection(etUsername.length());
                etPassword.setText("");
            }, (position, data) -> askForUserLogout((User) data));
            rvUsers.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
            rvUsers.setAdapter(userAdapter);
            switchCallerId.setChecked(myPreferences.getCallerIdEnableStatus());

            if (myPreferences.getLoggedInAdmin() != null) {
                tvBusinessName.setText(myPreferences.getLoggedInAdmin().selected_business.name);
            }
            SiteSetting logoSetting = myApp.findSetting("logo");
            if (logoSetting != null && !Validators.isNullOrEmpty(logoSetting.value)) {
                Glide.with(this)
                        .load(logoSetting.value)
                        .placeholder(R.drawable.user_profile_image_placeholder)
                        .error(R.drawable.user_profile_image_placeholder)
                        .into(ivProfile);
            } else {
                Glide.with(this)
                        .load(R.drawable.user_profile_image_placeholder)
                        .placeholder(R.drawable.user_profile_image_placeholder)
                        .error(R.drawable.user_profile_image_placeholder)
                        .into(ivProfile);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setListeners() {
        try {
            etPassword.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    if (editable.toString().length() != 0) {
                        etPassword.setSelection(etPassword.length());
                    }
                }
            });

            btn1.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "1"));
            btn2.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "2"));
            btn3.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "3"));
            btn4.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "4"));
            btn5.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "5"));
            btn6.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "6"));
            btn7.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "7"));
            btn8.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "8"));
            btn9.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "9"));
            btn0.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "0"));
            //btnDot.setOnClickListener(v -> etPassword.setText(etPassword.getText() + "."));

            btnClear.setOnClickListener(v -> {
                etPassword.setText("");
            });

            switchCallerId.setOnCheckedChangeListener((compoundButton, b) -> {
                myPreferences.saveCallerIdEnableStatus(b);
            });

            btnLogin.setOnClickListener(v -> {
                if (isValid()) {
                    if (myApp.isConnected(this))
                        performUserLogin();
                    else
                        offlineLogin();
                }
            });
            llSettings.setOnClickListener(v -> {
                if (!drawerLayout.isDrawerOpen(GravityCompat.START))
                    drawerLayout.openDrawer(GravityCompat.START);
                else drawerLayout.closeDrawer(GravityCompat.END);
            });
            chipBack.setOnClickListener(view -> {
                drawerLayout.closeDrawers();
            });
            llClear.setOnClickListener(view -> etPassword.setText(""));
            tvOrderSyncMode.setOnClickListener(view -> {
                drawerLayout.closeDrawers();
                RejectReasonDialogFragment rejectReasonDialogFragment = getInstanceRejectReason("Order Sync Mode", "Please select sync mode for orders", 0, "Auto,Manual", myPreferences.getOrderSyncMode());
                rejectReasonDialogFragment.show(getSupportFragmentManager(), "reason");
                rejectReasonDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        String mode = (String) o;
                        EnterPasswordDialogFragment enterPasswordDialogFragment = myApp.getInstanceEnterPassword(null, "Enter password", "Please enter password change order sync mode");
                        enterPasswordDialogFragment.show(getSupportFragmentManager(), "password");
                        enterPasswordDialogFragment.setDialogDismissListener(p -> {
                            if (p instanceof String) {
                                String password = (String) p;
                                if (password.equalsIgnoreCase(myPreferences.getEposAdminPassword())) {
                                    myPreferences.saveOrderSyncMode(mode);
                                    userAdapter.syncMode = myPreferences.getOrderSyncMode();
                                    userAdapter.notifyDataSetChanged();
                                    ToastUtils.makeSnackToast(LoginActivity.this, "Order sync mode changed");
                                } else {
                                    ToastUtils.makeSnackToast(LoginActivity.this, "Invalid password");
                                }
                            }
                        });
                    }
                });
            });
            tvRemoteDevice.setOnClickListener(v -> {
                drawerLayout.closeDrawers();
                RejectReasonDialogFragment rejectReasonDialogFragment = getInstanceRejectReason("Remote Device", "Is this Remote Device?", 0, "On,Off", myPreferences.getRemoteDeviceEnableStatus() ? "On" : "Off");
                rejectReasonDialogFragment.show(getSupportFragmentManager(), "reason");
                rejectReasonDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        String mode = (String) o;
                        myPreferences.saveRemoteDeviceEnableStatus(mode.equalsIgnoreCase("on"));

                    }
                });
            });
            tvCallerId.setOnClickListener(view -> {
                drawerLayout.closeDrawers();
                RejectReasonDialogFragment rejectReasonDialogFragment = getInstanceRejectReason("Caller ID", "Turn on or off Caller ID", 0, "On,Off", myPreferences.getCallerIdEnableStatus() ? "On" : "Off");
                rejectReasonDialogFragment.show(getSupportFragmentManager(), "reason");
                rejectReasonDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        String mode = (String) o;
                        LogUtils.e("CallderId Status::::::::::::" + mode.equalsIgnoreCase("on"));
                        myPreferences.saveCallerIdEnableStatus(mode.equalsIgnoreCase("on"));

                    }
                });
            });
            tvSunmiPrinterEnable.setOnClickListener(view -> {
                drawerLayout.closeDrawers();
                SunmiIpAddressFragment sunmiIpAddressFragment = new SunmiIpAddressFragment();
                sunmiIpAddressFragment.show(getSupportFragmentManager(), "reason");
            });
            tvChangeBusiness.setOnClickListener(view -> {
                drawerLayout.closeDrawers();
                startActivity(new Intent(LoginActivity.this, SelectBusinessActivity.class));
            });
            tvSunmiDownloadPrinter.setOnClickListener(view -> {
                if (siteSetting.value != null && !siteSetting.value.equals("")) {
                    DownloadManager downloadManager = new DownloadManager();
                    ToastUtils.makeToast(MyApp.getInstance(), "Downloading started");
                    downloadManager.downloadFile(LoginActivity.this, "Printing_UBSIDI", ".apk", siteSetting.value, Environment.DIRECTORY_DOWNLOADS);
                    drawerLayout.closeDrawers();
                }
            });
            tvResLogout.setOnClickListener(v -> {
                askForLogout();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForUserLogout(User user) {
        try {
            if (user.is_loggin) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Logout", "Are you sure you want to log out? Please confirm, as you may be logged in with another device.", 1, "Confirm", "Cancel");
                confirmationDialogFragment.show(getSupportFragmentManager(), "logout");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            callLogoutUserApi(user);
                        }
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void callLogoutUserApi(User user) {
        try {
            progressDialog.show();
            String userId = user.id;
            String server_URL = ApiEndPoints.users + userId + ApiEndPoints.user_logout;
            AndroidNetworking.get(server_URL)
                    .build()
                    .getAsObject(User.class, new ParsedRequestListener<User>() {
                        @Override
                        public void onResponse(User response) {
                            new Thread(() -> {
                                user.is_loggin = false;
                                appDatabase.userDao().insert(user);
                                runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                    userAdapter.notifyDataSetChanged();
                                });
                            }).start();
                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDialog.dismiss();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(LoginActivity.this, apiError.getMessage());
                            } else if (anError.getErrorCode() >= 500) {
                                ToastUtils.makeSnackToast(LoginActivity.this, "Error occurred while logout");
                            } else {
                                ToastUtils.makeSnackToast(LoginActivity.this, "Error occurred while logout");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForLogout() {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Logout", "Are you sure you want to logout?", 1, "Confirm", "Cancel");
            confirmationDialogFragment.show(getSupportFragmentManager(), "logout");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("confirm")) {
                        doAdminLogout();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doAdminLogout() {
        try {
            ToastUtils.makeToast(LoginActivity.this, "Logout successfully!!");
            FirebaseMessaging.getInstance().unsubscribeFromTopic("business_" + myPreferences.getLoggedInAdmin().selected_business.id);
            myPreferences.saveLoggedInAdmin(null);
            myPreferences.saveLoggedInUser(null);
            myPreferences.saveUserTokens(null, null);
            myPreferences.saveAdminTokens(null, null);
            myPreferences.userLoggedInWithoutInternet(false);
            myPreferences.adminLoggedInWithoutInternet(false);
            myPreferences.saveBusinessId(null);
            /*new Thread(() -> {
                appDatabase.emptyPulledDao().nukeAddon();
                appDatabase.emptyPulledDao().nukeCategory();
                appDatabase.emptyPulledDao().nukeCustomer();
                appDatabase.emptyPulledDao().nukePrepLocation();
                appDatabase.emptyPulledDao().nukeProduct();
                appDatabase.emptyPulledDao().nukeProductAddon();
                appDatabase.emptyPulledDao().nukeProductIngredient();
                appDatabase.emptyPulledDao().nukeTable();
                appDatabase.emptyPulledDao().nukeFloor();
                appDatabase.emptyPulledDao().nukeOrderItemIngredient();
                appDatabase.emptyPulledDao().nukeOrderItemAddon();
                appDatabase.emptyPulledDao().nukeOrderPayment();
                appDatabase.emptyPulledDao().nukeOrderSplit();
                appDatabase.emptyPulledDao().nukeOrder();
                appDatabase.emptyPulledDao().nukeUsers();
                appDatabase.emptyPulledDao().nukeReservations();
                appDatabase.emptyPulledDao().nukeVouchers();
                appDatabase.orderDao().resetPrimaryKey();
                try {
                    deleteImages();
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }).start();*/
            myPreferences.savePullStatus(false);
            startActivity(new Intent(LoginActivity.this, SplashActivity.class));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteImages() {
        try {
            File dir = new File(getApplicationContext().getExternalFilesDir("epos2021").getAbsolutePath());
            if (dir.isDirectory()) {
                String[] children = dir.list();
                if (children != null) {
                    for (String child : children) {
                        try {
                            new File(dir, child).delete();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValid() {
        try {
            if (Validators.isNullOrEmpty(etUsername.getText().toString())) {
                ToastUtils.makeToast(LoginActivity.this, "Please enter username");
                return false;
            }
            if (Validators.isNullOrEmpty(etPassword.getText().toString())) {
                ToastUtils.makeToast(LoginActivity.this, "Please enter password");
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void fetchMiniUsers() {
        try {
            progressDialog.show();
            new Thread(() -> {
                users.clear();
                users.addAll(appDatabase.userDao().list());
                runOnUiThread(() -> {
                    userAdapter.notifyDataSetChanged();
                    progressDialog.dismiss();
                });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchDevice() {
        try {
            AndroidNetworking.post(ApiEndPoints.devices + "validate/" + myApp.getDeviceId())
                    .addBodyParameter("device_token", myPreferences.getUserFCMToken())
                    .addQueryParameter("request_for", "admin")
                    .build()
                    .getAsObject(Device.class, new ParsedRequestListener<Device>() {
                        @Override
                        public void onResponse(Device response) {
                            Log.e("onResponse", "ApiEndPoints.devices " + new Gson().toJson(response));

                            if (!Validators.isNullOrEmpty(response.caller_id) && response.caller_id.equalsIgnoreCase("1")) {
                                callerIdStatus = "On";
                            } else {
                                callerIdStatus = "Off";
                            }

                            myPreferences.setSunmiEnabled(response.sunmi_printer_enable);
                            //response.sunmi_printer_enable = true;
                            if (response.sunmi_printer_enable) {
                                tvSunmiPrinterEnable.setVisibility(View.VISIBLE);
                                tvSunmiDownloadPrinter.setVisibility(View.VISIBLE);
                            } else {
                                tvSunmiDownloadPrinter.setVisibility(View.GONE);
                                tvSunmiPrinterEnable.setVisibility(View.GONE);
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            progressDialog.dismiss();
                            callerIdStatus = "Off";
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void callRmsSiteSettingApi() {
        try {
            LogUtils.e("Fetching Site Settings");
            AndroidNetworking.get(ApiEndPoints.SITESETTINGSRMS)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(SiteSetting.class, new ParsedRequestListener<List<SiteSetting>>() {
                        @Override
                        public void onResponse(List<SiteSetting> response) {
                            Log.e("SiteSettingRmsResponse", "" + response);
                            siteSetting = findSetting("printing_app_url_link", response);
                        }

                        @Override
                        public void onError(ANError anError) {
                            Log.e("Response", " " + anError.getErrorCode());
                            Log.e("Response", " " + anError.getMessage());

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SiteSetting findSetting(String key, List<SiteSetting> siteSettings) {
        SiteSetting siteSetting = new SiteSetting();
        siteSetting.key = key;
        int index = siteSettings.indexOf(siteSetting);
        if (index == -1) return null;
        if (siteSettings.size() == 0 || siteSettings.size() - 1 < index) return null;
        return siteSettings.get(index);
    }

    private void performUserLogin() {
        try {
            progressDialog.show();
            AndroidNetworking.post(ApiEndPoints.user_login)
                    .addBodyParameter("username", etUsername.getText().toString())
                    .addBodyParameter("password", etPassword.getText().toString())
                    .addBodyParameter("mode", myPreferences.getOrderSyncMode().toLowerCase())
                    .build()
                    .getAsObject(User.class, new ParsedRequestListener<User>() {
                        @Override
                        public void onResponse(User response) {
                            myPreferences.saveEposUserPermission(new Gson().toJson(response.permissions));
                            MyApp.userPermission = (EposUserPermission) response.permissions;
                            response.permissions = null;
                            response.password = etPassword.getText().toString();
                            myPreferences.saveLoggedInUser(response);
                            progressDialog.dismiss();
                            ToastUtils.makeToast(LoginActivity.this, "Login successfully");
                            startActivity(new Intent(LoginActivity.this, HomeActivity.class));
                            finish();
                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDialog.dismiss();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                if (apiError != null && !Validators.isNullOrEmpty(apiError.getMessage())) {
                                    if (apiError.getMessage().equalsIgnoreCase("User already logged in other device,Please try later")) {
                                        new Thread(() -> {
                                            User user = appDatabase.userDao().view(etUsername.getText().toString());
                                            if (selectedUser != null && !selectedUser.is_loggin) {
                                                selectedUser.is_loggin = true;
                                            }
                                            if (user != null && !user.is_loggin) {
                                                user.is_loggin = true;
                                                appDatabase.userDao().insert(user);
                                                runOnUiThread(() -> userAdapter.notifyDataSetChanged());
                                            }
                                        }).start();
                                    }
                                    ToastUtils.makeSnackToast(LoginActivity.this, apiError.getMessage());
                                }
                            } else if (anError.getErrorCode() >= 500) {
                                ToastUtils.makeSnackToast(LoginActivity.this, "Error occurred while login");
                            } else {
                                offlineLogin();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void offlineLogin() {
        try {
            String userName = etUsername.getText().toString();
            String password = etPassword.getText().toString();
            new Thread(() -> {
                User user = appDatabase.userDao().view(userName);
                if (user != null) {
                    if (password.equals(user.password)) {
                        myPreferences.saveLoggedInUser(user);
                        myPreferences.saveEposUserPermission(user.string_permission);
                        myPreferences.userLoggedInWithoutInternet(true);
                        ToastUtils.makeToast(LoginActivity.this, "Login successfully");
                        runOnUiThread(() -> {
                            myPreferences.savePullStatus(true);
                            startActivity(new Intent(LoginActivity.this, HomeActivity.class));
                            finish();
                        });
                    } else {
                        ToastUtils.makeSnackToast(LoginActivity.this, "Invalid password");
                    }
                } else {
                    ToastUtils.makeSnackToast(LoginActivity.this, "Invalid username");
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void changeStatusBarColor(int color) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                Window window = getWindow();
                window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
                window.setStatusBarColor(color);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver broadcastReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra(Constants.PROGRESS) && intent.getIntExtra(Constants.PROGRESS, 100) < 100) {
                //progressDialog.show();
            } else {
                /*Intent intent1 = new Intent(Intent.ACTION_VIEW);
                intent1.setDataAndType(Uri.fromFile(new File(Environment.getExternalStorageDirectory() + "/download/" + "Epos_Receiver_Printer.apk")), "application/vnd.android.package-archive");
                intent1.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                startActivity(intent1);*/
                //progressDialog.dismiss();
            }
        }
    };

    @Override
    protected void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance(this).registerReceiver(broadcastReceiver, new IntentFilter(Constants.DOWNLOAD_PROGRESS));
            if (!myApp.isConnected(this)) {
                changeStatusBarColor(Color.RED);
            } else {
                changeStatusBarColor(Color.BLACK);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        LocalBroadcastManager.getInstance(this).unregisterReceiver(broadcastReceiver);
    }

    public RejectReasonDialogFragment getInstanceRejectReason(String title, String info, int type, String reasons, String selectedReason) {
        RejectReasonDialogFragment rejectReasonDialogFragment = new RejectReasonDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("reasons", reasons);
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putInt("type", type);
        bundle.putString("selected_reason", selectedReason);
        rejectReasonDialogFragment.setArguments(bundle);
        return rejectReasonDialogFragment;
    }
}