package com.ubsidi.epos_2021.activities;

import static com.ubsidi.epos_2021.utils.Constants.AUTO_ACCEPT;
import static com.ubsidi.epos_2021.utils.Constants.BOOKING_ID;
import static com.ubsidi.epos_2021.utils.Constants.QUANTITY_MODIFIED_ADD;
import static com.ubsidi.epos_2021.utils.Constants.QUANTITY_MODIFIED_MINUS;

import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.ViewModelProvider;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.daimajia.swipe.SwipeLayout;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.imin.library.IminSDKManager;
import com.ubsidi.BuildConfig;
import com.ubsidi.R;
import com.ubsidi.epos_2021.Links;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.OrderButtonsAdapter;
import com.ubsidi.epos_2021.adapters.OrderItemsAdapter;
import com.ubsidi.epos_2021.adapters.OrderOptionMenuAdapter;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.daos.relations.OrderItemWithAddonsIngredients;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.fragment.AddCommentFragment;
import com.ubsidi.epos_2021.fragment.AssignTableDialogFragment;
import com.ubsidi.epos_2021.fragment.CancelOrderDialogFragment;
import com.ubsidi.epos_2021.fragment.CartProductEditDialogFragment;
import com.ubsidi.epos_2021.fragment.CartProductEditDialogFragmentOldDesign;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.fragment.ConvertOrderTypeFragment;
import com.ubsidi.epos_2021.fragment.CustomerInfoDialogFragment;
import com.ubsidi.epos_2021.fragment.DiscountDialogFragment;
import com.ubsidi.epos_2021.fragment.MainCategoryFragment;
import com.ubsidi.epos_2021.fragment.MiscItemFragment;
import com.ubsidi.epos_2021.fragment.NewOrderDialogFragment;
import com.ubsidi.epos_2021.fragment.OrderItemViewDialogFragment;
import com.ubsidi.epos_2021.fragment.OrderTypeSelectionDialogFragment;
import com.ubsidi.epos_2021.fragment.PaymentViaVoucherFragment;
import com.ubsidi.epos_2021.fragment.PrintOptionsDialogFragment;
import com.ubsidi.epos_2021.fragment.ProductAreaFragment;
import com.ubsidi.epos_2021.fragment.SendOrderDialogFragment;
import com.ubsidi.epos_2021.fragment.TimeSelectionDeliveryDialog;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.CalllogViewModel;
import com.ubsidi.epos_2021.models.CustomMenuItem;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.DeliveryCharge;
import com.ubsidi.epos_2021.models.Discount;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderButton;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.PaymentMethod;
import com.ubsidi.epos_2021.models.Postcode;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.qrcode_generator.QRGContents;
import com.ubsidi.epos_2021.qrcode_generator.QRGEncoder;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.services.UpdateOrderAsyncTaskServices;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.AppExecutors;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.OnSwipeTouchListener;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.ubsidi.epos_2021.utils.WrapContentLinearLayoutManager;

import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

/**
 * Created by Amrish on 17-05-2021.
 */
public class NewOrderActivity extends BaseActivity {
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;
    public Business selectedBusiness;
    private final ArrayList<OrderItem> orderItems = new ArrayList<>();
    private final ArrayList<Object> objects = new ArrayList<>();
    private final ArrayList<OrderButton> orderButtons = new ArrayList<>();
    private final ArrayList<CustomMenuItem> orderOptionsMenu = new ArrayList<>();
    private final ArrayList<CustomMenuItem> orderActionMenu = new ArrayList<>();
    public WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    public TableStatus vacantStatus = myApp.findStatus("Vacant");
    public TableStatus mergedStatus = myApp.findStatus("Merged");
    public TableStatus takingOrderStatus = myApp.findStatus("Taking Order");
    public TableStatus orderTakenStatus = myApp.findStatus("Order Taken");
    public TableStatus servedStatus = myApp.findStatus("Served");
    public TableStatus servedPaidStatus = myApp.findStatus("Served and paid");
    FragmentManager manager;
    Order order = new Order();
    boolean orderCompleteAuto = false;
    CalllogViewModel calllogViewModel;
    boolean shouldFetchDeliveryCharge = false;
    float deliveryCharge = 0;
    boolean splitByPersonPrint = false;
    float printableTotal = 0;
    private Chip chipBack;
    private TextView tvCurrentScreen, tvTime;
    private EditText etSearch;
    private LinearLayout llDiscount, llGratuity, llServiceCharge, llDelivery, llSearch, llCustomerInfo, llVoucher;
    private TextView tvGratuity, tvServiceCharge, tvDelivery, tvEditQty, tvSwipeToRemove, tvDone, tvcustomer_contact, tvcustomer_detail, tvVoucher;
    private MaterialButton btnCheckout, btnCancelOrder, btnDeleteOrder, btnCash, btnCard;
    private TextView tvInstruction;
    private LinearLayout llDelete, llCheckout;
    private SwipeLayout swipeLayout;
    private MaterialCardView cvInstructions;
    private TextView tvGratuityText, tvServiceChargeText, tvDiscountText, tvVoucherText;
    private LinearLayout llExpand, llGrandTotal;
    private ImageView ivExpand, imgSearch;
    private RecyclerView rvOrderItems, rvOrderAction;
    private MaterialCardView cvCallerId;
    private OrderItemsAdapter orderItemsAdapter;
    private Printer forceFullyDefaultPrinter;
    private ArrayList<Printer> printers = new ArrayList<>();
    private TextView tvSubtotal, tvDiscount, tvGrandTotal, tvCallerName, tvCalleAddress, tvDeliveryText;
    private float cartGrandTotal = 0, cartSubTotal = 0, cartDiscount = 0, cartGratuity = 0, cartServiceCharge = 0;
    private LinearLayout llCustomerDetails;
    private LinearLayout llCallerId;
    private TextView tvCustomerDetails;
    private RecyclerView rvOrderButtons;
    private OrderButtonsAdapter buttonsAdapter;
    private AlertDialog progressBarDialog;
    private Chip ivOrderOptions;
    private Chip ivRetriveOrder;
    private LinearLayout llOrderOptions;
    private RecyclerView rvOrderOptions;
    private OrderOptionMenuAdapter orderOptionMenuAdapter, orderActionMenuAdapter;
    private OrderWithItems orderWithItems;
    private TextView tvCallerNumber;
    private ImageView imgCancel, imgAccept, imgHold;
    private CallLogs callLogs;
    final long MIN_CLICK_INTERVAL = 1500; //in millis
    long lastClickTime = 0;
    private List<PrintSetting> printSettings = myPreferences.getPrintSetting();
    private PrintStructure printStructure;
    private ArrayList<PrintStyle> listPrintStructure;
    String stripe_private_key, stripe_public_key;
    BroadcastReceiver callReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                callLogs = new Gson().fromJson(intent.getStringExtra("calllogs"), CallLogs.class);
                cvCallerId.setVisibility(View.VISIBLE);
                if (callLogs.customer != null) {
                    Customer customer = callLogs.customer;
                    if (!Validators.isNullOrEmpty(customer.name)) {
                        tvCallerName.setText(customer.name);
                    } else {
                        tvCallerName.setText("");
                    }
                    StringBuilder sb = new StringBuilder();
                    if (!Validators.isNullOrEmpty(customer.house_no)) {
                        sb.append(customer.house_no).append(", ");
                    }
                    if (!Validators.isNullOrEmpty(customer.street)) {
                        sb.append(customer.street).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.postcode)) {
                        sb.append(customer.postcode).append("\n");
                    }

                    if (!Validators.isNullOrEmpty(customer.city)) {
                        sb.append(customer.city).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.state)) {
                        sb.append(customer.state).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.distance)) {
                        sb.append(customer.distance).append(" Miles away");
                    }

                    if (!Validators.isNullOrEmpty(sb.toString())) {
                        tvCalleAddress.setText(sb.toString());
                    } else {
                        tvCalleAddress.setText("");
                    }

                } else {
                    tvCallerName.setText("");
                    tvCalleAddress.setText("");
                }
                tvCallerNumber.setText(callLogs.number);
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }

        }
    };
    private int _order_id;
    private String order_id;
    private LinearLayout llMainLayout;
    private SiteSetting addonThemeSetting;
    private SiteSetting gratuityMainSetting;
    private SiteSetting printAllMainSetting;
    private SiteSetting printBillMainSetting;
    private SiteSetting sendOrderMainSetting;
    private SiteSetting sendOrderUpdateMainSetting;
    private SiteSetting sendDupOrderMainSetting;
    private SiteSetting sendDupOrderUpdateMainSetting;
    private SiteSetting buzzerSetting;
    private SiteSetting serviceChargeSetting;
    private SiteSetting serviceChargeTypeSetting;
    private SiteSetting ticketHeaderSetting;
    private SiteSetting footerOrderTypeSetting;
    private SiteSetting tableOrOrderIdSetting;
    private SiteSetting sendOrderActionSetting;
    private SiteSetting payBillActionSetting;
    private SiteSetting payBillActionModeSetting;
    private SiteSetting deliveryChargeTypeOption;
    private SiteSetting displayDiscount;
    private SiteSetting partialPaymentPrint;
    private SiteSetting auto_delivery_time_slot;
    private boolean serviceChargeAutoMode = true, serviceChargeVisible = false,
            serviceChargeEnabled = false, voucherPaymentsEnabled = false,
            discountEnabled = true, gratuityEnabled = true, autoDiscountApplied = false;
    private int headerAlignment = 0;
    private boolean printTotalInPrint = true;
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private Printer defaultPrinter;
    private boolean needToUpload = true;
    private boolean isBackPressed = false;
    private boolean isUploadStarted = false;
    private HashMap<String, String> settingsMap = new HashMap<>();

    BroadcastReceiver orderButtonClickReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getExtras().getBoolean("print_order")) {
                    if (!order.order_type_id.equalsIgnoreCase("1") && !order.is_delivery_collection_ask && auto_delivery_time_slot != null && (auto_delivery_time_slot.value.equalsIgnoreCase("true") || auto_delivery_time_slot.value.equalsIgnoreCase("1"))) {
                        openTimeSelection(o -> printOrder(intent));
                    } else {
                        printOrder(intent);
                    }
                }
                if (intent.getExtras().getBoolean("send_order")) {
                    try {
                        Pair<Integer, String> stringPair = isOnlyOneItemInSendOrder();
                        if (stringPair.first == 1) {
                            printCopy(stringPair.second);
                        } else {
                            if (!order.order_type_id.equalsIgnoreCase("1") && !order.is_delivery_collection_ask && auto_delivery_time_slot != null && (auto_delivery_time_slot.value.equalsIgnoreCase("true") || auto_delivery_time_slot.value.equalsIgnoreCase("1"))) {
                                openTimeSelection(o -> sendOrderKitchen());
                            } else {
                                sendOrderKitchen();
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void printOrder(Intent intent) {
        try {
            if (intent.getExtras().getBoolean("print_all")) {
                // For creating kitchen copy
                // createBillPrint("", true, false, false);
                //  createBillPrint("", false, true, false);
                // Calling two methods one by one
                boolean kitchenCopy = true;
                String title = "Full Order";
                boolean updateOrder = false;
                if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                    if (kitchenCopy) {
                        new PrepLocationSenderAsync(title, updateOrder, () -> {
                            Thread.sleep(200);
                            createBillPrint("", false, true, false);
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                } else {
                    showToastInPostExecute(false);
                    Thread.sleep(200);
                    createBillPrint("", false, true, false);
                }

            }
            if (intent.getExtras().getBoolean("print_bill")) {
                createBillPrint("print_bill", false, true, false);
            }
        } catch (Exception ce) {
            ce.printStackTrace();
        }
    }

    private void sendOrderKitchen() {
        SendOrderDialogFragment sendOrderDialogFragment = getInstanceSendOrder(sendOrderMainSetting, sendOrderUpdateMainSetting, sendDupOrderMainSetting, sendDupOrderUpdateMainSetting);
        sendOrderDialogFragment.show(getSupportFragmentManager(), "send_order");
        sendOrderDialogFragment.setDialogDismissListener(o -> {
            if (o instanceof String) {
                printCopy((String) o);
            }
        });
    }

    private void printCopy(String order_action_id) {
        order.order_action_id = (String) order_action_id;
        new UpdateOrderAsyncTask(() -> {
            if (sendOrderActionSetting != null && sendOrderActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                if (order.order_action_id.equalsIgnoreCase("1")) {
                    createPrint("Full Order", true, true, false);
                } else if (order.order_action_id.equalsIgnoreCase("2")) {
                    createPrint("Duplicate Order", true, true, false);
                } else if (order.order_action_id.equalsIgnoreCase("3")) {
                    createPrint("Updated Order", true, true, true);
                } else if (order.order_action_id.equalsIgnoreCase("4")) {
                    createPrint("Duplicate Updated Order", true, true, true);
                } else {
                    onBackPressed();
                }
            } else {
                onBackPressed();
            }
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private Pair<Integer, String> isOnlyOneItemInSendOrder() {
        int count = 0;
        String actionId = "";
        if (sendOrderMainSetting != null && (sendOrderMainSetting.value.equalsIgnoreCase("true") || sendOrderMainSetting.value.equalsIgnoreCase("1"))) {
            actionId = "1";
            count = count + 1;
        }
        if (sendOrderUpdateMainSetting != null && (sendOrderUpdateMainSetting.value.equalsIgnoreCase("true") || sendOrderUpdateMainSetting.value.equalsIgnoreCase("1"))) {
            actionId = "3";
            count = count + 1;
        }
        if (sendDupOrderMainSetting != null && (sendDupOrderMainSetting.value.equalsIgnoreCase("true") || sendDupOrderMainSetting.value.equalsIgnoreCase("1"))) {
            actionId = "2";
            count = count + 1;
        }
        if (sendDupOrderUpdateMainSetting != null && (sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("true") || sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("1"))) {
            actionId = "4";
            count = count + 1;
        }
        return new Pair(count, actionId);
    }

    private boolean voucherPaymentDone = true;
    private float voucherPaymentDoneAmount = 0f;
    private String destination;
    private String footerA, footerB, footerHeading;
    private String dateTimeModeInPrint;
    private Handler mHandler;
    private DialogDismissListener searchListerner;
    private boolean canEditOrder = false, callChangeTableStatus = true;
    private OrderSplit selectedSplit;
    private boolean shouldOpenSplitScreen = false;
    BroadcastReceiver orderItemReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (order != null) {
                    if (!isValidToPlaceOrder()) return;
                }
                if (!canEditOrder) return;
                String order_item = intent.getStringExtra("order_item");
                if (!Validators.isNullOrEmpty(order_item)) {
                    order.order_action_id = null;
                    OrderItem orderItem = new Gson().fromJson(order_item, OrderItem.class);
                    Log.e("OrderItem", ":" + orderItem.toString());
                    new AddOrUpdateOrderItemAsyncTask(() -> {
                        new UpdateOrderAsyncTask(() -> {
                            fetchOffline(false);
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, orderItem);

                }
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    };
    BroadcastReceiver orderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("result", false)) {
                    int arg_order_id = intent.getIntExtra("_order_id", -1);
                    if (arg_order_id == _order_id && intent.hasExtra("ingredients")) {
                        fetchOffline(false);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void setXML() {
        super.setXML();
        try {
            setContentView(R.layout.fragment_new_order);
            manager = getSupportFragmentManager();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSearchListener(DialogDismissListener searchListener) {
        this.searchListerner = searchListener;
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getIntent() != null) {
                order = new Gson().fromJson(getIntent().getStringExtra("order"), Order.class);
                //  Toast.makeText(this, "Order Type:" + order.order_type, Toast.LENGTH_SHORT).show(); // No need to show toast
                destination = getIntent().getStringExtra("destination");
                shouldFetchDeliveryCharge = getIntent().getBooleanExtra("fetch_delivery_charge", false);
                if (order != null && !Validators.isNullOrEmpty(order.order_status_id) && (order.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10"))) {
                    needToUpload = false;
                }
                _order_id = getIntent().getIntExtra("orderId", -1);
                _order_id = getIntent().getIntExtra("_order_id", -1);
                order_id = getIntent().getStringExtra("order_id");
                if (order != null) {
                    _order_id = order._id;
                    order_id = order.id;
                } else {
                    if (_order_id == -1 && order != null) {
                        _order_id = order._id;
                    }
                    if (Validators.isNullOrEmpty(order_id) && order != null) {
                        order_id = order.id;
                    }
                }
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        return super.onCreateView(parent, name, context, attrs);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            myApp.setOrderItems(new ArrayList<>());
            myApp.isPaymentLinkSent = false;
            calllogViewModel = new ViewModelProvider(this).get(CalllogViewModel.class);
            setListeners();
            changeFragment(getInstanceProductArea(order_id, _order_id), false);

            LogUtils.e("order::" + new Gson().toJson(order));
            LogUtils.e("order type id::" + order.order_type_id);
            addCategoryFragment(getInstance(order.order_type_id));

            if (orderItemReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(orderItemReceiver);
            }
            if (orderButtonClickReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(orderButtonClickReceiver);
            }
            LocalBroadcastManager.getInstance(this).registerReceiver(orderItemReceiver, new IntentFilter(Constants.EPOS_CART_UPDATE));
            LocalBroadcastManager.getInstance(this).registerReceiver(orderButtonClickReceiver, new IntentFilter("order_button_click"));

            updateTime();
            printers = selectedBusiness.printers;

            Log.e("Abc", "" + shouldFetchDeliveryCharge);
            if (shouldFetchDeliveryCharge && deliveryChargeTypeOption.value.equals("auto")) {
                fetchDeliveryCharge(() -> {
                    fetchOffline(true);
                    return null;
                });
            } else {
                shouldFetchDeliveryCharge = order.order_type_id.equalsIgnoreCase("3");
                Log.e("Abc", "" + shouldFetchDeliveryCharge);

                if (shouldFetchDeliveryCharge)
                    deliveryCharge = order.delivery_charge;

                fetchOffline(true);
            }

            if (defaultPrinter != null && (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                wifiPrinter.connect(defaultPrinter.ip);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addCategoryFragment(Fragment fragment) {
        try {
            FragmentManager manager = getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.fl_main_category, fragment);
            transaction.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        return super.onCreateView(name, context, attrs);
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            if (myPreferences.getLoggedInAdmin() != null)
                selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;
            if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                stripe_private_key = BuildConfig.connect_stripe_private_key;
                stripe_public_key = BuildConfig.connect_stripe_public_key;
            } else {
                stripe_private_key = selectedBusiness.stripe_private_key_live;
                stripe_public_key = selectedBusiness.stripe_public_key_live;
            }
            defaultPrinter = myPreferences.getDefaultPrinter();
            forceFullyDefaultPrinter = myPreferences.getDefaultPrinter(true);
            zoneRichPrinter = new ZoneRichPrinter(this);
            sunmiPrinter = new SunmiPrinter(this);
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(this);
            }
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(this);
            Toolbar toolbar = findViewById(R.id.toolbar);
            progressBarDialog = CommonFunctions.customProgressDialog(this);
            ivOrderOptions = findViewById(R.id.ivOrderOptions);
            ivRetriveOrder = findViewById(R.id.ivRetriveOrder);

            imgHold = findViewById(R.id.imgHold);
            imgCancel = findViewById(R.id.imgCancel);
            imgAccept = findViewById(R.id.imgAccept);
            tvCallerNumber = findViewById(R.id.tvCallerNumber);
            tvCallerName = findViewById(R.id.tvCallerName);
            tvCalleAddress = findViewById(R.id.tvCalleAddress);
            llCallerId = findViewById(R.id.llCallerId);
            cvCallerId = findViewById(R.id.cvCallerId);

            rvOrderItems = findViewById(R.id.rvSelectedProducts);

            llCustomerDetails = findViewById(R.id.llCustomerDetails);
            tvCustomerDetails = findViewById(R.id.tvCustomerDetails);

            tvSubtotal = findViewById(R.id.tvSubtotal);
            tvDiscount = findViewById(R.id.tvDiscount);
            tvGrandTotal = findViewById(R.id.tvGrandTotal);
            tvDeliveryText = findViewById(R.id.tvDeliveryText);

            rvOrderButtons = findViewById(R.id.rvOrderButtons);
            llOrderOptions = findViewById(R.id.llOrderOptions);
            rvOrderOptions = findViewById(R.id.rvOrderOptions);

            chipBack = findViewById(R.id.chipBack);
            tvCurrentScreen = findViewById(R.id.tvCurrentScreen);
            etSearch = findViewById(R.id.etSearchMenu);
            tvTime = findViewById(R.id.tvTime);
            tvEditQty = findViewById(R.id.tvEditQty);
            tvSwipeToRemove = findViewById(R.id.tvRemove);
            tvDone = findViewById(R.id.tvDone);

            llDelivery = findViewById(R.id.ll_Delivery);
            llGratuity = findViewById(R.id.ll_Gratuity);
            llServiceCharge = findViewById(R.id.ll_ServiceCharge);
            llDiscount = findViewById(R.id.ll_Discount);
            llVoucher = findViewById(R.id.ll_Voucher);
            llCustomerInfo = findViewById(R.id.llCustomerInfo);

            tvVoucher = findViewById(R.id.tvVoucher);
            tvDelivery = findViewById(R.id.tvDelivery);
            tvGratuity = findViewById(R.id.tvGratuity);
            tvcustomer_contact = findViewById(R.id.tvcustomer_contact);
            tvcustomer_detail = findViewById(R.id.tvcustomer_detail);
            tvServiceCharge = findViewById(R.id.tvServiceFee);
            btnCheckout = findViewById(R.id.btnCheckout);
            llSearch = findViewById(R.id.llSearch);
            tvInstruction = findViewById(R.id.tvInstructions);
            llDelete = findViewById(R.id.llDelete);
            swipeLayout = findViewById(R.id.swipeRevealLayout);
            cvInstructions = findViewById(R.id.cvInstruction);
            tvDiscountText = findViewById(R.id.tvDiscountText);
            tvVoucherText = findViewById(R.id.tvVoucherText);
            tvServiceChargeText = findViewById(R.id.tvServiceText);
            tvGratuityText = findViewById(R.id.tvGratuityText);
            llMainLayout = findViewById(R.id.drawer_layout);
            btnCancelOrder = findViewById(R.id.btnCancelOrder);
            btnDeleteOrder = findViewById(R.id.btnDeleteOrder);
            btnCash = findViewById(R.id.btnCash);
            btnCard = findViewById(R.id.btnCard);
            llCheckout = findViewById(R.id.llCheckout);

            llGrandTotal = findViewById(R.id.llGrandTotal);
            llExpand = findViewById(R.id.llExpandable);
            ivExpand = findViewById(R.id.ivExpand);
            imgSearch = findViewById(R.id.imgSearch);
            rvOrderAction = findViewById(R.id.rvOrderAction);

            llExpand.setVisibility(View.GONE);
            String currentTime = new SimpleDateFormat("h:mm a", Locale.getDefault()).format(new Date());
            tvTime.setText(currentTime);

            rvOrderButtons.setVisibility(View.GONE);
            btnCheckout.setVisibility(View.GONE);
            btnCard.setVisibility(View.GONE);
            btnCash.setVisibility(View.GONE);

            setSupportActionBar(toolbar);
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setTitle(" ");
            toolbar.setNavigationIcon(R.drawable.ic_baseline_arrow_back_24);
            loadSettings();
            setAdapters();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearEditText() {
        try {
            etSearch.setText("");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTime() {
        try {
            mHandler = new Handler();

            mHandler.postDelayed(runnable, 10);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final Runnable runnable = new Runnable() {
        @Override
        public void run() {
            String currentTime = new SimpleDateFormat("hh:mm a", Locale.getDefault()).format(new Date());
            if (tvTime != null) {
                tvTime.setText(currentTime);
            }
            mHandler.postDelayed(this, 1000);
        }
    };

    private void loadSettings() {
        try {
            auto_delivery_time_slot = myApp.findSetting("auto_delivery_time_slot");
            partialPaymentPrint = myApp.findSetting("partial_payment_print");
            gratuityMainSetting = myApp.findSetting("gratuity");
            // addon theme settings
            addonThemeSetting = myApp.findSetting("addon_theme");
            printAllMainSetting = myApp.findSetting("is_printall");
            printBillMainSetting = myApp.findSetting("is_printbill");
            buzzerSetting = myApp.findSetting("open_cash_drawer_after_send_to_kitchen");
            sendOrderMainSetting = myApp.findSetting("is_sendorder");
            sendOrderUpdateMainSetting = myApp.findSetting("is_sendorderupdate");
            sendDupOrderMainSetting = myApp.findSetting("is_sendduplicateorder");
            sendDupOrderUpdateMainSetting = myApp.findSetting("is_sendorderupdate");

            sendOrderActionSetting = myApp.findSetting("send_order_action");
            if (order != null) {
                if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("2")) {
                    payBillActionSetting = myApp.findSetting("pickup_pay_bill_action");
                    footerOrderTypeSetting = myApp.findSetting("footer_takeaway");
                } else if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("3")) {
                    payBillActionSetting = myApp.findSetting("delivery_pay_bill_action");
                    footerOrderTypeSetting = myApp.findSetting("footer_delivery");
                } else if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("5")) {
                    payBillActionSetting = myApp.findSetting("waiting_pay_bill_action");
                    footerOrderTypeSetting = myApp.findSetting("footer_waiting");
                } else {
                    if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("1")) {
                        footerOrderTypeSetting = myApp.findSetting("footer_dinein");
                    }
                    payBillActionSetting = myApp.findSetting("pay_bill_action");
                }
            } else {
                payBillActionSetting = myApp.findSetting("pay_bill_action");
            }

            payBillActionModeSetting = myApp.findSetting("pay_bill_action_type");
            SiteSetting totalVisibilitySetting = myApp.findSetting("kitchen_total_visible");
            SiteSetting footerASetting = myApp.findSetting("footer_a");
            SiteSetting footerBSetting = myApp.findSetting("footer_b");
            SiteSetting orderDateTimeSetting = myApp.findSetting("date_time_in_receipt_printing");
            tableOrOrderIdSetting = myApp.findSetting("use_table_number_or_order_number");
            SiteSetting serviceChargeEnableSetting = myApp.findSetting("is_service_charge");

            serviceChargeSetting = myApp.findSetting("service_charge");
            SiteSetting serviceChargeOptionSetting = myApp.findSetting("service_charge_type_option");
            serviceChargeTypeSetting = myApp.findSetting("service_charge_type");
            deliveryChargeTypeOption = myApp.findSetting("delivery_charge_type_option");
            displayDiscount = myApp.findSetting("display_discount_setting");

            SiteSetting ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            if (serviceChargeEnableSetting != null && (serviceChargeEnableSetting.value.equalsIgnoreCase("true") || serviceChargeEnableSetting.value.equalsIgnoreCase("1"))) {
                serviceChargeEnabled = true;
                serviceChargeVisible = true;
            }
            if (serviceChargeEnabled && serviceChargeOptionSetting != null && serviceChargeOptionSetting.value.equalsIgnoreCase("manual")) {
                serviceChargeAutoMode = false;
            }

            SiteSetting paidPaymentSetting = myApp.findSetting("paid_payment_title");
            SiteSetting unpaidPaymentSetting = myApp.findSetting("unpaid_payment_title");
            SiteSetting partialPaymentSetting = myApp.findSetting("partial_payment_title");
            SiteSetting cardPaymentSetting = myApp.findSetting("card_payment_type");
            SiteSetting cashPaymentSetting = myApp.findSetting("cash_payment_type");

            settingsMap.put("paid_payment_title", paidPaymentSetting.value);
            settingsMap.put("unpaid_payment_title", unpaidPaymentSetting.value);
            settingsMap.put("partial_payment_title", partialPaymentSetting.value);
            settingsMap.put("card_payment_type", cardPaymentSetting.value);
            settingsMap.put("cash_payment_type", cashPaymentSetting.value);

            if (footerASetting != null) {
                footerA = footerASetting.value;
            }
            if (footerBSetting != null) {
                footerB = footerBSetting.value;
            }
            if (footerOrderTypeSetting != null) {
                footerHeading = footerOrderTypeSetting.value;
            }
            if (orderDateTimeSetting != null) {
                dateTimeModeInPrint = orderDateTimeSetting.value;
            }
            if (totalVisibilitySetting != null && (totalVisibilitySetting.value.equalsIgnoreCase("no") || totalVisibilitySetting.value.equalsIgnoreCase("false") || totalVisibilitySetting.value.equalsIgnoreCase("0"))) {
                printTotalInPrint = false;
            }
            SiteSetting orderCompleteMode = myApp.findSetting("order_complete_mode");
            if (orderCompleteMode != null && !Validators.isNullOrEmpty(orderCompleteMode.value) && (orderCompleteMode.value.equalsIgnoreCase("auto") || orderCompleteMode.value.equalsIgnoreCase("1") || orderCompleteMode.value.equalsIgnoreCase("yes"))) {
                orderCompleteAuto = true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAdapters() {

        //right side detail
        // Product item clicked
        //            editAddons(position,data);

        try {
            orderItemsAdapter = new OrderItemsAdapter(NewOrderActivity.this, objects, (position, action, data) -> {
                try {
                    InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                    imm.hideSoftInputFromWindow(rvOrderItems.getWindowToken(), 0);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (data instanceof OrderItem) {
                    editProduct(position, action, data);
                } else if (data instanceof OrderSplit) {
                    OrderSplit split = (OrderSplit) data;
                    if (split.selected) {
                        selectedSplit = split;
                    } else {
                        selectedSplit = null;
                    }
                    FetchOrderOfflineRxJava();
                }
            }, (position, data) -> {
                if (data instanceof OrderItem) {
                    // Product get deleted
                    OrderItem orderItem = (OrderItem) data;
                    boolean isReturn = false;
                    if (!isValidToPlaceOrder()) isReturn = true;
                    /*if (order.total_paid > 0) {
                        ToastUtils.showSnackBar(NewOrderActivity.this, llMainLayout, "Cannot change in paid order", "failed");
                        return;
                    }*/
                    if (orderItem._order_split_id > 0 && selectedSplit.paid_amount > 0) {
                        ToastUtils.showSnackBar(NewOrderActivity.this, llMainLayout, "Cannot change in paid split group", "failed");
                        return;
                    }
                    if (isReturn) {
                        rvOrderItems.post(() -> orderItemsAdapter.notifyItemRemoved(position));
                        FetchOrderOfflineRxJava();
                        return;
                    }

                    UploadOrderAsyncTaskRxJava(orderItem);
                }

            }, (position, data) -> {
                openOrderItemDetails((OrderItem) data);
            });
            rvOrderItems.setLayoutManager(new WrapContentLinearLayoutManager(NewOrderActivity.this, LinearLayoutManager.VERTICAL, false));  // Handled multiple clicks rapidly and exceptions caused
            rvOrderItems.setItemAnimator(null);
            rvOrderItems.setAdapter(orderItemsAdapter);

            rvOrderButtons.setLayoutManager(new LinearLayoutManager(NewOrderActivity.this, RecyclerView.HORIZONTAL, false));
            buttonsAdapter = new OrderButtonsAdapter(this, orderButtons, (position, data) -> {
                OrderButton orderButton = (OrderButton) data;
                manageOrderActionsClick(orderButton);
            });
            rvOrderButtons.setAdapter(buttonsAdapter);


            rvOrderOptions.setLayoutManager(new LinearLayoutManager(NewOrderActivity.this, RecyclerView.VERTICAL, false));

            orderOptionMenuAdapter = new OrderOptionMenuAdapter(orderOptionsMenu, (position, data) -> {
                // Open dialogs here
                changeViewsVisibility(data);
            });

            rvOrderOptions.setAdapter(orderOptionMenuAdapter);

            orderActionMenuAdapter = new OrderOptionMenuAdapter(orderActionMenu, (position, data) -> {
                //manage click
                manageItemActionsClick(data);
            });
            rvOrderAction.setLayoutManager(new GridLayoutManager(this, 4));
            rvOrderAction.setAdapter(orderActionMenuAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printKitchenCopy(String actionId) {
        myPreferences.saveIsPrintBill(true);
        order.order_action_id = (String) actionId;
        new UpdateOrderAsyncTask(() -> {
            if (sendOrderActionSetting != null && sendOrderActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                if (order.order_action_id.equalsIgnoreCase("1")) {
                    createPrint("Full Order", true, true, false);
                } else if (order.order_action_id.equalsIgnoreCase("2")) {
                    createPrint("Duplicate Order", true, true, false);
                } else if (order.order_action_id.equalsIgnoreCase("3")) {
                    createPrint("Updated Order", true, true, true);
                } else if (order.order_action_id.equalsIgnoreCase("4")) {
                    createPrint("Duplicate Updated Order", true, true, true);
                } else {
                    onBackPressed();
                }
            } else {
                onBackPressed();
            }
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private void printKictchenCopy() {
        SendOrderDialogFragment sendOrderDialogFragment = getInstanceSendOrder(sendOrderMainSetting, sendOrderUpdateMainSetting, sendDupOrderMainSetting, sendDupOrderUpdateMainSetting);
        sendOrderDialogFragment.show(getSupportFragmentManager(), "send_order");
        sendOrderDialogFragment.setDialogDismissListener(o -> {
            if (o instanceof String) {
                printKitchenCopy((String) o);
            }
        });
    }

    private void manageItemActionsClick(Object data) {

        try {
            CustomMenuItem customMenuItem = (CustomMenuItem) data;

            if (customMenuItem.key.equalsIgnoreCase("send_order")) {
                Pair<Integer, String> stringPair = isOnlyOneItemInSendOrder();
                if (stringPair.first == 1) {
                    printKitchenCopy(stringPair.second);
                } else {
                    if (!order.order_type_id.equalsIgnoreCase("1") && !order.is_delivery_collection_ask && auto_delivery_time_slot != null && (auto_delivery_time_slot.value.equalsIgnoreCase("true") || auto_delivery_time_slot.value.equalsIgnoreCase("1"))) {
                        openTimeSelection(o -> printKictchenCopy());
                    } else {
                        printKictchenCopy();
                    }
                }
            } else if (customMenuItem.key.equalsIgnoreCase("print_order")) {
                //print bill
                if (!order.order_type_id.equalsIgnoreCase("1") && !order.is_delivery_collection_ask && auto_delivery_time_slot != null && (auto_delivery_time_slot.value.equalsIgnoreCase("true") || auto_delivery_time_slot.value.equalsIgnoreCase("1"))) {
                    openTimeSelection(o -> printOrder());
                } else {
                    printOrder();
                }
            } else if (customMenuItem.key.equalsIgnoreCase("discount")) {
                if (!canEditOrder) return;
                llSearch.setVisibility(View.INVISIBLE);
                DiscountDialogFragment discountFragment = getInstanceDiscountDialog(order._id, "Discount");
                changeFragment(discountFragment, true);
                discountFragment.setDialogDismissListener(o -> {
                    if (!isValidToPlaceOrder()) return;

                    if (o instanceof Float) {
                        cartDiscount = (float) o;
                        new UpdateOrderAsyncTask(() -> {
                            try {
                                fetchOffline(false);
                                ToastUtils.showSnackBar(this, llMainLayout, "Discount has been added", "success");
                                if (displayDiscount != null && !Validators.isNullOrEmpty(displayDiscount.value) && displayDiscount.value.equalsIgnoreCase("yes")) {
                                    runOnUiThread(() -> {
                                        // Expand view for discount text
                                        ivExpand.setRotation(270);
                                        llExpand.setVisibility(View.VISIBLE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                });

            } else if (customMenuItem.key.equalsIgnoreCase("split")) {
                isBackPressed = true;
                startActivityForResult(new Intent(NewOrderActivity.this, SplitActivity.class).putExtra("display_order_id", order.display_order_id).putExtra("_order_id", order._id).putExtra("order_id", order.id), Constants.CODE_REFRESH);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void printOrder() {
        PrintOptionsDialogFragment printOptionsDialogFragment = myApp.getInstancePrintOptions(printBillMainSetting, printAllMainSetting);//
        printOptionsDialogFragment.show(getSupportFragmentManager(), "print_options");
        printOptionsDialogFragment.setDialogDismissListener(o -> {
            if (o instanceof String) {
                myPreferences.saveIsPrintBill(true);
                String action = (String) o;
                if (action.equalsIgnoreCase("print_bill")) {
                    order.order_action_id = "5";
                } else if (action.equalsIgnoreCase("print_all")) {
                    order.order_action_id = "6";
                }
                new UpdateOrderStatusAsyncTask(() -> {
                    if (action.equalsIgnoreCase("print_bill")) {
                        createBillPrint("Full Order", false, true, false);
                    } else if (action.equalsIgnoreCase("print_all")) {
                        // For creating kitchen copy
                        try {
                            // Calling two methods one by one
                            boolean kitchenCopy = true;
                            String title = "Full Order";
                            boolean updateOrder = false;
                            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                if (kitchenCopy) {
                                    runOnUiThread(() -> {
                                        progressBarDialog.show();
                                    });
                                    new PrepLocationSenderAsync(title, updateOrder, () -> {
                                        Thread.sleep(1000);
                                        createBillPrint("", false, true, false);
                                        return null;
                                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                }
                            } else {
                                showToastInPostExecute(false);
                                Thread.sleep(200);
                                createBillPrint("", false, true, false);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            createBillPrint("", false, true, false);
                        }
                    }
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            }
        });
    }

    private void manageOrderActionsClick(OrderButton orderButton) {
        try {
            if (orderButton.key.equalsIgnoreCase("pay_bill")) {
                openPayBillScreen();
            } else if (orderButton.key.equalsIgnoreCase("send_order")) {
                Pair<Integer, String> stringPair = isOnlyOneItemInSendOrder();
                if (stringPair.first == 1) {
                    printCopy(stringPair.second);
                } else {
                    if (!order.order_type_id.equalsIgnoreCase("1") && !order.is_delivery_collection_ask && auto_delivery_time_slot != null && (auto_delivery_time_slot.value.equalsIgnoreCase("true") || auto_delivery_time_slot.value.equalsIgnoreCase("1"))) {
                        openTimeSelection(o -> openSendOrderDialog());
                    } else {
                        openSendOrderDialog();
                    }
                }
            } else if (orderButton.key.equalsIgnoreCase("print_bill")) {
                new UpdateOrderAsyncTask(() -> {
                    if (sendOrderActionSetting != null && sendOrderActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                        if (order.order_action_id.equalsIgnoreCase("1")) {
                            createPrint("Full Order", true, true, false);
                        } else if (order.order_action_id.equalsIgnoreCase("2")) {
                            createPrint("Duplicate Order", true, true, false);
                        } else if (order.order_action_id.equalsIgnoreCase("3")) {
                            createPrint("Updated Order", true, true, true);
                        } else if (order.order_action_id.equalsIgnoreCase("4")) {
                            createPrint("Duplicate Updated Order", true, true, true);
                        } else {
                            onBackPressed();
                        }
                    } else {
                        onBackPressed();
                    }
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                createPrint("print_bill", false, true, false);
            } else if (orderButton.key.equalsIgnoreCase("print_all")) {
                // Calling two methods one by one
                boolean kitchenCopy = true;
                String title = "Full Order";
                boolean updateOrder = false;
                if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                    if (kitchenCopy) {
                        new PrepLocationSenderAsync(title, updateOrder, () -> {
                            Thread.sleep(200);
                            createBillPrint("Full Order", false, true, false);
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                } else {
                    showToastInPostExecute(false);
                    Thread.sleep(200);
                    createBillPrint("", false, true, false);
                }
            } else if (orderButton.key.equalsIgnoreCase("cancel_order")) {
                cancelOrderAction();
            } else if (orderButton.key.equalsIgnoreCase("delete_order")) {
                deleteOrderAction();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openSendOrderDialog() {
        SendOrderDialogFragment sendOrderDialogFragment = getInstanceSendOrder(sendOrderMainSetting, sendOrderUpdateMainSetting, sendDupOrderMainSetting, sendDupOrderUpdateMainSetting);
        sendOrderDialogFragment.show(getSupportFragmentManager(), "send_order");
        sendOrderDialogFragment.setDialogDismissListener(o -> {
            if (o instanceof String) {
                printCopy((String) o);
            }
        });
    }

    private void openOrderItemDetails(OrderItem data) {
        try {
            OrderItemViewDialogFragment orderItemViewDialogFragment = getInstanceOrderItemView(data);
            orderItemViewDialogFragment.show(getSupportFragmentManager(), "show");
            orderItemViewDialogFragment.setCancelable(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OrderItemViewDialogFragment getInstanceOrderItemView(OrderItem orderItem) {
        OrderItemViewDialogFragment fragment = new OrderItemViewDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_item", new Gson().toJson(orderItem));
        fragment.setArguments(bundle);
        return fragment;
    }


    private void changeViewsVisibility(Object data) {

        try {
            if (rvOrderOptions.getVisibility() == View.VISIBLE) {
                ivOrderOptions.setRotation(0);
                handleOrderSidebarItemClick(data);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cancelOrderAction() {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Cancel order", "Are you sure you want to cancel this order?", 2, "Confirm", "Cancel");
            confirmationDialogFragment.show(getSupportFragmentManager(), "cancel_order_menu");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {

                    if (order.total_paid > 0) {
                        EnterPasswordDialogFragment enterPasswordDialogFragment = myApp.getInstanceEnterPassword(null, "Please enter password", "Please enter password to cancel this order");
                        enterPasswordDialogFragment.show(getSupportFragmentManager(), "password");
                        enterPasswordDialogFragment.setDialogDismissListener(o1 -> {
                            if (o1 instanceof String) {
                                String password = (String) o1;
                                if (password.equalsIgnoreCase(myPreferences.getLoggedInUser().password)) {
                                    order.order_status = "Order Rejected";
                                    order.order_status_id = "10";
                                    ToastUtils.showSnackBar(this, llMainLayout, "Order rejected", "reject");
                                    new UpdateOrderAsyncTask(() -> {
                                        onBackPressed();
                                        return null;
                                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                } else {
                                    ToastUtils.makeSnackToast(NewOrderActivity.this, "Incorrect password");
                                }
                            }
                        });
                    } else {
                        order.order_status = "Order Rejected";
                        order.order_status_id = "10";
                        ToastUtils.makeSnackToast(this, "Order rejected");
                        //ToastUtils.showSnackBar(this, llMainLayout, "Order rejected", "reject");
                        new UpdateOrderAsyncTask(() -> {
                            onBackPressed();
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteOrderAction() {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Delete order", "Are you sure you want to delete this order?", 2, "Confirm", "Cancel");
            confirmationDialogFragment.show(getSupportFragmentManager(), "delete_order_menu");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                    if (order.total_paid > 0) {
                        EnterPasswordDialogFragment enterPasswordDialogFragment = myApp.getInstanceEnterPassword(null, "Please enter password", "Please enter password to cancel this order");
                        enterPasswordDialogFragment.show(getSupportFragmentManager(), "password");
                        enterPasswordDialogFragment.setDialogDismissListener(o1 -> {
                            if (o1 instanceof String) {
                                String password = (String) o1;
                                if (password.equalsIgnoreCase(myPreferences.getLoggedInUser().password)) {
                                    if (myPreferences.getOrderSyncMode().equalsIgnoreCase("auto"))
                                        deleteOrder(order.id);

                                    order.order_status = "Order Deleted";
                                    order.order_status_id = "10";
                                    ToastUtils.showSnackBar(this, llMainLayout, "Order deleted", "delete");
                                    new UpdateOrderAsyncTask(() -> {
                                        onBackPressed();
                                        return null;
                                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                    //deleteOrderService();
                                } else {
                                    ToastUtils.makeSnackToast(NewOrderActivity.this, "Incorrect password");
                                }
                            }
                        });
                    } else {
                        if (myPreferences.getOrderSyncMode().equalsIgnoreCase("auto"))
                            deleteOrder(order.id);

                        order.order_status = "Order Deleted";
                        order.order_status_id = "10";
                        ToastUtils.showSnackBar(this, llMainLayout, "Order deleted", "delete");
                        new UpdateOrderAsyncTask(() -> {
                            onBackPressed();
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        //deleteOrderService();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // below method used to start service for delete order
    private void deleteOrderService() {
        Intent intent = new Intent(NewOrderActivity.this, UpdateOrderAsyncTaskServices.class);
        intent.putExtra("order", new Gson().toJson(order));
        intent.putExtra("_order_id", _order_id);
        startService(intent);
        onBackPressed();
    }

    private void deleteOrder(String orderId) {
        try {
            new Thread(() -> {
                AndroidNetworking.delete(ApiEndPoints.orders + orderId)
                        .build()
                        .getAsJSONObject(new JSONObjectRequestListener() {
                            @Override
                            public void onResponse(JSONObject response) {
                                LogUtils.e("Delete order", "response: " + response);
                            }

                            @Override
                            public void onError(ANError anError) {
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeSnackToast(NewOrderActivity.this, anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initOrderSidebar() {

        try {
            orderOptionsMenu.clear();
            if (shouldFetchDeliveryCharge && deliveryChargeTypeOption.value.equals("manual")) {
                Log.e("Type_option_size", " Applied");
                orderOptionsMenu.add(new CustomMenuItem("DELIVERY CHARGES", "deliveryChargeType"));
            }
            if (MyApp.userPermission != null && MyApp.userPermission.misc.actions.list && canEditOrder)
                orderOptionsMenu.add(new CustomMenuItem("MISC", "misc"));
            if (gratuityMainSetting != null && (gratuityMainSetting.value.equalsIgnoreCase("true") || gratuityMainSetting.value.equalsIgnoreCase("1")) && (MyApp.userPermission != null && MyApp.userPermission.gratutity.actions.list) && gratuityEnabled && canEditOrder)
                orderOptionsMenu.add(new CustomMenuItem("GRATUITY", "gratuity"));
            if (serviceChargeEnabled && !serviceChargeAutoMode && canEditOrder) {
                orderOptionsMenu.add(new CustomMenuItem("SERVICE CHARGE", "service_charge"));
            }else if(serviceChargeAutoMode && cartServiceCharge==0F){
                orderOptionsMenu.add(new CustomMenuItem("SERVICE CHARGE", "service_charge"));
            }
            if (MyApp.userPermission != null && MyApp.userPermission.customer_info.actions.list)
                orderOptionsMenu.add(new CustomMenuItem("CUSTOMER INFO", "customer_info"));
//        if (MyApp.userPermission != null && MyApp.userPermission.split_bill.actions.list && (order.total_paid == 0 || !Validators.isNullOrEmpty(order.split_type)))
//            orderOptionsMenu.add(new CustomMenuItem("SPLIT", "split"));
//        if (MyApp.userPermission != null && MyApp.userPermission.discount.actions.list && discountEnabled && !autoDiscountApplied)
//            orderOptionsMenu.add(new CustomMenuItem("DISCOUNT", "discount"));
            if (voucherPaymentsEnabled && canEditOrder)
                orderOptionsMenu.add(new CustomMenuItem("VOUCHER", "voucher"));
            if (MyApp.userPermission != null && MyApp.userPermission.convert_order.actions.list && !voucherPaymentDone && canEditOrder && myApp.isNewOrderVisible())
                orderOptionsMenu.add(new CustomMenuItem("CONVERT ORDER", "convert_order"));
            if (order.order_type_id.equalsIgnoreCase("1") && (MyApp.userPermission != null && MyApp.userPermission.swap_table.actions.list)) {
                orderOptionsMenu.add(new CustomMenuItem("SWAP TABLE", "swap_table"));
            }
            if ((MyApp.userPermission != null && MyApp.userPermission.merge_table.actions.list) && order.order_type_id.equalsIgnoreCase("1")) {
                orderOptionsMenu.add(new CustomMenuItem("MERGE TABLE", "merge_table"));
            }
            if (MyApp.userPermission != null && MyApp.userPermission.comment.actions.list)
                orderOptionsMenu.add(new CustomMenuItem("ADD INSTRUCTIONS", "add_comment"));
            if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1)
                orderOptionsMenu.add(new CustomMenuItem("COMPLETE ORDER", "complete_order"));

            if (!order.order_type_id.equalsIgnoreCase("1")) {
                orderOptionsMenu.add(new CustomMenuItem("ESTIMATE TIME", "delivery_time_selection"));
            }
            runOnUiThread(() -> {
                orderOptionMenuAdapter.notifyDataSetChanged();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initOrderBottombar() {
        try {
            orderButtons.clear();

            if (MyApp.userPermission != null && MyApp.userPermission.cancel_order.actions.list) {
                if (order.total_paid > 0 && MyApp.userPermission.cancel_order_after_payment.actions.list) {
                    btnCancelOrder.setVisibility(View.VISIBLE);
                    orderButtons.add(new OrderButton("Cancel order", "cancel_order"));
                } else if (order.total_paid == 0) {
                    btnCancelOrder.setVisibility(View.VISIBLE);
                    orderButtons.add(new OrderButton("Cancel order", "cancel_order"));
                } else {
                    btnCancelOrder.setVisibility(View.GONE);
                }
            } else {
                btnCancelOrder.setVisibility(View.GONE);
            }

            if (MyApp.userPermission != null && MyApp.userPermission.delete_order.actions.list) {
                if (order.total_paid > 0) {
                    btnDeleteOrder.setVisibility(View.VISIBLE);
                    orderButtons.add(new OrderButton("Delete order", "delete_order"));
                } else if (order.total_paid == 0) {
                    btnDeleteOrder.setVisibility(View.VISIBLE);
                    orderButtons.add(new OrderButton("Delete order", "delete_order"));
                } else {
                    btnDeleteOrder.setVisibility(View.GONE);
                }
            } else {
                btnDeleteOrder.setVisibility(View.GONE);
            }
            buttonsAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            if (order != null && order.customer != null) {
                Customer customer = order.customer;
                StringBuilder customerDetails = new StringBuilder();
                customerDetails.append(customer.name);
                if (!Validators.isNullOrEmpty(customer.mobile)) {
                    customerDetails.append("\n");
                    customerDetails.append(customer.mobile);
                }
                if (!Validators.isNullOrEmpty(customer.email)) {
                    customerDetails.append("\n");
                    customerDetails.append(customer.email);
                }
                if (order.order_type_id.equalsIgnoreCase("3")) {
                    customerDetails.append("\n");
                    StringBuilder addressBuilder = new StringBuilder();
                    if (!Validators.isNullOrEmpty(customer.house_no)) {
                        addressBuilder.append(customer.house_no);
                    }
                    if (!Validators.isNullOrEmpty(customer.street)) {
                        if (addressBuilder.toString().length() > 0) {
                            addressBuilder.append(", ");
                        }
                        addressBuilder.append(customer.street);
                    }
                    if (!Validators.isNullOrEmpty(customer.city)) {
                        if (addressBuilder.toString().length() > 0) {
                            addressBuilder.append(", ");
                        }
                        addressBuilder.append(customer.city);
                    }
                    if (!Validators.isNullOrEmpty(customer.postcode)) {
                        if (addressBuilder.toString().length() > 0) {
                            addressBuilder.append(", ");
                        }
                        addressBuilder.append(customer.postcode);
                    }
                    customerDetails.append(addressBuilder.toString());
                }
                if (customer.selectedTable != null) {
                    customerDetails.append("\n");
                    customerDetails.append("Table No: ");
                    customerDetails.append(customer.selectedTable.number);
                    customerDetails.append("\n");
                    customerDetails.append("No of guests: ");
                    customerDetails.append(customer.no_guest);
                }
                tvCustomerDetails.setText("Customer details: " + customerDetails.toString());
                initOrderBottombar();
                initOrderSidebar();
                if (!Validators.isNullOrEmpty(order.comment)) {
                    cvInstructions.setVisibility(View.VISIBLE);
                    tvInstruction.setText("Instructions: " + order.comment);
                } else {
                    cvInstructions.setVisibility(View.GONE);
                }
            } else {
                llCustomerDetails.setVisibility(View.GONE);
            }

            if (!Validators.isNullOrEmpty(order.order_type)) {
                if (order.order_type.equalsIgnoreCase("dine in")) {
                    tvCurrentScreen.setText("> " + order.order_type + " > " + order.table_number);
                } else {
                    tvCurrentScreen.setText("> " + order.order_type);
                }
            }

            if (MyApp.userPermission != null && MyApp.userPermission.order_option.actions.list) {
                ivOrderOptions.setVisibility(View.VISIBLE);
            } else {
                ivOrderOptions.setVisibility(View.GONE);
            }
            setCheckoutButtons();
            setCartValues();
            initOrderSidebarAction();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCheckoutButtons() {
        try {
            if (myApp.isConnected(this)) {
                List<String> ids = new ArrayList<>();
                ids.add("2");
                if (selectedBusiness.merchant_service) {
                    ids.add("9");
                    ids.add("10");
                }
                new Thread(() -> {
                    try {
                        ArrayList<PaymentMethod> pMethods = new ArrayList<>(appDatabase.paymentMethodDao().list(ids));
                        PaymentMethod cashPaymentMethod = appDatabase.paymentMethodDao().view("1");
                        CommonFunctions.functionThatDelay(100);
                        runOnUiThread(() -> {
                            if (MyApp.userPermission != null && MyApp.userPermission.pay_bill.actions.list && order.total > 0 && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) != 1) {
                                llCheckout.setVisibility(View.VISIBLE);
                            } else {
                                llCheckout.setVisibility(View.GONE);
                            }
                            if (!cashPaymentMethod.disabled)
                                btnCash.setVisibility(View.VISIBLE);
                            if (pMethods.size() > 0) {
                                btnCard.setVisibility(View.VISIBLE);
                            }
                        });
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            } else {
                runOnUiThread(() -> {
                    btnCash.setVisibility(View.VISIBLE);
                    btnCard.setVisibility(View.VISIBLE);
                    if (MyApp.userPermission != null && MyApp.userPermission.pay_bill.actions.list && order.total > 0 && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) != 1) {
                        llCheckout.setVisibility(View.VISIBLE);
                    } else {
                        llCheckout.setVisibility(View.GONE);
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initOrderSidebarAction() {
        try {
            orderActionMenu.clear();

            boolean showPrintButton = false;
            if (MyApp.userPermission != null && (MyApp.userPermission.print_all.actions.list || MyApp.userPermission.print_bill.actions.list)) {
                if (printBillMainSetting == null && printAllMainSetting == null) {
                    showPrintButton = false;
                } else
                    showPrintButton = (printBillMainSetting == null || (!printBillMainSetting.value.equalsIgnoreCase("false") && !printBillMainSetting.value.equalsIgnoreCase("0"))) || (printAllMainSetting == null || (!printAllMainSetting.value.equalsIgnoreCase("false") && !printAllMainSetting.value.equalsIgnoreCase("0")));
            }
            if (MyApp.userPermission != null && MyApp.userPermission.send_order.actions.list && showSendOrderButton())
                orderActionMenu.add(new CustomMenuItem("Send", "send_order", R.drawable.ic_send));

            if (showPrintButton)
                orderActionMenu.add(new CustomMenuItem("Print", "print_order", R.drawable.ic_baseline_print_24));

            if (MyApp.userPermission != null && MyApp.userPermission.discount.actions.list && discountEnabled && !autoDiscountApplied && canEditOrder && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) != 0) // Dont add discount if partial payment is done
                orderActionMenu.add(new CustomMenuItem("Disc", "discount", R.drawable.icon_percentage));

            if (MyApp.userPermission != null && MyApp.userPermission.split_bill.actions.list && (order.total_paid == 0 || !Validators.isNullOrEmpty(order.split_type)) && canEditOrder && order.discount == 0 && order.service_charge == 0 && order.gratuity == 0 && order.delivery_charge == 0)
                orderActionMenu.add(new CustomMenuItem("Split", "split", R.drawable.icon_split));
            if (orderActionMenu.size() > 0)
                rvOrderAction.setLayoutManager(new GridLayoutManager(this, orderActionMenu.size()));
            else rvOrderAction.setLayoutManager(new GridLayoutManager(this, 1));
            orderActionMenuAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void paymentCash() {
        isBackPressed = true;

        PaymentMethod cashMethod = new PaymentMethod();
        cashMethod.id = "1";
        cashMethod.name = "Cash";

        if (!Validators.isNullOrEmpty(order.split_type) && shouldOpenSplitScreen) {
            startActivityForResult(new Intent(NewOrderActivity.this, SplitActivity.class).putExtra("display_order_id", order.display_order_id).putExtra("payment_method", new Gson().toJson(cashMethod)).putExtra("_order_id", order._id).putExtra("order_id", order.id), Constants.CODE_REFRESH);
        } else {
            Intent intent = new Intent(NewOrderActivity.this, OrderReviewActivity.class);
            intent.putExtra("order_id", order.id)
                    .putExtra("unique_id", order.unique_id)
                    .putExtra("_order_id", order._id)
                    .putExtra("order_total", order.total)
                    .putExtra("paid_amount", order.total_paid)
                    .putExtra("cart_service_charge", cartServiceCharge)
                    .putExtra("cart_discount", cartDiscount)
                    .putExtra("cart_gratuity", cartGratuity)
                    .putExtra("cart_grand_total", cartGrandTotal)
                    .putExtra("display_order_id", order.display_order_id)
                    .putExtra("payment_method", new Gson().toJson(cashMethod));
            if (selectedSplit != null) {
                intent.putExtra("_order_split_id", selectedSplit._id);
            }
            startActivityForResult(intent, Constants.CODE_REFRESH);
        }
    }

    private void setListeners() {
        try {
            btnCancelOrder.setOnClickListener(view -> {
                cancelOrderAction();
            });

            btnDeleteOrder.setOnClickListener(v -> {
                deleteOrderAction();
            });

            llDelete.setOnClickListener(v -> {
                swipeLayout.close(true);
                order.comment = null;
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline(false);
                    ToastUtils.showSnackBar(this, llMainLayout, "Instruction has been removed", "remove");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });

            tvDiscountText.setOnClickListener(v -> {
                if (!canEditOrder) return;
                cartDiscount = 0;
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline(false);
                    ToastUtils.showSnackBar(this, llMainLayout, "Discount has been removed", "remove");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });
            tvVoucherText.setOnClickListener(v -> {
                new FetchOrderOfflineAsyncTask(() -> {
                    updateViews();
                    //afterPaymentPrintOptions();
                    return null;
                }, true).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });
            tvServiceChargeText.setOnClickListener(v -> {
                if (!canEditOrder)
                    return;

            /*    if (Links.service_charges_mode == 0) {
                    Links.service_charges = false;
                    serviceChargeEnabled = false;
                }*/

                cartServiceCharge = 0;
                order.is_auto_service_charge_remove = true;
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline(false);
                    ToastUtils.showSnackBar(this, llMainLayout, "Service charge has been removed", "remove");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });

            tvGratuityText.setOnClickListener(v -> {
                cartGratuity = 0;
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline(false);
                    ToastUtils.showSnackBar(this, llMainLayout, "Gratuity has been removed", "remove");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });

            tvDeliveryText.setOnClickListener(v -> {
                deliveryCharge = 0;
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline(false);
                    ToastUtils.showSnackBar(this, llMainLayout, "Delivery Charges has been removed", "remove");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });

            chipBack.setOnClickListener(v -> onBackPressed());

            etSearch.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    if (etSearch.getText().toString().isEmpty()) {
                        imgSearch.setImageResource(R.drawable.ic_baseline_search_24);
                    } else {
                        imgSearch.setImageResource(R.drawable.ic_baseline_close_24);
                    }
                    if (searchListerner != null) {
                        searchListerner.onDialogDismiss(etSearch.getText().toString());
                    }
                    LocalBroadcastManager.getInstance(NewOrderActivity.this).sendBroadcast(new Intent("search_category").putExtra("searched_item", etSearch.getText().toString()));
                }
            });
            imgSearch.setOnClickListener(view -> {
                if (!etSearch.getText().toString().isEmpty()) {
                    etSearch.setText("");
                }
            });

            etSearch.setOnKeyListener((textView, i, keyEvent) -> {
                if (keyEvent.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                    onBackPressed();
                } else if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {

                    if (searchListerner != null) {
                        searchListerner.onDialogDismiss(etSearch.getText().toString());
                    }
                    LocalBroadcastManager.getInstance(NewOrderActivity.this).sendBroadcast(new Intent("search_category").putExtra("searched_item", etSearch.getText().toString()));
                    CommonFunctions.hideKeyboard(this, etSearch);
                }
                return false;
            });

            tvEditQty.setOnClickListener(v -> {
                /*if (orderItems!=null&&orderItems.size()>0) {
                    for (int i = 0; i < orderItems.size(); i++) {
                        orderItems.get(i).shouldEdit=true;
                    }
                    objects.clear();
                    objects.addAll(orderItems);
                    orderItemsAdapter.notifyDataSetChanged();
                   // orderItemsAdapter.shouldEdit = true;
                }*/
                updateEditOrderItems(true);
                tvDone.setVisibility(View.VISIBLE);
                tvEditQty.setVisibility(View.INVISIBLE);
                tvSwipeToRemove.setVisibility(View.GONE);
            });

            tvDone.setOnClickListener(v -> {
               /* if (orderItems!=null&&orderItems.size()>0) {
                    for (int i = 0; i < orderItems.size(); i++) {
                        orderItems.get(i).shouldEdit=false;
                    }
                    objects.clear();
                    objects.addAll(orderItems);
                    orderItemsAdapter.notifyDataSetChanged();
                    // orderItemsAdapter.shouldEdit = false;
                }
                orderItemsAdapter.notifyDataSetChanged();*/
                updateEditOrderItems(false);
                tvDone.setVisibility(View.GONE);
                tvEditQty.setVisibility(View.VISIBLE);
                tvSwipeToRemove.setVisibility(View.VISIBLE);
            });
            btnCheckout.setOnClickListener(v -> {
                isBackPressed = true;
                if (!Validators.isNullOrEmpty(order.split_type) && shouldOpenSplitScreen) {
                    startActivityForResult(new Intent(NewOrderActivity.this, SplitActivity.class).putExtra("display_order_id", order.display_order_id).putExtra("_order_id", order._id).putExtra("order_id", order.id), Constants.CODE_REFRESH);
                } else {
                    Intent intent = new Intent(NewOrderActivity.this, OrderReviewActivity.class);
                    intent.putExtra("order_id", order.id)
                            .putExtra("unique_id", order.unique_id)
                            .putExtra("_order_id", order._id)
                            .putExtra("order_total", order.total)
                            .putExtra("paid_amount", order.total_paid)
                            .putExtra("cart_service_charge", cartServiceCharge)
                            .putExtra("cart_discount", cartDiscount)
                            .putExtra("display_order_id", order.display_order_id)
                            .putExtra("cart_gratuity", cartGratuity)
                            .putExtra("cart_grand_total", cartGrandTotal);
                    if (selectedSplit != null) {
                        intent.putExtra("_order_split_id", selectedSplit._id);
                    }
                    startActivityForResult(intent, Constants.CODE_REFRESH);
                }
            });
            btnCard.setOnClickListener(v -> {
                if (!order.order_type_id.equalsIgnoreCase("1") && !order.is_delivery_collection_ask && auto_delivery_time_slot != null && (auto_delivery_time_slot.value.equalsIgnoreCase("true") || auto_delivery_time_slot.value.equalsIgnoreCase("1"))) {
                    openTimeSelection(o -> {
                        isBackPressed = true;
                        //turnOnOffDeviceBluetooth();
                        askForPermission();
                    });
                } else {
                    isBackPressed = true;
                    //turnOnOffDeviceBluetooth();
                    askForPermission();
                }
            });
            btnCash.setOnClickListener(v -> {
                if (!order.order_type_id.equalsIgnoreCase("1") && !order.is_delivery_collection_ask && auto_delivery_time_slot != null && (auto_delivery_time_slot.value.equalsIgnoreCase("true") || auto_delivery_time_slot.value.equalsIgnoreCase("1"))) {
                    openTimeSelection(o -> paymentCash());
                } else {
                    paymentCash();
                }
            });
            calllogViewModel.getCallLogs().observe(this, item -> {
                callLogs = item;
                cvCallerId.setVisibility(View.VISIBLE);
                if (callLogs.customer != null) {
                    Customer customer = callLogs.customer;
                    if (!Validators.isNullOrEmpty(customer.name)) {
                        tvCallerName.setText(customer.name);
                    } else {
                        tvCallerName.setText("");
                    }
                    StringBuilder sb = new StringBuilder();
                    if (!Validators.isNullOrEmpty(customer.house_no)) {
                        sb.append(customer.house_no).append(", ");
                    }
                    if (!Validators.isNullOrEmpty(customer.street)) {
                        sb.append(customer.street).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.postcode)) {
                        sb.append(customer.postcode).append("\n");
                    }

                    if (!Validators.isNullOrEmpty(customer.city)) {
                        sb.append(customer.city).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.state)) {
                        sb.append(customer.state).append("\n");
                    }
                    if (!Validators.isNullOrEmpty(customer.distance)) {
                        sb.append(customer.distance).append(" Miles away");
                    }

                    if (!Validators.isNullOrEmpty(sb.toString())) {
                        tvCalleAddress.setText(sb.toString());
                    } else {
                        tvCalleAddress.setText("");
                    }

                } else {
                    tvCallerName.setText("");
                    tvCalleAddress.setText("");
                }
                tvCallerNumber.setText(callLogs.number);
            });
            llCallerId.setOnTouchListener(new OnSwipeTouchListener(NewOrderActivity.this) {
                @Override
                public void onSwipeLeft() {
                    super.onSwipeLeft();
                    changeStatusCallerid("parked");
                }

                @Override
                public void onSwipeRight() {
                    super.onSwipeRight();
                    changeStatusCallerid("parked");
                }

                @Override
                public void onSwipeBottom() {
                    super.onSwipeBottom();
                    changeStatusCallerid("parked");
                }

                @Override
                public void onSwipeTop() {
                    super.onSwipeTop();
                    changeStatusCallerid("parked");
                }

            });

            imgAccept.setOnClickListener(v -> changeStatusCallerid("accepted"));
            imgCancel.setOnClickListener(v -> changeStatusCallerid("rejected"));
            imgHold.setOnClickListener(v -> changeStatusCallerid("parked"));


            ivOrderOptions.setOnClickListener(view -> {
                if (rvOrderItems.getVisibility() == View.VISIBLE) {
                    rvOrderItems.setVisibility(View.GONE);
                    tvEditQty.setVisibility(View.GONE);
                    tvSwipeToRemove.setVisibility(View.GONE);
                    llOrderOptions.setVisibility(View.VISIBLE);
                    cvInstructions.setVisibility(View.GONE);
                    tvDone.setVisibility(View.GONE);
                    ivOrderOptions.setRotation(180);
                    // editable false when order items list is not visible
                    updateEditOrderItems(false);
                } else {
                    if (llOrderOptions.getVisibility() == View.VISIBLE) {
                        llOrderOptions.setVisibility(View.GONE);
                        rvOrderItems.setVisibility(View.VISIBLE);
                        tvEditQty.setVisibility(View.VISIBLE);
                       /* if (orderItems!=null&&orderItems.size()>0) {
                            for (int i = 0; i < orderItems.size(); i++) {
                                orderItems.get(i).shouldEdit=false;
                            }
                            objects.clear();
                            objects.addAll(orderItems);
                            orderItemsAdapter.notifyDataSetChanged();
                            // orderItemsAdapter.shouldEdit = false;
                        }
                        orderItemsAdapter.notifyDataSetChanged();*/
                        // editable true when order items list is not visible
                        updateEditOrderItems(!(!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")));
                        tvSwipeToRemove.setVisibility(View.VISIBLE);
                        if (!Validators.isNullOrEmpty(order.comment)) {
                            cvInstructions.setVisibility(View.VISIBLE);
                        }
                        ivOrderOptions.setRotation(0);
                    }
                }
            });

            ivRetriveOrder.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    AppExecutors.getInstance().diskIO().execute(new Runnable() {
                        @Override
                        public void run() {
                            int i = myApp.appDatabase.orderDao().orderWithItems(_order_id).orderItems.size();
                            Log.e("Db", "" + i);
                        }
                    });


                    new FetchOrderOfflineAsyncTask(() -> {
                        rvOrderItems.post(() -> orderItemsAdapter.notifyDataSetChanged());
                        return null;
                    }, false).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                }
            });


            llGrandTotal.setOnClickListener(view -> {
                if (llExpand.getVisibility() == View.VISIBLE) {
                    ivExpand.setRotation(90);
                    llExpand.setVisibility(View.GONE);
                } else {
                    ivExpand.setRotation(270);
                    llExpand.setVisibility(View.VISIBLE);
                }

            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void turnOnOffDeviceBluetooth() {
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            new Handler(Objects.requireNonNull(Looper.myLooper()))
                    .postDelayed(() -> {
                        if (!bluetoothAdapter.isEnabled()) {
                            bluetoothAdapter.enable();
                        }
                    }, 1000);
            redirectToPayCard();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // below is used to navigate on pay card screen
    private void redirectToPayCard() {
        PaymentMethod cardMethod = new PaymentMethod();
        cardMethod.id = "cc";
        cardMethod.name = "Card";
        if (!Validators.isNullOrEmpty(order.split_type) && shouldOpenSplitScreen) {
            startActivityForResult(new Intent(NewOrderActivity.this, SplitActivity.class).putExtra("display_order_id", order.display_order_id).putExtra("payment_method", new Gson().toJson(cardMethod)).putExtra("_order_id", order._id).putExtra("order_id", order.id), Constants.CODE_REFRESH);
        } else {
            isBackPressed = true;
            Intent intent = new Intent(NewOrderActivity.this, OrderReviewActivity.class);
            intent.putExtra("order_id", order.id)
                    .putExtra("unique_id", order.unique_id)
                    .putExtra("_order_id", order._id)
                    .putExtra("order_total", order.total)
                    .putExtra("paid_amount", order.total_paid)
                    .putExtra("cart_service_charge", cartServiceCharge)
                    .putExtra("cart_discount", cartDiscount)
                    .putExtra("cart_gratuity", cartGratuity)
                    .putExtra("cart_grand_total", cartGrandTotal)
                    .putExtra("display_order_id", order.display_order_id)
                    .putExtra("payment_method", new Gson().toJson(cardMethod));
            if (selectedSplit != null) {
                intent.putExtra("_order_split_id", selectedSplit._id);
            }
            startActivityForResult(intent, Constants.CODE_REFRESH);
        }
    }

    private void askForPermission() {
        try {
            final int locationPermission = ActivityCompat.checkSelfPermission(NewOrderActivity.this, Manifest.permission.ACCESS_FINE_LOCATION);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                final int scanPermission = ActivityCompat.checkSelfPermission(NewOrderActivity.this, Manifest.permission.BLUETOOTH_SCAN);
                final int connectPermission = ActivityCompat.checkSelfPermission(NewOrderActivity.this, Manifest.permission.BLUETOOTH_CONNECT);
                if (locationPermission == PackageManager.PERMISSION_GRANTED && scanPermission == PackageManager.PERMISSION_GRANTED && connectPermission == PackageManager.PERMISSION_GRANTED) {
                    turnOnOffDeviceBluetooth();
                } else {
                    // If we don't have them yet, request them before doing anything else
                    final String[] permissions = {Manifest.permission.BLUETOOTH_CONNECT, Manifest.permission.BLUETOOTH_SCAN, Manifest.permission.BLUETOOTH_ADMIN};
                    requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
                }
            } else {
                turnOnOffDeviceBluetooth();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Receive the result of our permissions check, and initialize if we can
     */
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        // If we receive a response to our permission check, initialize
        if (requestCode == Constants.PERMISSION_CODE_LOCATION && (ContextCompat.checkSelfPermission(this, Manifest.permission.BLUETOOTH_CONNECT) == PackageManager.PERMISSION_GRANTED)
                && (ContextCompat.checkSelfPermission(this, Manifest.permission.BLUETOOTH_SCAN) == PackageManager.PERMISSION_GRANTED) &&
                (ContextCompat.checkSelfPermission(this, Manifest.permission.BLUETOOTH_ADMIN) == PackageManager.PERMISSION_GRANTED)) {
            turnOnOffDeviceBluetooth();
        } else {
            redirectToPayCard();
        }
    }

    private void handleOrderSidebarItemClick(Object data) {
        try {
            CustomMenuItem customMenuItem = (CustomMenuItem) data;

            if (customMenuItem.key.equalsIgnoreCase("discount")) {
                if (!canEditOrder) return;
                llSearch.setVisibility(View.INVISIBLE);
                DiscountDialogFragment discountFragment = getInstanceDiscountDialog(order._id, "Discount");
                changeFragment(discountFragment, true);
                discountFragment.setDialogDismissListener(o -> {
                    if (!isValidToPlaceOrder()) return;

                    if (o instanceof Float) {
                        cartDiscount = (float) o;
                        new UpdateOrderAsyncTask(() -> {
                            try {
                                fetchOffline(false);
                                ToastUtils.showSnackBar(this, llMainLayout, "Discount has been added", "success");
                                if (displayDiscount != null && !Validators.isNullOrEmpty(displayDiscount.value) && displayDiscount.value.equalsIgnoreCase("yes")) {
                                    runOnUiThread(() -> {
                                        // Expand view for discount text
                                        ivExpand.setRotation(270);
                                        llExpand.setVisibility(View.VISIBLE);
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                });
            } else if (customMenuItem.key.equalsIgnoreCase("add_comment")) {
                //llSearch.setVisibility(View.INVISIBLE);
                AddCommentFragment addCommentFragment = getInstanceAddComment(order.comment);
                addCommentFragment.show(getSupportFragmentManager(), "addComment");
                //changeFragment(addCommentFragment, true);
                addCommentFragment.setDialogDismissListener(o -> {
                    if (!isValidToPlaceOrder()) return;
                    order.comment = (String) o;
                    new UpdateOrderAsyncTask(() -> {
                        fetchOffline(false);
                        if (!Validators.isNullOrEmpty(order.comment))
                            ToastUtils.showSnackBar(this, llMainLayout, "Instructions has been added", "success");
                        else
                            ToastUtils.showSnackBar(this, llMainLayout, "Instructions has been removed", "remove");

                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                });
            } else if (customMenuItem.key.equalsIgnoreCase("customer_info")) {
                if (order.order_type_id.equalsIgnoreCase("1")) {
                    if (Validators.isNullOrEmpty(order.no_guest)) {
                        order.customer.no_guest = 0;
                    } else {
                        order.customer.no_guest = Integer.parseInt(order.no_guest);
                    }
                    Table table = new Table();
                    table.id = order.table_id;
                    table.number = order.table_number;
                    order.customer.selectedTable = table;
                }
                CustomerInfoDialogFragment newOrderDialogFragment = getInstanceCustomerInfoDialog(order.customer, order.order_type_id);
                newOrderDialogFragment.show(getSupportFragmentManager(), "customer_info");
                newOrderDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof Customer) {
                        new UpdateCustomerAsynTask(() -> {
                            Log.e("CustomerInfo", "customer_info");
                            if(shouldFetchDeliveryCharge){
                                fetchDeliveryCharge(() -> {
                                    fetchOffline(true);
                                    return null;
                                });
                            }else{
                                fetchOffline(true);
                            }
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Customer) o);
                    }
                });
            } else if (customMenuItem.key.equalsIgnoreCase("cancel_order")) {
                CancelOrderDialogFragment cancelOrderDialogFragment = new CancelOrderDialogFragment();
                cancelOrderDialogFragment.show(getSupportFragmentManager(), "cancel_order_menu");
            } else if (customMenuItem.key.equalsIgnoreCase("gratuity")) {
                if (!canEditOrder) return;
                llSearch.setVisibility(View.INVISIBLE);
                DiscountDialogFragment gratuityFragment = getInstanceDiscountDialog(order._id, "Gratuity");
                changeFragment(gratuityFragment, true);
                gratuityFragment.setDialogDismissListener(o -> {
                    if (!isValidToPlaceOrder()) return;
                    if (o instanceof Float) {
                        cartGratuity = (float) o;
                        new UpdateOrderAsyncTask(() -> {
                            try {
                                fetchOffline(false);
                                ToastUtils.showSnackBar(this, llMainLayout, "Gratuity has been added", "success");
                                runOnUiThread(() -> {
                                    // Expand view for Gratuity text
                                    ivExpand.setRotation(270);
                                    llExpand.setVisibility(View.VISIBLE);
                                });
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                });

            } else if (customMenuItem.key.equalsIgnoreCase("voucher")) {
                if (!canEditOrder) return;
                llSearch.setVisibility(View.INVISIBLE);
                PaymentViaVoucherFragment viaVoucherFragment = getInstancePaymentViaVoucher(order);
                changeFragment(viaVoucherFragment, true);
                viaVoucherFragment.setDialogDismissListener(o -> {

                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            ToastUtils.showSnackBar(this, llMainLayout, "Voucher has been applied", "success");
                            new FetchOrderOfflineAsyncTask(() -> {
                                updateViews();
                                afterPaymentPrintOptions();
                                return null;
                            }, false).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        }
                    }
                });

            } else if (customMenuItem.key.equalsIgnoreCase("service_charge")) {
                if (!canEditOrder)
                    return;
                llSearch.setVisibility(View.INVISIBLE);
                DiscountDialogFragment serviceChargeFragment = getInstanceDiscountDialog(order._id, "Service Charge");
                changeFragment(serviceChargeFragment, true);
                serviceChargeFragment.setDialogDismissListener(o -> {
                    if (!isValidToPlaceOrder()) return;
                    if (o instanceof Float) {
                        cartServiceCharge = (float) o;
                        new UpdateOrderAsyncTask(() -> {
                            try {
                                fetchOffline(false);
                                ToastUtils.showSnackBar(this, llMainLayout, "Service charge has been added", "success");
                                runOnUiThread(() -> {
                                    // Expand view for service charge text
                                    ivExpand.setRotation(270);
                                    llExpand.setVisibility(View.VISIBLE);
                                });
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                });

            } else if (customMenuItem.key.equalsIgnoreCase("misc")) {
                if (!canEditOrder) return;
                llSearch.setVisibility(View.INVISIBLE);
                MiscItemFragment miscItemFragment = new MiscItemFragment();
                changeFragment(miscItemFragment, true);
                miscItemFragment.setDialogDismissListener(o -> {
                    if (o instanceof OrderItem) {
                        LogUtils.e("ORDER::", "Misc Received");
                        LogUtils.e(o);
                        myApp.notifyCart(this, new Intent(Constants.EPOS_CART_UPDATE).putExtra("order_item", new Gson().toJson(o)));
                    }
                });
            } else if (customMenuItem.key.equalsIgnoreCase("swap_table") || customMenuItem.key.equalsIgnoreCase("merge_table")) {
                if (!canEditOrder) return;
                AssignTableDialogFragment assignTableDialogFragment = getInstanceAssignTableDialog(customMenuItem.key.equalsIgnoreCase("merge_table") ? "Merge Table" : "Swap Table", !customMenuItem.key.equalsIgnoreCase("merge_table"), order.table_id, customMenuItem.key.equalsIgnoreCase("merge_table"));
                assignTableDialogFragment.show(getSupportFragmentManager(), "assign_table");
                assignTableDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof Pair) {
                        runOnUiThread(() -> {
                            progressBarDialog.show();
                        });
                        Pair pair = (Pair) o;
                        new MergeTableOrder((Table) pair.first, () -> {
                            runOnUiThread(() -> {
                                progressBarDialog.hide();
                                onBackPressed();
                            });
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    } else if (o instanceof Table) {
                        freeOldTable(order.table_id);
                        Table swappedTable = (Table) o;
                        order.table_number = swappedTable.number;
                        order.table_id = swappedTable.id;
                        order.is_table_swap = true;
                        new UpdateOrderAsyncTask(() -> {
                            fetchOffline(false);
                            lockTable(order, null, true);
                            changeTableStatus(order, orderTakenStatus.id, "Order Taken");
                            callChangeTableStatus = false;
                            onBackPressed();
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                });
            } else if (customMenuItem.key.equalsIgnoreCase("split")) {
                isBackPressed = true;
                startActivityForResult(new Intent(NewOrderActivity.this, SplitActivity.class).putExtra("display_order_id", order.display_order_id).putExtra("_order_id", order._id).putExtra("order_id", order.id), Constants.CODE_REFRESH);
            } else if (customMenuItem.key.equalsIgnoreCase("convert_order")) {
                if (!canEditOrder) return;
                ConvertOrderTypeFragment convertOrderTypeFragment = getInstanceConvertOrderType(order.order_type_id);
                changeFragment(convertOrderTypeFragment, true);
                convertOrderTypeFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {

                        String orderTypeId = (String) o;
                        if (!orderTypeId.equalsIgnoreCase(order.order_type_id)) {
                            order.delivery_charge = 0;

                            if (order.order_type_id.equalsIgnoreCase("1")) {
                                changeTableStatusToFree(order.table_id);
                                order.order_type_id = orderTypeId;
                            }
                            if (orderTypeId.equalsIgnoreCase("1")) {
                                AssignTableDialogFragment assignTableDialogFragment = getInstanceAssignTableDialog("Select Table", true, order.table_id, false);
                                assignTableDialogFragment.show(getSupportFragmentManager(), "assign_table");
                                assignTableDialogFragment.setDialogDismissListener(t -> {
                                    if (t instanceof Table) {
                                        Table swappedTable = (Table) t;
                                        order.table_id = swappedTable.id;
                                        order.no_guest = "1";
                                        order.order_type_id = orderTypeId;
                                        // change order type to dine in
                                        order.order_type = "Dine in";
                                        lockTable(order, swappedTable, true);
                                        new UpdateOrderAsyncTask(() -> {
                                            changeTableStatus(order, takingOrderStatus.id, "Taking Order");
                                            callChangeTableStatus = false;
                                            onBackPressed();
                                            return null;
                                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                    }
                                });
                            } else if (orderTypeId.equalsIgnoreCase("3")) {
                                CustomerInfoDialogFragment newOrderDialogFragment = getInstanceCustomerInfoDialog(order.customer, "3");
                                newOrderDialogFragment.show(getSupportFragmentManager(), "customer_info");
                                newOrderDialogFragment.setDialogDismissListener(c -> {
                                    if (c instanceof Customer) {
                                        order.order_type_id = orderTypeId;
                                        order.table_number = "";
                                        // change order type to delivery
                                        order.order_type = "Delivery";
                                        new UpdateCustomerAsynTask(() -> {
                                            Log.e(" CustomerInfo", "3");
                                            onBackPressed();
                                            return null;
                                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Customer) c);
                                    }
                                });
                            } else {
                                order.order_type_id = orderTypeId;
                                // change order type
                                if (order.order_type_id.equalsIgnoreCase("2")) {
                                    order.order_type = "Collection";
                                }
                                if (order.order_type_id.equalsIgnoreCase("4")) {
                                    order.order_type = "Bar";
                                }
                                if (order.order_type_id.equalsIgnoreCase("5")) {
                                    order.order_type = "Waiting";
                                }
                                order.table_number = "";
                                new UpdateOrderAsyncTask(() -> {
                                    onBackPressed();
                                    return null;
                                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                            }

                        }
                    }
                });
            } else if (customMenuItem.key.equalsIgnoreCase("complete_order")) {
                order.order_status_id = "5";
                order.order_status = "Order Completed";
                new UpdateOrderAsyncTask(() -> {
                    onBackPressed();
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            } else if (customMenuItem.key.equalsIgnoreCase("deliveryChargeType")) {
                Log.e("deliveryChargeType", " " + customMenuItem.title);

                if (!canEditOrder)
                    return;

                llSearch.setVisibility(View.INVISIBLE);
                DiscountDialogFragment gratuityFragment = getInstanceDiscountDialog(order._id, "deliveryChargeType");
                changeFragment(gratuityFragment, true);
                gratuityFragment.setDialogDismissListener(o -> {
                    if (!isValidToPlaceOrder()) return;
                    if (o instanceof Float) {
                        deliveryCharge = (float) o;
                        Log.e("deliveryCharge", " " + deliveryCharge);
                        new UpdateOrderAsyncTask(() -> {
                            fetchOffline(false);
                            ToastUtils.showSnackBar(this, llMainLayout, "Delivery Charge has been added", "success");
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                });
            } else if (customMenuItem.key.equalsIgnoreCase("delivery_time_selection")) {
                openTimeSelection(null);
            }
            ivOrderOptions.performClick();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }

    }

    private void openTimeSelection(DialogDismissListener dialogDismissListener) {
        TimeSelectionDeliveryDialog timeSelectionDeliveryDialog = new TimeSelectionDeliveryDialog(order.delivery_collection_time_slot);
        timeSelectionDeliveryDialog.setDialogDismissListener(o -> {
            if (o instanceof String) {
                new Thread(() -> {
                    if (!Validators.isNullOrEmpty((String) o)) {
                        order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                        order.delivery_collection_time_slot = String.valueOf(o);
                        order.is_delivery_collection_ask = true;
                        appDatabase.orderDao().update(order);
                    }
                    if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss(null);
                    }
                }).start();
            }
        });
        timeSelectionDeliveryDialog.show(getSupportFragmentManager(), "delivery_time_selection");
    }

    public CustomerInfoDialogFragment getInstanceCustomerInfoDialog(Customer customer, String orderTypeId) {
        CustomerInfoDialogFragment fragment = new CustomerInfoDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("customer", new Gson().toJson(customer));
        bundle.putString("order_type_id", orderTypeId);
        fragment.setArguments(bundle);
        return fragment;
    }

    public ConvertOrderTypeFragment getInstanceConvertOrderType(String orderType) {
        ConvertOrderTypeFragment fragment = new ConvertOrderTypeFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_type_id", orderType);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void freeOldTable(String oldTableId) {
        LogUtils.e("TABLE::Freeing old table start");
        try {
            new Thread(() -> {
                Table table = appDatabase.tableDao().view(oldTableId);
                table.locked = false;
                table.table_status_id = vacantStatus.id;
                table.status = vacantStatus.status;
                table.last_order_id = null;
                table._last_order_id = 0;
                table.last_order_created_at = null;
                table.updater_id = myPreferences.getLoggedInUser().id;
                appDatabase.tableDao().insert(table);
                // check and change merged table status as vacant
                changeMergedTableStatus(table.id);
                if ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()) && myApp.isConnected(NewOrderActivity.this)) {
                    AndroidNetworking.post(ApiEndPoints.tables + table.id)
                            .addApplicationJsonBody(table)
                            .build()
                            .getAsObject(Table.class, new ParsedRequestListener() {
                                @Override
                                public void onResponse(Object response) {
                                    LogUtils.e("TABLE FREEING STATUS CHANGED BEFORE RESPONSE:" + new Gson().toJson(table));
                                }

                                @Override
                                public void onError(ANError anError) {
                                    if (anError.getErrorCode() == 400) {
                                        LogUtils.e("TABLE FREEING OLD TABLE ERROR IN TABLE STATUS CHANGE: ", anError.getErrorAsObject(ApiError.class).getMessage());
                                    }
                                }
                            });
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeTableStatusToFree(String table_id) {
        try {
            if (!order.order_type_id.equals("1")) {
                return;
            }
            LogUtils.e("TABLE order status while changing: " + order.order_status);
            new Thread(() -> {
                Table table = appDatabase.tableDao().view(table_id);
                if (table == null) return;
                table.table_status = appDatabase.tableStatusDao().view(table.table_status_id);
                if (table.table_status != null)
                    table.status = table.table_status.status;
                else table.status = "";
                table.status = vacantStatus.status;
                table.table_status_id = vacantStatus.id;
                table.last_order_id = null;
                table._last_order_id = 0;
                table.last_order_created_at = null;
                table.locked = false;
                table.updater_id = myPreferences.getLoggedInUser().id;
                LogUtils.e("Table Updating ?:" + " number:" + table.number + " & ID:" + table.id + " & status:" + table.status + " &statusId:" + table.table_status_id);
                appDatabase.tableDao().insert(table);
                // check and change merged table status as vacant
                changeMergedTableStatus(table.id);
                if ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()) && myApp.isConnected(NewOrderActivity.this)) {
                    AndroidNetworking.post(ApiEndPoints.tables + table.id)
                            .addApplicationJsonBody(table)
                            .build()
                            .getAsObject(Table.class, new ParsedRequestListener() {
                                @Override
                                public void onResponse(Object response) {
                                    LogUtils.e("TABLE STATUS CHANGED RESPONSE RECEIVED");
                                }

                                @Override
                                public void onError(ANError anError) {
                                    if (anError.getErrorCode() == 400) {
                                        LogUtils.e("ERROR IN TABLE STATUS CHANGE: ", anError.getErrorAsObject(ApiError.class).getMessage());
                                    }
                                }
                            });
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeTableStatus(Order order, String table_status_id, String status) {
        try {
            if (!order.order_type_id.equals("1")) {
                return;
            }
            LogUtils.e("TABLE order status while changing: " + order.order_status);
            new Thread(() -> {
                Table table = appDatabase.tableDao().view(order.table_id);
                if (table == null) return;
                table.table_status = appDatabase.tableStatusDao().view(table.table_status_id);
                if (table.table_status != null)
                    table.status = table.table_status.status;
                else table.status = "";

                String oldStatus = table.status;
                if (order.total > 0) {
                    if (order.total_paid > 0) {
                        if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                            if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                                table.status = servedPaidStatus.status;
                                table.table_status_id = servedPaidStatus.id;
                            } else if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 0) {
                                table.table_status_id = orderTakenStatus.id;
                                table.status = orderTakenStatus.status;
                            }
                        } else {
                            table.status = vacantStatus.status;
                            table.table_status_id = vacantStatus.id;
                            table.locked = false;
                            // check and change merged table status as vacant
                            changeMergedTableStatus(table.id);
                        }
                    } else {
                        if (!order.order_status_id.equalsIgnoreCase("5") &&
                                !order.order_status_id.equalsIgnoreCase("10")) {
                            if (order.order_status_id.equalsIgnoreCase("3")) {
                                table.status = servedStatus.status;
                                table.table_status_id = servedStatus.id;
                            } else {
                                if (Validators.isNullOrEmpty(order.order_action_id)) {
                                    LogUtils.e("In Taking order");
                                    table.table_status_id = takingOrderStatus.id;
                                    table.status = takingOrderStatus.status;
                                } else {
                                    LogUtils.e("In Order taken");
                                    table.table_status_id = orderTakenStatus.id;
                                    table.status = orderTakenStatus.status;
                                }
                            }
                        } else {
                            table.status = vacantStatus.status;
                            table.table_status_id = vacantStatus.id;
                            table.locked = false;
                            // check and change merged table status as vacant
                            changeMergedTableStatus(table.id);
                        }
                        if (myApp.isPaymentLinkSent) {
                            table.table_status_id = orderTakenStatus.id;
                            table.status = orderTakenStatus.status;
                        }
                    }
                } else {
                    if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                        table.status = takingOrderStatus.status;
                        table.table_status_id = takingOrderStatus.id;
                    } else {
                        table.status = vacantStatus.status;
                        table.table_status_id = vacantStatus.id;
                        table.locked = false;
                        // check and change merged table status as vacant
                        changeMergedTableStatus(table.id);
                    }
                    if (myApp.isPaymentLinkSent) {
                        table.table_status_id = orderTakenStatus.id;
                        table.status = orderTakenStatus.status;
                    }
                }
                table.updater_id = myPreferences.getLoggedInUser().id;
                LogUtils.e("Table Updating ?:" + " number:" + table.number + " & ID:" + table.id + " & status:" + table.status + " &statusId:" + table.table_status_id);
                appDatabase.tableDao().insert(table);
                if ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()) && myApp.isConnected(NewOrderActivity.this)) {
                    AndroidNetworking.post(ApiEndPoints.tables + table.id)
                            .addApplicationJsonBody(table)
                            .build()
                            .getAsObject(Table.class, new ParsedRequestListener() {
                                @Override
                                public void onResponse(Object response) {
                                    LogUtils.e("TABLE STATUS CHANGED RESPONSE RECEIVED");
                                }

                                @Override
                                public void onError(ANError anError) {
                                    if (anError.getErrorCode() == 400) {
                                        LogUtils.e("ERROR IN TABLE STATUS CHANGE: ", anError.getErrorAsObject(ApiError.class).getMessage());
                                    }
                                }
                            });
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeMergedTableStatus(String tableId) {
        Log.e("changeMergedTableStatus", "changeMergedTableStatus " + tableId);
        new Thread(() -> {
            List<Table> tables = appDatabase.tableDao().viewByMergedTableId(tableId);
            for (Table table : tables) {
                table.status = vacantStatus.status;
                table.table_status_id = vacantStatus.id;
                table.locked = false;
                table.merge_table_id = "";
                appDatabase.tableDao().insert(table);
            }
            Log.e("changeMergedTableStatus", "changeMergedTableStatusonrequest " + new Gson().toJson(tables));
            if (!tables.isEmpty()) {
                if ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()) && myApp.isConnected(NewOrderActivity.this)) {
                    AndroidNetworking.post(ApiEndPoints.tables_status_bulk)
                            .addBodyParameter("tables", new Gson().toJson(tables))
                            .build()
                            .getAsObject(Table.class, new ParsedRequestListener() {
                                @Override
                                public void onResponse(Object response) {
                                    Log.e("changeMergedTableStatus", "changeMergedTableStatusonResponse " + response);
                                }

                                @Override
                                public void onError(ANError anError) {
                                    anError.printStackTrace();
                                    Log.e("changeMergedTableStatus", "changeMergedTableStatusonanError " + anError.getErrorBody());
                                    if (anError.getErrorCode() == 400) {
                                        LogUtils.e("TABLE::", anError.getErrorAsObject(ApiError.class).getMessage());
                                    }
                                }
                            });
                }
            }
        }).start();
    }

    private void lockTable(Order order, Table tableParam, boolean locked) {
        try {
            if (!order.order_type_id.equals("1")) {
                return;
            }

            new Thread(() -> {
                Table table = tableParam;
                if (table == null) {
                    LogUtils.e("TABLE PARAM NULL");
                    table = appDatabase.tableDao().view(order.table_id);
                } else {
                    table = appDatabase.tableDao().view(tableParam.id);
                }
                LogUtils.e("Table Locking ?:" + locked + " number:" + table.number + " & ID:" + table.id + " & status:" + table.status);
                // if auto mode then update locked status else no need to upload locked status as we fetching table lock issue
                if ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                    table.locked = locked;
                } else {
                    table.locked = false;
                }
                table.updater_id = myPreferences.getLoggedInUser().id;
                appDatabase.tableDao().insert(table);
                if ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()) && myApp.isConnected(NewOrderActivity.this)) {
                    AndroidNetworking.post(ApiEndPoints.tables + table.id)
                            .addApplicationJsonBody(table)
                            .build()
                            .getAsObject(Table.class, new ParsedRequestListener() {
                                @Override
                                public void onResponse(Object response) {

                                }

                                @Override
                                public void onError(ANError anError) {
                                    anError.printStackTrace();
                                    if (anError.getErrorCode() == 400) {
                                        LogUtils.e("TABLE::", anError.getErrorAsObject(ApiError.class).getMessage());
                                    }
                                }
                            });
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchDeliveryCharge(Callable<Void> nextThing) {
        try {
            if (!myApp.isConnected(this)) {
                if (nextThing != null) {
                    try {
                        nextThing.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            runOnUiThread(() -> {
                progressBarDialog.show();
            });
            new Thread(() -> {
                AndroidNetworking.post(ApiEndPoints.calculate_delivery_charge)
                        .addBodyParameter("distance", order.customer.distance)
                        .build()
                        .getAsObject(DeliveryCharge.class, new ParsedRequestListener<DeliveryCharge>() {
                            @Override
                            public void onResponse(DeliveryCharge response) {
                                runOnUiThread(() -> {
                                    progressBarDialog.dismiss();
                                });
                                deliveryCharge = response.charge;
                                Log.e("Distance", "" + deliveryCharge);
                                if (nextThing != null) {
                                    try {
                                        nextThing.call();
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                runOnUiThread(() -> {
                                    progressBarDialog.dismiss();
                                });
                                if (nextThing != null) {
                                    try {
                                        nextThing.call();
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void editProduct(int position, String action, Object data) {
        try {
            if ((!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) && (MyApp.userPermission != null && MyApp.userPermission.modify.actions.list) && !canEditOrder) {
                return;
            }
            OrderItem orderItem = (OrderItem) data;
            if (action != null && !action.equalsIgnoreCase("view")) {
                ArrayList<OrderItem> orderItems = new ArrayList<>();
                orderItems.add(orderItem);
                new AddOrUpdateOrderSideItemAsyncTask(action, () -> {
                    new UpdateOrderAsyncTask(() -> {
                        fetchOffline(false);
                        return null;
                    }).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR);
                    return null;
                }).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, orderItems);
            } else {
                if (orderItem._order_split_id > 0 && selectedSplit != null && selectedSplit.paid_amount > 0 && orderItem._order_split_id == selectedSplit._id) {
                    ToastUtils.showSnackBar(NewOrderActivity.this, llMainLayout, "Cannot change in paid split group", "failed");
                } else {
                    //if (selectedSplit == null || (orderItem._order_split_id == selectedSplit._id && selectedSplit.paid_amount == 0)) {
                    long currentTime = SystemClock.elapsedRealtime();
                    if (currentTime - lastClickTime > MIN_CLICK_INTERVAL) {
                        lastClickTime = currentTime;
                        try {
                            // addon theme wise
                            if (addonThemeSetting != null && !Validators.isNullOrEmpty(addonThemeSetting.value) && (addonThemeSetting.value.equalsIgnoreCase("theme1"))) {
                                CartProductEditDialogFragmentOldDesign cartProductEditDialogFragmentOldDesign = getInstanceCartProductEditDialogOldDesign(order.order_type_id, orderItem);
                                cartProductEditDialogFragmentOldDesign.show(getSupportFragmentManager(), "product_view");
                            } else {
                                CartProductEditDialogFragment cartProductEditDialogFragment = getInstanceCartProductEditDialog(order.order_type_id, orderItem);
                                cartProductEditDialogFragment.show(getSupportFragmentManager(), "product_view");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public CartProductEditDialogFragmentOldDesign getInstanceCartProductEditDialogOldDesign(String orderTypeId, OrderItem orderItem) {
        CartProductEditDialogFragmentOldDesign fragment = new CartProductEditDialogFragmentOldDesign();
        Bundle bundle = new Bundle();
        bundle.putString("order_item", new Gson().toJson(orderItem));
        bundle.putString("order_type_id", orderTypeId);
        fragment.setArguments(bundle);
        return fragment;
    }

    public CartProductEditDialogFragment getInstanceCartProductEditDialog(String orderTypeId, OrderItem orderItem) {
        CartProductEditDialogFragment fragment = new CartProductEditDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_item", new Gson().toJson(orderItem));
        bundle.putString("order_type_id", orderTypeId);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void setCartValues() {
        try {
            new Thread(() -> {
                cartSubTotal = order.sub_total;
                cartDiscount = order.discount;
                cartGratuity = order.gratuity;
                if (voucherPaymentDone && voucherPaymentDoneAmount > 0) {
                    cartGrandTotal = (((cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount) - voucherPaymentDoneAmount);
                } else {
                    cartGrandTotal = ((cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount);
                }
                cartServiceCharge = order.service_charge;
                runOnUiThread(() -> {
                    tvSubtotal.setText(MyApp.currencySymbol + MyApp.df.format(cartSubTotal));
                    tvGrandTotal.setText(MyApp.currencySymbol + MyApp.df.format(cartGrandTotal));
                    // display voucher amount if >0 and amount is paid
                    if (voucherPaymentDone && voucherPaymentDoneAmount > 0) {
                        tvVoucherText.setClickable(true);
                        tvVoucherText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                        tvVoucher.setText(MyApp.currencySymbol + MyApp.df.format(voucherPaymentDoneAmount));
                        llVoucher.setVisibility(View.VISIBLE);
                    } else {
                        llVoucher.setVisibility(View.GONE);
                    }
                    if (cartDiscount > 0) {
                        llDiscount.setVisibility(View.VISIBLE);
                        tvDiscount.setText(MyApp.currencySymbol + MyApp.df.format(cartDiscount));
                        if (autoDiscountApplied) {
                            tvDiscountText.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
                            tvDiscountText.setClickable(false);

                            if (displayDiscount != null && !Validators.isNullOrEmpty(displayDiscount.value) && displayDiscount.value.equalsIgnoreCase("yes")) {
                                runOnUiThread(() -> {
                                    // Expand view for discount text
                                    ivExpand.setRotation(270);
                                    llExpand.setVisibility(View.VISIBLE);
                                });
                            }
                        } else {
                            tvDiscountText.setClickable(true);
                            tvDiscountText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                        }
                    } else {
                        llDiscount.setVisibility(View.GONE);
                    }
                    if (cartGratuity > 0) {
                        llGratuity.setVisibility(View.VISIBLE);
                        tvGratuity.setText(MyApp.currencySymbol + MyApp.df.format(cartGratuity));
                        tvGratuityText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                    } else {
                        llGratuity.setVisibility(View.GONE);
                    }
                    if (cartServiceCharge > 0) {
                        llServiceCharge.setVisibility(View.VISIBLE);
                        tvServiceCharge.setText(MyApp.currencySymbol + MyApp.df.format(cartServiceCharge));
                        tvServiceChargeText.setClickable(true);
                        tvServiceChargeText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                    } else {
                        llServiceCharge.setVisibility(View.GONE);
                    }
                    if (order.delivery_charge > 0) {
                        Log.e("order.deliverycharge", "" + order.delivery_charge);
                        llDelivery.setVisibility(View.VISIBLE);
                        tvDelivery.setText(MyApp.currencySymbol + MyApp.df.format(order.delivery_charge));

                        if (deliveryChargeTypeOption != null && deliveryChargeTypeOption.value.equals("manual")) { // null condition added from Firebase bug
                            Log.e("order.deliverycharge", "" + deliveryChargeTypeOption);
                            tvDeliveryText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                        }
                        String houseNo = "";
                        if (order.customer != null && order.customer.house_no != null) {
                            houseNo = order.customer.house_no;
                        }
                        String customer_address = "";
                        if (order.customer != null) {
                            customer_address = houseNo + " ," + order.customer.street + " ," + order.customer.country;
                        } else {
                            customer_address = houseNo;
                        }
                        tvcustomer_detail.setText("" + customer_address);

                        String customer_contact = order.customer.name + " (" + order.customer.mobile + ")";
                        tvcustomer_contact.setText("" + customer_contact);

                        llCustomerInfo.setVisibility(View.VISIBLE);
                    } else {
                        llDelivery.setVisibility(View.GONE);
                        llCustomerInfo.setVisibility(View.GONE);
                    }
                });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOffline(boolean redirect) {
        try {
            FetchOrderOfflineRxJavaRedirect(redirect);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openPayBillScreen() {
        if (!Validators.isNullOrEmpty(order.split_type) && shouldOpenSplitScreen) {
            startActivityForResult(new Intent(NewOrderActivity.this, SplitActivity.class).putExtra("display_order_id", order.display_order_id).putExtra("_order_id", order._id).putExtra("order_id", order.id), Constants.CODE_REFRESH);
        } else {
            isBackPressed = true;
            startActivityForResult(new Intent(NewOrderActivity.this, OrderReviewActivity.class).putExtra("unique_id", order.unique_id).putExtra("display_order_id", order.display_order_id).putExtra("order_id", order.id).putExtra("_order_id", order._id).putExtra("order_total", order.total).putExtra("paid_amount", order.total_paid), Constants.CODE_REFRESH);
        }
    }

    private void changeFragment(Fragment fragment, boolean enableBackPress) {
        try {
            if (getIntent() != null) {
                if (fragment.getArguments() != null) {
                    fragment.getArguments().putAll(getIntent().getExtras());
                } else {
                    fragment.setArguments(getIntent().getExtras());
                }
            }
            if (fragment instanceof ProductAreaFragment) {
                llSearch.setVisibility(View.VISIBLE);
            } else {
                llSearch.setVisibility(View.INVISIBLE);
            }
            FragmentManager manager = getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.flProductArea, fragment);
            if (enableBackPress) {
                transaction.addToBackStack("can_go_back");
            }
            transaction.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValidToPlaceOrder() {
        if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) {
            return false;
        }
        // Order completed
        return !order.order_status_id.equalsIgnoreCase("5");
    }

    private void changeStatusCallerid(String status) {
        try {
            callLogs.status = status;
            cvCallerId.setVisibility(View.GONE);
            if (callLogs.status.equalsIgnoreCase("accepted")) {
                OrderTypeSelectionDialogFragment orderTypeSelectionDialog = myApp.getInstanceOrderTypeSelection(callLogs);
                orderTypeSelectionDialog.show(getSupportFragmentManager(), "order_type");
                orderTypeSelectionDialog.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        String orderTypeId = (String) o;
                        NewOrderDialogFragment newOrderDialogFragment = myApp.getInstanceNewOrder(callLogs, orderTypeId);
                        newOrderDialogFragment.show(getSupportFragmentManager(), "new_order");
                        newOrderDialogFragment.setDialogDismissListener(o1 -> {
                            if (o1 instanceof Order) {
                                uploadOrder();
                                finish();
                                startActivity(new Intent(this, NewOrderActivity.class).putExtra("order", new Gson().toJson(o1)).putExtra("fetch_delivery_charge", ((Order) o1).order_type_id.equalsIgnoreCase("3")));
                            } else if (o1 instanceof CallLogs) {
                                createNewReservation((CallLogs) o1);
                            }

                        });
                    } else if (o instanceof CallLogs) {
                        createNewReservation((CallLogs) o);
                    }
                });

            }
            new Thread(() -> {
                callLogs.uploadable = true;
                appDatabase.calllogDao().insert(callLogs);
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createNewReservation(CallLogs o) {
        try {
            uploadOrder();
            startActivity(new Intent(this, HomeActivity.class).putExtra("destination", "reservations").putExtra("calllogs", new Gson().toJson(o)));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {
        try {
            if (!order.order_type_id.equalsIgnoreCase("1") && !order.is_delivery_collection_ask && auto_delivery_time_slot != null && (auto_delivery_time_slot.value.equalsIgnoreCase("true") || auto_delivery_time_slot.value.equalsIgnoreCase("1"))) {
                openTimeSelection(o -> backpRessed());
            } else {
                backpRessed();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void backpRessed() {
        setResult(RESULT_OK);
        try {
            if (progressBarDialog != null && progressBarDialog.isShowing()) {
                runOnUiThread(() -> {
                    progressBarDialog.dismiss();
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.flProductArea);
        if (openedFragment instanceof ProductAreaFragment) {
            LogUtils.e("In If Condition");
            isBackPressed = true;
            uploadOrder();
            finish();
        } else {
            llSearch.setVisibility(View.VISIBLE);
            if (manager.getBackStackEntryCount() > 0) {
                LogUtils.e("In Else Condition");
                manager.popBackStack();
            }
        }
    }

    private void uploadOrder() {
        try {
            if (callChangeTableStatus) {
                LogUtils.e("TABLE upload order");
                changeTableStatus(order, orderTakenStatus.id, "Order Taken");
            }
            if (needToUpload) {
                isUploadStarted = true;
                Intent intent = new Intent(this, SingleOrderUploaderService.class);
                intent.putExtra("_order_id", _order_id);
                startService(intent);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        try {
            LogUtils.e("On Stop " + isBackPressed);
            if (needToUpload && !isBackPressed && myApp.isConnected(NewOrderActivity.this) && !isUploadStarted) {
                LogUtils.e("IF ON Stop " + isBackPressed);
                Intent intent = new Intent(this, SingleOrderUploaderService.class);
                intent.putExtra("_order_id", _order_id);
                startService(intent);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy() {
        try {
            LogUtils.e("On Destroy");
            if (progressBarDialog != null) progressBarDialog.dismiss();

            boolean printAction = false;
            if (printAction && defaultPrinter != null && (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80))) {
                if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                    wifiPrinter.disconnect();
                } else {
                    disconnectBTPrinter();
                }
            }
            if (orderItemReceiver != null)
                LocalBroadcastManager.getInstance(this).unregisterReceiver(orderItemReceiver);
            if (orderButtonClickReceiver != null)
                LocalBroadcastManager.getInstance(this).unregisterReceiver(orderButtonClickReceiver);


            calllogViewModel.getCallLogs().removeObservers(this);
            mHandler.removeCallbacks(runnable);
            mHandler.removeCallbacks(null);
            clearPrinterVariable();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }

    private void clearPrinterVariable() {
        sunmiPrinter.unBindService(this);
        sunmiPrinter.printBlockBill = null;
        sunmiPrinter.myApp = null;
        sunmiPrinter = null;
        if(sunmiPrinterV3Mix!=null){
            sunmiPrinterV3Mix.printBlockBill = null;
            sunmiPrinterV3Mix.myApp = null;
        }
        sunmiPrinterV3Mix = null;
        zoneRichPrinter.printBlockBill = null;
        zoneRichPrinter.activity = null;
        zoneRichPrinter.zonerich = null;
        zoneRichPrinter = null;
        wifiPrinter = null;
        myApp = null;
    }

    @Override
    protected void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance(this).registerReceiver(push_receiver, new IntentFilter(Constants.PUSH_NOTIFICATION));
            LocalBroadcastManager.getInstance(this).registerReceiver(callReceiver, new IntentFilter("call_received"));
            LocalBroadcastManager.getInstance(this).registerReceiver(orderUpdateReceiver, new IntentFilter(Constants.EPOS_ORDER_UPDATE));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver push_receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("push", true)) {
                    int booking_id = intent.getIntExtra(BOOKING_ID, 0);
                    boolean auto_accept = intent.getBooleanExtra(AUTO_ACCEPT, false);
                    if (auto_accept && booking_id != 0) {
                        OnlineReservation onlineReservation = new OnlineReservation();
                        onlineReservation.status = "Approved";
                        onlineReservation.id = booking_id;
                        myApp.changeStatusOnlineReservation(onlineReservation, NewOrderActivity.this);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onPause() {
        super.onPause();
        try {
            if (push_receiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(push_receiver);
            }
            if (callReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(callReceiver);
            }
            if (orderUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(orderUpdateReceiver);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == Constants.CODE_REFRESH && resultCode == RESULT_OK) {
                LogUtils.e("TABLE OnActivityResult");
                isBackPressed = false;
                new FetchOrderOfflineAsyncTask(() -> {
                    LogUtils.e("TABLE:::TOTAL::" + order.total + " & PAID::" + order.total_paid);
                    printableTotal = order.total;
                    // orderItemsAdapter.notifyDataSetChanged(); Not required already refreshing in above Fetch order method
                    progressBarDialog.dismiss();
                    updateViews();
                    int print_count = 0;
                    String order_action = null;
                    int _split_id = 0;
                    if (data != null) {
                        print_count = data.getIntExtra("print_count", 0);
                        _split_id = data.getIntExtra("_order_split_id", 0);
                        order_action = data.getStringExtra("order_action");
                    }
                    splitByPersonPrint = false;
                    try {
                        // When partial payment is done, remove discount option from list
                        if (orderActionMenu.size() > 0 && orderActionMenuAdapter != null && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 0) {
                            for (int i = 0; i < orderActionMenu.size(); i++) {
                                if (orderActionMenu.get(i).key.equalsIgnoreCase("discount")) {
                                    orderActionMenu.remove(i);
                                    orderActionMenuAdapter.notifyDataSetChanged();
                                    break;
                                }
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (myApp.isPaymentLinkSent) {
                        onBackPressed();
                    } else {
                        if (myApp.needToPrint) {
                            myApp.needToPrint = false;
                            if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) != 1) {
                                uploadOrderImmediately();
                            }
                            if (print_count > 0) {
                                splitByPersonPrint = true;
                                printableTotal = printableTotal / print_count;
                                for (int i = 0; i < print_count; i++) {
                                    createPrint("", false, print_count == i + 1, false);
                                }
                            } else if (_split_id > 0) {
                                createSplitPrint(_split_id);
                            } else if (!Validators.isNullOrEmpty(order_action)) {
                                if (order_action.equalsIgnoreCase("full_order")) {
                                    createPrint("Full Order", true, true, false);
                                } else if (order_action.equalsIgnoreCase("duplicate_order")) {
                                    createPrint("Duplicate Order", true, true, false);
                                } else if (order_action.equalsIgnoreCase("updated_order")) {
                                    createPrint("Updated Order", true, true, false);
                                } else if (order_action.equalsIgnoreCase("duplicate_updated_order")) {
                                    createPrint("Duplicate Updated Order", true, true, false);
                                } else if (order_action.equalsIgnoreCase("print_all")) {
                                    // For Kitchen Copy
                                    //   createBillPrint("", true, false, false);
                                    //   createBillPrint("", false, true, false);
                                    // Calling two methods one by one
                                    boolean kitchenCopy = true;
                                    String title = "";
                                    boolean updateOrder = false;
                                    if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                        if (kitchenCopy) {
                                            new PrepLocationSenderAsync(title, updateOrder, () -> {
                                                Thread.sleep(200);
                                                createBillPrint("", false, true, false);
                                                return null;
                                            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                        }
                                    } else {
                                        showToastInPostExecute(false);
                                        Thread.sleep(200);
                                        createBillPrint("", false, true, false);
                                    }
                                } else if (order_action.equalsIgnoreCase("print_bill")) {
                                    createBillPrint("print_bill", false, true, false);
                                } else {
                                    onBackPressed();
                                }
                            } else {
                                afterPaymentPrintOptions();
                            }
                        } else {
                            uploadOrderImmediately();
                            LogUtils.e("TABLE OnActivityResult: No Print");
                        }
                    }
                    return null;
                }, false).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            }
            if (myApp.isPaymentLinkSent) {
                onBackPressed();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void afterPaymentPrintOptions() {
        try {
            if (payBillActionModeSetting != null && payBillActionModeSetting.value.equalsIgnoreCase("auto")) {
                //No need to print part payment when set to false from backend
                if (order.order_status.equalsIgnoreCase("Part Payment Received") && order.order_status_id.equalsIgnoreCase("7") && partialPaymentPrint != null && partialPaymentPrint.value.equalsIgnoreCase("no")) {
                    Log.e("NewOrderActivity", "No need to print part payment when set to false from backend ");
                } else {
                    if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("both")) {
                        createPrint("", true, false, false);
                        createPrint("", false, true, false);
                    } else if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("bill")) {
                        createPrint("", false, true, false);
                    } else if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                        createPrint("", true, true, false);
                    } else {
                        onBackPressed();
                    }
                }
            } else {
                //No need to print part payment when set to false from backend
                if (order.order_status.equalsIgnoreCase("Part Payment Received") && order.order_status_id.equalsIgnoreCase("7") && partialPaymentPrint != null && partialPaymentPrint.value.equalsIgnoreCase("no")) {
                    Log.e("NewOrderActivity", "No need to print part payment when set to false from backend ");
                } else {
                    if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("both")) {
                        askForPrintLocation(true);
                    } else if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("bill")) {
                        askForPrintLocation(true);
                    } else if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                        askForPrintLocation(false);
                    } else {
                        onBackPressed();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForPrintLocation(boolean billPrint) {
        try {
            String messge = "Do you want to print bill receipt?";
            if (!billPrint) {
                messge = "Do you want prep ticket?";
            }
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Print", messge, 0, "Confirm", "Cancel");
            confirmationDialogFragment.setCancelable(false);
            confirmationDialogFragment.show(getSupportFragmentManager(), "action");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("confirm")) {
                        if (billPrint) {
                            createPrint("", false, false, false);
                            if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                                askForPrintLocation(false);
                            } else {
                                if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1)
                                    onBackPressed();
                            }
                        } else
                            createPrint("", true, true, false);
                    } else {
                        if (billPrint) {
                            if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                                askForPrintLocation(false);
                            } else {
                                if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1)
                                    onBackPressed();
                            }
                        } else {
                            if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1)
                                onBackPressed();
                        }
                    }
                } else {
                    if (billPrint) {
                        if (payBillActionSetting != null && payBillActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                            askForPrintLocation(false);
                        } else {
                            if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1)
                                onBackPressed();
                        }
                    } else {
                        if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1)
                            onBackPressed();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean showSendOrderButton() {
        if (sendOrderMainSetting == null && sendOrderUpdateMainSetting == null && sendDupOrderMainSetting == null && sendDupOrderUpdateMainSetting == null) {
            return false;
        }
        return (sendOrderMainSetting == null || (!sendOrderMainSetting.value.equalsIgnoreCase("false") && !sendOrderMainSetting.value.equalsIgnoreCase("0"))) || (sendOrderUpdateMainSetting == null || (!sendOrderUpdateMainSetting.value.equalsIgnoreCase("false") && !sendOrderUpdateMainSetting.value.equalsIgnoreCase("0"))) || (sendDupOrderMainSetting == null || (!sendDupOrderMainSetting.value.equalsIgnoreCase("false") && !sendDupOrderMainSetting.value.equalsIgnoreCase("0"))) || (sendDupOrderUpdateMainSetting == null || (!sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("false") && !sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("0")));
    }

    private void createBillPrintCopy(String title, boolean kitchenCopy, boolean goBack, boolean updateOrder) {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (kitchenCopy) {
                    new PrepLocationSenderAsync(title, updateOrder, () -> {
                        if (goBack)
                            onBackPressed();
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                } else {
                    new OrderItemsPrintBlockAsync(null, () -> {
                        LogUtils.e("TABLE Can we go back? " + (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title)) + " OrderTotal:" + order.total + " Paid: " + order.total_paid + " Title is nullorempty?" + Validators.isNullOrEmpty(title));
                        if (goBack) {
                            onBackPressed();
                        }
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                }
            } else {
                LogUtils.e("TABLE Can we go if no printer back? " + (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title)) + " OrderTotal:" + order.total + " Paid: " + order.total_paid + " Title is nullorempty?" + Validators.isNullOrEmpty(title));
                showToastInPostExecute(false);
                if (goBack) {
                    onBackPressed();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createBillPrint(String title, boolean kitchenCopy, boolean goBack, boolean updateOrder) {
        generatePaymentLink(title, kitchenCopy, goBack, updateOrder, true);
    }

    private void showToastInPostExecute(boolean isBluetooth) {
        try {
            runOnUiThread(() -> {
                if (!NewOrderActivity.this.isFinishing()) { // From firebase issue
                    try {
                        if (!isBluetooth) {
                            ToastUtils.makeLongToast(NewOrderActivity.this, "No printer model found");
                        } else {
                            ToastUtils.makeLongToast(NewOrderActivity.this, "No bluetooth device found.");
                        }
                    } catch (WindowManager.BadTokenException e) {
                        Log.e("WindowManagerBad ", e.toString());
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPrint(String title, boolean kitchenCopy, boolean goBack, boolean updateOrder) {
        generatePaymentLink(title, kitchenCopy, goBack, updateOrder, false);
    }

    private void createSplitPrint(int _split_id) {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                new OrderItemsPrintBlockAsync(null, () -> {
                    if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1)
                        onBackPressed();
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, _split_id);
            } else {
                showToastInPostExecute(false);
                if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1)
                    onBackPressed();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void calculateDistance(String latitude, String longitude) {
        try {
            SiteSetting findLongitude = myApp.findSetting("address_longitude");
            SiteSetting findlatitude = myApp.findSetting("address_latitude");

            if (findLongitude != null && findlatitude != null) {
                if (!Validators.isNullOrEmpty(findlatitude.value) &&
                        !Validators.isNullOrEmpty(findLongitude.value) &&
                        !Validators.isNullOrEmpty(latitude) && !Validators.isNullOrEmpty(longitude)) {
                    Location locationRestaurant = new Location("Restaurant Location");
                    locationRestaurant.setLongitude(Double.parseDouble(findLongitude.value));
                    locationRestaurant.setLatitude(Double.parseDouble(findlatitude.value));

                    Location locationUser = new Location("User Location");
                    locationUser.setLongitude(Double.parseDouble(longitude));
                    locationUser.setLatitude(Double.parseDouble(latitude));

                    float d = locationRestaurant.distanceTo(locationUser) * 0.000621371f;
                    float distance = Float.parseFloat(MyApp.df.format(d));
                    Log.e("distance", "" + distance);
                }
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private class AddOrUpdateOrderSideItemAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;
        String action;

        public AddOrUpdateOrderSideItemAsyncTask(String action, Callable<Void> nextMethod) {
            this.action = action;
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            if (objects[0] instanceof List) {
                try {
                    ArrayList<OrderItem> orderItems = (ArrayList<OrderItem>) objects[0];
                    for (OrderItem orderItem : orderItems) {
                        OrderItem dbOrderItem = appDatabase.orderItemDao().view(orderItem._id);

                        if (orderItem._order_split_id > 0) {
                            OrderSplit dbSplit = null;
                            if (orderItem._order_split_id == selectedSplit._id) {
                                dbSplit = selectedSplit;
                            } else {
                                dbSplit = appDatabase.orderSplitDao().view(orderItem._order_split_id);
                            }
                            if (dbSplit.paid_amount > 0) {
                                ToastUtils.showSnackBar(NewOrderActivity.this, llMainLayout, "Cannot change in paid split group", "failed");
                                break;
                            }
                        }
                        int dbOrderItemId, quantity;
                        if (orderItem.quantity <= 0) {
                            if (dbOrderItem != null) {
                                dbOrderItem.is_delete = true;
                                dbOrderItem.sent_to_kitchen_quantity = 0;
                                dbOrderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                appDatabase.orderItemDao().update(dbOrderItem);
                                //appDatabase.orderItemDao().delete(dbOrderItem);
                                if (orderItem._order_split_id > 0) {
                                    appDatabase.orderSplitDao().updateTotalAmount(orderItem._order_id, orderItem._order_split_id);
                                }
                                continue;
                            }
                        }
                        if (dbOrderItem != null) {
                            dbOrderItem.quantity = orderItem.quantity;
                            quantity = dbOrderItem.quantity;
                            dbOrderItem.sub_total = dbOrderItem.quantity * orderItem.price;
                            dbOrderItem.instruction_price = orderItem.instruction_price;
                            dbOrderItem.special_instruction = orderItem.special_instruction;
                            dbOrderItem.total = dbOrderItem.sub_total + dbOrderItem.addons_price + dbOrderItem.ingredients_price + (dbOrderItem.instruction_price * dbOrderItem.quantity);
                            // check user clicked on add,minus or edit throw the edittext
                            if (Objects.equals(action, QUANTITY_MODIFIED_ADD)) {
                                dbOrderItem.sent_to_kitchen_quantity = dbOrderItem.sent_to_kitchen_quantity + 1;
                            } else if (Objects.equals(action, QUANTITY_MODIFIED_MINUS)) {
                                dbOrderItem.sent_to_kitchen_quantity = dbOrderItem.sent_to_kitchen_quantity - 1;
                                addMinusQuantityInDatabase(dbOrderItem);
                            } else {
                                dbOrderItem.sent_to_kitchen_quantity = orderItem.quantity;
                            }
                            dbOrderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            myApp.appDatabase.orderItemDao().update(dbOrderItem);
                            dbOrderItemId = dbOrderItem._id;
                        } else {
                            quantity = orderItem.quantity;
                            orderItem.order_id = order.id;
                            orderItem._order_id = order._id;
                            orderItem.sub_total = orderItem.quantity * orderItem.price;
                            orderItem.total = orderItem.sub_total + orderItem.addons_price + orderItem.ingredients_price + (orderItem.instruction_price * orderItem.quantity);
                            // check user clicked on add,minus or edit throw the edittext
                            if (Objects.equals(action, QUANTITY_MODIFIED_ADD)) {
                                orderItem.sent_to_kitchen_quantity = orderItem.sent_to_kitchen_quantity + 1;
                            } else if (Objects.equals(action, QUANTITY_MODIFIED_MINUS)) {
                                orderItem.sent_to_kitchen_quantity = orderItem.sent_to_kitchen_quantity - 1;
                                addMinusQuantityInDatabase(orderItem);
                            } else {
                                orderItem.sent_to_kitchen_quantity = orderItem.quantity;
                            }
                            OrderItem checkItemInDb = appDatabase.orderItemDao().view(orderItem._id);
                            if (checkItemInDb == null) {
                                orderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                dbOrderItemId = (int) myApp.appDatabase.orderItemDao().insert(orderItem);
                            } else {
                                orderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                myApp.appDatabase.orderItemDao().update(orderItem);
                                dbOrderItemId = orderItem._id;
                            }
                        }
                        float addonTotal = 0;
                        if (orderItem.order_item_addons != null) {
                            for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                itemAddon._order_item_id = dbOrderItemId;
                                itemAddon.total = itemAddon.quantity * itemAddon.price;
                                addonTotal = addonTotal + itemAddon.total;
                            }
                            myApp.appDatabase.orderItemAddonDao().insertAll(orderItem.order_item_addons);
                        }

                        float ingredientTotal = 0;
                        if (orderItem.order_item_ingredients != null) {
                            appDatabase.orderItemIngredientDao().deleteAll(dbOrderItemId);
                            for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                itemIngredient._order_item_id = dbOrderItemId;
                                itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                ingredientTotal = ingredientTotal + itemIngredient.total;
                            }
                            appDatabase.orderItemIngredientDao().insertAll(orderItem.order_item_ingredients);
                        }

                        ingredientTotal = ingredientTotal * quantity;
                        addonTotal = addonTotal * quantity;
                        myApp.appDatabase.orderItemDao().updateOrderItemTotal(dbOrderItemId, addonTotal, ingredientTotal);
                        if (orderItem._order_split_id > 0) {
                            appDatabase.orderSplitDao().updateTotalAmount(orderItem._order_id, orderItem._order_split_id);
                        }
                    }
                    Order dbOrder = appDatabase.orderDao().view(order._id);
                    dbOrder.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);
                    dbOrder.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    // remove voucher if item total less than voucher amount
                    OrderPayment voucherPayment = appDatabase.orderPaymentDao().findByMethod(_order_id, "5");
                    if (voucherPayment != null && !Validators.isNullOrEmpty(voucherPayment.voucher_id)) {
                        Voucher voucher = appDatabase.voucherDao().view(voucherPayment.voucher_id);
                        if (voucher != null && voucher.minimum_order_value > 0 && dbOrder.sub_total < voucher.minimum_order_value) {
                            appDatabase.orderPaymentDao().delete(voucherPayment);
                        }
                    }
                    appDatabase.orderDao().update(dbOrder);
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class UpdateOrderStatusAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;


        public UpdateOrderStatusAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {

            try {
                if (orderCompleteAuto && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                    order.order_status_id = "5";
                    order.order_status = "Order Completed";
                }

                appDatabase.orderDao().update(order);

                if (order.order_type_id.equalsIgnoreCase("1") && !Validators.isNullOrEmpty(order.table_id) &&
                        (order.order_status_id.equalsIgnoreCase("5") ||
                                order.order_status_id.equalsIgnoreCase("10"))) {
                    Table table = appDatabase.tableDao().view(order.table_id);
                    table.status = vacantStatus.status;
                    table.locked = false;
                    table.last_order_total = 0;
                    table.last_order_id = null;
                    table._last_order_id = 0;
                    table.last_order_created_at = null;
                    table.table_status_id = vacantStatus.id;
                    appDatabase.tableDao().insert(table);

                    // check and change merged table status as vacant
                    changeMergedTableStatus(table.id);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addMinusQuantityInDatabase(OrderItem dbOrderItem){
        OrderItem deletedOrderItem = new OrderItem();
        deletedOrderItem._order_id = dbOrderItem._order_id;
        deletedOrderItem.order_id = dbOrderItem.order_id;
        deletedOrderItem._order_split_id = dbOrderItem._order_split_id;
        deletedOrderItem.order_split_id = dbOrderItem.order_split_id;
        deletedOrderItem.product_name = dbOrderItem.product_name;
        deletedOrderItem.product_id = dbOrderItem.product_id;
        deletedOrderItem.product_short_name = dbOrderItem.product_short_name;
        deletedOrderItem.product_description = dbOrderItem.product_description;
        deletedOrderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
        deletedOrderItem.is_delete = true;
        deletedOrderItem.price = dbOrderItem.price;
        deletedOrderItem.sub_total = (1 * dbOrderItem.price);
        deletedOrderItem.total = dbOrderItem.sub_total + dbOrderItem.addons_price + dbOrderItem.ingredients_price;
        deletedOrderItem.sent_to_kitchen_quantity =0;
        appDatabase.orderItemDao().insert(deletedOrderItem);
    }

    private void UploadOrderAsyncTaskRxJava(OrderItem orderItem) {
        try {
            Observable.fromCallable(() -> {
                        try {
                            cartSubTotal = cartSubTotal - orderItem.total;
                            orderItem.is_delete = true;
                            orderItem.sent_to_kitchen_quantity = 0;
                            orderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            myApp.appDatabase.orderItemDao().update(orderItem);
                            //myApp.appDatabase.orderItemDao().delete(orderItem);
                            // update total of split group when item delete
                            if (orderItem._order_split_id > 0) {
                                appDatabase.orderSplitDao().updateTotalAmount(orderItem._order_id, orderItem._order_split_id);
                            }
                            order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);
                            LogUtils.e("ORDER::", "Order Sub Total::" + order.sub_total);
                            // remove voucher if item total less than voucher amount
                            OrderPayment voucherPayment = appDatabase.orderPaymentDao().findByMethod(_order_id, "5");
                            if (voucherPayment != null && !Validators.isNullOrEmpty(voucherPayment.voucher_id)) {
                                Voucher voucher = appDatabase.voucherDao().view(voucherPayment.voucher_id);
                                if (voucher != null && voucher.minimum_order_value > 0 && order.sub_total < voucher.minimum_order_value) {
                                    appDatabase.orderPaymentDao().delete(voucherPayment);
                                }
                            }
                            cartSubTotal = order.sub_total;
                            LogUtils.e("ORDER::", "Cart Sub Total::" + cartSubTotal);

                            if (serviceChargeEnabled) {
                                if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                                    float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                                    if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                        cartServiceCharge = serviceChargeValue;
                                    } else {
                                        if (serviceChargeValue > 0) {
                                            cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                        } else {
                                            cartServiceCharge = 0;
                                        }
                                    }
                                }
                            }

                            if (discountEnabled) {
                                List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                                if (discounts.size() > 0) {
                                    Discount appliedDiscount = discounts.get(0);
                                    autoDiscountApplied = false;
                                    if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                                        if (cartSubTotal > 0)
                                            cartDiscount = appliedDiscount.discount;
                                        else cartDiscount = 0;
                                        autoDiscountApplied = true;
                                    }
                                    if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                                        if (cartSubTotal > 0)
                                            cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                                        else cartDiscount = 0;
                                        autoDiscountApplied = true;
                                    }
                                } else {
                                    if (autoDiscountApplied) cartDiscount = 0;
                                }
                            }

                            order.delivery_charge = deliveryCharge;
                            order.gratuity = cartGratuity;
                            order.discount = cartDiscount;
                            order.service_charge = cartServiceCharge;
                            cartGrandTotal = (cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount;
                            order.total = cartGrandTotal;

                            if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            }
                            if (orderCompleteAuto && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                                order.order_status_id = "5";
                                order.order_status = "Order Completed";
                            }
                            appDatabase.orderDao().update(order);

                            if (order.order_type_id.equalsIgnoreCase("1") &&
                                    !Validators.isNullOrEmpty(order.table_id) &&
                                    (order.order_status_id.equalsIgnoreCase("5") ||
                                            order.order_status_id.equalsIgnoreCase("10"))) {
                                Table table = appDatabase.tableDao().view(order.table_id);
                                table.status = vacantStatus.status;
                                table.locked = false;
                                table.last_order_total = 0;
                                table.last_order_id = null;
                                table._last_order_id = 0;
                                table.last_order_created_at = null;
                                table.table_status_id = vacantStatus.id;
                                appDatabase.tableDao().insert(table);

                                // check and change merged table status as vacant
                                changeMergedTableStatus(table.id);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        return true;
                    }) // Execute in IO thread, i.e. background thread.
                    .subscribeOn(Schedulers.io())
                    // report or post the result to main thread.
                    .observeOn(AndroidSchedulers.mainThread())
                    // execute this RxJava
                    .subscribe(new Observer<Boolean>() {
                        @Override
                        public void onSubscribe(Disposable d) {

                        }

                        @Override
                        public void onNext(Boolean success) {
                            // on success. Called on main thread, as defined in .observeOn(AndroidSchedulers.mainThread())
                            fetchOffline(false);
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private class UpdateOrderAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;


        public UpdateOrderAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);
                LogUtils.e("ORDER::", "Order Sub Total::" + order.sub_total);
                cartSubTotal = order.sub_total;
                LogUtils.e("ORDER::", "Cart Sub Total::" + cartSubTotal);

                if (serviceChargeEnabled) {
                    if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                        float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                        if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                            cartServiceCharge = serviceChargeValue;
                        } else {
                            if (serviceChargeValue > 0) {
                                cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                            } else {
                                cartServiceCharge = 0;
                            }
                        }
                    }
                }

                if (discountEnabled) {
                    List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                    if (discounts.size() > 0) {
                        Discount appliedDiscount = discounts.get(0);
                        autoDiscountApplied = false;
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                            if (cartSubTotal > 0)
                                cartDiscount = appliedDiscount.discount;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                            if (cartSubTotal > 0)
                                cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                    } else {
                        if (autoDiscountApplied) cartDiscount = 0;
                    }
                }

                order.delivery_charge = deliveryCharge;
                order.gratuity = cartGratuity;
                order.discount = cartDiscount;
                order.service_charge = cartServiceCharge;
                cartGrandTotal = (cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount;
                order.total = cartGrandTotal;

                if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                }
                if (orderCompleteAuto && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                    order.order_status_id = "5";
                    order.order_status = "Order Completed";
                }
                appDatabase.orderDao().update(order);

                if (order.order_type_id.equalsIgnoreCase("1") &&
                        !Validators.isNullOrEmpty(order.table_id) &&
                        (order.order_status_id.equalsIgnoreCase("5") ||
                                order.order_status_id.equalsIgnoreCase("10"))) {
                    Table table = appDatabase.tableDao().view(order.table_id);
                    table.status = vacantStatus.status;
                    table.locked = false;
                    table.last_order_total = 0;
                    table.last_order_id = null;
                    table._last_order_id = 0;
                    table.last_order_created_at = null;
                    table.table_status_id = vacantStatus.id;
                    appDatabase.tableDao().insert(table);

                    // check and change merged table status as vacant
                    changeMergedTableStatus(table.id);
                }

                if (order.order_status.equalsIgnoreCase("Order Deleted")) {
                    Log.e("Order deleted", "Order deleted " + order._id);
                    appDatabase.orderDao().delete(order);
                    myApp.isFromDeleteOrder = true;
                    // send brodcast to refresh home page list
                    LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(new Intent(Constants.DELETE_ORDER_SUCCESS));
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class MergeTableOrder extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;
        Table mergeTable;

        public MergeTableOrder(Table mergeTable, Callable<Void> nextMethod) {
            this.mergeTable = mergeTable;
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                /*if (Validators.isNullOrEmpty(mergeTable.last_order_id)) {
                 *//* mergeTable.last_order_id = order.id;
                    myApp.appDatabase.tableDao().insert(mergeTable);*//*
                    setStatusToMerge(mergeTable.id);
                } else {*/
                // below order need to merge in current order
                OrderWithItems orderWantToMerge = null;
                if (Validators.isNullOrEmpty(mergeTable.last_order_id)) {
                    Order dbOrder = appDatabase.orderDao().findLastOrderOfTable(mergeTable.id);
                    if (dbOrder == null) {
                        mergeTable.last_order_id = order.id;
                        myApp.appDatabase.tableDao().insert(mergeTable);
                        setStatusToMerge(mergeTable.id);
                    } else {
                        orderWantToMerge = myApp.appDatabase.orderDao().orderWithItems(dbOrder._id);
                    }
                } else {
                    orderWantToMerge = myApp.appDatabase.orderDao().orderWithItems(mergeTable.last_order_id);
                }
                if (orderWantToMerge != null) {
                    for (OrderItemWithAddonsIngredients item : orderWantToMerge.orderItems) {
                        OrderItem orderItem = item.orderItem;
                        //orderItem.id = null;
                        orderItem.order_split_id = null;
                        orderItem.order_id = order.id;
                        orderItem._order_id = order._id;
                        orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                        orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                        orderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                        myApp.appDatabase.orderItemDao().update(orderItem);
                        order.order_items.add(orderItem);
                    }
                    // update split type
                    order.split_type = orderWantToMerge.order.split_type;
                    //mergeTable.last_order_id = order.id;
                    //myApp.appDatabase.tableDao().insert(mergeTable);
                    order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);

                    float cartGratuity = orderWantToMerge.order.gratuity;
                    float discount = orderWantToMerge.order.discount;
                    float cartServiceCharge = orderWantToMerge.order.service_charge;
                    float delivery_charge = orderWantToMerge.order.delivery_charge;

                    order.delivery_charge = delivery_charge + order.delivery_charge;
                    order.gratuity = order.gratuity + cartGratuity;
                    order.service_charge = cartServiceCharge + order.service_charge;
                    float totalDiscount = order.discount + discount;
                    cartGrandTotal = ((order.sub_total + order.gratuity + order.service_charge + order.delivery_charge + order.gratuity) - totalDiscount);
                    order.discount = order.discount + discount;
                    order.total = cartGrandTotal;

                    // order payment change order id as we need to merge in new order
                    for (OrderPayment payment : orderWantToMerge.orderPayments) {
                        //orderItem.id = null;
                        payment.order_id = order.id;
                        payment._order_id = order._id;
                        myApp.appDatabase.orderPaymentDao().update(payment);
                        order.order_payments.add(payment);
                    }

                    // order split change order id as we need to merge in new order
                    for (OrderSplit split : orderWantToMerge.orderSplits) {
                        //orderItem.id = null;
                        split.id = null;
                        split.order_id = order.id;
                        split._order_id = order._id;
                        myApp.appDatabase.orderSplitDao().update(split);
                        order.order_splits.add(split);
                    }

                    order.total_paid = order.total_paid + orderWantToMerge.order.total_paid;
                    // update order
                    myApp.appDatabase.orderDao().update(order);
                    // set order status to merge
                    /*orderWantToMerge.order.order_status = mergedStatus.status;
                    orderWantToMerge.order.order_status_id = mergedStatus.id;

                    myApp.appDatabase.orderDao().update(orderWantToMerge.order);*/
                    setStatusToMerge(mergeTable.id);
                    // delete merged order
                    myApp.appDatabase.orderDao().delete(orderWantToMerge.order);
                    deleteOrder(orderWantToMerge.order.id);
                    //}
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void setStatusToMerge(String oldTableId) {
        try {
            new Thread(() -> {
                Table table = appDatabase.tableDao().view(oldTableId);
                table.locked = true;
                table.last_order_id = order.id;
                table._last_order_id = order._id;
                table.table_status_id = mergedStatus.id;
                table.status = mergedStatus.status;
                table.merge_table_id = order.table_id;
                table.updater_id = myPreferences.getLoggedInUser().id;
                appDatabase.tableDao().insert(table);
                if ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()) && myApp.isConnected(NewOrderActivity.this)) {
                    AndroidNetworking.post(ApiEndPoints.tables + table.id)
                            .addApplicationJsonBody(table)
                            .build()
                            .getAsObject(Table.class, new ParsedRequestListener() {
                                @Override
                                public void onResponse(Object response) {

                                }

                                @Override
                                public void onError(ANError anError) {
                                    if (anError.getErrorCode() == 400) {

                                    }
                                }
                            });
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void FetchOrderOfflineRxJava() {
        try {
            Observable.fromCallable(() -> {
                        try {
                            Log.e(" 11 Do in Background", "FetchOrderOfflineAsyncTask");
                            orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                            Log.e(" 22 Do in Background", "FetchOrderOfflineAsyncTask");
                            if (orderWithItems != null) {
                                order = orderWithItems.order;
                                Log.e(" 33 Do in Background", "FetchOrderOfflineAsyncTask");
                                boolean splitException = false;
                                if (order.split_type != null) {
                                    try {
                                        appDatabase.orderSplitDao().updatePaidAmount(_order_id);
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                        splitException = true;
                                    }
                                }
                                order.total_paid = appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id);
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("1")) {
                                    order.order_type = "Dine in";
                                }
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("2")) {
                                    order.order_type = "Collection";
                                }
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("3")) {
                                    order.order_type = "Delivery";
                                }
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("4")) {
                                    order.order_type = "Bar";
                                }
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("5")) {
                                    order.order_type = "Waiting";
                                }
                                if (shouldFetchDeliveryCharge) {
                                    order.delivery_charge = deliveryCharge;
                                }

                                Log.e("deliveryCharge", "" + deliveryCharge + " " + order.delivery_charge);

                                if (serviceChargeVisible) {
                                    SiteSetting services_charges = myApp.findSetting("service_charge_order_type");
                                    if (services_charges != null) {
                                        List<String> split_funcation = Links.split_funcation(services_charges.value);
                                        for (int i = 0; i < split_funcation.size(); i++) {
                                            if (order.order_type.equalsIgnoreCase(split_funcation.get(i))) {
                                                serviceChargeEnabled = true;
                                                break;
                                            } else {
                                                serviceChargeEnabled = false;
                                            }
                                        }
                                    }
                                }

                                if (!Validators.isNullOrEmpty(order.table_id))
                                    order.table_number = appDatabase.tableDao().view(order.table_id).number;

                                order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
                                order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;
                                if (splitException) {
                                    for (OrderSplit orderSplit : order.order_splits) {
                                        orderSplit.paid_amount = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, orderSplit._id);
                                        appDatabase.orderSplitDao().update(orderSplit);
                                    }
                                }
                                order.order_items = new ArrayList<>();
                                orderItems.clear();
                                HashMap<OrderSplit, List<OrderItem>> orderItemsWithSplitId = new HashMap<>();
                                for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                                    OrderItem orderItem = item.orderItem;
                                    orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                                    orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                                    order.order_items.add(orderItem);
                                    if (orderItem._order_split_id == 0) {
                                        orderItems.add(orderItem);
                                    } else {
                                        OrderSplit split = new OrderSplit();
                                        split._id = orderItem._order_split_id;
                                        List<OrderItem> splitOrderItems = new ArrayList<>();
                                        if (selectedSplit != null && split._id == selectedSplit._id) {
                                            if (orderItemsWithSplitId.containsKey(split)) {
                                                splitOrderItems = orderItemsWithSplitId.get(split);
                                            }
                                            splitOrderItems.add(orderItem);
                                        }
                                        orderItemsWithSplitId.put(split, splitOrderItems);
                                    }
                                }
                                //Collections.reverse(orderItems);
                                Collections.sort(orderItems, (o1, o2) -> {
                                    if(Validators.isNullOrEmpty(o1.created_at)){
                                        return 0;
                                    }
                                    Date date = CommonFunctions.convertStringDateToDate(o1.created_at,Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                    Date date1 = CommonFunctions.convertStringDateToDate(o2.created_at,Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                    return (date.getTime() > date1.getTime() ? -1 : 1);
                                });
                                if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("order_item")) {
                                    //We will show none splitted items first.
                                    objects.clear();
                                    objects.addAll(orderItems);

                                    for (Map.Entry<OrderSplit, List<OrderItem>> entry : orderItemsWithSplitId.entrySet()) {
                                        OrderSplit split = appDatabase.orderSplitDao().view(entry.getKey()._id);
                                        if (selectedSplit != null && split._id == selectedSplit._id) {
                                            split.selected = true;
                                        }
                                        LogUtils.e("ONREFRESH : SPLIT: " + new Gson().toJson(split));
                                        objects.add(split);
                                        objects.addAll(entry.getValue());
                                    }
                                    //                    for (OrderSplit split : order.order_splits) {
                                    //                        ArrayList<OrderItem> splitItems = (ArrayList<OrderItem>) appDatabase.orderItemDao().listSplitItems(split._id);
                                    //                        if (splitItems.size() == 0) continue;
                                    //                        objects.add(split);
                                    //                        for (OrderItem oit : splitItems) {
                                    //                            oit.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(oit._id);
                                    //                            oit.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(oit._id);
                                    //                            objects.add(oit);
                                    //                        }
                                    //                    }
                                } else {
                                    objects.clear();
                                    objects.addAll(orderItems);
                                }

                                order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                                if (order.customer == null) {
                                    order.customer = appDatabase.customerDao().view(order.customer_id);
                                }
                                if (order.service_charge == 0) {
                                    Log.e("serviceChargeEnabled", " " + serviceChargeEnabled);
                                    if (serviceChargeEnabled) {
                                        if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                                            float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                                            if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                                cartServiceCharge = serviceChargeValue;
                                            } else {
                                                if (serviceChargeValue > 0) {
                                                    cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                                } else {
                                                    cartServiceCharge = 0;
                                                }
                                            }
                                        }
                                    } else {
                                        cartServiceCharge = 0;
                                    }
                                } else {
                                    cartServiceCharge = order.service_charge;
                                }

                                if (order.split_type != null && order.split_type.equalsIgnoreCase("order_item")) {
                                    cartServiceCharge = 0;
                                    // serviceChargeEnabled = false;
                                    discountEnabled = false;
                                    gratuityEnabled = false;
                                }

                                order.service_charge = cartServiceCharge;
                                cartSubTotal = order.sub_total;
                                cartDiscount = order.discount;
                                cartGratuity = order.gratuity;

                                if (discountEnabled) {
                                    List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                                    if (discounts.size() > 0) {
                                        Discount appliedDiscount = discounts.get(0);
                                        autoDiscountApplied = false;
                                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                                            if (cartSubTotal > 0)
                                                cartDiscount = appliedDiscount.discount;
                                            else cartDiscount = 0;
                                            autoDiscountApplied = true;
                                        }
                                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                                            if (cartSubTotal > 0)
                                                cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                                            else cartDiscount = 0;
                                            autoDiscountApplied = true;
                                        }
                                    } else {
                                        if (autoDiscountApplied) cartDiscount = 0;
                                    }
                                }
                                order.discount = cartDiscount;
                                order.total = ((order.sub_total + order.gratuity + order.service_charge + order.delivery_charge) - order.discount);
                                if (!order.order_status_id.equalsIgnoreCase("5") &&
                                        !order.order_status_id.equalsIgnoreCase("10")) {
                                    if (order.total == 0) {
                                        order.order_status_id = "1";
                                        order.order_status = "Taking Order";
                                    } else if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                                        if (orderCompleteAuto) {
                                            order.order_status_id = "5";
                                            order.order_status = "Order Completed";
                                        } else if (!order.order_status_id.equalsIgnoreCase("6")) {
                                            order.order_status_id = "4";
                                            order.order_status = "Order Paid";
                                        }
                                    } else if (order.total_paid > 0) {
                                        order.order_status_id = "7";
                                        order.order_status = "Part Payment Received";
                                    } else {
                                        if (Validators.isNullOrEmpty(order.order_action_id)) {
                                            order.order_status_id = "1";
                                            order.order_status = "Taking Order";
                                        } else {
                                            if (!order.order_status_id.equalsIgnoreCase("3")) {
                                                order.order_status_id = "2";
                                                order.order_status = "Order Taken";
                                            }
                                        }
                                    }
                                    LogUtils.e("Updating TABLE onrefresh order status " + order.order_status);
                                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                }
                                myApp.appDatabase.orderDao().update(order);
                                myApp.setOrderItems(orderItems);
                                myApp.notifyCart(NewOrderActivity.this, new Intent(Constants.EPOS_CART_UPDATE).putExtra("notify_products", true));

                                PaymentMethod voucherPaymentMethod = appDatabase.paymentMethodDao().view("5");
                                if (order.split_type == null && voucherPaymentMethod != null && !voucherPaymentMethod.disabled) {
                                    OrderPayment voucherPayment = appDatabase.orderPaymentDao().findByMethod(_order_id, "5");
                                    voucherPaymentsEnabled = voucherPayment == null;
                                    voucherPaymentDone = voucherPayment != null;
                                    if (voucherPayment != null) {
                                        voucherPaymentDoneAmount = voucherPayment.amount;
                                    }
                                } else {
                                    voucherPaymentsEnabled = false;
                                }
                                if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("order_item")) {
                                    int nonSplitedItemCount = appDatabase.orderItemDao().listNonSplitItemsCount(_order_id);
                                    shouldOpenSplitScreen = nonSplitedItemCount > 0;
                                } else {
                                    shouldOpenSplitScreen = false;
                                }
                                if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) {
                                    canEditOrder = false;
                                } else {
                                    canEditOrder = CommonFunctions.orderPaymentStatus(order.total, order.total_paid) != 1;
                                }
                            }
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        return true;
                    }) // Execute in IO thread, i.e. background thread.
                    .subscribeOn(Schedulers.io())
                    // report or post the result to main thread.
                    .observeOn(AndroidSchedulers.mainThread())
                    // execute this RxJava
                    .subscribe(new Observer<Boolean>() {
                        @Override
                        public void onSubscribe(Disposable d) {

                        }

                        @Override
                        public void onNext(Boolean success) {
                            // on success. Called on main thread, as defined in .observeOn(AndroidSchedulers.mainThread())
                            try {
                                if (order != null) {
                                   /* if (orderItems!=null&&orderItems.size()>0) {
                                        for (int i = 0; i < orderItems.size(); i++) {
                                            orderItems.get(i).shouldEdit=canEditOrder;
                                        }
                                        objects.clear();
                                        objects.addAll(orderItems);
                                        //orderItemsAdapter.notifyDataSetChanged();
                                        // orderItemsAdapter.shouldEdit = false;
                                    }
                                    orderItemsAdapter.notifyDataSetChanged();*/
                                    updateEditOrderItems(canEditOrder);
                                    uploadOrderImmediately();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    // Upload order on every action
    private void uploadOrderImmediately() {
       /* try {
            isImmediateUploadStarted=true;
            Intent intent = new Intent(this, SingleOrderUploaderService.class);
            intent.putExtra("_order_id", _order_id);
            startService(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }*/
    }

    private void FetchOrderOfflineRxJavaRedirect(boolean redirect) {
        try {
            boolean r = redirect;
            Observable.fromCallable(() -> {
                        try {
                            Log.e(" 11 Do in Background", "FetchOrderOfflineAsyncTask");
                            orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                            if (orderWithItems != null && orderWithItems.order != null && orderWithItems.order.order_items != null) {
                                Log.e(" order_itemsd", " " + orderWithItems.order.order_items.size());
                            }
                            if (orderWithItems != null) {
                                order = orderWithItems.order;
                                Log.e(" 33 Do in Background", "FetchOrderOfflineAsyncTask");
                                boolean splitException = false;
                                if (order.split_type != null) {
                                    try {
                                        appDatabase.orderSplitDao().updatePaidAmount(_order_id);
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                        splitException = true;
                                    }
                                }
                                order.total_paid = appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id);
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("1")) {
                                    order.order_type = "Dine in";
                                }
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("2")) {
                                    order.order_type = "Collection";
                                }
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("3")) {
                                    order.order_type = "Delivery";
                                }
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("4")) {
                                    order.order_type = "Bar";
                                }
                                if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("5")) {
                                    order.order_type = "Waiting";
                                }
                                if (shouldFetchDeliveryCharge) {
                                    order.delivery_charge = deliveryCharge;
                                }

                                Log.e("deliveryCharge", "" + deliveryCharge + " " + order.delivery_charge);

                                if (serviceChargeVisible) {
                                    SiteSetting services_charges = myApp.findSetting("service_charge_order_type");
                                    if (services_charges != null) {
                                        List<String> split_funcation = Links.split_funcation(services_charges.value);
                                        for (int i = 0; i < split_funcation.size(); i++) {
                                            if (order.order_type.equalsIgnoreCase(split_funcation.get(i))) {
                                                serviceChargeEnabled = true;
                                                break;
                                            } else {
                                                serviceChargeEnabled = false;
                                            }
                                        }
                                    }
                                }

                                if (!Validators.isNullOrEmpty(order.table_id))
                                    order.table_number = appDatabase.tableDao().view(order.table_id).number;

                                order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
                                order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;
                                if (splitException) {
                                    for (OrderSplit orderSplit : order.order_splits) {
                                        orderSplit.paid_amount = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, orderSplit._id);
                                        appDatabase.orderSplitDao().update(orderSplit);
                                    }
                                }
                                order.order_items = new ArrayList<>();
                                orderItems.clear();
                                HashMap<OrderSplit, List<OrderItem>> orderItemsWithSplitId = new HashMap<>();
                                for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                                    OrderItem orderItem = item.orderItem;
                                    orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                                    orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                                    order.order_items.add(orderItem);
                                    if (orderItem._order_split_id == 0) {
                                        orderItems.add(orderItem);
                                    } else {
                                        OrderSplit split = new OrderSplit();
                                        split._id = orderItem._order_split_id;
                                        List<OrderItem> splitOrderItems = new ArrayList<>();
                                        if (selectedSplit != null && split._id == selectedSplit._id) {
                                            if (orderItemsWithSplitId.containsKey(split)) {
                                                splitOrderItems = orderItemsWithSplitId.get(split);
                                            }
                                            splitOrderItems.add(orderItem);
                                        }
                                        orderItemsWithSplitId.put(split, splitOrderItems);
                                    }
                                }
                                //Collections.reverse(orderItems);
                                Collections.sort(orderItems, (o1, o2) -> {
                                    if(Validators.isNullOrEmpty(o1.created_at)){
                                        return 0;
                                    }
                                    Date date = CommonFunctions.convertStringDateToDate(o1.created_at,Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                    Date date1 = CommonFunctions.convertStringDateToDate(o2.created_at,Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                    return (date.getTime() > date1.getTime() ? -1 : 1);
                                });
                                if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("order_item")) {
                                    //We will show none splitted items first.
                                    objects.clear();
                                    objects.addAll(orderItems);

                                    for (Map.Entry<OrderSplit, List<OrderItem>> entry : orderItemsWithSplitId.entrySet()) {

                                        OrderSplit split = appDatabase.orderSplitDao().view(entry.getKey()._id);
                                        if (selectedSplit != null && split._id == selectedSplit._id) {
                                            split.selected = true;
                                        }
                                        LogUtils.e("ONREFRESH : SPLIT: " + new Gson().toJson(split));
                                        objects.add(split);
                                        objects.addAll(entry.getValue());
                                    }
                                    //                    for (OrderSplit split : order.order_splits) {
                                    //                        ArrayList<OrderItem> splitItems = (ArrayList<OrderItem>) appDatabase.orderItemDao().listSplitItems(split._id);
                                    //                        if (splitItems.size() == 0) continue;
                                    //                        objects.add(split);
                                    //                        for (OrderItem oit : splitItems) {
                                    //                            oit.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(oit._id);
                                    //                            oit.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(oit._id);
                                    //                            objects.add(oit);
                                    //                        }
                                    //                    }
                                } else {
                                    objects.clear();
                                    objects.addAll(orderItems);
                                }

                                order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                                if (order.customer == null) {
                                    order.customer = appDatabase.customerDao().view(order.customer_id);
                                }
                                if (order.service_charge == 0) {
                                    Log.e("serviceChargeEnabled", " " + serviceChargeEnabled);
                                    if (serviceChargeEnabled) {
                                        if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                                            float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                                            if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                                cartServiceCharge = serviceChargeValue;
                                            } else {
                                                if (serviceChargeValue > 0) {
                                                    cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                                } else {
                                                    cartServiceCharge = 0;
                                                }
                                            }
                                        }
                                    } else {
                                        cartServiceCharge = 0;
                                    }
                                } else {
                                    cartServiceCharge = order.service_charge;
                                }

                                if (order.split_type != null && order.split_type.equalsIgnoreCase("order_item")) {
                                    cartServiceCharge = 0;
                                    // serviceChargeEnabled = false;
                                    discountEnabled = false;
                                    gratuityEnabled = false;
                                }

                                order.service_charge = cartServiceCharge;
                                cartSubTotal = order.sub_total;
                                cartDiscount = order.discount;
                                cartGratuity = order.gratuity;

                                if (discountEnabled) {
                                    List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                                    if (discounts.size() > 0) {
                                        Discount appliedDiscount = discounts.get(0);
                                        autoDiscountApplied = false;
                                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                                            if (cartSubTotal > 0)
                                                cartDiscount = appliedDiscount.discount;
                                            else cartDiscount = 0;
                                            autoDiscountApplied = true;
                                        }
                                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                                            if (cartSubTotal > 0)
                                                cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                                            else cartDiscount = 0;
                                            autoDiscountApplied = true;
                                        }
                                    } else {
                                        if (autoDiscountApplied) cartDiscount = 0;
                                    }
                                }
                                order.discount = cartDiscount;
                                order.total = ((order.sub_total + order.gratuity + order.service_charge + order.delivery_charge) - order.discount);
                                if (!order.order_status_id.equalsIgnoreCase("5") &&
                                        !order.order_status_id.equalsIgnoreCase("10")) {
                                    if (order.total == 0) {
                                        order.order_status_id = "1";
                                        order.order_status = "Taking Order";
                                    } else if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                                        if (orderCompleteAuto) {
                                            order.order_status_id = "5";
                                            order.order_status = "Order Completed";
                                        } else if (!order.order_status_id.equalsIgnoreCase("6")) {
                                            order.order_status_id = "4";
                                            order.order_status = "Order Paid";
                                        }
                                    } else if (order.total_paid > 0) {
                                        order.order_status_id = "7";
                                        order.order_status = "Part Payment Received";
                                    } else {
                                        if (Validators.isNullOrEmpty(order.order_action_id)) {
                                            order.order_status_id = "1";
                                            order.order_status = "Taking Order";
                                        } else {
                                            if (!order.order_status_id.equalsIgnoreCase("3")) {
                                                order.order_status_id = "2";
                                                order.order_status = "Order Taken";
                                            }
                                        }
                                    }
                                    LogUtils.e("Updating TABLE onrefresh order status " + order.order_status);
                                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                }
                                myApp.appDatabase.orderDao().update(order);
                                myApp.setOrderItems(orderItems);
                                myApp.notifyCart(NewOrderActivity.this, new Intent(Constants.EPOS_CART_UPDATE).putExtra("notify_products", true));

                                PaymentMethod voucherPaymentMethod = appDatabase.paymentMethodDao().view("5");
                                if (order.split_type == null && voucherPaymentMethod != null && !voucherPaymentMethod.disabled) {
                                    OrderPayment voucherPayment = appDatabase.orderPaymentDao().findByMethod(_order_id, "5");
                                    voucherPaymentsEnabled = voucherPayment == null;
                                    voucherPaymentDone = voucherPayment != null;
                                    if (voucherPayment != null) {
                                        voucherPaymentDoneAmount = voucherPayment.amount;
                                    }
                                } else {
                                    voucherPaymentsEnabled = false;
                                }
                                if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("order_item")) {
                                    int nonSplitedItemCount = appDatabase.orderItemDao().listNonSplitItemsCount(_order_id);
                                    shouldOpenSplitScreen = nonSplitedItemCount > 0;
                                } else {
                                    shouldOpenSplitScreen = false;
                                }
                                if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) {
                                    canEditOrder = false;
                                } else {
                                    canEditOrder = CommonFunctions.orderPaymentStatus(order.total, order.total_paid) != 1;
                                }
                            }
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        return true;
                    }) // Execute in IO thread, i.e. background thread.
                    .subscribeOn(Schedulers.io())
                    // report or post the result to main thread.
                    .observeOn(AndroidSchedulers.mainThread())
                    // execute this RxJava
                    .subscribe(new Observer<Boolean>() {
                        @Override
                        public void onSubscribe(Disposable d) {

                        }

                        @Override
                        public void onNext(Boolean success) {
                            // on success. Called on main thread, as defined in .observeOn(AndroidSchedulers.mainThread())
                            try {
                                if (order != null) {
                                    updateEditOrderItems(canEditOrder);
                                    uploadOrderImmediately();
                                }

                                LogUtils.e("ORDER::", "AFTER FETCH ORDER: SBUTOTAL::", "cartSubTotal::" + cartSubTotal, "order.sub_total" + order.sub_total, "cartGrandTotal::" + cartGrandTotal, "cartGrandTotal::" + order.total);
                                //orderItemsAdapter.notifyDataSetChanged();
                                if (progressBarDialog != null && progressBarDialog.isShowing()) {
                                    progressBarDialog.dismiss();
                                }
                                updateViews();
                                if (r) {
                                    lockTable(order, null, true);
                                    if (!Validators.isNullOrEmpty(destination)) {
                                        if (destination.equalsIgnoreCase("pay_bill")) {
                                            openPayBillScreen();
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FetchOrderOfflineAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;
        boolean isFromRemoveVoucher;

        public FetchOrderOfflineAsyncTask(Callable<Void> nextMethod, boolean isFromRemoveVoucher) {
            this.isFromRemoveVoucher = isFromRemoveVoucher;
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... paramObjects) {
            try {
                // if from voucher remove delete payment dao for vocuher
                if (isFromRemoveVoucher) {
                    OrderPayment voucherPayment = appDatabase.orderPaymentDao().findByMethod(_order_id, "5");
                    appDatabase.orderPaymentDao().delete(voucherPayment);
                    voucherPaymentDoneAmount = 0F;
                }
                Log.e(" 11 Do in Background", "FetchOrderOfflineAsyncTask");
                orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                Log.e(" 22 Do in Background", "FetchOrderOfflineAsyncTask");
                if (orderWithItems != null) {
                    order = orderWithItems.order;
                    Log.e(" 33 Do in Background", "FetchOrderOfflineAsyncTask");
                    boolean splitException = false;
                    if (order.split_type != null) {
                        try {
                            appDatabase.orderSplitDao().updatePaidAmount(_order_id);
                        } catch (Exception e) {
                            e.printStackTrace();
                            splitException = true;
                        }
                    }
                    order.total_paid = appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id);
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("1")) {
                        order.order_type = "Dine in";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("2")) {
                        order.order_type = "Collection";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("3")) {
                        order.order_type = "Delivery";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("4")) {
                        order.order_type = "Bar";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("5")) {
                        order.order_type = "Waiting";
                    }
                    if (shouldFetchDeliveryCharge) {
                        order.delivery_charge = deliveryCharge;
                    }

                    Log.e("deliveryCharge", "" + deliveryCharge + " " + order.delivery_charge);

                    if (serviceChargeVisible) {
                        SiteSetting services_charges = myApp.findSetting("service_charge_order_type");
                        if (services_charges != null) {
                            List<String> split_funcation = Links.split_funcation(services_charges.value);
                            for (int i = 0; i < split_funcation.size(); i++) {
                                if (order.order_type.equalsIgnoreCase(split_funcation.get(i))) {
                                    serviceChargeEnabled = true;
                                    break;
                                } else {
                                    serviceChargeEnabled = false;
                                }
                            }
                        }
                    }

                    if (!Validators.isNullOrEmpty(order.table_id))
                        order.table_number = appDatabase.tableDao().view(order.table_id).number;

                    order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
                    order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;
                    if (splitException) {
                        for (OrderSplit orderSplit : order.order_splits) {
                            orderSplit.paid_amount = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, orderSplit._id);
                            appDatabase.orderSplitDao().update(orderSplit);
                        }
                    }
                    order.order_items = new ArrayList<>();
                    orderItems.clear();
                    HashMap<OrderSplit, List<OrderItem>> orderItemsWithSplitId = new HashMap<>();
                    for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                        OrderItem orderItem = item.orderItem;
                        orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                        orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                        order.order_items.add(orderItem);
                        if (orderItem._order_split_id == 0) {
                            orderItems.add(orderItem);
                        } else {
                            OrderSplit split = new OrderSplit();
                            split._id = orderItem._order_split_id;
                            List<OrderItem> splitOrderItems = new ArrayList<>();
                            if (selectedSplit != null && split._id == selectedSplit._id) {
                                if (orderItemsWithSplitId.containsKey(split)) {
                                    splitOrderItems = orderItemsWithSplitId.get(split);
                                }
                                splitOrderItems.add(orderItem);
                            }
                            orderItemsWithSplitId.put(split, splitOrderItems);
                        }
                    }
                    //Collections.reverse(orderItems);
                    Collections.sort(orderItems, (o1, o2) -> {
                        if(Validators.isNullOrEmpty(o1.created_at)){
                            return 0;
                        }
                        Date date = CommonFunctions.convertStringDateToDate(o1.created_at,Constants.PHP_DATE_TIME_FORMAT_ZULU);
                        Date date1 = CommonFunctions.convertStringDateToDate(o2.created_at,Constants.PHP_DATE_TIME_FORMAT_ZULU);
                        return (date.getTime() > date1.getTime() ? -1 : 1);
                    });
                    if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("order_item")) {
                        //We will show none splitted items first.
                        objects.clear();
                        objects.addAll(orderItems);

                        for (Map.Entry<OrderSplit, List<OrderItem>> entry : orderItemsWithSplitId.entrySet()) {

                            OrderSplit split = appDatabase.orderSplitDao().view(entry.getKey()._id);
                            if (selectedSplit != null && split._id == selectedSplit._id) {
                                // change paid amount of the selected split group
                                selectedSplit.paid_amount = split.paid_amount;
                                split.selected = true;
                            }
                            LogUtils.e("ONREFRESH : SPLIT: " + new Gson().toJson(split));
                            objects.add(split);
                            objects.addAll(entry.getValue());
                        }
                        //                    for (OrderSplit split : order.order_splits) {
                        //                        ArrayList<OrderItem> splitItems = (ArrayList<OrderItem>) appDatabase.orderItemDao().listSplitItems(split._id);
                        //                        if (splitItems.size() == 0) continue;
                        //                        objects.add(split);
                        //                        for (OrderItem oit : splitItems) {
                        //                            oit.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(oit._id);
                        //                            oit.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(oit._id);
                        //                            objects.add(oit);
                        //                        }
                        //                    }
                    } else {
                        objects.clear();
                        objects.addAll(orderItems);
                    }

                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                    if (order.customer == null) {
                        order.customer = appDatabase.customerDao().view(order.customer_id);
                    }
                    if (order.service_charge == 0) {
                        Log.e("serviceChargeEnabled", " " + serviceChargeEnabled);
                        if (serviceChargeEnabled) {
                            if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                                float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                                if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                    cartServiceCharge = serviceChargeValue;
                                } else {
                                    if (serviceChargeValue > 0) {
                                        cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                    } else {
                                        cartServiceCharge = 0;
                                    }
                                }
                            }
                        } else {
                            cartServiceCharge = 0;
                        }
                    } else {
                        cartServiceCharge = order.service_charge;
                    }

                    if (order.split_type != null && order.split_type.equalsIgnoreCase("order_item")) {
                        cartServiceCharge = 0;
                        // serviceChargeEnabled = false;
                        discountEnabled = false;
                        gratuityEnabled = false;
                    }

                    order.service_charge = cartServiceCharge;
                    cartSubTotal = order.sub_total;
                    cartDiscount = order.discount;
                    cartGratuity = order.gratuity;

                    if (discountEnabled) {
                        List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                        if (discounts.size() > 0) {
                            Discount appliedDiscount = discounts.get(0);
                            autoDiscountApplied = false;
                            if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                                if (cartSubTotal > 0)
                                    cartDiscount = appliedDiscount.discount;
                                else cartDiscount = 0;
                                autoDiscountApplied = true;
                            }
                            if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                                if (cartSubTotal > 0)
                                    cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                                else cartDiscount = 0;
                                autoDiscountApplied = true;
                            }
                        } else {
                            if (autoDiscountApplied) cartDiscount = 0;
                        }
                    }
                    order.discount = cartDiscount;
                    order.total = ((order.sub_total + order.gratuity + order.service_charge + order.delivery_charge) - order.discount);
                    if (!order.order_status_id.equalsIgnoreCase("5") &&
                            !order.order_status_id.equalsIgnoreCase("10")) {
                        if (order.total == 0) {
                            order.order_status_id = "1";
                            order.order_status = "Taking Order";
                        } else if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                            if (orderCompleteAuto) {
                                order.order_status_id = "5";
                                order.order_status = "Order Completed";
                            } else if (!order.order_status_id.equalsIgnoreCase("6")) {
                                order.order_status_id = "4";
                                order.order_status = "Order Paid";
                            }
                        } else if (order.total_paid > 0) {
                            order.order_status_id = "7";
                            order.order_status = "Part Payment Received";
                        } else {
                            if (Validators.isNullOrEmpty(order.order_action_id)) {
                                order.order_status_id = "1";
                                order.order_status = "Taking Order";
                            } else {
                                if (!order.order_status_id.equalsIgnoreCase("3")) {
                                    order.order_status_id = "2";
                                    order.order_status = "Order Taken";
                                }
                            }
                        }
                        LogUtils.e("Updating TABLE onrefresh order status " + order.order_status);
                        order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    }
                    myApp.appDatabase.orderDao().update(order);
                    myApp.setOrderItems(orderItems);
                    myApp.notifyCart(NewOrderActivity.this, new Intent(Constants.EPOS_CART_UPDATE).putExtra("notify_products", true));

                    PaymentMethod voucherPaymentMethod = appDatabase.paymentMethodDao().view("5");
                    if (order.split_type == null && voucherPaymentMethod != null && !voucherPaymentMethod.disabled) {
                        OrderPayment voucherPayment = appDatabase.orderPaymentDao().findByMethod(_order_id, "5");
                        voucherPaymentsEnabled = voucherPayment == null;
                        voucherPaymentDone = voucherPayment != null;
                        if (voucherPayment != null) {
                            voucherPaymentDoneAmount = voucherPayment.amount;
                        }
                    } else {
                        voucherPaymentsEnabled = false;
                    }
                    if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("order_item")) {
                        int nonSplitedItemCount = appDatabase.orderItemDao().listNonSplitItemsCount(_order_id);
                        shouldOpenSplitScreen = nonSplitedItemCount > 0;
                    } else {
                        shouldOpenSplitScreen = false;
                    }
                    if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) {
                        canEditOrder = false;
                    } else {
                        canEditOrder = CommonFunctions.orderPaymentStatus(order.total, order.total_paid) != 1;
                    }
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            /*try{
                OrderItem orderItem = (OrderItem) objects.get(0);
                Log.e("Order",":"+orderItem.toString());
            }catch (Exception e){
                e.printStackTrace();
            }*/

            try {
                if (order != null) {
                    //orderItemsAdapter.shouldEdit = canEditOrder;
                    /*if (orderItems!=null&&orderItems.size()>0) {
                        for (int i = 0; i < orderItems.size(); i++) {
                            orderItems.get(i).shouldEdit=canEditOrder;
                        }
                        objects.clear();
                        objects.addAll(orderItems);
                        // orderItemsAdapter.shouldEdit = false;
                    }
                    orderItemsAdapter.notifyDataSetChanged();*/
                    updateEditOrderItems(canEditOrder);
                }
                if (nextMethod != null) {
                    try {
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    // Handle item click based on argument {isEdit}
    // It was found on firebase
    private void updateEditOrderItems(boolean isEdit) {
        try {
            if (objects != null && objects.size() > 0) {
                for (int i = 0; i < objects.size(); i++) {
                    Object obj = objects.get(i);
                    if (obj instanceof OrderItem) {
                        ((OrderItem) obj).shouldEdit = isEdit;
                    }
                }
            }
            rvOrderItems.post(() -> orderItemsAdapter.notifyDataSetChanged());
        } catch (Exception e) {
            e.printStackTrace();
            rvOrderItems.post(() -> orderItemsAdapter.notifyDataSetChanged());
        }
    }

    private class AddOrUpdateOrderItemAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public AddOrUpdateOrderItemAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                if (objects[0] instanceof OrderItem) {
                    OrderItem orderItem = (OrderItem) objects[0];
                    orderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    orderItem._order_id = _order_id;
                    orderItem.order_id = order.id;
                    orderItem.updater_id = myPreferences.getLoggedInUser().id;
                    OrderItem itemToBeUpdated = null;
                    if (selectedSplit == null || selectedSplit.paid_amount > 0) {
                        List<OrderItem> dbOrderItems = appDatabase.orderItemDao().findOldItemsToIncrementWithoutAddonsIngredient(_order_id, orderItem.product_id);
                        for (OrderItem dbOrderItem : dbOrderItems) {
                            boolean canWeUpdate = true;
                            dbOrderItem.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(dbOrderItem._id);
                            dbOrderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(dbOrderItem._id);
                            String whyCantUpdate = "";
                            if (dbOrderItem.order_item_ingredients.size() > 0) {
                                canWeUpdate = false;
                            }
                            if (canWeUpdate) {
                                if (dbOrderItem.order_item_addons.size() == orderItem.order_item_addons.size()) {
                                    // Check every addon;
                                    for (OrderItemAddon orderItemAddon : orderItem.order_item_addons) {
                                        int addonIndex = dbOrderItem.order_item_addons.indexOf(orderItemAddon);
                                        if (addonIndex == -1) {
                                            canWeUpdate = false;
                                            break;
                                        }
                                        OrderItemAddon dbOrderItemAddon = dbOrderItem.order_item_addons.get(addonIndex);
                                        if (!dbOrderItemAddon.addon_id.equals(orderItemAddon.addon_id)) {
                                            canWeUpdate = false;
                                            break;
                                        }
                                        if (dbOrderItemAddon.quantity != orderItemAddon.quantity) {
                                            canWeUpdate = false;
                                            break;
                                        }
                                    }
                                } else {
                                    canWeUpdate = false;
                                }
                            }
                            if (canWeUpdate) {
                                itemToBeUpdated = dbOrderItem;
                                break;
                            }
                        }
                    }

                    if (itemToBeUpdated != null) {
                        itemToBeUpdated.quantity = itemToBeUpdated.quantity + orderItem.quantity;
                        itemToBeUpdated.sent_to_kitchen_quantity = itemToBeUpdated.sent_to_kitchen_quantity + orderItem.quantity;

                        float addonTotal = 0;
                        for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                            addonTotal = addonTotal + itemAddon.total;
                        }
                        float ingredientTotal = 0;
                        for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                            ingredientTotal = addonTotal + itemIngredient.total;
                        }
                        itemToBeUpdated.ingredients_price = ingredientTotal * itemToBeUpdated.quantity;
                        itemToBeUpdated.addons_price = addonTotal * itemToBeUpdated.quantity;
                        itemToBeUpdated.sub_total = itemToBeUpdated.quantity * itemToBeUpdated.price;
                        itemToBeUpdated.total = itemToBeUpdated.sub_total + itemToBeUpdated.addons_price + itemToBeUpdated.ingredients_price + (itemToBeUpdated.instruction_price * itemToBeUpdated.quantity);
                        itemToBeUpdated.sent_to_kitchen = false;
                        itemToBeUpdated.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                        appDatabase.orderItemDao().update(itemToBeUpdated);
                    } else {
                        orderItem.sent_to_kitchen_quantity = orderItem.sent_to_kitchen_quantity + orderItem.quantity;
                        if (selectedSplit != null && selectedSplit.paid_amount == 0) {
                            // add selected group unique id to item
                            orderItem.unique_id = selectedSplit.unique_id;
                            orderItem._order_split_id = selectedSplit._id;
                            orderItem.order_split_id = selectedSplit.id;
                        }
                        int dbOrderItemId = 0;
                        if (orderItem._id > 0) {
                            orderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            appDatabase.orderItemDao().update(orderItem);
                            dbOrderItemId = orderItem._id;
                        } else {
                            // check item is in database or not before inserting
                            List<OrderItem> dbOrderItems = appDatabase.orderItemDao().findOldItemsToIncrementWithoutAddonsIngredient(_order_id, orderItem.product_id);
                            for (OrderItem dbOrderItem : dbOrderItems) {
                                boolean canWeUpdate = true;
                                dbOrderItem.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(dbOrderItem._id);
                                dbOrderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(dbOrderItem._id);
                                String whyCantUpdate = "";
                                if (dbOrderItem.order_item_ingredients.size() > 0) {
                                    canWeUpdate = false;
                                }
                                if (canWeUpdate) {
                                    if (dbOrderItem.order_item_addons.size() == orderItem.order_item_addons.size()) {
                                        // Check every addon;
                                        for (OrderItemAddon orderItemAddon : orderItem.order_item_addons) {
                                            int addonIndex = dbOrderItem.order_item_addons.indexOf(orderItemAddon);
                                            if (addonIndex == -1) {
                                                canWeUpdate = false;
                                                break;
                                            }
                                            OrderItemAddon dbOrderItemAddon = dbOrderItem.order_item_addons.get(addonIndex);
                                            if (!dbOrderItemAddon.addon_id.equals(orderItemAddon.addon_id)) {
                                                canWeUpdate = false;
                                                break;
                                            }
                                            if (dbOrderItemAddon.quantity != orderItemAddon.quantity) {
                                                canWeUpdate = false;
                                                break;
                                            }
                                        }
                                    } else {
                                        canWeUpdate = false;
                                    }
                                }
                                if (canWeUpdate) {
                                    itemToBeUpdated = dbOrderItem;
                                    break;
                                }
                            }
                            if (itemToBeUpdated != null) {
                                itemToBeUpdated.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                appDatabase.orderItemDao().update(itemToBeUpdated);
                                dbOrderItemId = orderItem._id;
                            } else {
                                orderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                                dbOrderItemId = (int) appDatabase.orderItemDao().insert(orderItem);
                            }
                        }
                        float addonTotal = 0;
                        if (orderItem.order_item_addons != null) {
                            for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                itemAddon._order_item_id = dbOrderItemId;
                                itemAddon.total = itemAddon.quantity * itemAddon.price;
                                addonTotal = addonTotal + itemAddon.total;
                            }
                            appDatabase.orderItemAddonDao().insertAll(orderItem.order_item_addons);
                        }

                        float ingredientTotal = 0;
                        if (orderItem.order_item_ingredients != null) {
                            for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                itemIngredient._order_item_id = dbOrderItemId;
                                itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                ingredientTotal = ingredientTotal + itemIngredient.total;
                            }
                            appDatabase.orderItemIngredientDao().insertAll(orderItem.order_item_ingredients);
                        }

                        ingredientTotal = ingredientTotal * orderItem.quantity;
                        addonTotal = addonTotal * orderItem.quantity;
                        appDatabase.orderItemDao().updateOrderItemTotal(dbOrderItemId, addonTotal, ingredientTotal);
                        if (selectedSplit != null && selectedSplit.paid_amount == 0) {
                            appDatabase.orderSplitDao().updateTotalAmount(orderItem._order_id, selectedSplit._id);
                        }
                    }
                    LogUtils.e("Order Item List::" + new Gson().toJson(myApp.appDatabase.orderItemDao().list(order._id)));

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);

            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class UpdateCustomerAsynTask extends AsyncTask<Customer, String, String> {

        Callable<Void> nextMethod;

        public UpdateCustomerAsynTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(Customer... customers) {
            try {
                Customer customer = customers[0];
                if (order.order_type_id.equalsIgnoreCase("1")) {
                    order.no_guest = String.valueOf(customer.no_guest);
                } else {
                    order.no_guest = "1";
                }

                if (customer._id == 0)
                    customer._id = (int) appDatabase.customerDao().insert(customer);
                else
                    appDatabase.customerDao().update(customer);


                Log.e("Distance", " " + customer.distance);
                order._customer_id = customer._id;
                order.customer_id = customer.id;
                order.customer_name = customer.name;
                order.customer.distance = customer.distance;
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                appDatabase.orderDao().update(order);

                Log.e("Distance", " " + order.customer.distance);
                shouldFetchDeliveryCharge = order.order_type_id.equalsIgnoreCase("3");
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String c) {
            super.onPostExecute(c);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class PrepLocationSenderAsync extends AsyncTask<String, String, String> {
        HashMap<PrepLocation, List<OrderItem>> prepOrderItems = new HashMap<>();
        String title;
        boolean updatedOrder;
        Callable<Void> nextMethod;

        public PrepLocationSenderAsync(String title, boolean updatedOrder, Callable<Void> nextMethod) {
            this.title = title;
            this.updatedOrder = updatedOrder;
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {

            try {
                ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) appDatabase.prepLocationDao().list();
                for (PrepLocation prepLocation : prepLocations) {
                    List<OrderItem> miscPrepOits = new ArrayList<>();
                    List<OrderItem> prepOits = new ArrayList<>();
                    List<OrderItem> prepOitsTypePrice = new ArrayList<>();
                    List<OrderItem> allOits = new ArrayList<>();
                    /**
                     * Commenting order type wise fetching misc items, now it will get data from prep location id
                     */
                    if (updatedOrder) {
                        if (order.order_type.equalsIgnoreCase("Collection")) {
                            // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsCollection(order._id, prepLocation.id, false);
                            prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsCollectionKitchen(order._id, prepLocation.id);
                        } else if (order.order_type.equalsIgnoreCase("Delivery")) {
                            // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsDelivery(order._id, prepLocation.id, false);
                            prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsDeliveryKitchen(order._id, prepLocation.id);
                        } else if (order.order_type.equalsIgnoreCase("Waiting")) {
                            // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsBanquet(order._id, prepLocation.id, false);
                            prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsBanquetKitchen(order._id, prepLocation.id);
                        } else {
                            //miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id, prepLocation.id, false);
                            prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsKitchen(order._id, prepLocation.id);
                        }
                        //miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id, prepLocation.id, false);
                        miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsKitchen(order._id, prepLocation.id);
                    } else {
                        if (order.order_type.equalsIgnoreCase("Collection")) {
                            // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsCollection(order._id, prepLocation.id);
                            prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsCollection(order._id, prepLocation.id);
                        } else if (order.order_type.equalsIgnoreCase("Delivery")) {
                            //  miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsDelivery(order._id, prepLocation.id);
                            prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsDelivery(order._id, prepLocation.id);
                        } else if (order.order_type.equalsIgnoreCase("Waiting")) {
                            // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsBanquet(order._id, prepLocation.id);
                            prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsBanquet(order._id, prepLocation.id);
                        } else {
                            // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id, prepLocation.id);
                            prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocations(order._id, prepLocation.id);
                        }
                        miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id, prepLocation.id);
                    }

                    if (miscPrepOits != null && miscPrepOits.size() > 0) {
                        allOits.addAll(miscPrepOits);
                    }
                    List<OrderItem> prepOitsPrice = new ArrayList<>();
                    prepOitsPrice.addAll(prepOits);

                    if (!Validators.isNullOrEmpty(order.order_type)) {
                        prepOitsTypePrice.clear();
                        for (OrderItem item : prepOits) {
                            OrderItem orderItem = new OrderItem();
                            for (OrderItem oi : prepOitsPrice) {
                                if (oi._id == item._id) {
                                    if (order.order_type.equalsIgnoreCase("collection") || order.order_type.equalsIgnoreCase("takeaway")) {
                                        oi.price = item.takeaway_price;
                                    } else if (order.order_type.equalsIgnoreCase("waiting")) {
                                        oi.price = item.waiting_price;
                                    } else if (order.order_type.equalsIgnoreCase("delivery")) {
                                        oi.price = item.delivery_price;
                                    } else {
                                        oi.price = item.price;
                                    }
                                    OrderItem localItem = appDatabase.orderItemDao().view(oi._id);
                                    if (localItem != null) {
                                        oi.id = localItem.id;
                                    }
                                    orderItem = oi;
                                }
                            }
                            prepOitsTypePrice.add(orderItem);
                        }

                    }

                    if (prepOitsTypePrice != null && prepOitsTypePrice.size() > 0) {
                        allOits.addAll(prepOitsTypePrice);
                    }
                    if (allOits.size() > 0) {
                        prepOrderItems.put(prepLocation, allOits);
                        for (OrderItem oit : allOits) {
                            int kitchenCopyCount = oit.sent_to_kitchen_quantity;
                            oit.sent_to_kitchen = true;
                            oit.sent_to_kitchen_quantity = 0;
                            oit.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            appDatabase.orderItemDao().update(oit);
                            if (updatedOrder) {
                                oit.sent_to_kitchen_quantity_for_local_use = kitchenCopyCount;
                            } else {
                                oit.sent_to_kitchen_quantity_for_local_use = 0;
                            }
                        }
                    }
                    for (Map.Entry<PrepLocation, List<OrderItem>> entry : prepOrderItems.entrySet()) {
                        for (OrderItem orderItem : (ArrayList<OrderItem>) entry.getValue()) {
                            orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(orderItem._id);
                            orderItem.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(orderItem._id);
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                int position = 0;
                for (Map.Entry<PrepLocation, List<OrderItem>> entry : prepOrderItems.entrySet()) {
                    position++;
                    PrepLocation prepLocation = entry.getKey();
                    if (printers == null) {
                        ToastUtils.makeToast(NewOrderActivity.this, "Business printers are null");
                        continue;
                    }
                    Printer prepPrinter = null;
                    for (Printer pp : printers) {
                        Log.e("Printer ", " " + pp.id);
                        Log.e("Printer Prep ", " " + prepLocation.printer_id);
                        if (prepLocation.printer_id.equalsIgnoreCase(pp.id)) {
                            prepPrinter = pp;
                        }
                    }
                    if (prepPrinter == null) {
                        ToastUtils.makeToast(NewOrderActivity.this, "Preplocation printer not found,: " + prepLocation.printer_name);
                        continue;
                    }
                    if (defaultPrinter == null && forceFullyDefaultPrinter != null && prepPrinter.ip.equalsIgnoreCase(forceFullyDefaultPrinter.ip)) {
                        ToastUtils.makeToast(NewOrderActivity.this, "Preplocation printer also same as default and its not connected");
                        continue;
                    }

                    Order tempOrder = new Gson().fromJson(new Gson().toJson(order), Order.class);
                    tempOrder.order_items = (ArrayList<OrderItem>) entry.getValue();
                    Log.e("OrderItems", ":" + tempOrder.order_items.toString());
                    String printSettingName = "";
                    if (printSettings != null) {
                        for (int i = 0; i < printSettings.size(); i++) {
                            if (printSettings.get(i).name.equalsIgnoreCase("Prep Ticket") || printSettings.get(i).name.equalsIgnoreCase("Custom Prep Ticket")) {
                                printSettingName = printSettings.get(i).name;
                                printStructure = printSettings.get(i).print_structure;
                                listPrintStructure = printSettings.get(i).list_print_structure;
                                break;
                            }
                        }
                    }

                    if (tempOrder.order_items != null && tempOrder.order_items.size() > 0) {
                        int numberOfPrint = 0;
                        Business business = myApp.myPreferences.getLoggedInAdmin().selected_business;
                        if (order.order_type.equalsIgnoreCase("Collection")) {
                            if (business.collection_number_of_print == null) {
                                numberOfPrint = 1;
                            } else {
                                numberOfPrint = Integer.parseInt(business.collection_number_of_print);
                            }
                        } else if (order.order_type.equalsIgnoreCase("Delivery")) {
                            numberOfPrint = Integer.parseInt(business.delivery_number_of_print);
                        } else if (order.order_type.equalsIgnoreCase("Waiting")) {
                            if (business.collection_number_of_print == null) {
                                numberOfPrint = 1;
                            } else {
                                numberOfPrint = Integer.parseInt(business.collection_number_of_print);
                            }
                        } else if (order.order_type.equalsIgnoreCase("Dine in")) {
                            numberOfPrint = Integer.parseInt(business.dinein_number_of_print);
                        } else {
                            numberOfPrint = Integer.parseInt(business.online_order_number_of_print);
                        }
                        for (int i = 0; i < numberOfPrint; i++) {
                            if (prepPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                zoneRichPrinter.connectPrinter(prepPrinter.ip);
                                LogUtils.e("Printer IP: " + prepPrinter.id);
                                CommonFunctions.functionThatDelay(250);
                                sendOrderToWifi(title, true, tempOrder);
                                if (printSettingName.equalsIgnoreCase("Custom Prep Ticket")) {
                                    zoneRichPrinter.printOrderEposFoodHubSeqeunce(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, listPrintStructure, footerA, footerB, footerHeading, settingsMap, true, myApp.myPreferences, voucherPaymentDoneAmount);//                            zoneRichPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB,footerHeading, true, false);
                                } else {
                                    zoneRichPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, true, myApp.myPreferences, voucherPaymentDoneAmount);//                            zoneRichPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB,footerHeading, true, false);
                                }
                                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                    zoneRichPrinter.connectPrinter(prepPrinter.ip);
                                    CommonFunctions.functionThatDelay(250);
                                    zoneRichPrinter.openCashDrawer();
                                }
                            } else if (prepPrinter.printer_model_name.toLowerCase().contains("t2") || prepPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                                if (printSettingName.equalsIgnoreCase("Custom Prep Ticket")) {
                                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                        sunmiPrinterV3Mix.printOrderEposFoodHubSeqeunce(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, true, myPreferences, voucherPaymentDoneAmount);
                                    } else {
                                        sunmiPrinter.printOrderEposFoodHubSeqeunce(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, true, myPreferences, voucherPaymentDoneAmount);
                                    }
                                } else {
                                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                        sunmiPrinterV3Mix.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, true, myPreferences, voucherPaymentDoneAmount);
                                    } else {
                                        sunmiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, true, myPreferences, voucherPaymentDoneAmount);
                                    }
                                }
                                sendOrderToWifi(title, true, tempOrder);
//                            sunmiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB,footerHeading, true, false);
                                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                        sunmiPrinterV3Mix.openCashDrawer();
                                    } else {
                                        sunmiPrinter.openCashDrawer();
                                    }
                                }
                            } else if (prepPrinter.printer_model_name.toLowerCase().contains("pos-80") || prepPrinter.printer_model_name.toLowerCase().contains("pos 80") || prepPrinter.printer_model_name.toLowerCase().contains("yoke4") || prepPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || prepPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                if (prepPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                    if (printSettingName.equalsIgnoreCase("Custom Prep Ticket")) {
                                        myApp.iMinPrinterUtils.printOrderEposFoodHubSeqeunce(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, true);
                                    } else {
                                        myApp.iMinPrinterUtils.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, true, myApp.myPreferences);
                                    }
                                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                        IminSDKManager.opencashBox();
                                    }
                                } else {
                                    if (prepPrinter.ip != null && !prepPrinter.ip.equalsIgnoreCase("")) {
                                        wifiPrinter.disconnect();
                                        CommonFunctions.functionThatDelay(200);
                                        if (wifiPrinter.connectionFlag == 0) {
                                            wifiPrinter.connect(prepPrinter.ip);
                                        }
                                        CommonFunctions.functionThatDelay(200);
                                        if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                            wifiPrinter.openCashDrawer(false);
                                        }
                                        wifiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, true, myPreferences);
//                                wifiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB,footerHeading, true, false);
                                    } else {
                                        try {
                                            if (bluetoothPrinter != null) {
                                                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                if (device != null) {
                                                    CommonFunctions.functionThatDelay(200);
                                                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                                        bluetoothPrinter.openCashDrawer(false);
                                                        CommonFunctions.functionThatDelay(200);
                                                    }
                                                    bluetoothPrinter.printEposOrder(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, true, false);
                                                    CommonFunctions.functionThatDelay(200);
                                                } else {
                                                    showToastInPostExecute(true);
                                                    //ToastUtils.makeToast(NewOrderActivity.this, "No bluetooth device found.");
                                                }
                                            }
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (prepOrderItems != null && position >= prepOrderItems.size()) {
                    try {
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                myApp.isCashDrawerOpen = false;
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendOrderToWifi(String title, boolean isKitchen, Order tempOrder) {
        /*if (myPreferences.getWifiConnectionId() != null) {
            SendOrderWifiModel sendOrderWifiModel = new SendOrderWifiModel(myApp.businessLogo, title != null ? title : "", (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, dateTimeModeInPrint, tempOrder, footerA, footerB, footerHeading, printStructure, headerAlignment,
                    printTotalInPrint, isKitchen, settingsMap, MyApp.getInstance().findSetting("print_block_bill"), MyApp.getInstance().myPreferences.getLoggedInUser().username, "", "", false);
            Logger.INSTANCE.sendText(myPreferences.getWifiConnectionId(), new Gson().toJson(sendOrderWifiModel));
        }*/
    }

    class OrderItemsPrintBlockAsync extends AsyncTask<Integer, Integer, Integer> {
        String title;
        ArrayList<OrderItem> groupedOrderItems = new ArrayList<>();
        Callable<Void> nextMethod;


        public OrderItemsPrintBlockAsync(String title, Callable<Void> nextMethod) {
            this.title = title;
            this.nextMethod = nextMethod;
        }

        @Override
        protected Integer doInBackground(Integer... integers) {
            try {
                List<OrderItem> miscOrderItems;
                List<OrderItem> productOrderItems;

                int _split_id = 0;
                if (integers.length > 0) {
                    _split_id = integers[0];
                    miscOrderItems = appDatabase.orderItemDao().orderItemsMiscForPrint(order._id, _split_id);
                    productOrderItems = appDatabase.orderItemDao().orderItemProductForPrint(order._id, _split_id);
                } else {
                    miscOrderItems = appDatabase.orderItemDao().orderItemsMiscForPrint(order._id);
                    productOrderItems = appDatabase.orderItemDao().orderItemProductForPrint(order._id);
                }

                if (miscOrderItems != null && miscOrderItems.size() > 0) {
                    groupedOrderItems.addAll(miscOrderItems);
                }

                if (productOrderItems != null && productOrderItems.size() > 0) {
                    groupedOrderItems.addAll(productOrderItems);
                }

                for (int i = 0; i < groupedOrderItems.size(); i++) {
                    OrderItem orderItems_object = groupedOrderItems.get(i);
                    orderItems_object.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(orderItems_object._id);
                    orderItems_object.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(orderItems_object._id);
                    groupedOrderItems.set(i, orderItems_object);
                }

                if (_split_id > 0) {
                    float total = 0;
                    // get total amount from all split persons
                    if ("manual".equalsIgnoreCase(myPreferences.getOrderSyncMode()) || !myApp.isConnected(NewOrderActivity.this)) {
                        List<OrderSplit> orderSplitList = appDatabase.orderSplitDao().list(order._id);
                        if (orderSplitList != null && orderSplitList.size() > 0) {
                            for (int i = 0; i < orderSplitList.size(); i++) {
                                total = total + orderSplitList.get(i).total;
                            }
                        } else {
                            OrderSplit orderSplit = appDatabase.orderSplitDao().view(_split_id);
                            total = orderSplit.total;
                        }
                    } else {
                        List<OrderSplit> orderSplitList = null;
                        if (order.id == null) {
                            orderSplitList = appDatabase.orderSplitDao().list(order._id);
                        } else {
                            orderSplitList = appDatabase.orderSplitDao().list(order.id);
                        }
                        if (orderSplitList != null && orderSplitList.size() > 0) {
                            for (int i = 0; i < orderSplitList.size(); i++) {
                                total = total + orderSplitList.get(i).total;
                            }
                        } else {
                            OrderSplit orderSplit = appDatabase.orderSplitDao().view(_split_id);
                            total = orderSplit.total;
                        }
                    }
                    order.total = total;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            return 0;
        }

        @Override
        protected void onPostExecute(Integer integer) {
            super.onPostExecute(integer);
            try {
                Order tempOrder = new Gson().fromJson(new Gson().toJson(order), Order.class);
                if (splitByPersonPrint) {
                    tempOrder.total = printableTotal;
                }

                tempOrder.order_items = groupedOrderItems;
                String printSettingName = "";
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Bill")) {
                        printSettingName = printSettings.get(i).name;
                        printStructure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                    }
                }
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                    CommonFunctions.functionThatDelay(250);
                    if (printSettingName.equalsIgnoreCase("Custom Bill")) {
                        zoneRichPrinter.printOrderEposFoodHubSeqeunce(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, listPrintStructure, footerA, footerB, footerHeading, settingsMap, false, myApp.myPreferences, voucherPaymentDoneAmount);
                    } else {
                        zoneRichPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, false, myApp.myPreferences, voucherPaymentDoneAmount);
                    }
                    sendOrderToWifi(title, true, tempOrder);
//                    zoneRichPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, true, footerA, footerB,footerHeading, false, false);
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    if (printSettingName.equalsIgnoreCase("Custom Bill")) {
                        if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                            sunmiPrinterV3Mix.printOrderEposFoodHubSeqeunce(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, false, myPreferences, voucherPaymentDoneAmount);
                        } else {
                            sunmiPrinter.printOrderEposFoodHubSeqeunce(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, false, myPreferences, voucherPaymentDoneAmount);
                        }
                    } else {
                        if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                            sunmiPrinterV3Mix.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, false, myPreferences, voucherPaymentDoneAmount);
                        } else {
                            sunmiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, false, myPreferences, voucherPaymentDoneAmount);
                        }
                    }
                    sendOrderToWifi(title, true, tempOrder);
//                    sunmiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, true, footerA, footerB,footerHeading, false, false);
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        if (printSettingName.equalsIgnoreCase("Custom Bill")) {
                            myApp.iMinPrinterUtils.printOrderEposFoodHubSeqeunce(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, false);
                        } else {
                            myApp.iMinPrinterUtils.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, false, myApp.myPreferences);
                        }
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            CommonFunctions.functionThatDelay(200);
                            if (wifiPrinter.connectionFlag == 0) {
                                wifiPrinter.connect(defaultPrinter.ip);
                            }
                            CommonFunctions.functionThatDelay(500);
                            wifiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, dateTimeModeInPrint, printTotalInPrint, tempOrder, printStructure, footerA, footerB, footerHeading, settingsMap, false, myPreferences);
//                        wifiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, false, false);
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        bluetoothPrinter.printEposOrder(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, false, false);
                                        CommonFunctions.functionThatDelay(200);
                                    } else {
                                        showToastInPostExecute(true);
                                        //ToastUtils.makeToast(NewOrderActivity.this, "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                myApp.isCashDrawerOpen = false;
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    }


    @Override
    public boolean dispatchTouchEvent(MotionEvent event) {
        View view = getCurrentFocus();
        boolean ret = super.dispatchTouchEvent(event);

        if (view instanceof EditText) {
            View w = getCurrentFocus();
            int scrcoords[] = new int[2];
            w.getLocationOnScreen(scrcoords);
            float x = event.getRawX() + w.getLeft() - scrcoords[0];
            float y = event.getRawY() + w.getTop() - scrcoords[1];

            if (event.getAction() == MotionEvent.ACTION_UP
                    && (x < w.getLeft() || x >= w.getRight()
                    || y < w.getTop() || y > w.getBottom())) {
                InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
                imm.hideSoftInputFromWindow(getWindow().getCurrentFocus().getWindowToken(), 0);
            }
        }
        return ret;
    }

    private void disconnectBTPrinter() {
        try {
            if (bluetoothPrinter != null) {
                BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                if (device != null) {
                    bluetoothPrinter.closeBTPrinter();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generatePaymentLink(String title, boolean kitchenCopy, boolean goBack, boolean updateOrder, boolean isFromCreateBillPrint) {
        try {
            if (kitchenCopy || !selectedBusiness.is_qr_print_on_bill) {
                createCopy(title, kitchenCopy, goBack, updateOrder, isFromCreateBillPrint);
            } else {
                progressBarDialog.show();
                AndroidNetworking.post(ApiEndPoints.online_payment_links)
                        .addBodyParameter("phone", "")
                        .addBodyParameter("secretkey", stripe_private_key)
                        .addBodyParameter("publishkey", stripe_public_key)
                        .addBodyParameter("amount", String.valueOf(order.total))
                        .addBodyParameter("name", selectedBusiness.name)
                        .addBodyParameter("business_id", selectedBusiness.id)
                        .addBodyParameter("order_id", order.unique_id)
                        .addBodyParameter("qr", "1")
                        .addBodyParameter("device_id", myPreferences.getUserFCMToken())
                        .addBodyParameter("description", selectedBusiness.statement_description)
                        .addBodyParameter("descriptor", selectedBusiness.statement_descriptor)
                        .build()
                        .getAsJSONObject(new JSONObjectRequestListener() {
                            @Override
                            public void onResponse(JSONObject response) {
                                try {
                                    progressBarDialog.dismiss();
                                    myApp.paymentLinkBitmap = new QRGEncoder(response.getString("payment_link"), null, QRGContents.Type.TEXT, 300).getBitmap(0);
                                    createCopy(title, kitchenCopy, goBack, updateOrder, isFromCreateBillPrint);
                                } catch (Exception e) {
                                    myApp.paymentLinkBitmap = null;
                                    createCopy(title, kitchenCopy, goBack, updateOrder, isFromCreateBillPrint);
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                myApp.paymentLinkBitmap = null;
                                progressBarDialog.dismiss();
                                createCopy(title, kitchenCopy, goBack, updateOrder, isFromCreateBillPrint);
                            }
                        });
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void createCopy(String title, boolean kitchenCopy, boolean goBack, boolean updateOrder, boolean isFromCreateBillPrint) {
        if (isFromCreateBillPrint) {
            createBillPrintCopy(title, kitchenCopy, goBack, updateOrder);
        } else {
            printBill(title, kitchenCopy, goBack, updateOrder);
        }
    }

    private void printBill(String title, boolean kitchenCopy, boolean goBack, boolean updateOrder) {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                LogUtils.d("Check", "defaultPrinter: " + defaultPrinter);
                LogUtils.d("Check", "defaultPrinter printer_model_name: " + defaultPrinter.printer_model_name);

                if (kitchenCopy) {
                    new PrepLocationSenderAsync(title, updateOrder, () -> {
                        if (goBack && (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title)))
                            onBackPressed();
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                } else {
                    new OrderItemsPrintBlockAsync(null, () -> {
                        LogUtils.e("TABLE Can we go back? " + (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title)) + " OrderTotal:" + order.total + " Paid: " + order.total_paid + " Title is nullorempty?" + Validators.isNullOrEmpty(title));
                        if (goBack && (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title))) {
                            onBackPressed();
                        }
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                }
            } else {
                LogUtils.e("TABLE Can we go if no printer back? " + (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title)) + " OrderTotal:" + order.total + " Paid: " + order.total_paid + " Title is nullorempty?" + Validators.isNullOrEmpty(title));
                showToastInPostExecute(false);
                if (goBack && (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 || !Validators.isNullOrEmpty(title))) {
                    onBackPressed();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddCommentFragment getInstanceAddComment(String comment) {
        AddCommentFragment fragment = new AddCommentFragment();
        Bundle bundle = new Bundle();
        bundle.putString("comment", comment);
        fragment.setArguments(bundle);
        return fragment;
    }

    public AssignTableDialogFragment getInstanceAssignTableDialog(String title, boolean showOnlyFree, String tableId, boolean isFromMergeTable) {
        AssignTableDialogFragment fragment = new AssignTableDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("table_id", tableId);
        bundle.putBoolean("isFromMergeTable", isFromMergeTable);
        bundle.putString("title", title);
        bundle.putBoolean("show_only_free", showOnlyFree);
        fragment.setArguments(bundle);
        return fragment;
    }

    public DiscountDialogFragment getInstanceDiscountDialog(int _order_id, String title) {
        DiscountDialogFragment fragment = new DiscountDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("_order_id", _order_id);
        bundle.putString("title", title);
        fragment.setArguments(bundle);
        return fragment;
    }

    public MainCategoryFragment getInstance(String orderType) {
        MainCategoryFragment fragment = new MainCategoryFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_type", orderType);
        fragment.setArguments(bundle);
        return fragment;
    }

    public PaymentViaVoucherFragment getInstancePaymentViaVoucher(Order order) {
        PaymentViaVoucherFragment fragment = new PaymentViaVoucherFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("_order_id", order._id);
        bundle.putString("order_id", order.id);
        bundle.putFloat("order_total", order.total);
        bundle.putFloat("order_sub_total", order.sub_total);
        bundle.putFloat("paid_amount", order.total_paid);
        bundle.putString("order_type_id", order.order_type_id);
        bundle.putInt("_customer_id", order._customer_id);
        bundle.putString("customer_id", order.customer_id);
        fragment.setArguments(bundle);
        return fragment;
    }

    public ProductAreaFragment getInstanceProductArea(String order_id, int _order_id) {
        Bundle bundle = new Bundle();
        bundle.putString("order_id", order_id);
        bundle.putInt("_order_id", _order_id);
        ProductAreaFragment productAreaFragment = new ProductAreaFragment();
        productAreaFragment.setArguments(bundle);
        return productAreaFragment;
    }

    public SendOrderDialogFragment getInstanceSendOrder(SiteSetting sendOrderMainSetting, SiteSetting sendOrderUpdateMainSetting, SiteSetting sendDupOrderMainSetting, SiteSetting sendDupOrderUpdateMainSetting) {
        SendOrderDialogFragment fragment = new SendOrderDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("sendOrderMainSetting", new Gson().toJson(sendOrderMainSetting));
        bundle.putString("sendOrderUpdateMainSetting", new Gson().toJson(sendOrderUpdateMainSetting));
        bundle.putString("sendDupOrderMainSetting", new Gson().toJson(sendDupOrderMainSetting));
        bundle.putString("sendDupOrderUpdateMainSetting", new Gson().toJson(sendDupOrderUpdateMainSetting));
        fragment.setArguments(bundle);
        return fragment;
    }
}
