package com.ubsidi.epos_2021.activities;

import static com.ubsidi.epos_2021.utils.Constants.AUTO_ACCEPT;
import static com.ubsidi.epos_2021.utils.Constants.BOOKING_ID;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.Links;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.OrderReviewItemsAdapter;
import com.ubsidi.epos_2021.adapters.SplitGroupAdapter;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.daos.relations.OrderItemWithAddonsIngredients;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.fragment.AmountSelectionFragment;
import com.ubsidi.epos_2021.fragment.OrderItemViewDialogFragment;
import com.ubsidi.epos_2021.fragment.PaymentMethodSelectionFragment;
import com.ubsidi.epos_2021.fragment.PrintOptionsDialogFragment;
import com.ubsidi.epos_2021.fragment.SendOrderDialogFragment;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Discount;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.online.models.OnlineReservation;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

public class OrderReviewActivity extends BaseActivity {
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;
    public Business selectedBusiness;
    private Chip ivBack;
    private TextView tvPreviousScreen;
    private TextView tvEditQty;
    private RecyclerView rvOrderItems;
    private LinearLayout llDone, llMainLayout;
    private MaterialCardView cvEditOrder, cvSendOrder, cvPrintOrder;
    private DrawerLayout drawerLayout;
    private Chip ivDrawerBack;
    private RecyclerView rvSplitGroup;
    private Order order;
    private OrderReviewItemsAdapter orderItemsAdapter;
    private SiteSetting printBillMainSetting;
    private SiteSetting sendOrderMainSetting;
    private SiteSetting sendOrderUpdateMainSetting;
    private SiteSetting sendDupOrderMainSetting;
    private SiteSetting sendDupOrderUpdateMainSetting;
    private HashMap<String, String> settingsMap = new HashMap<>();
    private OrderSplit selectedSplit;
    int _order_id, _order_split_id;
    String payment_method;
    float total, total_paid;
    FragmentManager manager;
    private float cartGrandTotal = 0, cartSubTotal = 0, cartDiscount = 0, cartGratuity = 0, cartServiceCharge = 0, cartDeliveryCharge = 0;
    private SiteSetting printAllMainSetting;
    private SiteSetting serviceChargeSetting;
    private SiteSetting serviceChargeTypeSetting;
    private SiteSetting sendOrderActionSetting;
    private boolean serviceChargeAutoMode = true;
    private boolean serviceChargeEnabled = false;
    private boolean serviceChargeVisible = false;
    private boolean discountEnabled = true;
    private boolean autoDiscountApplied = false;
    private ArrayList<OrderItem> orderItems = new ArrayList<>();
    boolean canEditOrder;
    private SplitGroupAdapter splitGroupAdapter;
    private final ArrayList<OrderSplit> orderSplits = new ArrayList<>();
    private TextView tvText;

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_order_review);
        manager = getSupportFragmentManager();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getIntent() != null) {
                _order_id = getIntent().getIntExtra("_order_id", 0);
                _order_split_id = getIntent().getIntExtra("_order_split_id", 0);
                total = getIntent().getFloatExtra("order_total", 0);
                payment_method = getIntent().getStringExtra("payment_method");
                total_paid = getIntent().getFloatExtra("paid_amount", 0);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            fetchOffline();
            LocalBroadcastManager.getInstance(OrderReviewActivity.this).registerReceiver(fragmentChangeReceiver, new IntentFilter(Constants.FRAGMENT_CHANGE));
            LocalBroadcastManager.getInstance(OrderReviewActivity.this).registerReceiver(push_receiver, new IntentFilter(Constants.PUSH_NOTIFICATION));
            if (Validators.isNullOrEmpty(payment_method)) {
                changeFragment(new PaymentMethodSelectionFragment());
            } else {
                changeFragment(new AmountSelectionFragment());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver push_receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("push", true)) {
                    int booking_id = intent.getIntExtra(BOOKING_ID, 0);
                    boolean auto_accept = intent.getBooleanExtra(AUTO_ACCEPT, false);
                    if (auto_accept && booking_id != 0) {
                        OnlineReservation onlineReservation = new OnlineReservation();
                        onlineReservation.status = "Approved";
                        onlineReservation.id = booking_id;
                        myApp.changeStatusOnlineReservation(onlineReservation, OrderReviewActivity.this);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onPause() {
        super.onPause();
        if (push_receiver != null) {
            LocalBroadcastManager.getInstance(OrderReviewActivity.this).unregisterReceiver(push_receiver);
        }
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            if (myPreferences.getLoggedInAdmin() != null)
                selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;
            myApp.isPaymentLinkSent = false;
            ivBack = findViewById(R.id.chipBack);
            tvPreviousScreen = findViewById(R.id.tvPreviousScreen);
            TextView tvCurrentScreen = findViewById(R.id.tvCurrentScreen);
            tvEditQty = findViewById(R.id.tvEditQty);
            rvOrderItems = findViewById(R.id.rvSelectedProducts);
            cvEditOrder = findViewById(R.id.cvEditOrder);
            cvSendOrder = findViewById(R.id.cvSendOrder);
            cvPrintOrder = findViewById(R.id.cvPrintOrder);
            llDone = findViewById(R.id.llDone);
            llMainLayout = findViewById(R.id.llMainLayout);
            drawerLayout = findViewById(R.id.drawer_layout);
            ivDrawerBack = findViewById(R.id.chipDrawerBack);
            rvSplitGroup = findViewById(R.id.rvSplitGroups);
            tvText = findViewById(R.id.tvText);

            tvCurrentScreen.setText("> Checkout");
            drawerLayout.setDrawerLockMode(DrawerLayout.LOCK_MODE_LOCKED_CLOSED);
            loadSettings();
            setAdapters();
            setButtonVisibilties();
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOffline() {
        try {
            new FetchOrderOfflineAsyncTask(() -> {
                // orderItemsAdapter.notifyDataSetChanged();
                rvOrderItems.post(() -> orderItemsAdapter.notifyDataSetChanged());
                Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.flContainer);
                if (openedFragment instanceof AmountSelectionFragment) {
                    ((AmountSelectionFragment) openedFragment).updateData();
                } else {
                    myApp.notifyCart(OrderReviewActivity.this, new Intent(Constants.EPOS_ORDER_UPDATE).putExtra("refresh", true).putExtra("_order_split_id", _order_split_id));
                }
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValidToPlaceOrder() {
        if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) {
            return false;
        }
        // Order completed
        return !order.order_status_id.equalsIgnoreCase("5");
    }

    private void setButtonVisibilties() {
        try {
            if (MyApp.userPermission != null && MyApp.userPermission.send_order.actions.list && showSendOrderButton())
                cvSendOrder.setVisibility(View.VISIBLE);
            else
                cvSendOrder.setVisibility(View.GONE);
            if (showPrintButton()) {
                cvPrintOrder.setVisibility(View.VISIBLE);
            } else
                cvPrintOrder.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean showPrintButton() {
        if (MyApp.userPermission != null && (MyApp.userPermission.print_all.actions.list || MyApp.userPermission.print_bill.actions.list)) {
            if (printBillMainSetting == null && printAllMainSetting == null) {
                return false;
            } else if ((printBillMainSetting != null && (printBillMainSetting.value.equalsIgnoreCase("false") || printBillMainSetting.value.equalsIgnoreCase("0"))) && (printAllMainSetting != null && (printAllMainSetting.value.equalsIgnoreCase("false") || printAllMainSetting.value.equalsIgnoreCase("0")))) {
                return false;
            } else {
                return true;
            }
        } else return false;
    }

    private boolean showSendOrderButton() {
        if (sendOrderMainSetting == null && sendOrderUpdateMainSetting == null && sendDupOrderMainSetting == null && sendDupOrderUpdateMainSetting == null) {
            return false;
        }
        return (sendOrderMainSetting == null || (!sendOrderMainSetting.value.equalsIgnoreCase("false") && !sendOrderMainSetting.value.equalsIgnoreCase("0"))) || (sendOrderUpdateMainSetting == null || (!sendOrderUpdateMainSetting.value.equalsIgnoreCase("false") && !sendOrderUpdateMainSetting.value.equalsIgnoreCase("0"))) || (sendDupOrderMainSetting == null || (!sendDupOrderMainSetting.value.equalsIgnoreCase("false") && !sendDupOrderMainSetting.value.equalsIgnoreCase("0"))) || (sendDupOrderUpdateMainSetting == null || (!sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("false") && !sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("0")));
    }

    private void setListeners() {
        try {
            ivBack.setOnClickListener(v -> onBackPressed());

            ivDrawerBack.setOnClickListener(v -> drawerLayout.closeDrawer(GravityCompat.END));
            tvEditQty.setOnClickListener(v -> {
                //Edit Qty
                toggleEditOption();
            });
            llDone.setOnClickListener(v -> {
                //Edit Qty
                toggleEditOption();
            });

            cvEditOrder.setOnClickListener(v -> {
                setResult(RESULT_OK);
                finish();
            });
            cvSendOrder.setOnClickListener(v -> {
                Pair<Integer, String> stringPair = isOnlyOneItemInSendOrder();
                if (stringPair.first == 1) {
                    orderUpdatePrint(stringPair.second);
                } else {
                    SendOrderDialogFragment sendOrderDialogFragment = getInstanceSendOrder(sendOrderMainSetting, sendOrderUpdateMainSetting, sendDupOrderMainSetting, sendDupOrderUpdateMainSetting);
                    sendOrderDialogFragment.show(getSupportFragmentManager(), "send_order");
                    sendOrderDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            orderUpdatePrint((String) o);
                        }
                    });
                }
            });

            cvPrintOrder.setOnClickListener(v -> {
                PrintOptionsDialogFragment printOptionsDialogFragment = myApp.getInstancePrintOptions(printBillMainSetting, printAllMainSetting);
                printOptionsDialogFragment.show(getSupportFragmentManager(), "print_options");
                printOptionsDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        myPreferences.saveIsPrintBill(true);
                        myApp.needToPrint = true;
                        Intent intent = new Intent();
                        intent.putExtra("order_action", ((String) o));
                        setResult(RESULT_OK, intent);
                        finish();
                    }
                });
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public SendOrderDialogFragment getInstanceSendOrder(SiteSetting sendOrderMainSetting, SiteSetting sendOrderUpdateMainSetting, SiteSetting sendDupOrderMainSetting, SiteSetting sendDupOrderUpdateMainSetting) {
        SendOrderDialogFragment fragment = new SendOrderDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("sendOrderMainSetting", new Gson().toJson(sendOrderMainSetting));
        bundle.putString("sendOrderUpdateMainSetting", new Gson().toJson(sendOrderUpdateMainSetting));
        bundle.putString("sendDupOrderMainSetting", new Gson().toJson(sendDupOrderMainSetting));
        bundle.putString("sendDupOrderUpdateMainSetting", new Gson().toJson(sendDupOrderUpdateMainSetting));
        fragment.setArguments(bundle);
        return fragment;
    }

    private Pair<Integer, String> isOnlyOneItemInSendOrder() {
        int count = 0;
        String actionId = "";
        if (sendOrderMainSetting != null && (sendOrderMainSetting.value.equalsIgnoreCase("true") || sendOrderMainSetting.value.equalsIgnoreCase("1"))) {
            actionId = "1";
            count = count + 1;
        }
        if (sendOrderUpdateMainSetting != null && (sendOrderUpdateMainSetting.value.equalsIgnoreCase("true") || sendOrderUpdateMainSetting.value.equalsIgnoreCase("1"))) {
            actionId = "3";
            count = count + 1;
        }
        if (sendDupOrderMainSetting != null && (sendDupOrderMainSetting.value.equalsIgnoreCase("true") || sendDupOrderMainSetting.value.equalsIgnoreCase("1"))) {
            actionId = "2";
            count = count + 1;
        }
        if (sendDupOrderUpdateMainSetting != null && (sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("true") || sendDupOrderUpdateMainSetting.value.equalsIgnoreCase("1"))) {
            actionId = "4";
            count = count + 1;
        }
        return new Pair(count, actionId);
    }

    private void orderUpdatePrint(String order_action_id) {
        myPreferences.saveIsPrintBill(true);
        order.order_action_id = (String) order_action_id;
        new UpdateOrderAsyncTask(() -> {
            String action = null;
            if (sendOrderActionSetting != null && sendOrderActionSetting.value.equalsIgnoreCase("prep_ticket")) {
                if (order.order_action_id.equalsIgnoreCase("1")) {
                    //                                createPrint("Full Order", true, true, false);
                    action = "full_order";
                } else if (order.order_action_id.equalsIgnoreCase("2")) {
                    //                                createPrint("Duplicate Order", true, true, false);
                    action = "duplicate_order";
                } else if (order.order_action_id.equalsIgnoreCase("3")) {
                    //                                createPrint("Updated Order", true, true, true);
                    action = "updated_order";
                } else if (order.order_action_id.equalsIgnoreCase("4")) {
                    //                                createPrint("Duplicate Updated Order", true, true, true);
                    action = "duplicate_updated_order";
                } else {
                    onBackPressed();
                    action = "";
                }
            } else {
                //                            onBackPressed();
                action = "";
            }
            myApp.needToPrint = true;
            Intent intent = new Intent();
            intent.putExtra("order_action", action);
            setResult(RESULT_OK, intent);
            finish();
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private void toggleEditOption() {
        try {
            //orderItemsAdapter.shouldEdit = !orderItemsAdapter.shouldEdit;
            boolean shouldEditBol = false;
            if (orderItems != null && orderItems.size() > 0) {
                for (int i = 0; i < orderItems.size(); i++) {
                    shouldEditBol = !orderItems.get(0).shouldEdit;
                    break;
                }
            }
            if (shouldEditBol) {
                llDone.setVisibility(View.VISIBLE);
                tvEditQty.setVisibility(View.GONE);
                updateEditOrderItems(true);
            } else {
                llDone.setVisibility(View.GONE);
                tvEditQty.setVisibility(View.VISIBLE);
                updateEditOrderItems(false);
            }
            // updateEditOrderItems(false);
            // orderItemsAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAdapters() {
        try {
            orderItemsAdapter = new OrderReviewItemsAdapter(orderItems, new RecyclerviewItemClickListener() {
                @Override
                public void onItemClick(int position, Object data) {
                    OrderItem orderItem = (OrderItem) data;
                    editProduct(orderItem,position);
                }
            }, (position, data) -> {
                // Product get deleted
                OrderItem orderItem = (OrderItem) data;
                boolean isReturn = false;
                if (!isValidToPlaceOrder()) isReturn = true;
                if (order.total_paid > 0) {
                    ToastUtils.showSnackBar(OrderReviewActivity.this, llMainLayout, "Cannot change in paid order", "failed");
                    isReturn = true;
                }
                if (orderItem._order_split_id > 0 && selectedSplit.paid_amount > 0) {
                    ToastUtils.showSnackBar(OrderReviewActivity.this, llMainLayout, "Cannot change in paid split group", "failed");
                    isReturn = true;
                }
                if (isReturn) {
                    fetchOffline();
                    return;
                }
                // Update db and views
                UploadOrderAsyncTaskRxJava(orderItem);
            }, (position, data) -> {
                openOrderItemDetails((OrderItem) data);
            });
            rvOrderItems.setLayoutManager(new GridLayoutManager(this, getResources().getInteger(R.integer.order_review_items_span)));
            rvOrderItems.setAdapter(orderItemsAdapter);

            splitGroupAdapter = new SplitGroupAdapter(orderSplits, (position, data) -> {
                OrderSplit orderSplit = (OrderSplit) data;
                if (_order_split_id != orderSplit._id) {
                    _order_split_id = orderSplit._id;
                    selectedSplit = orderSplit;
                    changeFragment(new PaymentMethodSelectionFragment());
                    fetchOffline();
                }
            });
            rvSplitGroup.setLayoutManager(new LinearLayoutManager(this, RecyclerView.HORIZONTAL, false));
            rvSplitGroup.setAdapter(splitGroupAdapter);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void UploadOrderAsyncTaskRxJava(OrderItem orderItem) {
        try {
            Observable.fromCallable(() -> {
                        try {
                            cartSubTotal = cartSubTotal - orderItem.total;
                            orderItem.is_delete = true;
                            orderItem.sent_to_kitchen_quantity = 0;
                            myApp.appDatabase.orderItemDao().update(orderItem);
                            //myApp.appDatabase.orderItemDao().delete(orderItem);

                            order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);
                            LogUtils.e("ORDER::", "Order Sub Total::" + order.sub_total);
                            cartSubTotal = order.sub_total;
                            LogUtils.e("ORDER::", "Cart Sub Total::" + cartSubTotal);

                            if (serviceChargeEnabled) {
                                if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                                    float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                                    if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                        cartServiceCharge = serviceChargeValue;
                                    } else {
                                        if (serviceChargeValue > 0) {
                                            cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                        } else {
                                            cartServiceCharge = 0;
                                        }
                                    }
                                }
                            }

                            if (discountEnabled) {
                                List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                                if (discounts.size() > 0) {
                                    Discount appliedDiscount = discounts.get(0);
                                    autoDiscountApplied = false;
                                    if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                                        if (cartSubTotal > 0)
                                            cartDiscount = appliedDiscount.discount;
                                        else cartDiscount = 0;
                                        autoDiscountApplied = true;
                                    }
                                    if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                                        if (cartSubTotal > 0)
                                            cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                                        else cartDiscount = 0;
                                        autoDiscountApplied = true;
                                    }
                                } else {
                                    if (autoDiscountApplied) cartDiscount = 0;
                                }
                            }

                            order.delivery_charge = cartDeliveryCharge;
                            order.gratuity = cartGratuity;
                            order.discount = cartDiscount;
                            order.service_charge = cartServiceCharge;
                            cartGrandTotal = (cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount;
                            order.total = cartGrandTotal;

                            if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            }
                            if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                                order.order_status_id = "5";
                                order.order_status = "Order Completed";
                            }
                            appDatabase.orderDao().update(order);

                   /* if (order.order_type_id.equalsIgnoreCase("1") &&
                            !Validators.isNullOrEmpty(order.table_id) &&
                            (order.order_status_id.equalsIgnoreCase("5") ||
                                    order.order_status_id.equalsIgnoreCase("10"))) {
                        Table table = appDatabase.tableDao().view(order.table_id);
                        table.status = vacantStatus.status;
                        table.locked = false;
                        table.last_order_total = 0;
                        table.last_order_id = null;
                        table._last_order_id = 0;
                        table.last_order_created_at = null;
                        table.table_status_id = vacantStatus.id;
                        appDatabase.tableDao().insert(table);
                    }*/
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        return true;
                    }) // Execute in IO thread, i.e. background thread.
                    .subscribeOn(Schedulers.io())
                    // report or post the result to main thread.
                    .observeOn(AndroidSchedulers.mainThread())
                    // execute this RxJava
                    .subscribe(new Observer<Boolean>() {
                        @Override
                        public void onSubscribe(Disposable d) {

                        }

                        @Override
                        public void onNext(Boolean success) {
                            // on success. Called on main thread, as defined in .observeOn(AndroidSchedulers.mainThread())
                            fetchOffline();
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void openOrderItemDetails(OrderItem data) {
        try {
            OrderItemViewDialogFragment orderItemViewDialogFragment = getInstanceOrderItemView(data);
            orderItemViewDialogFragment.show(getSupportFragmentManager(), "show");
            orderItemViewDialogFragment.setCancelable(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OrderItemViewDialogFragment getInstanceOrderItemView(OrderItem orderItem) {
        OrderItemViewDialogFragment fragment = new OrderItemViewDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_item", new Gson().toJson(orderItem));
        fragment.setArguments(bundle);
        return fragment;
    }

    private void loadSettings() {
        try {
            printAllMainSetting = myApp.findSetting("is_printall");
            printBillMainSetting = myApp.findSetting("is_printbill");
            sendOrderMainSetting = myApp.findSetting("is_sendorder");
            sendOrderUpdateMainSetting = myApp.findSetting("is_sendorderupdate");
            sendDupOrderMainSetting = myApp.findSetting("is_sendduplicateorder");
            sendDupOrderUpdateMainSetting = myApp.findSetting("is_sendorderupdate");

            sendOrderActionSetting = myApp.findSetting("send_order_action");
            SiteSetting serviceChargeEnableSetting = myApp.findSetting("is_service_charge");
            serviceChargeSetting = myApp.findSetting("service_charge");
            SiteSetting serviceChargeOptionSetting = myApp.findSetting("service_charge_type_option");
            serviceChargeTypeSetting = myApp.findSetting("service_charge_type");
            tvText.setVisibility(View.GONE);
            if (serviceChargeEnableSetting != null && (serviceChargeEnableSetting.value.equalsIgnoreCase("true") || serviceChargeEnableSetting.value.equalsIgnoreCase("1"))) {
                serviceChargeEnabled = true;
                serviceChargeVisible = true;
            }
            if (serviceChargeEnabled && serviceChargeOptionSetting != null && serviceChargeOptionSetting.value.equalsIgnoreCase("manual")) {
                serviceChargeAutoMode = false;
            }

            SiteSetting paidPaymentSetting = myApp.findSetting("paid_payment_title");
            SiteSetting unpaidPaymentSetting = myApp.findSetting("unpaid_payment_title");
            SiteSetting partialPaymentSetting = myApp.findSetting("partial_payment_title");
            SiteSetting cardPaymentSetting = myApp.findSetting("card_payment_type");
            SiteSetting cashPaymentSetting = myApp.findSetting("cash_payment_type");

            settingsMap.put("paid_payment_title", paidPaymentSetting.value);
            settingsMap.put("unpaid_payment_title", unpaidPaymentSetting.value);
            settingsMap.put("partial_payment_title", partialPaymentSetting.value);
            settingsMap.put("card_payment_type", cardPaymentSetting.value);
            settingsMap.put("cash_payment_type", cashPaymentSetting.value);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UpdateOrderAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public UpdateOrderAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);

                cartSubTotal = order.sub_total;
                if (serviceChargeEnabled) {
                    if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                        float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                        if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                            cartServiceCharge = serviceChargeValue;
                        } else {
                            if (serviceChargeValue > 0) {
                                cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                            } else {
                                cartServiceCharge = 0;
                            }
                        }
                    }
                } else {
                    cartServiceCharge = 0;
                }
                cartDiscount = order.discount;
                if (discountEnabled) {
                    List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                    if (discounts.size() > 0) {
                        Discount appliedDiscount = discounts.get(0);
                        autoDiscountApplied = false;
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                            if (cartSubTotal > 0)
                                cartDiscount = appliedDiscount.discount;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                            if (cartSubTotal > 0)
                                cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                            else
                                cartDiscount = 0;

                            autoDiscountApplied = true;
                        }
                    } else {
                        if (autoDiscountApplied)
                            cartDiscount = 0;
                    }
                }

                order.gratuity = cartGratuity;
                order.discount = cartDiscount;
                order.service_charge = cartServiceCharge;
                cartGrandTotal = ((cartSubTotal + cartGratuity + cartServiceCharge + cartDeliveryCharge) - cartDiscount);
                order.total = cartGrandTotal;
                if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                }
                appDatabase.orderDao().update(order);
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class FetchOrderOfflineAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchOrderOfflineAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                if (orderWithItems != null) {
                    order = orderWithItems.order;
                    boolean splitException = false;
                    if (order.split_type != null) {
                        try {
                            appDatabase.orderSplitDao().updatePaidAmount(_order_id);
                        } catch (Exception e) {
                            e.printStackTrace();
                            splitException = true;
                        }
                    }
                    order.total_paid = appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id);
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("1")) {
                        order.order_type = "Dine in";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("2")) {
                        order.order_type = "Collection";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("3")) {
                        order.order_type = "Delivery";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("4")) {
                        order.order_type = "Bar";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("5")) {
                        order.order_type = "Waiting";
                    }
                    boolean shouldFetchDeliveryCharge = false;
                    if (shouldFetchDeliveryCharge) {
                        order.delivery_charge = cartDeliveryCharge;
                    }

                    Log.e("Order_type", " " + order.order_type);
                    if (serviceChargeVisible) {
                        SiteSetting services_charges = myApp.findSetting("service_charge_order_type");
                        List<String> split_funcation = Links.split_funcation(services_charges.value);
                        for (int i = 0; i < split_funcation.size(); i++) {
                            if (order.order_type.equalsIgnoreCase(split_funcation.get(i).toString())) {
                                serviceChargeEnabled = true;
                                break;
                            } else {
                                serviceChargeEnabled = false;
                            }
                        }
                    }

                    if (!Validators.isNullOrEmpty(order.table_id))
                        order.table_number = appDatabase.tableDao().view(order.table_id).number;
                    order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
                    order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;
                    if (order.order_splits.size() > 0 && _order_split_id == 0) {
                        _order_split_id = order.order_splits.get(0)._id;
                        selectedSplit = order.order_splits.get(0);
                    }
                    if (splitException) {
                        for (OrderSplit orderSplit : order.order_splits) {
                            orderSplit.paid_amount = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, orderSplit._id);
                            appDatabase.orderSplitDao().update(orderSplit);
                        }
                    }
                    order.order_items = new ArrayList<>();
                    boolean shouldEdit = false;
                    boolean shouldClick = false;
                    if (orderItems != null && orderItems.size() > 0) {
                        for (int i = 0; i < orderItems.size(); i++) {
                            shouldEdit = orderItems.get(0).shouldEdit;
                            shouldClick = orderItems.get(0).shouldClick;
                            break;
                        }
                    }
                    orderItems.clear();
                    for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                        OrderItem orderItem = item.orderItem;
                        orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                        orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                        orderItem.shouldEdit = shouldEdit;
                        orderItem.shouldClick = shouldClick;
                        order.order_items.add(orderItem);
                        if (_order_split_id == orderItem._order_split_id || orderItem._order_split_id == 0) {
                            orderItems.add(orderItem);
                        }
                    }
                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                    if (order.customer == null) {
                        order.customer = appDatabase.customerDao().view(order.customer_id);
                    }

                    if (order.service_charge == 0) {
                        if (serviceChargeEnabled) {
                            if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                                float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                                if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                    cartServiceCharge = serviceChargeValue;
                                } else {
                                    if (serviceChargeValue > 0) {
                                        cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                    } else {
                                        cartServiceCharge = 0;
                                    }
                                }
                            }
                        } else {
                            cartServiceCharge = 0;
                        }
                    } else {
                        cartServiceCharge = order.service_charge;
                    }
                    if (order.split_type != null && order.split_type.equalsIgnoreCase("order_item")) {
                        cartServiceCharge = 0;
                        serviceChargeEnabled = false;
                        discountEnabled = false;
                    }
                    order.service_charge = cartServiceCharge;
                    cartSubTotal = order.sub_total;
                    cartDiscount = order.discount;

                    if (discountEnabled) {
                        List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                        if (discounts.size() > 0) {
                            Discount appliedDiscount = discounts.get(0);
                            autoDiscountApplied = false;
                            if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                                if (cartSubTotal > 0)
                                    cartDiscount = appliedDiscount.discount;
                                else cartDiscount = 0;
                                autoDiscountApplied = true;
                            }
                            if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                                if (cartSubTotal > 0)
                                    cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                                else
                                    cartDiscount = 0;
                                autoDiscountApplied = true;
                            }
                        } else {
                            if (autoDiscountApplied) cartDiscount = 0;
                        }
                    }
                    order.discount = cartDiscount;
                    order.total = ((order.sub_total + order.gratuity + order.service_charge + order.delivery_charge) - order.discount);

                    // order.total = ((cartSubTotal + cartGratuity + cartServiceCharge + cartDeliveryCharge)  - cartDiscount);

                    if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                        if (order.total == 0) {
                            order.order_status_id = "2";
                            order.order_status = "Order Taken";
                        } else if (order.total == order.total_paid) {
                            if (!order.order_status_id.equalsIgnoreCase("6")) {
                                order.order_status_id = "4";
                                order.order_status = "Order Paid";
                            }
                        } else if (order.total_paid > 0) {
                            order.order_status_id = "7";
                            order.order_status = "Part Payment Received";
                        } else {
                            if (!order.order_status_id.equalsIgnoreCase("3")) {
                                order.order_status_id = "2";
                                order.order_status = "Order Taken";
                            }
                        }
                        order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    }
                    myApp.appDatabase.orderDao().update(order);

                    myApp.notifyCart(OrderReviewActivity.this, new Intent("cart_update").putExtra("notify_products", true));

                    if (_order_split_id > 0) {
                        selectedSplit = appDatabase.orderSplitDao().view(_order_split_id);
                        total_paid = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, _order_split_id);
                    }
                    if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) {
                        canEditOrder = false;
                    } else {
                        canEditOrder = CommonFunctions.orderPaymentStatus(order.total, order.total_paid) != 1;
                    }
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (order != null)
                if (nextMethod != null) {
                    try {
                        tvPreviousScreen.setText(order.order_type);
                        updateViews();
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
        }
    }

    private void updateViews() {
        try {
            if (order.order_splits != null && order.order_splits.size() > 0) {
                rvSplitGroup.setVisibility(View.VISIBLE);
                orderSplits.clear();
                orderSplits.addAll(order.order_splits);
                //orderItemsAdapter.shouldEdit = canEditOrder;
                if (!canEditOrder) {
                    tvEditQty.setVisibility(View.GONE);
                    llDone.setVisibility(View.GONE);
                } else {
                    tvEditQty.setVisibility(View.VISIBLE);
                }
                //orderItemsAdapter.notifyDataSetChanged();
                updateEditOrderItems(canEditOrder);
                splitGroupAdapter.selectedSplitId = _order_split_id;
                splitGroupAdapter.notifyDataSetChanged();
                changeFragment(new PaymentMethodSelectionFragment());
            } else {
                rvSplitGroup.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void editProduct(OrderItem orderItem,int position) {
        try {
            if ((!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) && (MyApp.userPermission != null && MyApp.userPermission.modify.actions.list) && !canEditOrder) {
                return;
            }
            ArrayList<OrderItem> tempItems = new ArrayList<>();
            tempItems.add(orderItem);
            new AddOrUpdateOrderItemAsyncTask(position,() -> {
                /*setResult(Activity.RESULT_OK);
                fetchOffline();
                return null;*/
                // Update db and views
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline();
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, tempItems);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class AddOrUpdateOrderItemAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;
        int position;

        public AddOrUpdateOrderItemAsyncTask(int position,Callable<Void> nextMethod) {
            this.position = position;
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                if (objects[0] instanceof List) {
                    ArrayList<OrderItem> orderItems = (ArrayList<OrderItem>) objects[0];
                    for (OrderItem orderItem : orderItems) {
                        OrderItem dbOrderItem = appDatabase.orderItemDao().view(orderItem._id);
                        if (orderItem._order_split_id > 0) {
                            OrderSplit dbSplit = null;
                            if (selectedSplit != null) {
                                if (orderItem._order_split_id == selectedSplit._id) {
                                    dbSplit = selectedSplit;
                                } else {
                                    dbSplit = appDatabase.orderSplitDao().view(orderItem._order_split_id);
                                }
                            } else {
                                dbSplit = appDatabase.orderSplitDao().view(orderItem._order_split_id);
                            }
                            if (dbSplit.paid_amount > 0) {
                                break;
                            }
                        }
                        int dbOrderItemId, quantity;
                        if (orderItem.quantity <= 0) {
                            if (dbOrderItem != null) {
                                dbOrderItem.is_delete = true;
                                dbOrderItem.sent_to_kitchen_quantity = 0;
                                appDatabase.orderItemDao().update(dbOrderItem);
                                //appDatabase.orderItemDao().delete(dbOrderItem);
                                if (orderItem._order_split_id > 0) {
                                    appDatabase.orderSplitDao().updateTotalAmount(orderItem._order_id, orderItem._order_split_id);
                                }
                                continue;
                            }
                        }
                        if (dbOrderItem != null) {
                            dbOrderItem.quantity = orderItem.quantity;
                            quantity = dbOrderItem.quantity;
                            dbOrderItem.sub_total = dbOrderItem.quantity * orderItem.price;
                            dbOrderItem.instruction_price = orderItem.instruction_price;
                            dbOrderItem.special_instruction = orderItem.special_instruction;
                            dbOrderItem.total = dbOrderItem.sub_total + dbOrderItem.addons_price + dbOrderItem.ingredients_price + (dbOrderItem.instruction_price * dbOrderItem.quantity);
                            myApp.appDatabase.orderItemDao().update(dbOrderItem);
                            dbOrderItemId = dbOrderItem._id;
                            if(position==-100){
                                addMinusQuantityInDatabase(dbOrderItem);
                            }
                        } else {
                            quantity = orderItem.quantity;
                            orderItem.order_id = order.id;
                            orderItem._order_id = _order_id;
                            orderItem.sub_total = orderItem.quantity * orderItem.price;
                            orderItem.total = orderItem.sub_total + orderItem.addons_price + orderItem.ingredients_price + (orderItem.instruction_price * orderItem.quantity);
                            dbOrderItemId = (int) myApp.appDatabase.orderItemDao().insert(orderItem);
                            if(position==-100){
                                addMinusQuantityInDatabase(orderItem);
                            }
                        }
                        float addonTotal = 0;
                        if (orderItem.order_item_addons != null) {
                            for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                itemAddon._order_item_id = dbOrderItemId;
                                itemAddon.total = itemAddon.quantity * itemAddon.price;
                                addonTotal = addonTotal + itemAddon.total;
                            }
                            myApp.appDatabase.orderItemAddonDao().insertAll(orderItem.order_item_addons);
                        }

                        float ingredientTotal = 0;
                        if (orderItem.order_item_ingredients != null) {
                            appDatabase.orderItemIngredientDao().deleteAll(dbOrderItemId);
                            for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                itemIngredient._order_item_id = dbOrderItemId;
                                itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                ingredientTotal = ingredientTotal + itemIngredient.total;
                            }
                            appDatabase.orderItemIngredientDao().insertAll(orderItem.order_item_ingredients);
                        }

                        ingredientTotal = ingredientTotal * quantity;
                        addonTotal = addonTotal * quantity;
                        myApp.appDatabase.orderItemDao().updateOrderItemTotal(dbOrderItemId, addonTotal, ingredientTotal);
                        if (orderItem._order_split_id > 0) {
                            appDatabase.orderSplitDao().updateTotalAmount(orderItem._order_id, orderItem._order_split_id);
                        }
                    }

                    order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(_order_id);
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    appDatabase.orderDao().update(order);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addMinusQuantityInDatabase(OrderItem dbOrderItem){
        OrderItem deletedOrderItem = new OrderItem();
        deletedOrderItem._order_id = dbOrderItem._order_id;
        deletedOrderItem.order_id = dbOrderItem.order_id;
        deletedOrderItem._order_split_id = dbOrderItem._order_split_id;
        deletedOrderItem.order_split_id = dbOrderItem.order_split_id;
        deletedOrderItem.product_name = dbOrderItem.product_name;
        deletedOrderItem.product_id = dbOrderItem.product_id;
        deletedOrderItem.product_short_name = dbOrderItem.product_short_name;
        deletedOrderItem.product_description = dbOrderItem.product_description;
        deletedOrderItem.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
        deletedOrderItem.is_delete = true;
        deletedOrderItem.price = dbOrderItem.price;
        deletedOrderItem.sub_total = (1 * dbOrderItem.price);
        deletedOrderItem.total = dbOrderItem.sub_total + dbOrderItem.addons_price + dbOrderItem.ingredients_price;
        deletedOrderItem.sent_to_kitchen_quantity =0;
        appDatabase.orderItemDao().insert(deletedOrderItem);
    }

    private void changeFragment(Fragment fragment) {
        try {
            if (getIntent() != null) {
                getIntent().putExtra("_order_split_id", _order_split_id);
            }
            if (manager.getBackStackEntryCount() > 0)
                manager.popBackStack("can_go_back", FragmentManager.POP_BACK_STACK_INCLUSIVE);
            if (getIntent() != null) {
                fragment.setArguments(getIntent().getExtras());
            }
            FragmentManager manager = getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.flContainer, fragment);
            transaction.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    BroadcastReceiver fragmentChangeReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getExtras() != null) {
                    boolean canEdit = intent.getBooleanExtra("can_edit", false);
                    if (canEdit && canEditOrder) {
                        tvEditQty.setVisibility(View.VISIBLE);
                        llDone.setVisibility(View.GONE);
                        // orderItemsAdapter.shouldEdit = false;
                        // orderItemsAdapter.shouldClick = true;
                        updateBothActionsOrderItems(false, true);
                    } else {
                        tvEditQty.setVisibility(View.GONE);
                        llDone.setVisibility(View.GONE);
                        //  orderItemsAdapter.shouldClick = false;
                        // orderItemsAdapter.shouldEdit = false;
                        updateBothActionsOrderItems(false, false);
                    }
                    //orderItemsAdapter.notifyDataSetChanged();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    // Handle item click based on argument {isEdit}
    // It was found on firebase
    private void updateEditOrderItems(boolean isEdit) {
        try {
            if (orderItems != null && orderItems.size() > 0) {
                for (int i = 0; i < orderItems.size(); i++) {
                    orderItems.get(i).shouldEdit = isEdit;
                }
            }
            rvOrderItems.post(() -> orderItemsAdapter.notifyDataSetChanged());
        } catch (Exception e) {
            e.printStackTrace();
            rvOrderItems.post(() -> orderItemsAdapter.notifyDataSetChanged());
        }
    }

    private void updateBothActionsOrderItems(boolean isEdit, boolean isClick) {
        try {
            if (orderItems != null && orderItems.size() > 0) {
                for (int i = 0; i < orderItems.size(); i++) {
                    orderItems.get(i).shouldClick = isClick;
                    orderItems.get(i).shouldEdit = isEdit;
                }
            }
            rvOrderItems.post(() -> orderItemsAdapter.notifyDataSetChanged());
        } catch (Exception e) {
            e.printStackTrace();
            rvOrderItems.post(() -> orderItemsAdapter.notifyDataSetChanged());
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (fragmentChangeReceiver != null)
            LocalBroadcastManager.getInstance(OrderReviewActivity.this).unregisterReceiver(fragmentChangeReceiver);
    }

    @Override
    public void onBackPressed() {
        setResult(RESULT_OK);
        try {
            Fragment openedFragment = getSupportFragmentManager().findFragmentById(R.id.flContainer);

            if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                drawerLayout.closeDrawer(GravityCompat.END);
            } else {
                if (openedFragment instanceof PaymentMethodSelectionFragment) {
                    finish();
                } else {
                    if (manager.getBackStackEntryCount() > 0) {
                        manager.popBackStack();
                    } else if (openedFragment instanceof AmountSelectionFragment) {
                        changeFragment(new PaymentMethodSelectionFragment());
                    } else {
                        finish();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
