package com.ubsidi.epos_2021.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.Priority;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.DatabasePull;
import com.ubsidi.epos_2021.models.EposUserPermission;
import com.ubsidi.epos_2021.models.Floor;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.Product;
import com.ubsidi.epos_2021.models.ProductAddon;
import com.ubsidi.epos_2021.models.ProductIngredient;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.User;
import com.ubsidi.epos_2021.models.Voucher;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.services.ImageDownloadService;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.InternetUtils;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.NetworkWatcher;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;

/**
 * Created by Amrish on 22-05-2021.
 */
public class PullActivity extends BaseActivity {
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_pull);
    }
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;
    private TextView tvMessage;
    private Admin loggedInAdmin = myPreferences.getLoggedInAdmin();
    private ArrayList<Product> products = new ArrayList<>();
    private String destination;
    private boolean alreadyPulled = myPreferences.getPullStatus();

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getIntent() != null) {
                destination = getIntent().getStringExtra("destination");
            }
            FirebaseMessaging.getInstance().subscribeToTopic("business_" + loggedInAdmin.selected_business.id).addOnCompleteListener(new OnCompleteListener<Void>() {
                @Override
                public void onComplete(@NonNull Task<Void> task) {
                    //Toast.makeText(PullActivity.this, "Subscribe Success!", Toast.LENGTH_SHORT).show();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            tvMessage = findViewById(R.id.tvMessage);
            if (!InternetUtils.isNetworkConnected(this)) {
                ToastUtils.makeSnackToast(PullActivity.this, "No internet connection");
                startActivity(new Intent(PullActivity.this, HomeActivity.class));
                finish();
            } else {
                fetchData();
            }

            try {
                new NetworkWatcher(this).observe(this, aBoolean -> {
                    if (!aBoolean) {
                        ToastUtils.makeSnackToast(PullActivity.this, "No internet connection, Please try again when internet is connected.");
                        startActivity(new Intent(PullActivity.this, HomeActivity.class));
                        finish();
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        try {
            LogUtils.e("Fetching Pull");
            AndroidNetworking.post(ApiEndPoints.database_pull)
                    .addQueryParameter("request_for", "admin")
                    .addQueryParameter("business_id", loggedInAdmin.selected_business.id)
                    .build()
                    .getAsObject(DatabasePull.class, new ParsedRequestListener<DatabasePull>() {
                        @Override
                        public void onResponse(DatabasePull response) {
                            LogUtils.e("Pull Fetched");
                            new PullSaverAsync(() -> {
                                fetchOnlineOrders(() -> {
                                    Product firstProduct = products.get(0);
                                    startService(new Intent(PullActivity.this, ImageDownloadService.class).putExtra("image_url", firstProduct.image_url).putExtra("position", 0).putExtra("product_id", firstProduct.id));
                                    return null;
                                });
                                return null;
                            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                        }

                        @Override
                        public void onError(ANError anError) {
                            LogUtils.e("Error in pull");
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(PullActivity.this, apiError.getMessage());
                            }else if (anError.getErrorCode() == 401) {
                                logoutAdmin();
                            }
                            if (!myApp.isConnected(PullActivity.this)) {
                                ToastUtils.makeSnackToast(PullActivity.this, "No internet connection");
                                startActivity(new Intent(PullActivity.this, HomeActivity.class));
                                finish();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logoutAdmin() {
        try {
            FirebaseMessaging.getInstance().unsubscribeFromTopic("business_" + myPreferences.getLoggedInAdmin().selected_business.id);
            myPreferences.saveLoggedInAdmin(null);
            myPreferences.saveLoggedInUser(null);
            myPreferences.saveUserTokens(null, null);
            myPreferences.saveAdminTokens(null, null);
            myPreferences.userLoggedInWithoutInternet(false);
            myPreferences.adminLoggedInWithoutInternet(false);
            myPreferences.saveBusinessId(null);
            /*new Thread(() -> {
                appDatabase.emptyPulledDao().nukeAddon();
                appDatabase.emptyPulledDao().nukeCategory();
                appDatabase.emptyPulledDao().nukeCustomer();
                appDatabase.emptyPulledDao().nukePrepLocation();
                appDatabase.emptyPulledDao().nukeProduct();
                appDatabase.emptyPulledDao().nukeProductAddon();
                appDatabase.emptyPulledDao().nukeProductIngredient();
                appDatabase.emptyPulledDao().nukeTable();
                appDatabase.emptyPulledDao().nukeFloor();
                appDatabase.emptyPulledDao().nukeOrderItemIngredient();
                appDatabase.emptyPulledDao().nukeOrderItemAddon();
                appDatabase.emptyPulledDao().nukeOrderPayment();
                appDatabase.emptyPulledDao().nukeOrderSplit();
                appDatabase.emptyPulledDao().nukeOrder();
                appDatabase.emptyPulledDao().nukeUsers();
                appDatabase.emptyPulledDao().nukeReservations();
                appDatabase.orderDao().resetPrimaryKey();
                try {
                    deleteImages();
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }).start();*/
            myPreferences.savePullStatus(false);
            startActivity(new Intent(this, SplashActivity.class));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class PullSaverAsync extends AsyncTask<DatabasePull, Void, String> {
        Callable<Void> nextThing;

        public PullSaverAsync(Callable<Void> nextThing) {
            this.nextThing = nextThing;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(DatabasePull... object) {
            try {
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
                DatabasePull dbPull = object[0];
                LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Fetching Settings"));
                // Save site settings
                if (dbPull.site_settings != null && dbPull.site_settings.size() > 0) {
                    appDatabase.siteSettingDao().insertMultiple(dbPull.site_settings);
                    myApp.siteSettings.clear();
                    myApp.siteSettings.addAll(dbPull.site_settings);
                    myApp.restaurant_id = null;
                }

                // Save Addons
                LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Saving Products"));
                if (dbPull.addons != null && dbPull.addons.size() > 0)
                    appDatabase.addonDao().deleteAll();
                appDatabase.addonDao().insertMultiple(dbPull.addons);

                // Save Products and its Addons
                if (dbPull.products != null && dbPull.products.size() > 0)
                    appDatabase.productDao().deleteAll();
                appDatabase.productDao().insertMultiple(dbPull.products);
                ArrayList<ProductAddon> productAddons = new ArrayList<>();
                ArrayList<ProductIngredient> productIngredients = new ArrayList<>();
                products.clear();
                for (Product product : dbPull.products) {
                    products.add(product);
                    productAddons.addAll(product.product_addons);
                    productIngredients.addAll(product.product_ingredients);
                }
                appDatabase.productAddonDao().deleteAll();
                if (productAddons.size() > 0)
                    appDatabase.productAddonDao().insertMultiple(productAddons);

                appDatabase.productIngredientDao().deleteAll();
                if (productIngredients.size() > 0)
                    appDatabase.productIngredientDao().insertMultiple(productIngredients);

                //Save users
                LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Saving Users"));
                appDatabase.userDao().deleteAllUser();
                User loggedInUser = myPreferences.getLoggedInUser();
                if (dbPull.users != null && dbPull.users.size() > 0) {
                    for (User u : dbPull.users) {
                        if (loggedInUser != null && u.id.equalsIgnoreCase(loggedInUser.id)) {
                            MyApp.userPermission = (EposUserPermission) u.permissions;
                            MyApp.getInstance().myPreferences.saveLoggedInUser(u);
                            MyApp.getInstance().myPreferences.saveEposUserPermission(new Gson().toJson(u.permissions));
                        }
                        u.string_permission = new Gson().toJson(u.permissions);
                    }
                    appDatabase.userDao().insertMultiple(dbPull.users);
                }

                // Save Categories
                appDatabase.categoryDao().deleteAll();
                if (dbPull.categories != null && dbPull.categories.size() > 0)
                    appDatabase.categoryDao().insertMultiple(dbPull.categories);


                // Save Prep Locations
                if (dbPull.prep_locations != null && dbPull.prep_locations.size() > 0)
                    appDatabase.prepLocationDao().insertMultiple(dbPull.prep_locations);

                // Save Discounts
                appDatabase.discountDao().deleteAll();
                if (dbPull.discounts != null && dbPull.discounts.size() > 0)
                    appDatabase.discountDao().insertMultiple(dbPull.discounts);


                if (!alreadyPulled) {
                    // Save Customers
                    LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Saving Customers"));
                    ArrayList<String> alreadySavedIds = (ArrayList<String>) appDatabase.customerDao().customerIds();

                    ArrayList<String> shouldNotDeleteThisIds = new ArrayList<>();
                    int count = 0;
                    if (dbPull.customers != null && dbPull.customers.size() > 0) {
                        //                List<Customer> allCustomers = Collections.unmodifiableList(dbPull.customers);
                        //                List<List<Customer>> parts = chopped(allCustomers, 998);
                        //                int coutn1 = 1;
                        //                for (List<Customer> cList : parts) {
                        //                    appDatabase.customerDao().insertMultiple(cList);
                        //                    LogUtils.e("Savings customers: " + cList.size() + "  Page:" + coutn1);
                        //                    LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", String.format("Saving %d customers of %d customers", coutn1 * cList.size(), dbPull.customers.size())));
                        //                    coutn1++;
                        //                }
                        for (Customer c : dbPull.customers) {
                            shouldNotDeleteThisIds.add(c.id);
                            Customer dbCustomer = appDatabase.customerDao().view(c.id);
                            if (dbCustomer != null) {
                                c._id = dbCustomer._id;
                            }
                            appDatabase.customerDao().insert(c);
                            count++;
                            LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", String.format("Saving %d customers of %d customers", count, dbPull.customers.size())));
                        }
                    }

                    ArrayList<String> deletableIds = new ArrayList<>();
                    for (String id : alreadySavedIds) {
                        if (!shouldNotDeleteThisIds.contains(id)) {
                            deletableIds.add(id);
                        }
                    }
                    LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Setting up"));
                    for (String id : deletableIds) {
                        appDatabase.customerDao().delete(id);
                    }
                } else {
                    LogUtils.e("Skiping Saving customers");
                }


                // Save Floors & Its Table
                LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Finishing up"));
                appDatabase.tableDao().deleteAll();
                appDatabase.floorDao().deleteAll();

                if (dbPull.floors != null && dbPull.floors.size() > 0)
                    appDatabase.floorDao().insertMultiple(dbPull.floors);

                ArrayList<Table> tables = new ArrayList<>();
                for (Floor floor : dbPull.floors) {
                    if (floor.tables != null && floor.tables.size() > 0)
                        tables.addAll(floor.tables);
                }
                if (tables.size() > 0)
                    appDatabase.tableDao().insertMultiple(tables);

                // Save Table Status
                if (dbPull.table_statuses != null && dbPull.table_statuses.size() > 0) {
                    appDatabase.tableStatusDao().insertMultiple(dbPull.table_statuses);
                    myApp.tableStatuses.clear();
                    myApp.tableStatuses.addAll(dbPull.table_statuses);
                }

                //Save Order Status
                if (dbPull.order_statuses != null && dbPull.order_statuses.size() > 0) {
                    appDatabase.orderStatuesDao().deleteAll();
                    appDatabase.orderStatuesDao().insertMultiple(dbPull.order_statuses);
                    myApp.orderStatuses.clear();
                    myApp.orderStatuses.addAll(dbPull.order_statuses);
                }

                //Save Prep Locations
                /*if (dbPull.prep_locations != null && dbPull.prep_locations.size() > 0) {
                    appDatabase.orderStatuesDao().deleteAll();
                    appDatabase.orderStatuesDao().insertMultiple(dbPull.order_statuses);
                    myApp.orderStatuses.clear();
                    myApp.orderStatuses.addAll(dbPull.order_statuses);
                }*/

                //Save deposit type
                if (dbPull.deposit_types != null && dbPull.deposit_types.size() > 0)
                    myPreferences.saveDepositTypes(dbPull.deposit_types);

                // Save payment methods
                if (dbPull.payment_methods != null && dbPull.payment_methods.size() > 0)
                    appDatabase.paymentMethodDao().insertMultiple(dbPull.payment_methods);

                // Save Print block
                if (dbPull.print_blocks != null && dbPull.print_blocks.size() > 0)
                    appDatabase.printBlockDao().insertMultiple(dbPull.print_blocks);

                // save business details
                if (dbPull.business != null) {
                    loggedInAdmin.selected_business = dbPull.business;
                    if (dbPull.business.card_readers != null && !dbPull.business.card_readers.isEmpty()) {
                        myPreferences.saveDefaultCardReader(dbPull.business.card_readers.get(0));
                    }
                    myPreferences.saveLoggedInAdmin(loggedInAdmin);
                    myPreferences.saveForOfflineLoginLoggedInAdmin(loggedInAdmin);
                }

                //Save vouchers
                appDatabase.voucherDao().deleteAll();
                ArrayList<String> voucherIds = new ArrayList<>();
                if (dbPull.vouchers != null && dbPull.vouchers.size() > 0) {
                    for (Voucher voucher : dbPull.vouchers) {
                        voucherIds.add(voucher.id);
                        Voucher dbVoucher = appDatabase.voucherDao().view(voucher.id);
                        Customer dbCustomer = appDatabase.customerDao().view(voucher.customer.id);
                        if (dbCustomer == null) {
                            voucher._customer_id = (int) appDatabase.customerDao().insert(voucher.customer);
                            voucher.customer._id = voucher._customer_id;
                        } else {
                            voucher.customer._id = dbCustomer._id;
                            appDatabase.customerDao().insert(voucher.customer);
                            voucher._customer_id = dbCustomer._id;
                            voucher.customer._id = dbCustomer._id;
                        }
                        if (dbVoucher != null) {
                            voucher._id = dbVoucher._id;
                        }
                        appDatabase.voucherDao().insert(voucher);
                    }
                }
                if (voucherIds.size() > 0) {
                    //                appDatabase.voucherDao().deleteButNotThisIds(voucherIds);
                }

                //Save Reservations
                if (dbPull.reservations != null) {
                    appDatabase.reservationDao().deleteAll();
                    for (Reservation res : dbPull.reservations) {
                        Reservation dbRes = appDatabase.reservationDao().view(res.id);
                        Customer dbCustomer = appDatabase.customerDao().view(res.customer.id);
                        if (dbCustomer != null) {
                            res.customer._id = dbCustomer._id;
                            res._customer_id = dbCustomer._id;
                            appDatabase.customerDao().insert(res.customer);
                        } else {
                            res._customer_id = (int) appDatabase.customerDao().insert(res.customer);
                            res.customer._id = res._customer_id;
                        }
                        if (dbRes != null) {
                            res._id = dbRes._id;
                        }
                        appDatabase.reservationDao().insert(res);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return "Executed";
        }

        <T> List<List<T>> chopped(List<T> list, final int L) {
            List<List<T>> parts = new ArrayList<List<T>>();
            final int N = list.size();
            for (int i = 0; i < N; i += L) {
                parts.add(new ArrayList<T>(
                        list.subList(i, Math.min(N, i + L)))
                );
            }
            return parts;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                myApp.setupData();
                setResult(RESULT_OK);
                myPreferences.savePullStatus(true);
                if (nextThing != null) {
                    try {
                        nextThing.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private HashMap<String, String> getOrdersParameters() {
        HashMap<String, String> params = new HashMap<>();

        params.put("nopaginate", "1");
        params.put("screen", "dashboard");

        return params;
    }

    private void fetchOnlineOrders(Callable<Void> nextMethod) {
        try {
            LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Fetching Orders"));

            AndroidNetworking.get(ApiEndPoints.orders)
                    .addQueryParameter("request_for", "admin")
                    .setPriority(Priority.IMMEDIATE)
                    .addQueryParameter(getOrdersParameters())
                    .build()
                    .getAsObjectList(Order.class, new ParsedRequestListener<List<Order>>() {
                        @Override
                        public void onResponse(List<Order> response) {
                            LogUtils.e("ORDERS", "API CALL response avyo " + response.size());
                            Collections.reverse(response);
                            LogUtils.e("response reversed ");
                            new OrderSaverAsync(() -> {
                                nextMethod.call();
                                return null;
                            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);

                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            boolean shouldDelete = false;
                            try {
                                nextMethod.call();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class OrderSaverAsync extends AsyncTask<Object, Void, String> {
        Callable<Void> nextMethod;

        public OrderSaverAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected void onPreExecute() {
            LogUtils.e("ORDERS", "PRE EXECUTE");
            fetchRestaurantDetails();
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Object... lists) {
            try {
                LogUtils.e("ORDERS", "IN background start");
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);

                if (lists[0] instanceof ArrayList<?>) {
                    LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Saving Orders"));

                    ArrayList<Order> parameterOrders = (ArrayList<Order>) lists[0];
                    ArrayList<String> allOrderIds = new ArrayList<>();
                    ArrayList<Order> newOnlineOrders = new ArrayList<>();
                    for (Order o : parameterOrders) {
                        allOrderIds.add(o.id);
                    }

                    // list all online orders that are not in local DB
                    ArrayList<Order> localOrdersWithOnlineID = new ArrayList<>();
                    localOrdersWithOnlineID = (ArrayList<Order>) appDatabase.orderDao().listWithOnlineIds(allOrderIds);
                    List<String> shouldNotDeleteThisIds;
                    for (Order onlineOrder : parameterOrders) {
                        boolean found = false;
                        for (Order dbOrder : localOrdersWithOnlineID) {
                            if (onlineOrder.id.equalsIgnoreCase(dbOrder.id)) {
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            newOnlineOrders.add(onlineOrder);
                        }
                    }
                    // list all orders that are already in local DB
                    for (Order dbOrder : localOrdersWithOnlineID) {
                        Order matchedOnlineOrder = null;
                        for (Order onlineOrder : parameterOrders) {
                            if (onlineOrder.id.equalsIgnoreCase(dbOrder.id)) {
                                matchedOnlineOrder = onlineOrder;
                                break;
                            }
                        }
                        if (matchedOnlineOrder != null) {
                            if (!dbOrder.is_uploaded_on_server) {
                                LogUtils.e("Order is not updated on server");
                            } else {
                                if (dbOrder.updated_at != null && dbOrder.updated_at.toLowerCase().equalsIgnoreCase(matchedOnlineOrder.updated_at.toLowerCase())) {
                                    LogUtils.e("Continuing... second");
                                    continue;
                                } else {
                                    Customer dbCustomer = appDatabase.customerDao().view(matchedOnlineOrder.customer_id);
                                    int _customer_id;
                                    if (dbCustomer == null) {
                                        dbCustomer = matchedOnlineOrder.customer;
                                        _customer_id = (int) appDatabase.customerDao().insert(matchedOnlineOrder.customer);
                                    } else {
                                        _customer_id = dbCustomer._id;
                                        dbCustomer = matchedOnlineOrder.customer;
                                        dbCustomer._id = _customer_id;
                                        appDatabase.customerDao().update(dbCustomer);
                                        _customer_id = dbCustomer._id;
                                    }
                                    matchedOnlineOrder._customer_id = _customer_id;
                                    matchedOnlineOrder.customer._id = _customer_id;

                                    int _order_id;
                                    matchedOnlineOrder.customer_name = dbCustomer.name;
                                    matchedOnlineOrder.is_uploaded_on_server = true;
                                    if (dbOrder == null) {
                                        _order_id = (int) appDatabase.orderDao().insert(matchedOnlineOrder);
                                        matchedOnlineOrder._id = _order_id;
                                    } else {
                                        matchedOnlineOrder._id = dbOrder._id;
                                        _order_id = dbOrder._id;
                                        // if local order status is not paid then update the order
                                        if (!dbOrder.order_status_id.equalsIgnoreCase("5") || matchedOnlineOrder.order_status_id.equalsIgnoreCase("10")) {
                                            appDatabase.orderDao().update(matchedOnlineOrder);
                                        }
                                    }

                                    shouldNotDeleteThisIds = new ArrayList<>();
                                    if (matchedOnlineOrder.order_splits != null) {
                                        for (OrderSplit split : matchedOnlineOrder.order_splits) {
                                            shouldNotDeleteThisIds.add(split.id);
                                            split._order_id = _order_id;
                                            OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                                            if (dbSplit == null) {
                                                split._id = (int) appDatabase.orderSplitDao().insert(split);
                                            } else {
                                                split._id = dbSplit._id;
                                                appDatabase.orderSplitDao().update(split);
                                            }
                                        }
                                    }
                                    appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                                    shouldNotDeleteThisIds = new ArrayList<>();
                                    if (matchedOnlineOrder.order_payments != null) {
                                        for (OrderPayment payment : matchedOnlineOrder.order_payments) {
                                            shouldNotDeleteThisIds.add(payment.id);
                                            payment._order_id = _order_id;
                                            OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                                            if (dbPayment == null) {
                                                payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                                            } else {
                                                payment._id = dbPayment._id;

                                            }
                                            if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                                                OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                                                if (dbOrderSplit != null)
                                                    payment._order_split_id = dbOrderSplit._id;
                                            }
                                            appDatabase.orderPaymentDao().insert(payment);
                                        }
                                    }

                                    appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                                    if (matchedOnlineOrder.order_items != null) {
                                        appDatabase.orderItemDao().deleteAll(_order_id);
                                        for (OrderItem orderItem : matchedOnlineOrder.order_items) {
                                            orderItem._order_id = _order_id;
                                            OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);

                                            if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                                                OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                                                if (orderSplit != null)
                                                    orderItem._order_split_id = orderSplit._id;
                                            }

                                            int _order_item_id = 0;
                                            if (dbOrderItem == null) {
                                                try {
                                                    _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                                                    orderItem._id = _order_item_id;
                                                } catch (Exception e) {

                                                }
                                            } else {
                                                _order_item_id = dbOrderItem._id;
                                                orderItem._id = _order_item_id;
                                                appDatabase.orderItemDao().update(orderItem);
                                            }

                                            float addonTotal = 0;
                                            shouldNotDeleteThisIds = new ArrayList<>();
                                            if (orderItem.order_item_addons != null) {
                                                for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                                    shouldNotDeleteThisIds.add(itemAddon.id);
                                                    itemAddon._order_item_id = _order_item_id;
                                                    itemAddon.total = itemAddon.quantity * itemAddon.price;
                                                    addonTotal = addonTotal + itemAddon.total;
                                                    OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                                                    if (dbAddon == null) {
                                                        itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                                                    } else {
                                                        itemAddon._id = dbAddon._id;
                                                        appDatabase.orderItemAddonDao().update(itemAddon);
                                                    }
                                                }
                                            }
                                            appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                                            float ingredientTotal = 0;
                                            if (orderItem.order_item_ingredients != null) {
                                                appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                                                for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                                    itemIngredient._order_item_id = _order_item_id;
                                                    itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                                    ingredientTotal = ingredientTotal + itemIngredient.total;
                                                    OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                                                    if (dbAddon == null) {
                                                        itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                                                    } else {
                                                        itemIngredient._id = dbAddon._id;
                                                        appDatabase.orderItemIngredientDao().update(itemIngredient);
                                                    }
                                                }
                                            }

                                            ingredientTotal = ingredientTotal * orderItem.quantity;
                                            addonTotal = addonTotal * orderItem.quantity;
                                            myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    Iterator<Order> iterator = newOnlineOrders.iterator();
                    int count = 1;
                    LogUtils.e("ORDERS", "Saving order start size:" + newOnlineOrders.size());
                    while (iterator.hasNext()) {
                        LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Saving Orders " + count + " of " + newOnlineOrders.size()));
                        Order order = iterator.next();
                        if (isCancelled()) break;
                        Order dbOrder = appDatabase.orderDao().view(order.id);
                        if (dbOrder == null) {
                            // if local order is not updated check with local unique id in order to prevent duplicate order issue
                            dbOrder = appDatabase.orderDao().viewByUniqueId(order.unique_id);
                        }
                        if (dbOrder != null && dbOrder.updated_at.toLowerCase().equalsIgnoreCase(order.updated_at.toLowerCase())) {
                            LogUtils.e("Continuing...");
                            continue;
                        }
                        Customer dbCustomer = appDatabase.customerDao().view(order.customer_id);
                        int _customer_id;
                        if (dbCustomer == null) {
                            dbCustomer = order.customer;
                            _customer_id = (int) appDatabase.customerDao().insert(order.customer);
                        } else {
                            _customer_id = dbCustomer._id;
                            dbCustomer = order.customer;
                            dbCustomer._id = _customer_id;
                            appDatabase.customerDao().update(dbCustomer);
                            _customer_id = dbCustomer._id;
                        }
                        order._customer_id = _customer_id;
                        order.customer._id = _customer_id;

                        int _order_id;
                        order.customer_name = dbCustomer.name;
                        order.is_uploaded_on_server = true;
                        if (dbOrder == null) {
                            _order_id = (int) appDatabase.orderDao().insert(order);
                            order._id = _order_id;
                        } else {
                            order._id = dbOrder._id;
                            _order_id = dbOrder._id;
                            // if local order status is not paid then update the order
                            if (!dbOrder.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10")) {
                                appDatabase.orderDao().update(order);
                            }
                        }

                        shouldNotDeleteThisIds = new ArrayList<>();
                        if (order.order_splits != null) {
                            for (OrderSplit split : order.order_splits) {
                                shouldNotDeleteThisIds.add(split.id);
                                split._order_id = _order_id;
                                OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                                if (dbSplit == null) {
                                    split._id = (int) appDatabase.orderSplitDao().insert(split);
                                } else {
                                    split._id = dbSplit._id;
                                    appDatabase.orderSplitDao().update(split);
                                }
                            }
                        }
                        appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                        shouldNotDeleteThisIds = new ArrayList<>();
                        if (order.order_payments != null) {
                            for (OrderPayment payment : order.order_payments) {
                                shouldNotDeleteThisIds.add(payment.id);
                                payment._order_id = _order_id;
                                OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                                if (dbPayment == null) {
                                    payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                                } else {
                                    payment._id = dbPayment._id;

                                }
                                if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                                    OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                                    if (dbOrderSplit != null)
                                        payment._order_split_id = dbOrderSplit._id;
                                }
                                appDatabase.orderPaymentDao().insert(payment);
                            }
                        }

                        appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                        if (order.order_items != null) {
                            appDatabase.orderItemDao().deleteAll(_order_id);
                            for (OrderItem orderItem : order.order_items) {
                                orderItem._order_id = _order_id;
                                OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);

                                if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                                    OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                                    if (orderSplit != null)
                                        orderItem._order_split_id = orderSplit._id;
                                }

                                int _order_item_id = 0;
                                if (dbOrderItem == null) {
                                    try {
                                        _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                                        orderItem._id = _order_item_id;
                                    } catch (Exception e) {

                                    }
                                } else {
                                    _order_item_id = dbOrderItem._id;
                                    orderItem._id = _order_item_id;
                                    appDatabase.orderItemDao().update(orderItem);
                                }

                                float addonTotal = 0;
                                shouldNotDeleteThisIds = new ArrayList<>();
                                if (orderItem.order_item_addons != null) {
                                    for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                        shouldNotDeleteThisIds.add(itemAddon.id);
                                        itemAddon._order_item_id = _order_item_id;
                                        itemAddon.total = itemAddon.quantity * itemAddon.price;
                                        addonTotal = addonTotal + itemAddon.total;
                                        OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                                        if (dbAddon == null) {
                                            itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                                        } else {
                                            itemAddon._id = dbAddon._id;
                                            appDatabase.orderItemAddonDao().update(itemAddon);
                                        }
                                    }
                                }
                                appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                                float ingredientTotal = 0;
                                if (orderItem.order_item_ingredients != null) {
                                    appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                                    for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                        itemIngredient._order_item_id = _order_item_id;
                                        itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                        ingredientTotal = ingredientTotal + itemIngredient.total;
                                        OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                                        if (dbAddon == null) {
                                            itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                                        } else {
                                            itemIngredient._id = dbAddon._id;
                                            appDatabase.orderItemIngredientDao().update(itemIngredient);
                                        }
                                    }
                                }

                                ingredientTotal = ingredientTotal * orderItem.quantity;
                                addonTotal = addonTotal * orderItem.quantity;
                                myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                            }
                        } else {

                        }
                        count++;
                    }
                    if (isCancelled()) return null;

                }
            } catch (Exception e) {
                e.printStackTrace();
            }


            LogUtils.e("ORDERS", "IN background finish");
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                nextMethod.call();
            } catch (Exception e) {
                e.printStackTrace();
            }
            myApp.shallWeRefreshOrders = true;

        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            try {
                nextMethod.call();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fetchRestaurantDetails() {
        try {
            if (Validators.isNullOrEmpty(myApp.getRestaurantId())) {
                return;
            }
            AndroidNetworking.get(ApiEndPoints.restaurant_details + myApp.restaurant_id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            myPreferences.saveRestaurant(response);
                        }

                        @Override
                        public void onError(ANError anError) {

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    BroadcastReceiver textMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            tvMessage.setText(intent.getStringExtra("message"));
        }
    };

    BroadcastReceiver imageDownloadReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {

            try {
                int position = intent.getIntExtra("position", -1);
                if (position == products.size() - 1) {
                    if (isOrderedBroadcast())
                        PullActivity.this.setResult(RESULT_OK);
                    if (!Validators.isNullOrEmpty(destination) && destination.equalsIgnoreCase("home")) {
                        startActivity(new Intent(PullActivity.this, HomeActivity.class));
                    }
                    finish();
                } else {
                    tvMessage.setText(String.format("Downloading images %d of %d", position + 2, products.size()));
                    Product product = products.get(position + 1);
                    startService(new Intent(PullActivity.this, ImageDownloadService.class).putExtra("image_url", product.image_url).putExtra("position", position + 1).putExtra("product_id", product.id));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    };

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (imageDownloadReceiver != null)
                registerReceiver(imageDownloadReceiver, new IntentFilter(
                        "image_download_download"));
            if (textMessageReceiver != null)
                LocalBroadcastManager.getInstance(this).registerReceiver(textMessageReceiver, new IntentFilter(
                        "message_receiver"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {
        ToastUtils.makeLongToast(this, "Please wait while pulling data");
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            if (imageDownloadReceiver != null) {
                unregisterReceiver(imageDownloadReceiver);
            }
            if (textMessageReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(textMessageReceiver);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
