package com.ubsidi.epos_2021.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

/**
 * Created by Amrish on 27-09-2021.
 */
public class PullCustomersActivity extends BaseActivity {
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_pull);
    }
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;
    private TextView tvMessage;
    private Admin loggedInAdmin = myPreferences.getLoggedInAdmin();

    @Override
    protected void manageIntents() {
        super.manageIntents();
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            tvMessage = findViewById(R.id.tvMessage);
            tvMessage.setText("Fetching customers");
            if (!myApp.isConnected(PullCustomersActivity.this)) {
                ToastUtils.makeSnackToast(PullCustomersActivity.this, "No internet connection");
                startActivity(new Intent(PullCustomersActivity.this, HomeActivity.class));
                finish();
            } else
                fetchData();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        try {
            LogUtils.e("Fetching Pull");
            AndroidNetworking.get(ApiEndPoints.customers)
                    .addQueryParameter("request_for", "admin")
                    .addQueryParameter("business_id", loggedInAdmin.selected_business.id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Customer.class, new ParsedRequestListener<List<Customer>>() {
                        @Override
                        public void onResponse(List<Customer> response) {
                            new CustomersSaver(() -> {
                                setResult(RESULT_OK);
                                finish();
                                startActivity(new Intent(PullCustomersActivity.this, HomeActivity.class));
                                return null;
                            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                        }

                        @Override
                        public void onError(ANError anError) {
                            LogUtils.e("Error in pull customers");
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(PullCustomersActivity.this, apiError.getMessage());
                            }
                            if (!myApp.isConnected(PullCustomersActivity.this)) {
                                ToastUtils.makeSnackToast(PullCustomersActivity.this, "No internet connection");
                            }
                            startActivity(new Intent(PullCustomersActivity.this, HomeActivity.class));
                            finish();
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private class CustomersSaver extends AsyncTask<List<Customer>, Void, String> {
        Callable<Void> nextThing;

        public CustomersSaver(Callable<Void> nextThing) {
            this.nextThing = nextThing;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(List<Customer>... object) {
            try {
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
                List<Customer> customers = object[0];
                // Save Customers
                LocalBroadcastManager.getInstance(PullCustomersActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Saving Customers"));
                ArrayList<String> alreadySavedIds = (ArrayList<String>) appDatabase.customerDao().customerIds();

                ArrayList<String> shouldNotDeleteThisIds = new ArrayList<>();
                int count = 0;
                if (customers != null && customers.size() > 0) {
    //                List<Customer> allCustomers = Collections.unmodifiableList(customers.customers);
    //                List<List<Customer>> parts = chopped(allCustomers, 998);
    //                int coutn1 = 1;
    //                for (List<Customer> cList : parts) {
    //                    appDatabase.customerDao().insertMultiple(cList);
    //                    LogUtils.e("Savings customers: " + cList.size() + "  Page:" + coutn1);
    //                    LocalBroadcastManager.getInstance(PullActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", String.format("Saving %d customers of %d customers", coutn1 * cList.size(), customers.customers.size())));
    //                    coutn1++;
    //                }
                    for (Customer c : customers) {
                        shouldNotDeleteThisIds.add(c.id);
                        Customer dbCustomer = appDatabase.customerDao().view(c.id);
                        if (dbCustomer != null) {
                            c._id = dbCustomer._id;
                        }
                        appDatabase.customerDao().insert(c);
                        count++;
                        LocalBroadcastManager.getInstance(PullCustomersActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", String.format("Saving %d customers of %d customers", count, customers.size())));
                    }
                }

                ArrayList<String> deletableIds = new ArrayList<>();
                for (String id : alreadySavedIds) {
                    if (!shouldNotDeleteThisIds.contains(id)) {
                        deletableIds.add(id);
                    }
                }
                LocalBroadcastManager.getInstance(PullCustomersActivity.this).sendBroadcast(new Intent("message_receiver").putExtra("message", "Finishing up"));
                for (String id : deletableIds) {
                    appDatabase.customerDao().delete(id);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }


            return "Executed";
        }

        <T> List<List<T>> chopped(List<T> list, final int L) {
            List<List<T>> parts = new ArrayList<List<T>>();
            final int N = list.size();
            for (int i = 0; i < N; i += L) {
                parts.add(new ArrayList<T>(
                        list.subList(i, Math.min(N, i + L)))
                );
            }
            return parts;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                myApp.setupData();
                setResult(RESULT_OK);
                myPreferences.savePullStatus(true);
                if (nextThing != null) {
                    try {
                        nextThing.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    BroadcastReceiver textMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            tvMessage.setText(intent.getStringExtra("message"));
        }
    };

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (textMessageReceiver != null)
            {
                LocalBroadcastManager.getInstance(this).registerReceiver(textMessageReceiver, new IntentFilter(
                        "message_receiver"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {
        ToastUtils.makeLongToast(this, "Please wait while pulling data");
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            if (textMessageReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(textMessageReceiver);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
