package com.ubsidi.epos_2021.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Device;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.ToastUtils;

/**
 * Created by Amrish on 07-05-2021.
 */
public class RegisterDeviceActivity extends BaseActivity {
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.dialog_register_device);
    }
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    MaterialButton btnSubmit;
    EditText etDeviceName;
    TextView tvMessage;
    AlertDialog progressDialog;
    LinearLayout llMainLayout;
    boolean canRefresh;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        fetchDevice();
        setListeners();
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            progressDialog = CommonFunctions.customProgressDialog(this);
            llMainLayout = findViewById(R.id.llMainLayout);
            etDeviceName = findViewById(R.id.etDeviceName);
            tvMessage = findViewById(R.id.tvMessage);
            btnSubmit = findViewById(R.id.btnSubmit);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnSubmit.setOnClickListener(view -> {
                if (canRefresh) {
                    fetchDevice();
                } else {
                    if (Validators.isNullOrEmpty(etDeviceName.getText().toString())) {
                        etDeviceName.setError("Please enter device name");
                        etDeviceName.requestFocus();
                    } else {
                        saveDevice();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchDevice() {
        try {
            progressDialog.show();
            llMainLayout.setVisibility(View.GONE);
            AndroidNetworking.post(ApiEndPoints.devices + "validate/" + myApp.getDeviceId())
                    .addBodyParameter("device_token", myPreferences.getUserFCMToken())
                    .addQueryParameter("request_for", "admin")
                    .build()
                    .getAsObject(Device.class, new ParsedRequestListener<Device>() {
                        @Override
                        public void onResponse(Device response) {
                            myPreferences.saveRegisteredDevice(response);
                            progressDialog.dismiss();
                            canRefresh = true;
                            if (response.disabled || Validators.isNullOrEmpty(response.status) || !response.status.equalsIgnoreCase("approved")) {
                                tvMessage.setText(etDeviceName.getText().toString() + myApp.getDeviceId() + " is not approved yet, Please contact service provider to activate");
                                etDeviceName.setVisibility(View.GONE);
                                btnSubmit.setText("REFRESH");
                                llMainLayout.setVisibility(View.VISIBLE);
                            } else {
                                startActivity(new Intent(RegisterDeviceActivity.this, SplashActivity.class));
                                finish();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            progressDialog.dismiss();
                            tvMessage.setText("Please submit your device name \nand contact to TiffinTom administration to approve your device");
                            etDeviceName.setVisibility(View.VISIBLE);
                            btnSubmit.setText("Add device");
                            llMainLayout.setVisibility(View.VISIBLE);
                            canRefresh = false;
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void saveDevice() {
        try {
            progressDialog.show();
            Device device = new Device();
            device.business_id = myPreferences.getBusinessId();
            device.name = etDeviceName.getText().toString();
            device.device_type = "Android";
            device.type = "Android";
            device.service_type = "Epos";
            device.device_token = myPreferences.getUserFCMToken();
            device.device_id = myApp.getDeviceId();

            AndroidNetworking.post(ApiEndPoints.devices)
                    .addApplicationJsonBody(device)
                    .addQueryParameter("request_for", "admin")
                    .build()
                    .getAsObject(Device.class, new ParsedRequestListener<Device>() {
                        @Override
                        public void onResponse(Device response) {
                            progressDialog.dismiss();
                            myPreferences.saveRegisteredDevice(response);
                            if (response.disabled || Validators.isNullOrEmpty(response.status) || !response.status.equalsIgnoreCase("approved")) {
                                canRefresh = true;
                                tvMessage.setText(etDeviceName.getText().toString() + myApp.getDeviceId() + " is not approved yet, Please contact service provider to activate");
                                etDeviceName.setVisibility(View.GONE);
                                btnSubmit.setText("REFRESH");
                                llMainLayout.setVisibility(View.VISIBLE);
                            } else {
                                if(myPreferences.getBusinessId().equals("1025")){
                                    startActivity(new Intent(RegisterDeviceActivity.this, SplashActivity.class));
                                }else {
                                    startActivity(new Intent(RegisterDeviceActivity.this, LoginActivity.class));
                                }
                                finish();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            progressDialog.dismiss();
                            tvMessage.setText("Please submit your device name \nand contact to TiffinTom administration to approve your device");
                            etDeviceName.setVisibility(View.VISIBLE);
                            btnSubmit.setText("Add device");
                            llMainLayout.setVisibility(View.VISIBLE);
                            canRefresh = false;
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(RegisterDeviceActivity.this, apiError.getMessage());
                            } else {
                                anError.printStackTrace();
                                ToastUtils.makeSnackToast(RegisterDeviceActivity.this, "Something went wrong!");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
