package com.ubsidi.epos_2021.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.SelectBusinessAdapter;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Amrish on 23-04-2021.
 */
public class SelectBusinessActivity extends BaseActivity {
    private RecyclerView rvBusinesses;
    private SelectBusinessAdapter selectBusinessAdapter;
    private ArrayList<Business> businesses = new ArrayList<>();
    private MaterialButton btnConfirm;
    AlertDialog progressDialog;
    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public Business selectedBusiness;
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_select_business);
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            progressDialog = CommonFunctions.customProgressDialog(this);
            rvBusinesses = findViewById(R.id.rvBusinesses);
            btnConfirm = findViewById(R.id.btnConfirm);
            btnConfirm.setEnabled(false);
            selectBusinessAdapter = new SelectBusinessAdapter(businesses, new RecyclerviewItemClickListener() {
                @Override
                public void onItemClick(int position, Object data) {
                    btnConfirm.setEnabled(true);
                    selectedBusiness = (Business) data;
                    myPreferences.saveBusinessId(selectedBusiness.id);
                    myPreferences.saveForOfflineLoginBusinessId(selectedBusiness.id);
                    Admin admin = myPreferences.getLoggedInAdmin();
                    admin.selected_business = selectedBusiness;
                    myPreferences.saveLoggedInAdmin(admin);
                    myPreferences.saveForOfflineLoginLoggedInAdmin(admin);
                }
            });
            if(!Validators.isNullOrEmpty(myPreferences.getBusinessId())){
                selectBusinessAdapter.selectedBusinessId = myPreferences.getBusinessId();
                btnConfirm.setEnabled(true);
            }
            rvBusinesses.setAdapter(selectBusinessAdapter);
            rvBusinesses.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            fetchBusinesses();
            btnConfirm.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    saveDeviceDetails();

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveDeviceDetails() {
        try {
            startActivity(new Intent(SelectBusinessActivity.this, RegisterDeviceActivity.class));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchBusinesses() {
        try {
            progressDialog.show();
            AndroidNetworking.get(ApiEndPoints.businesses)
                    .addQueryParameter("request_for", "admin")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Business.class, new ParsedRequestListener<List<Business>>() {

                        @Override
                        public void onResponse(List<Business> response) {
                            businesses.addAll(response);
                            selectBusinessAdapter.notifyDataSetChanged();
                            progressDialog.dismiss();
                        }

                        @Override
                        public void onError(ANError anError) {
                            progressDialog.dismiss();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(SelectBusinessActivity.this, apiError.getMessage());
                            } else {
                                anError.printStackTrace();
                                ToastUtils.makeSnackToast(SelectBusinessActivity.this, "Something went wrong!");
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
