package com.ubsidi.epos_2021.activities;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.multidex.BuildConfig;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.google.firebase.messaging.FirebaseMessaging;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Device;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.InternetUtils;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;


public class SplashActivity extends BaseActivity {

    Handler handler;
    Runnable runnable;
    String dpiMode = "";

    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);

        try {
            //Send previous reports;
            FirebaseCrashlytics.getInstance().sendUnsentReports();

            myApp.saveScreenWidth(this);

            runnable = () -> new CheckInternetConnectivity().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            handler = new Handler(Looper.getMainLooper());
            switch (getResources().getDisplayMetrics().densityDpi) {
                case DisplayMetrics.DENSITY_LOW:
                    // handle your code here for ldpi
                    dpiMode = "LDPI";
                    break;
                case DisplayMetrics.DENSITY_MEDIUM:
                    // handle your code here for mdpi
                    dpiMode = "MDPI";
                    break;
                case DisplayMetrics.DENSITY_HIGH:
                    // handle your code here for hdpi
                    dpiMode = "HDPI";
                    break;
                case DisplayMetrics.DENSITY_XHIGH:
                    // handle your code here for xhdpi
                    dpiMode = "XHDPI";
                    break;
                case DisplayMetrics.DENSITY_XXHIGH:
                    // handle your code here for xxhdpi
                    dpiMode = "XXHDPI";
                    break;
                case DisplayMetrics.DENSITY_XXXHIGH:
                    // handle your code here for xxxhdpi
                    dpiMode = "XXXHDPI";
                    break;
            }
            LogUtils.e("DEVICE::: DPI MODE: " + dpiMode + " Density: " + getResources().getDisplayMetrics().density + " ScaledDensity:" + getResources().getDisplayMetrics().scaledDensity);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CheckInternetConnectivity extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection) new URL(ApiEndPoints.BASE_URL()).openConnection();
                connection.setRequestProperty("User-Agent", "Test");
                connection.setRequestProperty("Connection", "close");
                connection.setConnectTimeout(1500);
                connection.connect();
                return String.valueOf((connection.getResponseCode() == 200));
            } catch (IOException e) {
                e.printStackTrace();
                LogUtils.e(e.getMessage());
            }
            return "false";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            handleNavigation();
        }
    }

    private void handleNavigation() {
        try {
            if (myPreferences.getBusinessId() == null) {
                if (myPreferences.getLoggedInAdmin() != null) {
                    startActivity(new Intent(SplashActivity.this, SelectBusinessActivity.class));
                } else {
                    startActivity(new Intent(SplashActivity.this, AdminLoginActivity.class));
                }
                finish();
            } else if (myPreferences.getRegisteredDevice() == null || myPreferences.getRegisteredDevice().disabled) {
                startActivity(new Intent(SplashActivity.this, RegisterDeviceActivity.class));
                finish();
            } else {
                FirebaseCrashlytics.getInstance().setCustomKey("sync_mode", myPreferences.getOrderSyncMode());
                FirebaseCrashlytics.getInstance().setCustomKey("crash_device_name", myPreferences.getRegisteredDevice().name);
                FirebaseCrashlytics.getInstance().setCustomKey("crash_device_email", myPreferences.getLoggedInAdmin().login_email);
                FirebaseCrashlytics.getInstance().setCustomKey("country", getResources().getConfiguration().locale.getCountry());
                FirebaseCrashlytics.getInstance().setCustomKey("build_type", BuildConfig.BUILD_TYPE);
                FirebaseCrashlytics.getInstance().setCustomKey("ui_type", "NEW");
                FirebaseCrashlytics.getInstance().setCustomKey("dpi", dpiMode);
                FirebaseCrashlytics.getInstance().setCustomKey("server", ApiEndPoints.ubsidiBuild ? "ubsidi" : "testrms");
                FirebaseCrashlytics.getInstance().setCustomKey("business", myPreferences.getLoggedInAdmin().selected_business.name);
                try {
                    FirebaseCrashlytics.getInstance().setCustomKey("first_install_at", CommonFunctions.convertMsToDesiredFormat(getPackageManager().getPackageInfo(BuildConfig.APPLICATION_ID, 0).firstInstallTime, Constants.PHP_DATE_TIME_FORMAT));
                    FirebaseCrashlytics.getInstance().setCustomKey("last_update_at", CommonFunctions.convertMsToDesiredFormat(getPackageManager().getPackageInfo(BuildConfig.APPLICATION_ID, 0).lastUpdateTime, Constants.PHP_DATE_TIME_FORMAT));
                } catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
                if (myApp.isConnected(SplashActivity.this))
                    fetchSiteSettings();
                else checkPullData();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchSiteSettings() {
        try {
            LogUtils.e("Fetching Site Settings");
            AndroidNetworking.get(ApiEndPoints.site_settings)
                    .addQueryParameter("request_for", "admin")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(SiteSetting.class, new ParsedRequestListener<List<SiteSetting>>() {
                        @Override
                        public void onResponse(List<SiteSetting> response) {
                            Log.e("Response", "" + response.size());

//                            for (int i = 0; i < response.size(); i++) {
//                                Log.d("Site Setting Key", response.get(i).key);
//                                Log.d("Site Setting Value", response.get(i).value);
//                            }

                            if ("auto".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                                myApp.siteSettings.clear();
                                myApp.siteSettings.addAll(response);

                                new Thread(() -> {
                                    myApp.appDatabase.siteSettingDao().insertMultiple(response);
                                    checkPullData();
                                }).start();
                            } else {
                                checkPullData();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            Log.e("Response", " " + anError.getErrorCode());
                            Log.e("Response", " " + anError.getMessage());

                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(SplashActivity.this, apiError.getMessage());
                            } else if (anError.getErrorCode() == 401) {
                                logoutAdmin();
                            } else if (anError.getErrorCode() != 403) {
                                checkPullData();
                                if (!myApp.isConnected(SplashActivity.this) || "manual".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                                } else {
                                    ToastUtils.makeSnackToast(SplashActivity.this, "Cannot connect to server");
                                }
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logoutAdmin() {
        try {
            FirebaseMessaging.getInstance().unsubscribeFromTopic("business_" + myPreferences.getLoggedInAdmin().selected_business.id);
            myPreferences.saveLoggedInAdmin(null);
            myPreferences.saveLoggedInUser(null);
            myPreferences.saveUserTokens(null, null);
            myPreferences.saveAdminTokens(null, null);
            myPreferences.userLoggedInWithoutInternet(false);
            myPreferences.adminLoggedInWithoutInternet(false);
            myPreferences.saveBusinessId(null);
            /*new Thread(() -> {
                appDatabase.emptyPulledDao().nukeAddon();
                appDatabase.emptyPulledDao().nukeCategory();
                appDatabase.emptyPulledDao().nukeCustomer();
                appDatabase.emptyPulledDao().nukePrepLocation();
                appDatabase.emptyPulledDao().nukeProduct();
                appDatabase.emptyPulledDao().nukeProductAddon();
                appDatabase.emptyPulledDao().nukeProductIngredient();
                appDatabase.emptyPulledDao().nukeTable();
                appDatabase.emptyPulledDao().nukeFloor();
                appDatabase.emptyPulledDao().nukeOrderItemIngredient();
                appDatabase.emptyPulledDao().nukeOrderItemAddon();
                appDatabase.emptyPulledDao().nukeOrderPayment();
                appDatabase.emptyPulledDao().nukeOrderSplit();
                appDatabase.emptyPulledDao().nukeOrder();
                appDatabase.emptyPulledDao().nukeUsers();
                appDatabase.emptyPulledDao().nukeReservations();
                appDatabase.orderDao().resetPrimaryKey();
                try {
                    deleteImages();
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }).start();
         */
            myPreferences.savePullStatus(false);
            startActivity(new Intent(this, SplashActivity.class));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteImages() {
        try {
            File dir = new File(getApplicationContext().getExternalFilesDir("epos2021").getAbsolutePath());
            if (dir.isDirectory()) {
                String[] children = dir.list();
                if (children != null) {
                    for (String child : children) {
                        try {
                            new File(dir, child).delete();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkPullData() {
        try {
            if (myApp.siteSettings == null || myApp.siteSettings.size() == 0) {
                new Thread(() -> {
                    myApp.siteSettings = new ArrayList<>();
                    myApp.siteSettings.addAll(new ArrayList<>(appDatabase.siteSettingDao().list()));
                    Log.d("Site Settings", "size: " + myApp.siteSettings.size());

//                    for (int i = 0; i < myApp.siteSettings.size(); i++) {
//                        Log.d("Site Setting Key1", myApp.siteSettings.get(i).key);
//                        Log.d("Site Setting Value1", myApp.siteSettings.get(i).value);
//                    }
                }).start();
            }

            if (myApp.tableStatuses == null || myApp.tableStatuses.size() == 0) {
                new Thread(() -> {
                    myApp.tableStatuses = new ArrayList<>();
                    myApp.tableStatuses.addAll(new ArrayList<>(appDatabase.tableStatusDao().list()));
                    LogUtils.e("Table Statuses");
                    LogUtils.e(myApp.tableStatuses);
                }).start();
            }
            if (!myPreferences.getPullStatus() && InternetUtils.isNetworkConnected(this)) {
                pullData();
            } else {
                if (!myApp.isConnected(SplashActivity.this)) {
                    if (myPreferences.getRegisteredDevice().disabled || Validators.isNullOrEmpty(myPreferences.getRegisteredDevice().status) || !myPreferences.getRegisteredDevice().status.equalsIgnoreCase("approved")) {
                        startActivity(new Intent(SplashActivity.this, RegisterDeviceActivity.class));
                    } else {
                        if (myPreferences.getLoggedInUser() != null) {
                            SiteSetting appVersionSetting = myApp.findSetting("epos_android_app_version");
                            MyApp.userPermission = myPreferences.getEposUserPermission();
                            try {
                                //if (appVersionSetting != null && Integer.parseInt(appVersionSetting.value) > BuildConfig.VERSION_CODE) {
                                if (appVersionSetting != null && compareVersionNames(myApp.getVersionName(),appVersionSetting.value)<0){
                                    showAppUpdateAvailable();
                                } else {
                                    startActivity(new Intent(SplashActivity.this, HomeActivity.class));
                                }
                            } catch (Exception e) {
                                startActivity(new Intent(SplashActivity.this, HomeActivity.class));
                            }
                        } else {
                            startActivity(new Intent(SplashActivity.this, LoginActivity.class));
                        }
                    }
                    finish();
                } else
                    checkDeviceValidationAndContinueToUserScreen();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showAppUpdateAvailable() {
        try {
            //startActivity(new Intent(this, AppVersionUpdateActivity.class));
            startActivity(new Intent(this, InAppUpdateActivity.class));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void pullData() {
        try {
            startActivityForResult(new Intent(SplashActivity.this, PullActivity.class), Constants.CODE_REFRESH);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkDeviceValidationAndContinueToUserScreen() {
        try {
            AndroidNetworking.post(ApiEndPoints.devices + "validate/" + myApp.getDeviceId())
                    .addBodyParameter("device_token", myPreferences.getUserFCMToken())
                    .addQueryParameter("request_for", "admin")
                    .build()
                    .getAsObject(Device.class, new ParsedRequestListener<Device>() {
                        @Override
                        public void onResponse(Device response) {
                            myPreferences.saveRegisteredDevice(response);
                            if (response.disabled || Validators.isNullOrEmpty(response.status) || !response.status.equalsIgnoreCase("approved")) {
                                startActivity(new Intent(SplashActivity.this, RegisterDeviceActivity.class));
                            } else {
                                if (myPreferences.getLoggedInUser() != null) {
                                    SiteSetting appVersionSetting = myApp.findSetting("epos_android_app_version");
                                    MyApp.userPermission = myPreferences.getEposUserPermission();
                                    try {
                                        //if (appVersionSetting != null && Integer.parseInt(appVersionSetting.value) > BuildConfig.VERSION_CODE) {
                                        if (appVersionSetting != null && compareVersionNames(myApp.getVersionName(),appVersionSetting.value)<0){
                                            showAppUpdateAvailable();
                                        } else {
                                            startActivity(new Intent(SplashActivity.this, HomeActivity.class));
                                        }
                                    } catch (Exception e) {
                                        startActivity(new Intent(SplashActivity.this, HomeActivity.class));
                                    }
                                } else {
                                    // Prevent opening login activity multiple times
                                    startActivity(new Intent(SplashActivity.this, LoginActivity.class).setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP));
                                    finish();
                                    return;
                                }
                            }
                            finish();
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(SplashActivity.this, apiError.getMessage());
                                startActivity(new Intent(SplashActivity.this, RegisterDeviceActivity.class));
                            } else if (anError.getErrorCode() != 403) {
                                if (anError.getErrorCode() == 0 || !myApp.isConnected(SplashActivity.this) || "manual".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                                    if (myPreferences.getRegisteredDevice().disabled || Validators.isNullOrEmpty(myPreferences.getRegisteredDevice().status) || !myPreferences.getRegisteredDevice().status.equalsIgnoreCase("approved")) {
                                        startActivity(new Intent(SplashActivity.this, RegisterDeviceActivity.class));
                                    } else {
                                        if (myPreferences.getLoggedInUser() != null) {
                                            SiteSetting appVersionSetting = myApp.findSetting("epos_android_app_version");
                                            MyApp.userPermission = myPreferences.getEposUserPermission();
                                            try {
                                                //if (appVersionSetting != null && Integer.parseInt(appVersionSetting.value) > BuildConfig.VERSION_CODE) {
                                                if (appVersionSetting != null && compareVersionNames(myApp.getVersionName(),appVersionSetting.value)<0){
                                                    showAppUpdateAvailable();
                                                } else {
                                                    startActivity(new Intent(SplashActivity.this, HomeActivity.class));
                                                }
                                            } catch (Exception e) {
                                                startActivity(new Intent(SplashActivity.this, HomeActivity.class));
                                            }
                                        } else {
                                            // Prevent opening login activity multiple times
                                            startActivity(new Intent(SplashActivity.this, LoginActivity.class).setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP));
                                            finish();
                                            return;
                                        }
                                    }
                                    finish();
                                } else {
                                    ToastUtils.makeSnackToast(SplashActivity.this, "Cannot connect to server");
                                }
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    protected void onResume() {
        super.onResume();
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU){
                if (ContextCompat.checkSelfPermission(SplashActivity.this, Manifest.permission.READ_MEDIA_IMAGES) != PackageManager.PERMISSION_GRANTED &&
                        ContextCompat.checkSelfPermission(SplashActivity.this, Manifest.permission.READ_MEDIA_VIDEO) != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(SplashActivity.this, new String[]{Manifest.permission.READ_MEDIA_IMAGES}, 123);
                    ActivityCompat.requestPermissions(SplashActivity.this, new String[]{Manifest.permission.READ_MEDIA_VIDEO}, 123);
                    Toast.makeText(SplashActivity.this, "Need Permission to access storage for Downloading Image", Toast.LENGTH_SHORT).show();
                    //            showToast("Need Permission to access storage for Downloading Image");
                } else {
                    if (handler != null && runnable != null) {
                        handler.postDelayed(runnable, 400);
                    }
                }
            }else {
                if (ContextCompat.checkSelfPermission(SplashActivity.this, Manifest.permission.READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED &&
                        ContextCompat.checkSelfPermission(SplashActivity.this, Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(SplashActivity.this, new String[]{Manifest.permission.READ_EXTERNAL_STORAGE}, 123);
                    ActivityCompat.requestPermissions(SplashActivity.this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, 123);
                    Toast.makeText(SplashActivity.this, "Need Permission to access storage for Downloading Image", Toast.LENGTH_SHORT).show();
                    //            showToast("Need Permission to access storage for Downloading Image");
                } else {
                    if (handler != null && runnable != null) {
                        handler.postDelayed(runnable, 400);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            if (handler != null && runnable != null) {
                handler.removeCallbacks(runnable);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Constants.CODE_REFRESH && resultCode == RESULT_OK) {
            try {
                checkDeviceValidationAndContinueToUserScreen();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int compareVersionNames(String oldVersionName, String newVersionName) {
        int res = 0;

        String[] oldNumbers = oldVersionName.split("\\.");
        String[] newNumbers = newVersionName.split("\\.");

        // To avoid IndexOutOfBounds
        int maxIndex = Math.min(oldNumbers.length, newNumbers.length);

        for (int i = 0; i < maxIndex; i ++) {
            int oldVersionPart = Integer.valueOf(oldNumbers[i]);
            int newVersionPart = Integer.valueOf(newNumbers[i]);

            if (oldVersionPart < newVersionPart) {
                res = -1;
                break;
            } else if (oldVersionPart > newVersionPart) {
                res = 1;
                break;
            }
        }

        // If versions are the same so far, but they have different length...
        if (res == 0 && oldNumbers.length != newNumbers.length) {
            res = (oldNumbers.length > newNumbers.length)?1:-1;
        }

        return res;
    }
}
