package com.ubsidi.epos_2021.activities;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.SplitGroupAdapter;
import com.ubsidi.epos_2021.adapters.SplitOrderItemsAdapter;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.daos.relations.OrderItemWithAddonsIngredients;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.fragment.ConfirmationDialogFragment;
import com.ubsidi.epos_2021.models.Discount;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.ubsidi.epos_2021.utils.WrapContentLinearLayoutManager;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

/**
 * Created by Amrish on 13-05-2021.
 */
public class SplitActivity extends BaseActivity {
    public MyApp myApp = MyApp.getInstance();
    public AppDatabase appDatabase = myApp.appDatabase;
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_split);
    }

    private AlertDialog progressBarDialog;
    private TextView tvTotal;
    public static TextView tvSelectedAmount;
    private Toolbar toolbar;
    private RadioButton rbSplitByPerson, rbSplitByItem;
    private RadioGroup rgSplit;
    private Order order;
    private TextView tvSplitByItem, tvSplitByPerson;
    private View vItemSelector, vPersonSelector;
    private Chip chipBack;
    private TextView tvTime, tvTypeTitle, tvItemTitle;
    private EditText etPerson;
    private Handler mHandler;
    private LinearLayout llSplitByItem, llSplitByPerson;
    private RecyclerView rvNonSplitOrderItems, rvSplitOrderItems, rvSplitGroups;
    private MaterialButton btnPayBill, btnPrint, btnPrintAll;
    private LinearLayout llSubTotal, llDiscount, llGratuity, llServiceCharge, llDelivery;
    private TextView tvGratuity, tvServiceCharge, tvDelivery, tvSubtotal, tvDiscount, tvGrandTotal, tvBalance;
    private TextView tvGratuityText, tvServiceChargeText, tvDiscountText;
    private ImageView ivSplit;
    private MaterialButton btnSplit;
    private LinearLayout llSplitGroups;

    private SplitOrderItemsAdapter splitOrderItemsAdapter, nonSplitOrderItemsAdapter;
    private final ArrayList<OrderItem> splitOrderItems = new ArrayList<>();
    private final ArrayList<OrderItem> nonSplitOrderItems = new ArrayList<>();
    private final ArrayList<OrderSplit> orderSplits = new ArrayList<>();
    private OrderSplit selectedSplitGroup;
    private SplitGroupAdapter splitGroupAdapter;

    private boolean splitByItem = true;
    private int splitCount = 0;
    private int selectedSplitId;
    private float cartGrandTotal = 0, cartSubTotal = 0, cartDiscount = 0, cartGratuity = 0, cartServiceCharge = 0;
    private boolean serviceChargeAutoMode = true, serviceChargeEnabled = false, discountEnabled = true, gratuityEnabled = true, autoDiscountApplied = false;
    private SiteSetting serviceChargeSetting, serviceChargeTypeSetting;
    private int _order_id;
    private String order_id;
    private LinearLayout llExpand, llGrandTotal;
    private ImageView ivExpand;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getIntent() != null) {
                order = new Gson().fromJson(getIntent().getStringExtra("order"), Order.class);
                _order_id = getIntent().getIntExtra("_order_id", -1);
                order_id = getIntent().getStringExtra("order_id");
            }
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            setListeners();

            fetchOffline(true);
            updateTime();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews() {
        super.initViews();

        try {
            progressBarDialog = CommonFunctions.customProgressDialog(this);
            toolbar = findViewById(R.id.toolbar);
            tvSelectedAmount = findViewById(R.id.tvSelectedAmount);
            tvTotal = findViewById(R.id.tvTotalPay);
            rgSplit = findViewById(R.id.rgSplit);
            rbSplitByItem = findViewById(R.id.rbSplitByItem);
            rbSplitByPerson = findViewById(R.id.rbSplitByPerson);

            llSplitByItem = findViewById(R.id.llSplitByItem);
            llSplitByPerson = findViewById(R.id.llSplitByPerson);
            tvSplitByItem = findViewById(R.id.tvSplitByItem);
            tvSplitByPerson = findViewById(R.id.tvSplitByPerson);
            vItemSelector = findViewById(R.id.vItemSelector);
            vPersonSelector = findViewById(R.id.vPersonSelector);

            chipBack = findViewById(R.id.chipBack);
            tvTime = findViewById(R.id.tvTime);
            tvTypeTitle = findViewById(R.id.tvTypeTitle);
            tvItemTitle = findViewById(R.id.tvItemTitle);
            etPerson = findViewById(R.id.etPerson);
            rvNonSplitOrderItems = findViewById(R.id.rvNonSplitOrderItems);
            rvSplitOrderItems = findViewById(R.id.rvSplitOrderItems);
            rvSplitGroups = findViewById(R.id.rvSplitGroups);
            btnPayBill = findViewById(R.id.btnPayBill);
            btnPrint = findViewById(R.id.btnSplitPrint);
            btnPrintAll = findViewById(R.id.btnPrintAll);

            llSubTotal = findViewById(R.id.ll_SubTotal);
            llDelivery = findViewById(R.id.ll_Delivery);
            llGratuity = findViewById(R.id.ll_Gratuity);
            llServiceCharge = findViewById(R.id.ll_ServiceCharge);
            llDiscount = findViewById(R.id.ll_Discount);
            llGrandTotal = findViewById(R.id.llGrandTotal);
            llExpand = findViewById(R.id.llExpandable);
            ivExpand = findViewById(R.id.ivExpand);
            tvSubtotal = findViewById(R.id.tvSubtotal);
            tvDelivery = findViewById(R.id.tvDelivery);
            tvGratuity = findViewById(R.id.tvGratuity);
            tvServiceCharge = findViewById(R.id.tvServiceFee);
            tvDiscount = findViewById(R.id.tvDiscount);
            tvGrandTotal = findViewById(R.id.tvGrandTotal);

            tvDiscountText = findViewById(R.id.tvDiscountText);
            tvServiceChargeText = findViewById(R.id.tvServiceText);
            tvGratuityText = findViewById(R.id.tvGratuityText);
            tvBalance = findViewById(R.id.tvBalance);
            ivSplit = findViewById(R.id.ivSplit);

            btnSplit = findViewById(R.id.btnSplit);
            llSplitGroups = findViewById(R.id.llSplitGroups);

            setSupportActionBar(toolbar);
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setTitle(" ");
            toolbar.setNavigationIcon(R.drawable.ic_baseline_arrow_back_24);

            String currentTime = new SimpleDateFormat("h:mm a", Locale.getDefault()).format(new Date());
            tvTime.setText(currentTime);

            serviceChargeSetting = myApp.findSetting("service_charge");
            serviceChargeTypeSetting = myApp.findSetting("service_charge_type");

            btnPrintAll.setVisibility(View.GONE);
            btnPayBill.setEnabled(false);
            setAdapters();
            llExpand.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAdapters() {
        try {
            splitOrderItemsAdapter = new SplitOrderItemsAdapter(splitOrderItems, (position, data) -> {
                if (order.total_paid == 0) {
                    new RemoveItemFromSplitAsync(() -> {
                        fetchOffline(false);
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (OrderItem) data);
                }
            });
            rvSplitOrderItems.setLayoutManager(new WrapContentLinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));  // Handled multiple clicks rapidly and exceptions caused
            //      rvSplitOrderItems.setLayoutManager(new LinearLayoutManager(this, RecyclerView.VERTICAL, false));
            rvSplitOrderItems.setItemAnimator(null);
            rvSplitOrderItems.setAdapter(splitOrderItemsAdapter);


            nonSplitOrderItemsAdapter = new SplitOrderItemsAdapter(nonSplitOrderItems, (position, data) -> {
                new AddItemToSplitAsync(() -> {
                    fetchOffline(false);
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (OrderItem) data);
            });
            rvNonSplitOrderItems.setLayoutManager(new WrapContentLinearLayoutManager(this, LinearLayoutManager.VERTICAL, false)); // Handled multiple clicks rapidly and exceptions caused
            // rvNonSplitOrderItems.setLayoutManager(new LinearLayoutManager(this, RecyclerView.VERTICAL, false));
            rvNonSplitOrderItems.setItemAnimator(null);
            rvNonSplitOrderItems.setAdapter(nonSplitOrderItemsAdapter);


            splitGroupAdapter = new SplitGroupAdapter(orderSplits, (position, data) -> {
                setSplitOrderItems(position, (OrderSplit) data);
            });
            rvSplitGroups.setLayoutManager(new LinearLayoutManager(this, RecyclerView.HORIZONTAL, false));
            rvSplitGroups.setItemAnimator(null);
            rvSplitGroups.setAdapter(splitGroupAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void updateViews() {

        try {
            if (order != null) {
                if (!Validators.isNullOrEmpty(order.split_type)) {
                    if (order.split_type.equalsIgnoreCase("person")) {
                        llSplitByPerson.performClick();
                        llSplitByItem.setVisibility(View.GONE);
                        btnSplit.setVisibility(View.GONE);
                        etPerson.setText(order.split_count + "");
                    } else {
                        llSplitByItem.performClick();
                        llSplitByPerson.setVisibility(View.GONE);
                    }
                } else {
                    llSplitByItem.performClick();
                    if (order.order_type_id.equalsIgnoreCase("1")) {
                        if (Validators.isNullOrEmpty(order.no_guest) || order.no_guest.equalsIgnoreCase("0") || order.no_guest.equalsIgnoreCase("1")) {
                            etPerson.setText("2");
                        } else {
                            etPerson.setText(order.no_guest);
                        }
                    } else {
                        etPerson.setText("2");
                    }
                }

                tvSubtotal.setText(MyApp.currencySymbol + MyApp.df.format(order.sub_total));
                tvGrandTotal.setText(MyApp.currencySymbol + MyApp.df.format(order.total));
                tvTotal.setText("Total: " + MyApp.currencySymbol + MyApp.df.format(order.total));

                if (order.discount > 0) {
                    llDiscount.setVisibility(View.VISIBLE);
                    tvDiscount.setText(MyApp.currencySymbol + MyApp.df.format(order.discount));
                    tvDiscountText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                } else {
                    llDiscount.setVisibility(View.GONE);
                }
                if (order.gratuity > 0) {
                    llGratuity.setVisibility(View.VISIBLE);
                    tvGratuity.setText(MyApp.currencySymbol + MyApp.df.format(order.gratuity));
                    tvGratuityText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                } else {
                    llGratuity.setVisibility(View.GONE);
                }
                if (order.service_charge > 0) {
                    llServiceCharge.setVisibility(View.VISIBLE);
                    tvServiceCharge.setText(MyApp.currencySymbol + MyApp.df.format(order.service_charge));
                    tvServiceChargeText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                } else {
                    llServiceCharge.setVisibility(View.GONE);
                }
                if (order.delivery_charge > 0) {
                    llDelivery.setVisibility(View.VISIBLE);
                    tvDelivery.setText(MyApp.currencySymbol + MyApp.df.format(order.delivery_charge));
                } else {
                    llDelivery.setVisibility(View.GONE);
                }
                tvBalance.setText("Balance Remaining: " + MyApp.currencySymbol + MyApp.df.format(order.total - order.total_paid));

                updatePayButton();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setSplitOrderItems(int position, OrderSplit orderSplit) {
        try {
            SplitActivity.tvSelectedAmount.setText("Selected Amount: " + MyApp.currencySymbol + MyApp.df.format(orderSplit.total));
            splitOrderItems.clear();
            if (splitGroupAdapter.selectedSplitId == 0) {
                btnPayBill.setText("Pay");
                btnPayBill.setEnabled(false);
                selectedSplitGroup = orderSplit;
                tvItemTitle.setText("Bill Payment");
                SplitActivity.tvSelectedAmount.setText("Selected Amount: " + MyApp.currencySymbol + MyApp.df.format(0));
            } else {
                selectedSplitGroup = orderSplit;
                tvItemTitle.setText("Bill for " + orderSplit.group_name);
                fetchOffline(false);
            }
            rvSplitOrderItems.post(() -> splitOrderItemsAdapter.notifyDataSetChanged());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void fetchOffline(boolean fetchSplits) {
        try {
            new FetchOrderAsync(() -> {
                updateViews();
                if (fetchSplits)
                    new FetchOrderSplits().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FetchOrderAsync extends AsyncTask<String, String, String> {
        private Callable<Void> nextMethod;

        public FetchOrderAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {
            // Fetching order
            try {
                OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                if (orderWithItems != null) {

                    order = orderWithItems.order;
                    order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
                    order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;
                    for (OrderSplit orderSplit : order.order_splits) {
                        orderSplit.paid_amount = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, orderSplit._id);
                        appDatabase.orderSplitDao().update(orderSplit);
                    }
                    order.order_items = new ArrayList<>();
                    for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                        OrderItem orderItem = item.orderItem;
                        orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                        orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                        order.order_items.add(orderItem);
                    }
                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                    for (OrderItem oit : order.order_items) {
                        if (!Validators.isNullOrEmpty(oit.order_split_id)) {
                            OrderSplit dbOrderSplit = myApp.appDatabase.orderSplitDao().view(oit.order_split_id);
                            if (dbOrderSplit != null) {
                                oit._order_split_id = dbOrderSplit._id;
                                myApp.appDatabase.orderItemDao().update(oit);
                            }
                        }

                    }
                    nonSplitOrderItems.clear();
                    nonSplitOrderItems.addAll(appDatabase.orderItemDao().listNonSplitItems(_order_id));

                    splitOrderItems.clear();
                    if (selectedSplitGroup != null && selectedSplitGroup._id > 0) {
                        selectedSplitGroup = appDatabase.orderSplitDao().view(selectedSplitGroup._id);
                        splitOrderItems.addAll((ArrayList<OrderItem>) appDatabase.orderItemDao().listSplitItems(selectedSplitGroup._id));
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                progressBarDialog.dismiss();
                rvNonSplitOrderItems.post(() -> nonSplitOrderItemsAdapter.notifyDataSetChanged());
                rvSplitOrderItems.post(() -> splitOrderItemsAdapter.notifyDataSetChanged());
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class FetchOrderSplits extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            // Fetching order

            try {
                orderSplits.clear();
                if ((Validators.isNullOrEmpty(order.split_type) && splitByItem) || (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("order_item"))) {
                    if (order.order_splits.size() == 0) {
                        OrderSplit orderSplit = new OrderSplit();
                        orderSplit._id = -1;
                        orderSplit.group_name = "Person 1";
                        orderSplit._order_id = _order_id;
                        if (order != null)
                            orderSplit.order_id = order.id;
                        orderSplits.add(orderSplit);

                        orderSplit = new OrderSplit();
                        orderSplit._id = -2;
                        orderSplit._order_id = _order_id;
                        orderSplit.group_name = "Person 2";
                        if (order != null)
                            orderSplit.order_id = order.id;
                        orderSplits.add(orderSplit);

                    } else if (order.order_splits.size() == 1) {
                        orderSplits.addAll(order.order_splits);

                        OrderSplit orderSplit = new OrderSplit();
                        orderSplit._id = -2;
                        orderSplit.group_name = "Person 2";
                        if (order != null)
                            orderSplit.order_id = order.id;
                        orderSplit._order_id = _order_id;
                        orderSplits.add(orderSplit);

                    } else {
                        orderSplits.addAll(order.order_splits);
                    }
                } else {
                    orderSplits.addAll(order.order_splits);
                }
                if (orderSplits != null && orderSplits.size() > 0) {
                    selectedSplitGroup = orderSplits.get(0);
                }
                if (selectedSplitGroup != null && selectedSplitGroup._id > 0 && order.split_type.equalsIgnoreCase("order_item")) {
                    selectedSplitGroup = appDatabase.orderSplitDao().view(selectedSplitGroup._id);
                    splitOrderItems.addAll((ArrayList<OrderItem>) appDatabase.orderItemDao().listSplitItems(selectedSplitGroup._id));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);

            try {
                progressBarDialog.dismiss();
                if (selectedSplitGroup != null) {
                    splitGroupAdapter.selectedSplitId = selectedSplitGroup._id;
                }
                updatePayButton();
                rvSplitGroups.post(() -> splitGroupAdapter.notifyDataSetChanged());
                rvSplitOrderItems.post(() -> splitOrderItemsAdapter.notifyDataSetChanged());

                if (Validators.isNullOrEmpty(order.split_type) && !splitByItem) {
                    llSplitGroups.setVisibility(View.GONE);
                } else {
                    llSplitGroups.setVisibility(View.VISIBLE);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    private void updatePayButton() {
        try {
            if (selectedSplitGroup != null) {
                tvItemTitle.setText("Bill for " + selectedSplitGroup.group_name);
                btnPayBill.setEnabled(true);
                btnPayBill.setText("Pay: " + MyApp.currencySymbol + MyApp.df.format(selectedSplitGroup.total - selectedSplitGroup.paid_amount));
                int payment_status = 0;
                if (selectedSplitGroup.total == 0 || selectedSplitGroup.total - selectedSplitGroup.paid_amount == 0 || MyApp.df.format(selectedSplitGroup.total).equalsIgnoreCase(MyApp.df.format(selectedSplitGroup.paid_amount)) || selectedSplitGroup.paid_amount > selectedSplitGroup.total)
                    btnPayBill.setEnabled(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class AddItemToSplitAsync extends AsyncTask<OrderItem, String, String> {
        private Callable<Void> nextMethod;

        public AddItemToSplitAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(OrderItem... orderItems) {
            try {
                OrderItem orderItem = orderItems[0];

                for (OrderSplit s : orderSplits) {
                    if (s._id == selectedSplitGroup._id) {
                        break;
                    }
                    if (s._id <= 0) {
                        return "Please add items to empty group first";
                    } else {
                        int count = appDatabase.orderItemDao().count(s._id);
                        if (count == 0) {
                            return "Please add items to empty group first";
                        }
                    }
                }
                if (selectedSplitGroup != null) {
                    if (selectedSplitGroup._id <= 0) {
                        selectedSplitGroup._id = 0;
                        long tsLong = System.currentTimeMillis() / 1000;
                        selectedSplitGroup.unique_id = tsLong + MyApp.getInstance().myPreferences.getBusinessId() + MyApp.getInstance().myPreferences.getRegisteredDevice().id;
                        selectedSplitGroup._id = (int) appDatabase.orderSplitDao().insert(selectedSplitGroup);
                    }
                }
                boolean orderItemFound = false;
                int splitItemIndex = 0;
                for (OrderItem splitOrderItem : splitOrderItems) {
                    if (splitOrderItem._id == orderItem._id) {
                        orderItemFound = true;
                        splitOrderItem._order_split_id = selectedSplitGroup._id;
                        splitOrderItem.order_split_id = selectedSplitGroup.id;
                        splitOrderItem.unique_id = selectedSplitGroup.unique_id;
                        splitOrderItem.quantity = splitOrderItem.quantity + 1;
                        splitOrderItem.sub_total = splitOrderItem.price * splitOrderItem.quantity;
                        splitOrderItem.addons_price = getAddonPrice(orderItem) * splitOrderItem.quantity;
                        splitOrderItem.ingredients_price = getIngredientPrice(orderItem) * splitOrderItem.quantity;
                        splitOrderItem.total = splitOrderItem.sub_total + splitOrderItem.addons_price + splitOrderItem.ingredients_price + (splitOrderItem.instruction_price * splitOrderItem.quantity);

                        appDatabase.orderItemDao().update(splitOrderItem);
                        appDatabase.orderSplitDao().updateTotalAmount(_order_id, selectedSplitGroup._id);
                        break;
                    }
                    splitItemIndex = splitItemIndex + 1;
                }
                if (!orderItemFound) {

                    if (orderItem.quantity > 1) {
                        OrderItem splitOrderItem = new Gson().fromJson(new Gson().toJson(orderItem), OrderItem.class);
                        // add new Split item
                        splitOrderItem._id = 0;
                        splitOrderItem._order_split_id = selectedSplitGroup._id;
                        splitOrderItem.order_split_id = selectedSplitGroup.id;
                        splitOrderItem.quantity = 1;
                        splitOrderItem.sub_total = splitOrderItem.price * splitOrderItem.quantity;
                        splitOrderItem.addons_price = getAddonPrice(splitOrderItem) * splitOrderItem.quantity;
                        splitOrderItem.ingredients_price = getIngredientPrice(splitOrderItem) * splitOrderItem.quantity;
                        splitOrderItem.total = splitOrderItem.sub_total + splitOrderItem.addons_price + splitOrderItem.ingredients_price + (splitOrderItem.instruction_price * splitOrderItem.quantity);
                        splitOrderItem.unique_id = selectedSplitGroup.unique_id;
                        appDatabase.orderItemDao().insert(splitOrderItem);

                        //decreased quantity from main item
                        orderItem.id = null;
                        orderItem.quantity = orderItem.quantity - 1;
                        orderItem.sub_total = orderItem.price * orderItem.quantity;
                        orderItem.addons_price = getAddonPrice(orderItem) * orderItem.quantity;
                        orderItem.ingredients_price = getIngredientPrice(orderItem) * orderItem.quantity;
                        orderItem.total = orderItem.sub_total + orderItem.addons_price + orderItem.ingredients_price + (orderItem.instruction_price * orderItem.quantity);
                        orderItem.unique_id = null;
                        appDatabase.orderItemDao().update(orderItem);

                    } else {
                        orderItem._order_split_id = selectedSplitGroup._id;
                        orderItem.order_split_id = selectedSplitGroup.id;
                        orderItem.unique_id = selectedSplitGroup.unique_id;
                        OrderItem localOrderItem = appDatabase.orderItemDao().view(orderItem._id);
                        if(localOrderItem==null){
                            appDatabase.orderItemDao().insert(orderItem);
                        }else {
                            appDatabase.orderItemDao().update(orderItem);
                        }
                    }
                    appDatabase.orderSplitDao().updateTotalAmount(_order_id, selectedSplitGroup._id);

                }
                order.split_type = splitByItem ? "order_item" : "person";
                order.service_charge = 0;
                order.discount = 0;
                order.gratuity = 0;
                order.delivery_charge = 0;
                order.total = order.sub_total;
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                appDatabase.orderPaymentDao().deletePaymentMethodPayment(order._id, "5");
                order.total_paid = appDatabase.orderPaymentDao().getTotalPaidAmount(order._id);
                appDatabase.orderDao().update(order);
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (!Validators.isNullOrEmpty(s)) {
                    ToastUtils.makeLongToast(SplitActivity.this, s);
                } else {
                    try {
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class RemoveItemFromSplitAsync extends AsyncTask<OrderItem, String, String> {
        private Callable<Void> nextMethod;

        public RemoveItemFromSplitAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(OrderItem... orderItems) {
            try {
                OrderItem orderItem = orderItems[0];

                boolean orderItemFound = false;
                int splitItemIndex = 0;
                for (OrderItem nonSplitItem : nonSplitOrderItems) {
                    if (nonSplitItem._id == orderItem._id) {
                        orderItemFound = true;
                        nonSplitItem.quantity = nonSplitItem.quantity + 1;
                        nonSplitItem.sub_total = nonSplitItem.price * nonSplitItem.quantity;
                        nonSplitItem.addons_price = getAddonPrice(orderItem) * nonSplitItem.quantity;
                        nonSplitItem.ingredients_price = getIngredientPrice(orderItem) * nonSplitItem.quantity;
                        nonSplitItem.total = nonSplitItem.sub_total + nonSplitItem.addons_price + nonSplitItem.ingredients_price + (nonSplitItem.instruction_price * nonSplitItem.quantity);
                        nonSplitItem.unique_id = null;
                        nonSplitItem.order_split_id = null;
                        nonSplitItem._order_split_id = 0;
                        appDatabase.orderItemDao().insert(nonSplitItem);
                        appDatabase.orderSplitDao().updateTotalAmount(_order_id, selectedSplitGroup._id);
                        break;
                    }
                    splitItemIndex = splitItemIndex + 1;
                }
                if (!orderItemFound) {
                    orderItem.id = null;
                    orderItem.order_split_id = null;
                    orderItem._order_split_id = 0;
                    orderItem.unique_id = null;
                    orderItem.quantity = 1;
                    orderItem.sub_total = orderItem.price * orderItem.quantity;
                    orderItem.addons_price = getAddonPrice(orderItem) * orderItem.quantity;
                    orderItem.ingredients_price = getIngredientPrice(orderItem) * orderItem.quantity;
                    orderItem.total = orderItem.sub_total + orderItem.addons_price + orderItem.ingredients_price + (orderItem.instruction_price * orderItem.quantity);
                    OrderItem localOrderItem = appDatabase.orderItemDao().view(orderItem._id);
                    if(localOrderItem==null){
                        appDatabase.orderItemDao().insert(orderItem);
                    }else {
                        appDatabase.orderItemDao().update(orderItem);
                    }
                    appDatabase.orderSplitDao().updateTotalAmount(_order_id, selectedSplitGroup._id);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }


            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                nextMethod.call();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private float getAddonPrice(OrderItem orderItem) {
        float addonPrice = 0;
        for (OrderItemAddon orderItemAdd : orderItem.order_item_addons) {
            addonPrice = addonPrice + orderItemAdd.total;
        }
        return addonPrice;
    }

    private float getIngredientPrice(OrderItem orderItem) {
        float ingredientPrice = 0;
        for (OrderItemIngredient orderItemIngredient :
                orderItem.order_item_ingredients) {
            ingredientPrice = ingredientPrice + orderItemIngredient.total;
        }
        return ingredientPrice;
    }

    private void updateTime() {
        try {
            mHandler = new Handler();

            mHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    String currentTime = new SimpleDateFormat("hh:mm a", Locale.getDefault()).format(new Date());
                    tvTime.setText(currentTime);
                    mHandler.postDelayed(this, 1000);
                }
            }, 10);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {

        try {
            chipBack.setOnClickListener(v -> onBackPressed());

            llSplitByItem.setOnClickListener(v -> {
                tvTypeTitle.setText("Item Payable");
                etPerson.setVisibility(View.GONE);
                rvNonSplitOrderItems.setVisibility(View.VISIBLE);
                changeTextColor(v);
                rbSplitByItem.setChecked(true);
                btnSplit.setVisibility(View.GONE);
                ivSplit.setVisibility(View.VISIBLE);
                if (!splitByItem) {
                    new FetchOrderSplits().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                }
                splitByItem = true;

            });
            llSplitByPerson.setOnClickListener(v -> {
                tvTypeTitle.setText("Split Between");
                etPerson.setVisibility(View.VISIBLE);
                if (order != null && order.split_type == null) {
                    btnSplit.setVisibility(View.VISIBLE);
                }
                ivSplit.setVisibility(View.GONE);
                rvNonSplitOrderItems.setVisibility(View.GONE);
                changeTextColor(v);
                rbSplitByPerson.setChecked(true);
                if (splitByItem)
                    new FetchOrderSplits().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                splitByItem = false;
            });

            tvDiscountText.setOnClickListener(v -> {
                cartDiscount = 0;
                new UpdateOrderAsyncTask(() -> {
                    setResult(Activity.RESULT_OK);
                    fetchOffline(false);
                    ToastUtils.makeSnackToast(this, "Discount has been removed");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });
            tvServiceChargeText.setOnClickListener(v -> {
                cartServiceCharge = 0;
                new UpdateOrderAsyncTask(() -> {
                    setResult(Activity.RESULT_OK);
                    fetchOffline(false);
                    ToastUtils.makeSnackToast(this, "Service charge has been removed");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });

            tvGratuityText.setOnClickListener(v -> {
                cartGratuity = 0;
                new UpdateOrderAsyncTask(() -> {
                    setResult(Activity.RESULT_OK);
                    fetchOffline(false);
                    ToastUtils.makeSnackToast(this, "Gratuity has been removed");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });

            ivSplit.setOnClickListener(v -> {
                if (splitByItem) {
                    if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("person")) {
                        showDialog("Error", "Order already split");
                    } else {
                        createOrUpdateItemGroup();
                    }
                } else if (rbSplitByPerson.isChecked()) {
                    if (Validators.isNullOrEmpty(order.split_type) && orderSplits.size() == 0) {
                        if (Validators.isNullOrEmpty(etPerson.getText().toString())) {
                            showDialog("Error", "Please enter person to split");
                            etPerson.requestFocus();
                        } else if (Integer.parseInt(etPerson.getText().toString()) < 2) {
                            showDialog("Error", "Split person should be greater than one");
                            etPerson.requestFocus();
                        } else {
                            splitCount = Integer.parseInt(etPerson.getText().toString());
                            createOrUpdatePersonGroup();
                        }
                    } else {
                        showDialog("Error", "Order already split");
                    }
                }
            });
            btnSplit.setOnClickListener(v -> {
                if (Validators.isNullOrEmpty(order.split_type) && orderSplits.size() == 0) {
                    if (Validators.isNullOrEmpty(etPerson.getText().toString())) {
                        showDialog("Error", "Please enter person to split");
                        etPerson.requestFocus();
                    } else if (Integer.parseInt(etPerson.getText().toString()) < 2) {
                        showDialog("Error", "Split person should be greater than one");
                        etPerson.requestFocus();
                    } else {
                        splitCount = Integer.parseInt(etPerson.getText().toString());
                        createOrUpdatePersonGroup();
                    }
                } else {
                    showDialog("Error", "Order already split");
                }
            });

            btnPrint.setOnClickListener(v -> {
                if (selectedSplitGroup == null) {
                    showDialog("Error", "Please select split group");
                } else {
                    Intent intent = new Intent();
                    if (split != null)
                        intent.putExtra("_order_split_id", split._id);
                    intent.putExtra("print_count", splitCount);
                    setResult(Activity.RESULT_OK, intent);
                    myApp.needToPrint = true;
                    onBackPressed();
                }
            });
            btnPayBill.setOnClickListener(view -> {
                if (selectedSplitGroup == null) {
                    showDialog("Error", "Please select split group");
                } else {
                    selectedSplitId = selectedSplitGroup._id;
                    LogUtils.e("_order_split_id :: " + selectedSplitGroup._id + " order_total::" + selectedSplitGroup.total + " paid_amount::" + selectedSplitGroup.paid_amount);
                    startActivityForResult(new Intent(this, OrderReviewActivity.class).putExtra("order_id", order.id).putExtra("_order_id", order._id).putExtra("unique_id", order.unique_id).putExtra("_order_split_id", selectedSplitGroup._id).putExtra("order_split_id", selectedSplitGroup.id).putExtra("order_total", selectedSplitGroup.total).putExtra("paid_amount", selectedSplitGroup.paid_amount), Constants.CODE_REFRESH);
                }
            });
            llGrandTotal.setOnClickListener(view -> {
                if (llExpand.getVisibility() == View.VISIBLE) {
                    ivExpand.setRotation(90);
                    llExpand.setVisibility(View.GONE);
                } else {
                    ivExpand.setRotation(270);
                    llExpand.setVisibility(View.VISIBLE);
                }

            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void createOrUpdatePersonGroup() {

        try {
            ArrayList<OrderSplit> splitOrderItems = new ArrayList<>();
            for (int i = 1; i <= splitCount; i++) {
                OrderSplit split = new OrderSplit();
                split.total = Float.parseFloat(MyApp.df.format(order.total / Integer.parseInt(etPerson.getText().toString())));
                split.group_name = "Person " + (i);
                split.order_id = order.id;
                split._order_id = order._id;
                long tsLong = System.currentTimeMillis() / 1000;
                split.unique_id = tsLong + MyApp.getInstance().myPreferences.getBusinessId() + MyApp.getInstance().myPreferences.getRegisteredDevice().id+i;
                splitOrderItems.add(split);
            }
            progressBarDialog.show();

            new CreateSplitAsync(() -> {
                fetchOffline(true);
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, splitOrderItems);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private class CreateSplitAsync extends AsyncTask<ArrayList<OrderSplit>, String, String> {
        Callable<Void> nextMethod;

        public CreateSplitAsync(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(ArrayList<OrderSplit>... splits) {
            try {
                ArrayList<OrderSplit> splitOrderItems = splits[0];
                appDatabase.orderSplitDao().insertMultiple(splitOrderItems);
                order.split_type = "person";
                order.split_count = splitCount;
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                appDatabase.orderDao().update(order);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            progressBarDialog.dismiss();
            try {
                nextMethod.call();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createOrUpdateItemGroup() {
        try {
            OrderSplit orderSplit = new OrderSplit();
            orderSplit._id = (orderSplits.size() + 1) * -1;
            orderSplit.group_name = "Person " + (orderSplits.size() + 1);
            orderSplit._order_id = _order_id;
            if (order != null)
                orderSplit.order_id = order.id;
            orderSplits.add(orderSplit);
            splitGroupAdapter.selectedSplitId = selectedSplitGroup._id;
            splitGroupAdapter.notifyDataSetChanged();
            rvSplitGroups.smoothScrollToPosition(orderSplits.size() - 1);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void showDialog(String title, String message) {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog(title, message, 0, "Okay", null);
            confirmationDialogFragment.show(getSupportFragmentManager(), "dialog");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    OrderSplit split;


    private class UpdateOrderAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public UpdateOrderAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);

                cartSubTotal = order.sub_total;

         /*   if (Links.service_charges_mode == 0) {
                if (!Links.service_charges)
                    serviceChargeEnabled = false;
            }*/

                if (serviceChargeEnabled) {
                    if (serviceChargeAutoMode) {
                        float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                        if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                            cartServiceCharge = serviceChargeValue;
                        } else {
                            if (serviceChargeValue > 0) {
                                cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                            } else {
                                cartServiceCharge = 0;
                            }
                        }
                    }
                } else {
                    cartServiceCharge = 0;
                }

                if (discountEnabled) {
                    List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                    if (discounts.size() > 0) {
                        Discount appliedDiscount = discounts.get(0);
                        autoDiscountApplied = false;
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                            if (cartSubTotal > 0)
                                cartDiscount = appliedDiscount.discount;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                            if (cartSubTotal > 0)
                                cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                    } else {
                        if (autoDiscountApplied) cartDiscount = 0;
                    }
                }

                order.gratuity = cartGratuity;
                order.discount = cartDiscount;
                order.service_charge = cartServiceCharge;
                cartGrandTotal = ((cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount);
                Log.e("cartServiceCharge_6", ":" + cartSubTotal + ":" + cartGratuity + ":" + cartDiscount + ":" + cartServiceCharge + ":" + order.delivery_charge);
                order.total = cartGrandTotal;
                if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                }
                appDatabase.orderDao().update(order);
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void changeTextColor(View v) {
        try {
            vPersonSelector.setBackgroundResource(R.color.light_gray);
            vPersonSelector.setAlpha(0.5f);

            vItemSelector.setBackgroundResource(R.color.light_gray);
            tvSplitByItem.setAlpha(0.5f);
            tvSplitByPerson.setAlpha(0.5f);

            if (v == llSplitByItem) {
                vItemSelector.setBackgroundResource(R.color.persian_green);
                tvSplitByItem.setAlpha(1f);
            }
            if (v == llSplitByPerson) {
                vPersonSelector.setBackgroundResource(R.color.persian_green);
                vPersonSelector.setAlpha(1f);
                tvSplitByPerson.setAlpha(1f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {
        setResult(Activity.RESULT_OK);
        super.onBackPressed();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Constants.CODE_REFRESH) {
            onBackPressed();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }
}
