package com.ubsidi.epos_2021.activities;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.fragment.CartProductEditDialogFragment;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;


/**
 * Created by Amrish on 26-08-2020.
 */
public class TransportActivity extends BaseActivity {
    private String destination;
    BroadcastReceiver broadcastReceiver;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        handleNavigation();
        setListeners();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getIntent() != null) {
                destination = getIntent().getStringExtra("destination");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_transport);
    }

    @Override
    protected void initViews() {
        super.initViews();
    }

    private void handleNavigation() {
        try {
            if (destination.equalsIgnoreCase("cart_product_edit")) {
                changeFragment(new CartProductEditDialogFragment());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
    }


    private void changeFragment(Fragment fragment) {
        try {
            if (getIntent() != null) {
                fragment.setArguments(getIntent().getExtras());
            }
            FragmentManager manager = getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.flContainer, fragment);
            transaction.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
    }


    @Override
    public void onBackPressed() {

        try {
            if (!isTaskRoot()) {
                super.onBackPressed();
            } else {
                finish();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    protected void onStop() {
        try {
            LocalBroadcastManager.getInstance(this).unregisterReceiver(broadcastReceiver);
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onStop();

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == Constants.CODE_DATA_RECEIVE && resultCode == RESULT_OK) {
                if (data != null) {
                    setResult(RESULT_OK, data);
                    LogUtils.e("intent received");


                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
