package com.ubsidi.epos_2021.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.airbnb.lottie.LottieAnimationView;
import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.Priority;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.firebase.messaging.FirebaseMessaging;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseActivity;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.services.SingleCustomerUploadService;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.services.SingleReservationUploadService;
import com.ubsidi.epos_2021.storageutils.MyPreferences;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.InternetUtils;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.NetworkWatcher;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Amrish on 01-06-2021.
 */
public class UploadOrdersActivity extends BaseActivity {
    @Override
    protected void setXML() {
        super.setXML();
        setContentView(R.layout.activity_upload_orders);
    }

    public MyApp myApp = MyApp.getInstance();
    public MyPreferences myPreferences = myApp.myPreferences;
    public AppDatabase appDatabase = myApp.appDatabase;
    private TextView tvUploadStatus, tvMessage;
    private ArrayList<Order> orders = new ArrayList<>();
    private ArrayList<Reservation> reservations = new ArrayList<>();
    private ArrayList<Customer> customers = new ArrayList<>();
    private boolean admin_logout = false;
    boolean canGoBack = false, finish = false;
    boolean isManual = false;
    boolean is_from_upload_failed_order = false;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getIntent() != null) {
                admin_logout = getIntent().getBooleanExtra("admin_logout", false);
                finish = getIntent().getBooleanExtra("finish", false);
                is_from_upload_failed_order = false;
                if (getIntent().hasExtra(Constants.IS_FROM_UPLOAD_FAILED_ORDER)) {
                    is_from_upload_failed_order = getIntent().getBooleanExtra(Constants.IS_FROM_UPLOAD_FAILED_ORDER, false);
                }
                if (getIntent().hasExtra("isManual")) {
                    isManual = getIntent().getBooleanExtra("isManual", false);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            if (!InternetUtils.isNetworkConnected(this)) {
                ToastUtils.makeSnackToast(UploadOrdersActivity.this, "No internet connection");
                startActivity(new Intent(UploadOrdersActivity.this, HomeActivity.class));
                finish();
                return;
            } else {
                new FetchAllDataAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            }

            try {
                new NetworkWatcher(this).observe(this, aBoolean -> {
                    if (!aBoolean) {
                        ToastUtils.makeSnackToast(UploadOrdersActivity.this, "No internet connection, Please try again when internet is connected.");
                        startActivity(new Intent(UploadOrdersActivity.this, HomeActivity.class));
                        finish();
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void initViews() {
        super.initViews();
        try {
            Toolbar toolbar = findViewById(R.id.toolbar);
            tvUploadStatus = findViewById(R.id.tvUploadCount);
            tvMessage = findViewById(R.id.tvMessage);
            setSupportActionBar(toolbar);
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setTitle("Push data");
            toolbar.setNavigationIcon(R.drawable.ic_baseline_arrow_back_24);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    class FetchAllDataAsync extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            try {
                orders.clear();
                if (is_from_upload_failed_order) {
                    reservations.clear();
                    customers.clear();
                    orders.addAll(appDatabase.orderDao().failedOrderList());
                } else {
                    List<OrderWithItems> orderWithItemsList = appDatabase.orderDao().ordersWithItems();
                    for (OrderWithItems orderWithItems : orderWithItemsList) {
                        Order order = orderWithItems.order;

                        orders.add(order);
                    }
                    reservations.clear();
                    reservations.addAll(appDatabase.reservationDao().uploadableList());

                    customers.clear();
                    customers.addAll(appDatabase.customerDao().uploadableList());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                tvUploadStatus.setVisibility(View.VISIBLE);
                if (isManual) {
                    checkOrderStatus();
                } else {
                    startUploading();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    // Check rejected order status
    // (Change status of orders which are rejected/canceled before uploading)
    private void checkOrderStatus() {
        try {
            if (orders.size() == 0) {
                startUploading();
            } else {
                AndroidNetworking.get(ApiEndPoints.orders)
                        .setPriority(Priority.IMMEDIATE)
                        .addQueryParameter(getOrdersParameters())
                        .build()
                        .getAsObjectList(Order.class, new ParsedRequestListener<List<Order>>() {
                            @Override
                            public void onResponse(List<Order> response) {
                                try {
                                    if (response != null && response.size() > 0) {
                                        //new Thread(() -> {
                                        for (int i = 0; i < response.size(); i++) {
                                            for (int i1 = 0; i1 < orders.size(); i1++) {
                                                if ((orders.get(i1).id.equalsIgnoreCase(response.get(i).id) || orders.get(i1).id.equals(response.get(i).id)) &&
                                                        !orders.get(i1).order_status_id.equalsIgnoreCase("10")) {
                                                    orders.get(i1).order_status = "Order Rejected";
                                                    orders.get(i1).order_status_id = "10";
                                                    appDatabase.orderDao().update(orders.get(i1));
                                                }
                                            }
                                        }
                                        //}).start();
                                        startUploading();
                                    } else {
                                        startUploading();
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                    startUploading();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                try {
                                    anError.printStackTrace();
                                    startUploading();
                                } catch (Exception e) {
                                    e.printStackTrace();
                                    startUploading();
                                }
                            }
                        });
            }
        } catch (Exception e) {
            e.printStackTrace();
            startUploading();
        }
    }

    private HashMap<String, String> getOrdersParameters() {
        HashMap<String, String> params = new HashMap<>();
        params.put("order_status_id", "10");
        params.put("nopaginate", "1");
        return params;
    }


    private void startUploading() {
        try {
            if (orders.size() > 0) {
                tvUploadStatus.setText(String.format("Uploading orders %d of %d", 1, orders.size()));
                startService(new Intent(UploadOrdersActivity.this, SingleOrderUploaderService.class).putExtra("forcefully", true).putExtra("_order_id", orders.get(0)._id).putExtra("position", 0));
            } else if (reservations.size() > 0) {
                startReservations();
            } else if (customers.size() > 0) {
                startCustomers();
            } else {
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startCustomers() {
        try {
            tvUploadStatus.setText(String.format("Uploading customers %d of %d", 1, customers.size()));
            startService(new Intent(UploadOrdersActivity.this, SingleCustomerUploadService.class).putExtra("forcefully", true).putExtra("_customer_id", customers.get(0)._id).putExtra("position", 0));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startReservations() {
        try {
            tvUploadStatus.setText(String.format("Uploading reservations %d of %d", 1, reservations.size()));
            startService(new Intent(UploadOrdersActivity.this, SingleReservationUploadService.class).putExtra("forcefully", true).putExtra("_reservation_id", reservations.get(0)._id).putExtra("position", 0));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goBack() {
        try {
            if (isManual) {
                startActivityForResult(new Intent(this, PullActivity.class).putExtra("destination", "home"), Constants.CODE_REFRESH);
                return;
            }
            if (admin_logout) {
                doAdminLogout();
            } else if (finish) {
                setResult(RESULT_OK);
                finish();
            } else {
                startActivity(new Intent(UploadOrdersActivity.this, HomeActivity.class));
                finish();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    BroadcastReceiver orderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                int position = intent.getIntExtra("position", -1);
                if (position == orders.size() - 1) {
                    if (reservations.size() > 0)
                        startReservations();
                    else if (customers.size() > 0)
                        startCustomers();
                    else goBack();
                } else {
                    tvUploadStatus.setText(String.format("Uploading orders %d of %d", position + 2, orders.size()));
                    startService(new Intent(UploadOrdersActivity.this, SingleOrderUploaderService.class).putExtra("forcefully", true).putExtra("_order_id", orders.get(position + 1)._id).putExtra("position", position + 1));
                }

                if (intent.getStringExtra("message") != null) {
                    String message = "\n" + intent.getStringExtra("message");
                    tvMessage.append(message);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    };
    BroadcastReceiver reservationUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                int position = intent.getIntExtra("position", -1);
                if (position == reservations.size() - 1) {
                    startCustomers();
                } else {
                    tvUploadStatus.setText(String.format("Uploading reservations %d of %d", position + 2, reservations.size()));
                    startService(new Intent(UploadOrdersActivity.this, SingleReservationUploadService.class).putExtra("forcefully", true).putExtra("_reservation_id", reservations.get(position + 1)._id).putExtra("position", position + 1));
                }

                if (intent.getStringExtra("message") != null) {
                    String message = "\n" + intent.getStringExtra("message");
                    tvMessage.append(message);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    };
    BroadcastReceiver customerUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                int position = intent.getIntExtra("position", -1);
                LogUtils.e("position:" + position);
                if (position == customers.size() - 1) {
                    goBack();
                } else {
                    tvUploadStatus.setText(String.format("Uploading customers %d of %d", position + 2, customers.size()));
                    startService(new Intent(UploadOrdersActivity.this, SingleCustomerUploadService.class).putExtra("forcefully", true).putExtra("_customer_id", customers.get(position + 1)._id).putExtra("position", position + 1));
                }

                if (intent.getStringExtra("message") != null) {
                    String message = "\n" + CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), "dd-MM hh:mm:ss a") + " " + intent.getStringExtra("message");
                    tvMessage.append(message);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    };

    private void doAdminLogout() {
        try {
            ToastUtils.makeToast(UploadOrdersActivity.this, "Logout successfully!!");
            FirebaseMessaging.getInstance().unsubscribeFromTopic("business_" + myPreferences.getLoggedInAdmin().selected_business.id);
            myPreferences.saveLoggedInAdmin(null);
            myPreferences.saveLoggedInUser(null);
            myPreferences.saveUserTokens(null, null);
            myPreferences.saveAdminTokens(null, null);
            myPreferences.userLoggedInWithoutInternet(false);
            myPreferences.adminLoggedInWithoutInternet(false);
            myPreferences.saveBusinessId(null);
          /*  new Thread(() -> {
                appDatabase.emptyPulledDao().nukeAddon();
                appDatabase.emptyPulledDao().nukeCategory();
                appDatabase.emptyPulledDao().nukeCustomer();
                appDatabase.emptyPulledDao().nukePrepLocation();
                appDatabase.emptyPulledDao().nukeProduct();
                appDatabase.emptyPulledDao().nukeProductAddon();
                appDatabase.emptyPulledDao().nukeProductIngredient();
                appDatabase.emptyPulledDao().nukeTable();
                appDatabase.emptyPulledDao().nukeFloor();
                appDatabase.emptyPulledDao().nukeOrderItemIngredient();
                appDatabase.emptyPulledDao().nukeOrderItemAddon();
                appDatabase.emptyPulledDao().nukeOrderPayment();
                appDatabase.emptyPulledDao().nukeOrderSplit();
                appDatabase.emptyPulledDao().nukeOrder();
                appDatabase.emptyPulledDao().nukeUsers();
                appDatabase.emptyPulledDao().nukeReservations();
                appDatabase.emptyPulledDao().nukeVouchers();
                appDatabase.orderDao().resetPrimaryKey();
                try {
                    deleteImages();
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }).start();*/
            myPreferences.savePullStatus(false);
            startActivity(new Intent(UploadOrdersActivity.this, SplashActivity.class));
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteImages() {
        try {
            File dir = new File(getApplicationContext().getExternalFilesDir("epos2021").getAbsolutePath());
            if (dir.isDirectory()) {
                String[] children = dir.list();
                if (children != null) {
                    for (String child : children) {
                        try {
                            new File(dir, child).delete();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (orderUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(this).registerReceiver(orderUpdateReceiver, new IntentFilter(
                        Constants.EPOS_ORDER_UPDATE));
            }
            if (customerUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(this).registerReceiver(customerUpdateReceiver, new IntentFilter(
                        "single_customer_upload"));
            }
            if (reservationUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(this).registerReceiver(reservationUpdateReceiver, new IntentFilter(
                        "single_reservation_upload"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBackPressed() {
        if (canGoBack) super.onBackPressed();
        else ToastUtils.makeLongToast(this, "Please wait while uploading data");
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
            if (orderUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(orderUpdateReceiver);
            }
            if (customerUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(customerUpdateReceiver);
            }
            if (reservationUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(this).unregisterReceiver(reservationUpdateReceiver);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
