package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.ProductAddon;

import java.util.ArrayList;

public class AddonAdapter extends RecyclerView.Adapter<AddonAdapter.ViewHolder> {

    private ArrayList<ProductAddon> productAddons;
    private RecyclerviewItemClickListener itemClickListener;

    public AddonAdapter(ArrayList<ProductAddon> productAddons, RecyclerviewItemClickListener itemClickListener) {
        this.productAddons = productAddons;
        this.itemClickListener = itemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_addon, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        try {
            ProductAddon productAddon = productAddons.get(position);
            Addon addon = productAddon.addon;
            if (addon != null) {
                holder.tvAddonName.setText(addon.name);
                holder.tvPrice.setText(MyApp.currencySymbol + addon.price);
                Context context = holder.itemView.getContext();
                if (addon.selected) {
                    holder.cvAddon.setCardBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
                    holder.tvAddonName.setTextColor(ContextCompat.getColor(context, R.color.white));
                    holder.tvPrice.setTextColor(ContextCompat.getColor(context, R.color.white));
                } else {
                    holder.cvAddon.setCardBackgroundColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.white));
                    holder.tvAddonName.setTextColor(ContextCompat.getColor(context, R.color.black));
                    holder.tvPrice.setTextColor(ContextCompat.getColor(context, R.color.black));
                }
            }
            holder.itemView.setOnClickListener(v -> {
                if (itemClickListener != null) {
                    itemClickListener.onItemClick(position, productAddon);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return productAddons.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        LinearLayout llAddon;
        TextView tvAddonName, tvPrice;
        CardView cvAddon;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            llAddon = itemView.findViewById(R.id.llAddon);
            cvAddon = itemView.findViewById(R.id.cvAddon);
            tvAddonName = itemView.findViewById(R.id.tvAddonName);
            tvPrice = itemView.findViewById(R.id.tvPrice);
        }
    }
}
