package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Table;

import java.util.ArrayList;

/**
 * Created by Amrish on 14-06-2021.
 */
public class AssignTablesAdapter extends RecyclerView.Adapter<AssignTablesAdapter.ViewHolder> {
    private ArrayList<Table> tables;
    private RecyclerviewItemClickListener itemClickListener;
    public boolean checkable;
    public String selectedId;

    public AssignTablesAdapter(ArrayList<Table> tables, RecyclerviewItemClickListener itemClickListener, boolean checkable) {
        this.tables = tables;
        this.itemClickListener = itemClickListener;
        this.checkable = true;
    }

    @NonNull
    @Override
    public AssignTablesAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new AssignTablesAdapter.ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_selectable_table, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull AssignTablesAdapter.ViewHolder holder, int position) {
        try {
            Table table = tables.get(position);
            holder.tvName.setText(table.number);
            if (table.id.equalsIgnoreCase(selectedId)) {
                holder.tvName.setTextColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.white));
                holder.cvTable.setCardBackgroundColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.persian_green));
            } else {
                holder.tvName.setTextColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.dark_grey_color));
                holder.cvTable.setCardBackgroundColor(ContextCompat.getColor(holder.itemView.getContext(), R.color.light_grey));
            }
            holder.cvTable.setOnClickListener(v -> {
                if (checkable) {
                    selectedId = table.id;
                    notifyDataSetChanged();
                }
                if (itemClickListener != null) {
                    itemClickListener.onItemClick(position, table);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return tables.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        MaterialCardView cvTable;
        TextView tvName;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);

            cvTable = itemView.findViewById(R.id.cvItem);
            tvName = itemView.findViewById(R.id.tvItemName);
        }
    }
}
