package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatSeekBar;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.fragment.AudioFilesModel;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.ProductAddon;

import java.io.IOException;
import java.util.ArrayList;

public class AudioFileListAdapter extends RecyclerView.Adapter<AudioFileListAdapter.ViewHolder> {

    private ArrayList<AudioFilesModel> audioFilesModelList;
    private RecyclerviewItemClickListener itemClickListener;
    public RadioButton checkedRadioButton;
    String selectedReservacationUri;

    public AudioFileListAdapter(ArrayList<AudioFilesModel> audioFilesModelList, String selectedReservacationUri, RecyclerviewItemClickListener itemClickListener) {
        this.selectedReservacationUri = selectedReservacationUri;
        this.audioFilesModelList = audioFilesModelList;
        this.itemClickListener = itemClickListener;
    }

    public void updateList(ArrayList<AudioFilesModel> audioFilesModelList) {
        this.audioFilesModelList = audioFilesModelList;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_audio_file_list, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        try {
            AudioFilesModel audioFilesModel = audioFilesModelList.get(position);
            if (selectedReservacationUri != null)
                holder.rbBusiness.setChecked(selectedReservacationUri.equalsIgnoreCase(audioFilesModel.getName()));
            else holder.rbBusiness.setChecked(false);
            holder.tvBusiness.setText(audioFilesModel.getName());
            holder.itemView.setOnClickListener(v -> {
                selectedReservacationUri = audioFilesModel.getName();
                notifyDataSetChanged();
                if (checkedRadioButton != null) checkedRadioButton.setChecked(false);
                checkedRadioButton = holder.rbBusiness;
                holder.rbBusiness.setChecked(true);
                if (itemClickListener != null) {
                    itemClickListener.onItemClick(position, audioFilesModel);
                }
            });
            Handler mSeekbarUpdateHandler = new Handler();
            Runnable mUpdateSeekbar = new Runnable() {
                @Override
                public void run() {
                    try {
                        Log.e("isPlayingisPlaying", "isPlaying " + audioFilesModel.isPlaying());
                        if (audioFilesModel.isPlaying()) {
                            if (holder.mPlayer != null && holder.mPlayer.isPlaying()) {
                                holder.seekBar.setProgress(holder.mPlayer.getCurrentPosition());
                                mSeekbarUpdateHandler.postDelayed(this, 50);
                            } else {
                                mSeekbarUpdateHandler.removeCallbacks(this);
                            }
                        }
                    } catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                }
            };
            holder.ivPlay.setOnClickListener(view -> {
                /*if (holder.mPlayer != null && holder.mPlayer.isPlaying()) {
                    mSeekbarUpdateHandler.removeCallbacks(mUpdateSeekbar);
                    holder.mPlayer.stop();
                    holder.mPlayer.reset();
                    holder.ivPlay.setVisibility(View.VISIBLE);
                    holder.seekBar.setProgress(0);
                    holder.ivStop.setVisibility(View.GONE);
                }*/
                audioFilesModel.setPlaying(true);
                holder.mPlayer = new MediaPlayer();
                // Set the media player audio stream type
                holder.mPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
                try {
                    holder.pbLoading.setVisibility(View.VISIBLE);
                    holder.ivPlay.setVisibility(View.GONE);
                    holder.ivStop.setVisibility(View.GONE);
                    holder.mPlayer.setDataSource(holder.pbLoading.getContext(), audioFilesModel.getUri());
                    holder.mPlayer.prepare();
                    holder.mPlayer.start();

                } catch (IOException e) {
                    e.printStackTrace();
                }
                holder.mPlayer.setOnCompletionListener(mediaPlayer -> {
                    audioFilesModel.setPlaying(false);
                    mSeekbarUpdateHandler.removeCallbacks(mUpdateSeekbar);
                    holder.mPlayer.stop();
                    holder.mPlayer.release();
                    holder.ivPlay.setVisibility(View.VISIBLE);
                    holder.seekBar.setProgress(0);
                    holder.ivStop.setVisibility(View.GONE);
                });
                holder.mPlayer.setOnPreparedListener(mediaPlayer -> {
                    holder.seekBar.setMax(mediaPlayer.getDuration());
                    mSeekbarUpdateHandler.postDelayed(mUpdateSeekbar, 500);
                    holder.pbLoading.setVisibility(View.GONE);
                    holder.ivPlay.setVisibility(View.GONE);
                    holder.ivStop.setVisibility(View.VISIBLE);
                });

            });
            holder.seekBar.setOnTouchListener((view, motionEvent) -> true);
            holder.ivStop.setOnClickListener(view1 -> {
                audioFilesModel.setPlaying(false);
                if (holder.mPlayer != null) {
                    holder.mPlayer.stop();
                    holder.mPlayer.release();
                }
                holder.ivPlay.setVisibility(View.VISIBLE);
                holder.ivStop.setVisibility(View.GONE);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return audioFilesModelList.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        private ImageView ivPlay, ivStop;
        private TextView tvBusiness;
        private RadioButton rbBusiness;
        MediaPlayer mPlayer;
        private AppCompatSeekBar seekBar;
        private ProgressBar pbLoading;
        private TextView tvMessageTime;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvBusiness = itemView.findViewById(R.id.tvBusiness);
            rbBusiness = itemView.findViewById(R.id.rbBusiness);
            ivPlay = itemView.findViewById(R.id.ivPlay);
            ivStop = itemView.findViewById(R.id.ivStop);
            seekBar = itemView.findViewById(R.id.seekbar);
            pbLoading = itemView.findViewById(R.id.pbLoading);
            tvMessageTime = itemView.findViewById(R.id.tvMessageTime);
        }
    }
}
