package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.stripe.stripeterminal.external.models.Reader;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.BusinessCardReader;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

/**
 * Created by Amrish on 07-12-2020.
 */
public class CardReaderAdapter extends RecyclerView.Adapter<CardReaderAdapter.ItemViewHolder> {
    private ArrayList<Object> cardReaderObjects;
    private RecyclerviewItemClickListener recyclerViewItemClickListener;

    public String selectedId = "";
    private RadioButton checkedRadioButton;


    public CardReaderAdapter(ArrayList<Object> cardReaderObjects, RecyclerviewItemClickListener recyclerViewItemClickListener) {
        this.cardReaderObjects = cardReaderObjects;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    public void updateReaders(@NotNull ArrayList<Object> readers) {
        this.cardReaderObjects = readers;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ItemViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_cardreader, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ItemViewHolder holder, int position) {
        try {
            if (cardReaderObjects.get(position) instanceof BusinessCardReader) {
                BusinessCardReader cardReader = (BusinessCardReader) cardReaderObjects.get(position);
                holder.rbItem.setChecked(selectedId != null && selectedId.equalsIgnoreCase(cardReader.id));

                holder.tvName.setText(cardReader.name);
                holder.itemView.setOnClickListener(view -> {
                    selectedId = cardReader.id;
                    notifyDataSetChanged();
                    if (checkedRadioButton != null) checkedRadioButton.setChecked(false);
                    checkedRadioButton = holder.rbItem;
                    holder.rbItem.setChecked(true);
                    if (recyclerViewItemClickListener != null)
                        recyclerViewItemClickListener.onItemClick(position, cardReader);
                });
            }
            if (cardReaderObjects.get(position) instanceof Reader) {
                Reader cardReader = (Reader) cardReaderObjects.get(position);
                if (cardReader.getId() != null) {
                    holder.rbItem.setChecked(selectedId != null && selectedId.equalsIgnoreCase(cardReader.getId()));
                } else {
                    holder.rbItem.setChecked(selectedId != null && selectedId.equalsIgnoreCase(cardReader.getSerialNumber()));
                }
                if (cardReader.getLabel() == null) {
                    holder.tvName.setText(cardReader.getSerialNumber());
                } else {
                    holder.tvName.setText(cardReader.getLabel());
                }
                holder.itemView.setOnClickListener(view -> {
                    if (cardReader.getId() != null) {
                        selectedId = cardReader.getId();
                    } else {
                        selectedId = cardReader.getSerialNumber();
                    }
                    if (checkedRadioButton != null) checkedRadioButton.setChecked(false);
                    checkedRadioButton = holder.rbItem;
                    holder.rbItem.setChecked(true);
                    notifyDataSetChanged();
                    if (recyclerViewItemClickListener != null)
                        recyclerViewItemClickListener.onItemClick(position, cardReader);
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return cardReaderObjects.size();
    }

    protected static class ItemViewHolder extends RecyclerView.ViewHolder {

        private TextView tvName;
        private RadioButton rbItem;

        public ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
            rbItem = itemView.findViewById(R.id.rbItem);
        }
    }
}
