package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Category;

import java.util.ArrayList;

public class CategoryAdapter extends RecyclerView.Adapter<CategoryAdapter.ViewHolder> {
    private final ArrayList<Category> categories;
    private final RecyclerviewItemClickListener recyclerviewItemClickListener;
    private RadioButton checkedRadio;
    public String selectedCategoryId;

    public CategoryAdapter(ArrayList<Category> categories, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.categories = categories;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public CategoryAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_category, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CategoryAdapter.ViewHolder holder, int position) {
        try {
            Category category = categories.get(position);
            Context context = holder.itemView.getContext();

            if (selectedCategoryId != null && selectedCategoryId.equalsIgnoreCase(category.id)) {
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                holder.tvName.setBackground(ContextCompat.getDrawable(context, R.drawable.green_shadow_12));
            } else {
                holder.tvName.setBackgroundResource(R.drawable.shadow_12);
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.reason_normal_text));
                try {
                    GradientDrawable gd = new GradientDrawable(
                            GradientDrawable.Orientation.TOP_BOTTOM,
                            new int[]{Color.parseColor(category.top_color), Color.parseColor(category.bottom_color)});
                    gd.setCornerRadius(12f);
                    holder.tvName.setBackground(gd);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (Validators.isNullOrEmpty(category.font_color)) {
                    holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                } else
                    holder.tvName.setTextColor(Color.parseColor(category.font_color));

            }

            holder.tvName.setText(category.name);
            holder.tvName.setOnClickListener((view) -> {
                selectedCategoryId = category.id;
                notifyDataSetChanged();
                if (recyclerviewItemClickListener != null)
                    recyclerviewItemClickListener.onItemClick(position, category);

            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return categories.size();
    }

    protected static class ViewHolder extends RecyclerView.ViewHolder {

        private TextView tvName;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
        }
    }
}
