package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.chauthai.swipereveallayout.SwipeRevealLayout;
import com.google.android.material.card.MaterialCardView;
import com.mikhaellopez.circularimageview.CircularImageView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Chat;
import com.ubsidi.epos_2021.utils.Constants;

import java.util.ArrayList;


public class ChatListAdapter extends RecyclerView.Adapter<ChatListAdapter.ChatItemViewHolder> {
    private ArrayList<Chat> chats;
    private RecyclerviewItemClickListener recyclerViewItemClickListener, deleteItemListners;
    private boolean check = false;
    public String selectedUser;

    public ChatListAdapter(ArrayList<Chat> chats, RecyclerviewItemClickListener recyclerViewItemClickListener, RecyclerviewItemClickListener deleteItemListners) {
        this.chats = chats;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
        this.deleteItemListners = deleteItemListners;
    }

    @NonNull
    @Override
    public ChatItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ChatItemViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_chat_list, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ChatItemViewHolder holder, int position) {
        try {
            Chat chatMessage = chats.get(position);
            if (!Validators.isNullOrEmpty(chatMessage.customer_name))
                holder.tvName.setText(chatMessage.customer_name);
            else
                holder.tvName.setText("");

            holder.tvChatDate.setText(CommonFunctions.formatUnknownDateTime(chatMessage.created, Constants.PHP_DATE_TIME_FORMAT_ZULU, "EEE dd MMM"));
            Context context = holder.itemView.getContext();
            if (chatMessage.unread_count > 0) {
                holder.rlChatCount.setVisibility(View.VISIBLE);
            } else {
                holder.rlChatCount.setVisibility(View.GONE);
            }
            holder.tvChatCount.setText(String.valueOf(chatMessage.unread_count));
            String imageUrl = null;
            if (chatMessage.user != null) {
                if (!Validators.isNullOrEmpty(chatMessage.user.image_url)) {
                    imageUrl = chatMessage.user.image_url;
                }
            } else {
                imageUrl = chatMessage.image_url;
            }
            if (!Validators.isNullOrEmpty(imageUrl)) {
                Glide.with(holder.itemView.getContext())
                        .load(imageUrl)
                        .placeholder(R.drawable.avatar_logo_placeholder)
                        .error(R.drawable.avatar_logo_placeholder)
                        .into(holder.ivLogo);
            } else {
                holder.ivLogo.setImageResource(R.drawable.avatar_logo_placeholder);
            }
            holder.llItem.setOnClickListener(view -> {
                selectedUser = chatMessage.customer_id;
                notifyDataSetChanged();
                if (recyclerViewItemClickListener != null)
                    recyclerViewItemClickListener.onItemClick(position, chatMessage);
            });

            if (!Validators.isNullOrEmpty(selectedUser)) {
                if (selectedUser.equalsIgnoreCase(chatMessage.customer_id)) {
                    holder.llItem.setBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
                    holder.ivLogo.setBorderColor(ContextCompat.getColor(context, R.color.white));
                    holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                    holder.tvChatDate.setTextColor(ContextCompat.getColor(context, R.color.white));
                    holder.tvSeenTime.setTextColor(ContextCompat.getColor(context, R.color.white));
                } else {
                    holder.llItem.setBackgroundColor(ContextCompat.getColor(context, R.color.white));
                    holder.ivLogo.setBorderColor(ContextCompat.getColor(context, R.color.black));
                    holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.black));
                    holder.tvChatDate.setTextColor(ContextCompat.getColor(context, R.color.dark_grey_color));
                    holder.tvSeenTime.setTextColor(ContextCompat.getColor(context, R.color.dark_grey_color));
                }
            } else {
                holder.llItem.setBackgroundColor(ContextCompat.getColor(context, R.color.white));
                holder.ivLogo.setBorderColor(ContextCompat.getColor(context, R.color.black));
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.black));
                holder.tvChatDate.setTextColor(ContextCompat.getColor(context, R.color.dark_grey_color));
                holder.tvSeenTime.setTextColor(ContextCompat.getColor(context, R.color.dark_grey_color));
            }

            holder.llDelete.setOnClickListener(view -> {
                holder.swipeLayout.close(true);
                if (deleteItemListners != null) {
                    deleteItemListners.onItemClick(position, chatMessage);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return chats.size();
    }

    protected static class ChatItemViewHolder extends RecyclerView.ViewHolder {
        private TextView tvName, tvChatCount, tvChatDate, tvSeenTime, tvLogoName;
        private CircularImageView ivLogo;
        private RelativeLayout rlChatCount;
        private MaterialCardView cvChat;
        private SwipeRevealLayout swipeLayout;
        private LinearLayout llDelete, llItem;

        public ChatItemViewHolder(@NonNull View itemView) {
            super(itemView);
            tvChatCount = itemView.findViewById(R.id.tvUnreadCount);
            tvChatDate = itemView.findViewById(R.id.tvChatDate);
            tvName = itemView.findViewById(R.id.tvName);
            rlChatCount = itemView.findViewById(R.id.rlUnreadCount);
            ivLogo = itemView.findViewById(R.id.ivLogo);
            cvChat = itemView.findViewById(R.id.cvChat);
            tvSeenTime = itemView.findViewById(R.id.tvSeenTime);
            tvLogoName = itemView.findViewById(R.id.tvLogoName);
            swipeLayout = itemView.findViewById(R.id.swipeRevealLayout);
            llDelete = itemView.findViewById(R.id.llDelete);
            llItem = itemView.findViewById(R.id.llItem);

            swipeLayout.setLockDrag(true);
        }
    }
}
