package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.SiteSetting;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Amrish on 07-05-2021.
 */
public class CustomerAutoSuggestAdapter extends ArrayAdapter<Customer> {

    List<Customer> items, tempItems, suggestions;
    private Activity activity;
    private SiteSetting customerSearch = MyApp.getInstance().findSetting("customer_search_setting");
    private boolean isCustomerEnable=false;

    public CustomerAutoSuggestAdapter(@NonNull Activity context, List<Customer> items) {
        super(context, 0, items);
        this.activity = context;
        this.items = items;
        tempItems = new ArrayList<Customer>(items); // this makes the difference.
        suggestions = new ArrayList<Customer>();
    }

    public void updateData(List<Customer> items) {
        this.items = items;
        tempItems = new ArrayList<Customer>(items); // this makes the difference.
        /*if (activity != null) {
            activity.runOnUiThread(this::notifyDataSetChanged);
        }*/
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        // Check if an existing view is being reused, otherwise inflate the view
        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.item_customer, parent, false);
        }
        TextView tvCustomer = convertView.findViewById(R.id.tvCustomer);

        Customer customer = items.get(position);
        if(Validators.isNullOrEmpty(customer.mobile)){
            tvCustomer.setText(customer.name);
        }else {
            tvCustomer.setText(customer.name + " (" + customer.mobile + ")");
        }
        return convertView;
    }

    @Override
    public Filter getFilter() {
        return nameFilter;
    }

    /**
     * Custom Filter implementation for custom suggestions we provide.
     */
    Filter nameFilter = new Filter() {
        @Override
        public CharSequence convertResultToString(Object resultValue) {
            String str = ((Customer) resultValue).name;
            return str;
        }

        @Override
        protected FilterResults performFiltering(CharSequence constraint) {
            try {
                if (activity != null) {
                    activity.runOnUiThread(() -> {

                    });
                }
                // Setting for enable customer search
                if(customerSearch!=null && !Validators.isNullOrEmpty(customerSearch.value) && customerSearch.value.equalsIgnoreCase("yes"))
                {
                    isCustomerEnable=true;
                }
                if (constraint != null&&isCustomerEnable) {
                    suggestions.clear();
                    int count = 0;
                    for (Customer people : tempItems) {
                        if ((people.name != null && people.name.toLowerCase().contains(constraint.toString().toLowerCase())) || (people.mobile != null && people.mobile.contains(constraint.toString()))) {
                            suggestions.add(people);
                            count++;
                            if (count == 25) {
                                break;
                            }
                        }
                    }
                    FilterResults filterResults = new FilterResults();
                    filterResults.values = suggestions;
                    filterResults.count = suggestions.size();
                    return filterResults;
                } else {
                    return new FilterResults();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return new FilterResults();
        }

        @Override
        protected void publishResults(CharSequence constraint, FilterResults results) {
            try {
                if (activity != null) {
                    activity.runOnUiThread(() -> {

                        if (results != null && results.count > 0) {
                            items.clear();
                            items.addAll((ArrayList<Customer>) results.values);
                           // clear();
                            //addAll(items);
                            if (activity != null) {
                                activity.runOnUiThread(() -> notifyDataSetChanged());
                            }
                        }

                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
}
