package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Customer;

import java.util.ArrayList;

public class CustomersAdapter extends RecyclerView.Adapter<CustomersAdapter.CustomerViewHolder> {
    private ArrayList<Customer> customers;
    private RecyclerviewItemClickListener editClickListener, deleteClickListener;

    public CustomersAdapter(ArrayList<Customer> customers, RecyclerviewItemClickListener editClickListener, RecyclerviewItemClickListener deleteClickListener) {
        this.customers = customers;
        this.editClickListener = editClickListener;
        this.deleteClickListener = deleteClickListener;
    }

    @NonNull
    @Override
    public CustomerViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CustomerViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_customer_full, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull CustomerViewHolder holder, int position) {
        try {
            Customer customer = customers.get(position);
            holder.tvPostcode.setText(customer.postcode == null ? "-" : customer.postcode);
            holder.tvName.setText(customer.name == null ? "-" : customer.name);
            holder.tvMobile.setText(customer.mobile == null ? "-" : customer.mobile);
            holder.tvEdit.setOnClickListener(v -> {
                if (editClickListener != null) {
                    editClickListener.onItemClick(position, customer);
                }
            });
            holder.tvDelete.setOnClickListener(v -> {
                if (deleteClickListener != null) {
                    deleteClickListener.onItemClick(position, customer);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getItemId(int position) {
        return customers.get(position)._id;
    }

    @Override
    public int getItemCount() {
        return customers.size();
    }

    protected class CustomerViewHolder extends RecyclerView.ViewHolder {
        private TextView tvName, tvMobile, tvPostcode, tvEdit, tvDelete;

        public CustomerViewHolder(@NonNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
            tvMobile = itemView.findViewById(R.id.tvMobile);
            tvPostcode = itemView.findViewById(R.id.tvPostcode);
            tvEdit = itemView.findViewById(R.id.tvEdit);
            tvDelete = itemView.findViewById(R.id.tvDelete);
        }
    }
}
