package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.ExclusionModel;

import java.util.ArrayList;

public class DateAdapter extends RecyclerView.Adapter<DateAdapter.ViewHolder> {

    private ArrayList<ExclusionModel> daysList;
    private RecyclerviewItemClickListener recyclerviewItemClickListener;

    public DateAdapter(ArrayList<ExclusionModel> daysList, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.daysList = daysList;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.exclusive_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull DateAdapter.ViewHolder holder, int position) {
        try {
            ExclusionModel exclusionModel = daysList.get(position);

            holder.chkExclusive.setText(exclusionModel.name);

            holder.chkExclusive.setChecked(exclusionModel.isChecked);

            holder.chkExclusive.setOnClickListener(v -> {
                if (recyclerviewItemClickListener != null) {
                    recyclerviewItemClickListener.onItemClick(position, exclusionModel);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return daysList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private CheckBox chkExclusive;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            chkExclusive = itemView.findViewById(R.id.chkExclusive);
        }
    }
}
