package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Handler;
import android.util.Log;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTag;
import com.ubsidi.epos_2021.models.Header;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderStatuses;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.utils.Constants;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class EposOrdersAdapterTheme2 extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    public ArrayList<Object> orders;
    public List<OrderViewHolder> lstHolders;
    public List<HomeOrderViewHolder> lstHomeHolders;
    public RecyclerviewItemClickListener itemClickListener;
    public RecyclerviewItemClickListener actionListener;
    public Handler handler = new Handler();
    private final SiteSetting readyToCollectSetting = MyApp.getInstance().findSetting("is_ready_to_collect");
    public Timer tmr = new Timer();
    public final Runnable updateTime = new Runnable() {
        @Override
        public void run() {
            synchronized (lstHolders) {
                long currentTime = System.currentTimeMillis();
                for (OrderViewHolder holder : lstHolders) {
                    holder.updateTimeRemaining(currentTime);
                }

            }
            synchronized (lstHomeHolders) {
                long currentTime = System.currentTimeMillis();
                for (HomeOrderViewHolder holder : lstHomeHolders) {
                    holder.updateTimeRemaining(currentTime);
                }
            }
        }
    };
    public boolean showCheck = false;
    public boolean selectAll = false, isAllSelected = false;
    public MyApp myApp = MyApp.getInstance();
    public AppDatabase appDatabase = myApp.appDatabase;
    public ArrayList<OrderStatuses> orderStatuses = new ArrayList();
    int var = 0;
    public RecyclerviewItemClickListenerWithTag homeActionListener;
    private boolean fromTheme2;
    private boolean isReadyToCollect = false, canPayBill = true, fromHistory;

    public EposOrdersAdapterTheme2(ArrayList<Object> orders, boolean fromTheme2, boolean isAllSelected, RecyclerviewItemClickListener itemClickListener, RecyclerviewItemClickListener actionListener, RecyclerviewItemClickListenerWithTag homactionListener) {
        this.orders = orders;
        this.itemClickListener = itemClickListener;
        this.actionListener = actionListener;
        this.homeActionListener = homactionListener;
        this.fromTheme2 = fromTheme2;
        lstHolders = new ArrayList<>();
        lstHomeHolders = new ArrayList<>();
        this.isAllSelected = isAllSelected;
        startUpdateTimer();
        isReadyToCollect = readyToCollectSetting != null && (readyToCollectSetting.value.equalsIgnoreCase("true") || readyToCollectSetting.value.equalsIgnoreCase("1"));
        canPayBill = MyApp.userPermission != null && MyApp.userPermission.pay_bill.actions.list;
        orderStatuses.addAll(appDatabase.orderStatuesDao().list());
    }

    public EposOrdersAdapterTheme2(ArrayList<Object> orders, boolean fromHistory, RecyclerviewItemClickListener itemClickListener, RecyclerviewItemClickListener actionListener) {
        this.orders = orders;
        this.fromHistory = fromHistory;
        this.itemClickListener = itemClickListener;
        this.actionListener = actionListener;
        lstHolders = new ArrayList<>();
        lstHomeHolders = new ArrayList<>();
        startUpdateTimer();
        isReadyToCollect = readyToCollectSetting != null && (readyToCollectSetting.value.equalsIgnoreCase("true") || readyToCollectSetting.value.equalsIgnoreCase("1"));
        canPayBill = MyApp.userPermission != null && MyApp.userPermission.pay_bill.actions.list;
        orderStatuses.addAll(appDatabase.orderStatuesDao().list());
    }

    private Pair<String, Long> calculatedTimeDifference(Date selectTime, Date current) {
        if (selectTime == null) return new Pair<>("", 0L);
        long diff = selectTime.getTime() - current.getTime();
        long diffSeconds = diff / 1000 % 60;
        long diffMinutes = diff / (60 * 1000) % 60;
        long diffHours = diff / (60 * 60 * 1000);
        String finalText = "";
        if (diffHours < 0 && diffMinutes < 0 && diffSeconds < 0) {
            String hour = String.valueOf((diffHours)).replace("-", "");
            hour = (hour.length() > 1 ? hour : "0" + hour);
            String min = String.valueOf((diffMinutes)).replace("-", "");
            min = (min.length() > 1 ? min : "0" + min);
            String second = String.valueOf((diffSeconds)).replace("-", "");
            second = (second.length() > 1 ? second : "0" + second);
            finalText = "-" + hour + ":" + min + ":" + second;
        } else if (diffHours >= 0 && diffMinutes < 0 && diffSeconds < 0) {
            String min = String.valueOf((diffMinutes)).replace("-", "");
            min = (min.length() > 1 ? min : "0" + min);
            String second = String.valueOf((diffSeconds)).replace("-", "");
            second = (second.length() > 1 ? second : "0" + second);
            finalText = "-0" + (diffHours) + ":" + min + ":" + second;
        } else {
            finalText = (diffHours > 9 ? diffHours : "0" + diffHours) + ":" + (diffMinutes > 9 ? diffMinutes : "0" + diffMinutes) + ":" + (diffSeconds > 9 ? diffSeconds : "0" + diffSeconds);
        }
        return new Pair(finalText, diffMinutes);
    }

    private String calculatedTime(Date crated, Date current) {

        if (crated == null) return "";
        long diff = current.getTime() - crated.getTime();

        long diffSeconds = diff / 1000 % 60;
        long diffMinutes = diff / (60 * 1000) % 60;
        long diffHours = diff / (60 * 60 * 1000);
        int diffInDays = (int) diff / (1000 * 60 * 60 * 24);


        String formate = (diffHours > 9 ? diffHours : "0" + diffHours) + ":" + (diffMinutes > 9 ? diffMinutes : "0" + diffMinutes) + ":" + (diffSeconds > 9 ? diffSeconds : "0" + diffSeconds);
        return formate;
    }

    private void startUpdateTimer() {
        if (tmr != null) {
            tmr.schedule(new TimerTask() {
                @Override
                public void run() {
                    handler.post(updateTime);
                }
            }, 1000, 1000);
        }
    }

    @Override
    public int getItemViewType(int position) {
        if (orders.size() > 0 && orders.get(position) instanceof Order) {
            if (!fromTheme2) {
                return R.layout.item_order;
            } else {
                return R.layout.item_order_home_theme2;
            }
        } else {
            return R.layout.item_header;
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_order) {
            return new OrderViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else if (viewType == R.layout.item_order_home_theme2) {
            return new HomeOrderViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else {
            return new HeaderViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        try {
            if (orders.size() > 0 && position > -1) {
                if (getItemViewType(position) == R.layout.item_order) {

                    Order order = (Order) orders.get(position);
                    OrderViewHolder orderViewHolder = (OrderViewHolder) holder;
                    synchronized (lstHolders) {
                        lstHolders.add(orderViewHolder);
                    }
                    if (Validators.isNullOrEmpty(order.table_number)) {
                        orderViewHolder.tvTableNumber.setText(order.order_type);
                    } else {
                        orderViewHolder.tvTableNumber.setText(order.table_number);
                    }
                    orderViewHolder.setData(order, canPayBill);
                    boolean canWeSelect = order.total > 0 && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 && ((!fromHistory && !order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) || (fromHistory && (order.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10"))));
                    orderViewHolder.cvOrder.setOnClickListener(view -> {
                        if (showCheck && canWeSelect) {
                            order.selected = !order.selected;
                        } else {
                            order.selected = false;
                        }
                        orderViewHolder.rbSelect.setChecked(order.selected);
                        itemClickListener.onItemClick(position, order);
                    });
                    orderViewHolder.itemView.setOnClickListener(view -> {
                        if (showCheck && canWeSelect) {
                            order.selected = !order.selected;
                        } else {
                            order.selected = false;
                        }
                        orderViewHolder.rbSelect.setChecked(order.selected);
                        itemClickListener.onItemClick(position, order);
                    });

                    if (showCheck) {
                        orderViewHolder.rbSelect.setEnabled(canWeSelect);
                        orderViewHolder.rbSelect.setVisibility(View.VISIBLE);
                        orderViewHolder.rbSelect.setChecked(order.selected);
                    } else {
                        orderViewHolder.rbSelect.setEnabled(false);
                        orderViewHolder.rbSelect.setVisibility(View.GONE);
                    }
                    orderViewHolder.cvAction.setOnClickListener(view -> {
                        if (!showCheck) {
                            actionListener.onItemClick(position, order);
                        }
                    });
                } else if (getItemViewType(position) == R.layout.item_order_home_theme2) {
                    HomeOrderViewHolder homeOrderViewHolder = (HomeOrderViewHolder) holder;
                    Order order = (Order) orders.get(position);
                    synchronized (lstHomeHolders) {
                        lstHomeHolders.add(homeOrderViewHolder);
                    }
                    if (Validators.isNullOrEmpty(order.table_number)) {
                        homeOrderViewHolder.tvTableNumber.setText(order.order_type);
                    } else {
                        homeOrderViewHolder.tvTableNumber.setText(order.table_number);
                    }
                    boolean orderIsPaid = order.total > 0 && CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 && (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10"));
                    Log.e("orderIsPaid", " " + orderIsPaid);
                    homeOrderViewHolder.setData(order);
                    if (showCheck) {
                        homeOrderViewHolder.rbSelect.setVisibility(View.VISIBLE);
                        homeOrderViewHolder.rbSelect.setEnabled(orderIsPaid);
                    } else {
                        homeOrderViewHolder.rbSelect.setEnabled(false);
                        homeOrderViewHolder.rbSelect.setVisibility(View.GONE);
                    }
                    Context context = homeOrderViewHolder.itemView.getContext();
                    int viewType = 0;
                    boolean shouldShowReadyToCollect = false;

                    if (!order.order_status_id.equalsIgnoreCase("10") && !order.order_status_id.equalsIgnoreCase("5")) {
                        if (!orderIsPaid) {
                            viewType = canPayBill ? 1 : 0; // Show Pay now button
                        } else {
                            viewType = 2; // show expandable menu
                            if (order.order_status_id.equalsIgnoreCase("6")) {
                                shouldShowReadyToCollect = false;
                            } else {
                                shouldShowReadyToCollect = isReadyToCollect;
                            }
                        }
                    }
                    Log.e("viewType", " " + viewType);
                    homeOrderViewHolder.ivAction.setVisibility(View.VISIBLE);
                    if (viewType == 1) {
                        // Order is not paid yet.
                        homeOrderViewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                        homeOrderViewHolder.llExpandedView.setVisibility(View.GONE);
                        homeOrderViewHolder.llPaymentStatus.setVisibility(View.VISIBLE);
                        homeOrderViewHolder.ivAction.setImageResource(R.drawable.icon_pound_sign);
                    } else if (viewType == 2) {
                        // Order is paid but needs some actions
                        Log.e("expanded", " " + order.expanded);
                        if (order.expanded) {
                            homeOrderViewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                            homeOrderViewHolder.llExpandedView.setVisibility(View.VISIBLE);
                            homeOrderViewHolder.llOrder.setVisibility(View.GONE);
                            homeOrderViewHolder.llPaymentStatus.setVisibility(View.GONE);
                            homeOrderViewHolder.ivAction.setImageResource(R.drawable.icon_ios_arrow_back);
                            if (shouldShowReadyToCollect) {
                                homeOrderViewHolder.llReadyToAction.setVisibility(View.VISIBLE);
                            } else {
                                homeOrderViewHolder.llReadyToAction.setVisibility(View.GONE);
                            }
                        } else {
                            homeOrderViewHolder.ivAction.setImageResource(R.drawable.three_dot);
                            homeOrderViewHolder.cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                            homeOrderViewHolder.llExpandedView.setVisibility(View.GONE);
                            homeOrderViewHolder.llOrder.setVisibility(View.VISIBLE);
                            homeOrderViewHolder.llPaymentStatus.setVisibility(View.VISIBLE);
                        }
                    } else {
                        // Order is completed or rejected
                        homeOrderViewHolder.ivAction.setVisibility(View.GONE);
                        homeOrderViewHolder.llExpandedView.setVisibility(View.GONE);
                        homeOrderViewHolder.llPaymentStatus.setVisibility(View.GONE);
                    }

                    int finalViewType = viewType;
                    homeOrderViewHolder.ivAction.setOnClickListener(view -> {
                        if (finalViewType == 1) {
                            if (homeActionListener != null) {
                                homeActionListener.onItemClick(position, "pay_order", order);
                            }
                        } else if (finalViewType == 2) {
                            // Show order options
                            order.expanded = !order.expanded;
                        }
                        notifyDataSetChanged();
                    });

                    homeOrderViewHolder.llReadyToAction.setOnClickListener(view -> {
                        if (homeActionListener != null) {
                            homeActionListener.onItemClick(position, "ready_to_action", order);
                        }
                    });

                    homeOrderViewHolder.llCompleteAction.setOnClickListener(view -> {
                        if (homeActionListener != null) {
                            homeActionListener.onItemClick(position, "complete_order", order);
                        }
                    });

                    homeOrderViewHolder.rbSelect.setChecked(order.selected);
                    homeOrderViewHolder.cvOrder.setOnClickListener(view -> {
                        if (showCheck && orderIsPaid) {
                            order.selected = !order.selected;
                        } else {
                            order.selected = false;
                        }
                        itemClickListener.onItemClick(position, order);
                    });

                    homeOrderViewHolder.itemView.setOnClickListener(view -> {
                        homeOrderViewHolder.cvOrder.performClick();
                    });


                } else if (getItemViewType(position) == R.layout.item_header) {
                    Header header = (Header) orders.get(position);
                    HeaderViewHolder headerViewHolder = (HeaderViewHolder) holder;
                    headerViewHolder.tvHeader.setText(header.title);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return orders.size();
    }

    @Override
    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        handler.removeCallbacks(updateTime);
    }

    @Override
    public long getItemId(int position) {
        if (orders.get(position) instanceof Order) {
            return ((Order) orders.get(position))._id;
        } else if (orders.get(position) instanceof Header) {
            return ((Header) orders.get(position)).id;
        } else
            return position;
    }

    private void setColorBG(LinearLayout llOrder, String status, MaterialCardView cvOrder) {
        try {
            for (int i = 0; i < orderStatuses.size(); i++) {
                if (status.equalsIgnoreCase(orderStatuses.get(i).status)) {
                    llOrder.setBackgroundColor(Color.parseColor(orderStatuses.get(i).top_color));
                    cvOrder.setBackgroundTintList(ColorStateList.valueOf(Color.parseColor(orderStatuses.get(i).top_color)));
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class OrderViewHolder extends RecyclerView.ViewHolder {
        LinearLayout llPaymentStatus;
        TextView tvOrderNumber, tvCustomerName, tvTimeDiff, tvAction, tvPaymentStatus, tvTableNumber;
        MaterialCardView cvOrder;
        Order order;
        RadioButton rbSelect;
        MaterialCardView cvAction;

        public OrderViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTableNumber = itemView.findViewById(R.id.tvTableNumberIOrder);
            rbSelect = itemView.findViewById(R.id.rbSelectIOrder);
            cvOrder = itemView.findViewById(R.id.cvOrderIOrder);
            tvOrderNumber = itemView.findViewById(R.id.tvOrderNumberIOrder);
            tvCustomerName = itemView.findViewById(R.id.tvCustomerNameIOrder);
            tvTimeDiff = itemView.findViewById(R.id.tvTimeDiff);
            tvAction = itemView.findViewById(R.id.tvActionIOrder);
            tvPaymentStatus = itemView.findViewById(R.id.tvPaymentStatusIOrder);
            llPaymentStatus = itemView.findViewById(R.id.llPaymentStatusIOrder);
            cvAction = itemView.findViewById(R.id.cvAction);
        }

        public void setData(Order item, boolean canPayBill) {
            try {
                order = item;
                Context context = itemView.getContext();
                if (Validators.isNullOrEmpty(item.id)) {
                    if (order.order_type_id.equalsIgnoreCase("3") && order.customer != null) {
                        tvOrderNumber.setText("#" + item._id + " | " + order.customer.postcode);
                    } else {
                        tvOrderNumber.setText("#" + item._id);
                    }
                } else {
                    if (order.order_type_id.equalsIgnoreCase("3") && order.customer != null) {
                        tvOrderNumber.setText("#" + item.id + " | " + order.customer.postcode);
                    } else {
                        tvOrderNumber.setText("#" + item.id);
                    }
                }
                tvCustomerName.setText(item.customer_name);

                if (order.order_status_id.equalsIgnoreCase("5") ||
                        order.order_status_id.equalsIgnoreCase("6") ||
                        order.order_status_id.equalsIgnoreCase("9") ||
                        order.order_status_id.equalsIgnoreCase("10")) {

                    cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.light_grey));
                    cvAction.setCardBackgroundColor(ContextCompat.getColor(context, R.color.light_grey));

                    tvTableNumber.setTextColor(ContextCompat.getColor(context, R.color.light_black));
                    tvOrderNumber.setTextColor(ContextCompat.getColor(context, R.color.light_black));
                    tvCustomerName.setTextColor(ContextCompat.getColor(context, R.color.light_black));
                    tvAction.setTextColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                    tvTimeDiff.setTextColor(ContextCompat.getColor(context, R.color.black));
                    tvAction.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ic_baseline_green_done_18, 0);
                    if (order.order_status_id.equalsIgnoreCase("10")) {
                        tvAction.setText("Rejected  ");
                        tvAction.setTextColor(ContextCompat.getColor(context, R.color.reject_color));
                        tvAction.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ic_baseline_green_close_18, 0);
                    } else {
                        if (order.order_type_id.equalsIgnoreCase("3")) {
                            tvAction.setText("Delivered  ");
                            //  cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                        } else if (order.order_type_id.equalsIgnoreCase("2")) {
                            tvAction.setText("Collected  ");
                            // cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.orders_card_bg_indigo));
                        } else if (order.order_type_id.equalsIgnoreCase("1")) {
                            tvAction.setText("Served  ");
                        } else if (order.order_type_id.equalsIgnoreCase("5")) {
                            tvAction.setText("Collected  ");
                        } else {
                            tvAction.setText("Completed  ");
                        }
                    }

                    cvAction.setEnabled(false);
                    tvAction.setPaintFlags(0);
                    tvTimeDiff.setVisibility(View.INVISIBLE);
                    llPaymentStatus.setVisibility(View.GONE);
                } else {
                    tvTimeDiff.setVisibility(View.VISIBLE);
                    tvAction.setCompoundDrawables(null, null, null, null);
                    cvAction.setEnabled(true);
                    cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                    cvAction.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                    tvTableNumber.setTextColor(ContextCompat.getColor(context, R.color.white));
                    tvOrderNumber.setTextColor(ContextCompat.getColor(context, R.color.white));
                    tvCustomerName.setTextColor(ContextCompat.getColor(context, R.color.white));
                    tvAction.setTextColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                    tvAction.setPaintFlags(0);

                    tvTimeDiff.setTextColor(ContextCompat.getColor(context, R.color.white));
                    llPaymentStatus.setVisibility(View.VISIBLE);
                    if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                        tvPaymentStatus.setText("Paid");
                        tvPaymentStatus.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
                        if (order.order_type_id.equalsIgnoreCase("3")) {
                            tvAction.setText("Mark as delivered");
                        } else {
                            tvAction.setText("Mark as collected");
                        }
                        if (order.order_type_id.equalsIgnoreCase("3")) {
                            tvAction.setText("Mark as delivered");
                        } else if (order.order_type_id.equalsIgnoreCase("2")) {
                            tvAction.setText("Mark as collected");
                        } else if (order.order_type_id.equalsIgnoreCase("1")) {
                            tvAction.setText("Mark as served");
                        } else if (order.order_type_id.equalsIgnoreCase("5")) {
                            tvAction.setText("Mark as collected");
                        } else {
                            tvAction.setText("Mark as Completed");
                        }
                    } else {
                        if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == -1) {
                            tvPaymentStatus.setText("Unpaid");
                            tvPaymentStatus.setTextColor(ContextCompat.getColor(context, R.color.orders_card_bg_orange));
                            tvAction.setText("Pay Order");
                        } else {
                            //Toast.makeText(context, "P Paid", Toast.LENGTH_SHORT).show();
                            tvPaymentStatus.setText("Partial Paid--");
                            tvPaymentStatus.setTextColor(ContextCompat.getColor(context, R.color.orders_card_bg_orange));
                            tvAction.setText("Pay Order");
                        }
                        if (canPayBill) {
                            cvAction.setVisibility(View.VISIBLE);
                            cvAction.setEnabled(true);
                        } else {
                            cvAction.setVisibility(View.INVISIBLE);
                            cvAction.setEnabled(false);
                        }
                    }
                }


                updateTimeRemaining(System.currentTimeMillis());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }


        public void updateTimeRemaining(long currentTime) {
            try {
                if (Validators.isNullOrEmpty(order.delivery_collection_time_slot)) {
                    if (order.created_at.contains("Z")) {
                        tvTimeDiff.setText("Ongoing - " + calculatedTime(CommonFunctions.convertToDate(order.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU), new Date()));
                    } else {
                        tvTimeDiff.setText("Ongoing - " + calculatedTime(CommonFunctions.convertToDate(order.created_at, Constants.PHP_DATE_TIME_FORMAT), new Date()));
                    }
                } else {
                    Calendar calendar = Calendar.getInstance();
                    String date = CommonFunctions.formatMiliToDesireFormat(calendar.getTime().getTime(), "dd-MM-yyyy");
                    date += order.delivery_collection_time_slot.trim();
                    calendar.setTime(CommonFunctions.convertToDate(date, "dd-MM-yyyyHH:mm"));
                    Pair<String, Long> pair = calculatedTimeDifference(calendar.getTime(), new Date());
                    if (pair.second <= 5) {
                        cvOrder.setCardBackgroundColor(ContextCompat.getColor(cvOrder.getContext(), R.color.red));
                        tvTimeDiff.setText("Delayed " + pair.first);
                    } else {
                        tvTimeDiff.setText(pair.first);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class HomeOrderViewHolder extends RecyclerView.ViewHolder {
        LinearLayout llOrder, llPaymentStatus, llExpandedView, llReadyToAction, llCompleteAction;
        TextView tvOrderNumber, tvCustomerName, tvPaymentStatus, tvTableNumber;
        MaterialCardView cvOrder;
        Order order;
        RadioButton rbSelect;
        ImageView ivAction;
        TextView tvReadyToAction, tvCompletedStatus, tvTimer;

        public HomeOrderViewHolder(@NonNull View itemView) {
            super(itemView);
            rbSelect = itemView.findViewById(R.id.rbSelectHOrder);
            tvTableNumber = itemView.findViewById(R.id.tvTableNumberHOrder);
            llOrder = itemView.findViewById(R.id.llOrderHOrder);
            cvOrder = itemView.findViewById(R.id.cvOrderHOrder);
            tvOrderNumber = itemView.findViewById(R.id.tvOrderNumberHOrder);
            tvCustomerName = itemView.findViewById(R.id.tvCustomerNameHOrder);
            tvPaymentStatus = itemView.findViewById(R.id.tvPaymentStatus);
            llPaymentStatus = itemView.findViewById(R.id.llPaymentStatus);
            ivAction = itemView.findViewById(R.id.ivAction);
            llExpandedView = itemView.findViewById(R.id.llExpandedView);
            llReadyToAction = itemView.findViewById(R.id.llReadyToAction);
            llCompleteAction = itemView.findViewById(R.id.llCompleteAction);
            tvReadyToAction = itemView.findViewById(R.id.tvReadyToAction);
            tvCompletedStatus = itemView.findViewById(R.id.tvCompleteStatus);
            tvTimer = itemView.findViewById(R.id.tvTimer);
        }

        public void setData(Order item) {
            try {
                order = item;
                Context context = itemView.getContext();
                if (Validators.isNullOrEmpty(item.id)) {
                    if (order.order_type_id.equalsIgnoreCase("3") && order.customer != null) {
                        tvOrderNumber.setText("#" + item._id + " | " + order.customer.postcode);
                    } else {
                        tvOrderNumber.setText("#" + item._id);
                    }
                } else {
                    if (order.order_type_id.equalsIgnoreCase("3") && order.customer != null) {
                        tvOrderNumber.setText("#" + item.id + " | " + order.customer.postcode);
                    } else {
                        tvOrderNumber.setText("#" + item.id);
                    }
                }
                tvCustomerName.setText(item.customer_name);
                llExpandedView.setVisibility(View.GONE);
                llOrder.setVisibility(View.VISIBLE);
                llPaymentStatus.setVisibility(View.VISIBLE);
                if (order.order_status_id.equalsIgnoreCase("5") ||
                        order.order_status_id.equalsIgnoreCase("9") ||
                        order.order_status_id.equalsIgnoreCase("10")) {
                    cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.light_grey));
                    tvTableNumber.setTextColor(ContextCompat.getColor(context, R.color.light_black));
                    tvOrderNumber.setTextColor(ContextCompat.getColor(context, R.color.light_black));
                    tvCustomerName.setTextColor(ContextCompat.getColor(context, R.color.light_black));
                    llPaymentStatus.setVisibility(View.GONE);
                    tvTimer.setVisibility(View.INVISIBLE);
                } else {
                    /*Toast.makeText(context, "DB Order status"+orderStatuses.get(0).status, Toast.LENGTH_SHORT).show();
                    Toast.makeText(context, "Refresh", Toast.LENGTH_SHORT).show();*/
                    tvTimer.setVisibility(View.VISIBLE);
                    cvOrder.setCardBackgroundColor(ContextCompat.getColor(context, R.color.orders_card_bg_green));
                    tvTableNumber.setTextColor(ContextCompat.getColor(context, R.color.white));
                    tvOrderNumber.setTextColor(ContextCompat.getColor(context, R.color.white));
                    tvCustomerName.setTextColor(ContextCompat.getColor(context, R.color.white));
                    tvTimer.setTextColor(ContextCompat.getColor(context, R.color.white));

                    llPaymentStatus.setVisibility(View.VISIBLE);
                    if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1) {
                        tvPaymentStatus.setText("Paid");
                        tvPaymentStatus.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));

                        if (order.order_type_id.equalsIgnoreCase("3")) {
                            tvReadyToAction.setText("Ready to deliver");
                        } else if (order.order_type_id.equalsIgnoreCase("2")) {
                            tvReadyToAction.setText("Ready to collect");
                        } else if (order.order_type_id.equalsIgnoreCase("1")) {
                            tvReadyToAction.setText("Ready to serve");
                        } else if (order.order_type_id.equalsIgnoreCase("5")) {
                            tvReadyToAction.setText("Ready to collect");
                        }
                    } else if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == -1) {
                        tvPaymentStatus.setText("Unpaid");
                        tvPaymentStatus.setTextColor(ContextCompat.getColor(context, R.color.orders_card_bg_orange));
                    } else {
                        //Toast.makeText(context, "Partial Paid-", Toast.LENGTH_SHORT).show();
                        tvPaymentStatus.setText("Partial Paid");
                        tvPaymentStatus.setTextColor(ContextCompat.getColor(context, R.color.orders_card_bg_orange));
                    }
                    updateTimeRemaining(System.currentTimeMillis());
                }

                setColorBG(llOrder, order.order_status, cvOrder);
            } catch (Exception e) {
                e.printStackTrace();
            }

            /*if (order.order_status.equalsIgnoreCase("Taking Order")) {
                //Toast.makeText(context, "Taking Order", Toast.LENGTH_SHORT).show();
                cvOrder.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.epos_taking_order)));
                //llOrder.setBackgroundColor(ContextCompat.getColor(context, R.color.epos_taking_order));
            } else if (order.order_status.equalsIgnoreCase("Order Taken")) {
                //Toast.makeText(context, "Order Taken", Toast.LENGTH_SHORT).show();
                cvOrder.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.epos_order_taken)));
                //llOrder.setBackgroundColor(ContextCompat.getColor(context, R.color.epos_order_taken));
            } else if (order.order_status.equalsIgnoreCase("Order Completed")) {
                tvOrderNumber.setTextColor(ContextCompat.getColor(context, R.color.black));
                tvCustomerName.setTextColor(ContextCompat.getColor(context, R.color.black));
                cvOrder.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.epos_completed)));
                //llOrder.setBackgroundColor(ContextCompat.getColor(context, R.color.epos_completed));
            } else if (order.order_status.equalsIgnoreCase("Order Paid")) {
                cvOrder.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.epos_paid)));
                //llOrder.setBackgroundColor(ContextCompat.getColor(context, R.color.epos_paid));
            } else if (order.order_status.equalsIgnoreCase("Kitchen In Progress")) {
                //Toast.makeText(context, "Kitchen In Progress", Toast.LENGTH_SHORT).show();
                cvOrder.setBackgroundTintList(ColorStateList.valueOf(ContextCompat.getColor(context, R.color.epos_paid)));
                //llOrder.setBackgroundColor(ContextCompat.getColor(context, R.color.epos_paid));
            }*/
        }


        public void updateTimeRemaining(long currentTime) {
            try {
                if (Validators.isNullOrEmpty(order.delivery_collection_time_slot)) {
                    if (order.created_at != null) {
                        if (order.created_at.contains("Z")) {
                            tvTimer.setText(calculatedTime(CommonFunctions.convertToDate(order.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU), new Date()));
                        } else {
                            tvTimer.setText(calculatedTime(CommonFunctions.convertToDate(order.created_at, Constants.PHP_DATE_TIME_FORMAT), new Date()));
                        }
                    }
                } else {
                    Calendar calendar = Calendar.getInstance();
                    String date = CommonFunctions.formatMiliToDesireFormat(calendar.getTime().getTime(), "dd-MM-yyyy");
                    date += order.delivery_collection_time_slot.trim();
                    calendar.setTime(CommonFunctions.convertToDate(date, "dd-MM-yyyyHH:mm"));
                    Pair<String, Long> pair = calculatedTimeDifference(calendar.getTime(), new Date());
                    if (pair.second <= 5) {
                        llOrder.setBackgroundColor(ContextCompat.getColor(cvOrder.getContext(), R.color.red));
                    }
                    if (pair.second <= 5) {
                        llOrder.setBackgroundColor(ContextCompat.getColor(cvOrder.getContext(), R.color.red));
                        tvTimer.setText("Delayed " + pair.first);
                    } else {
                        tvTimer.setText(pair.first);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }

    public class HeaderViewHolder extends RecyclerView.ViewHolder {
        TextView tvHeader;

        public HeaderViewHolder(@NonNull @NotNull View itemView) {
            super(itemView);
            tvHeader = itemView.findViewById(R.id.tvTitleMain);
        }

    }


}

