package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Floor;

import java.util.ArrayList;

/**
 * Created by Amrish on 23-04-2021.
 */
public class FloorAdapter extends RecyclerView.Adapter<FloorAdapter.BusinessViewHolder> {
    public ArrayList<Floor> floors;
    private final RecyclerviewItemClickListener recyclerviewItemClickListener;
    public String selectedFloorId = "";
    public RadioButton checkedRadioButton;

    public FloorAdapter(ArrayList<Floor> floors, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.floors = floors;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public BusinessViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new BusinessViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_floor, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull BusinessViewHolder holder, int position) {
        try {
            if (floors.size() > 0) {

                holder.tvFloor.setText(floors.get(position).name);
                holder.itemView.setOnClickListener(view -> {
                    selectedFloorId = floors.get(position).id;
                    notifyDataSetChanged();
                    if (recyclerviewItemClickListener != null)
                        recyclerviewItemClickListener.onItemClick(position, floors.get(position));
                });

                if (selectedFloorId != null && selectedFloorId.equalsIgnoreCase(floors.get(position).id)) {
                    holder.vSelector.setBackgroundResource(R.color.persian_green);
                    holder.tvFloor.setAlpha(1f);
                } else {
                    holder.vSelector.setBackgroundResource(R.color.light_gray);
                    holder.tvFloor.setAlpha(0.5f);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return floors.size();
    }

    protected static class BusinessViewHolder extends RecyclerView.ViewHolder {
        private RadioButton rbFloor;
        private TextView tvFloor;
        private View vSelector;

        public BusinessViewHolder(@NonNull View itemView) {
            super(itemView);
            rbFloor = itemView.findViewById(R.id.rbFloor);
            tvFloor = itemView.findViewById(R.id.tvFloor);
            vSelector = itemView.findViewById(R.id.vSelector);
        }
    }
}
