package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.ReportTextModel;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

public class FullReportAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    public ArrayList<Object> objects;
    private final RecyclerviewItemClickListener recyclerviewItemClickListener;

    public FullReportAdapter(ArrayList<Object> objects, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.objects = objects;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        if (objects.get(position) instanceof ReportTextModel) {
            return R.layout.item_report_simple;
        } else {
            return R.layout.item_cart_product_empty;
        }

    }

    @Override
    public void onBindViewHolder(@NonNull @NotNull RecyclerView.ViewHolder holder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_report_simple) {
                ReportSimpleViewHolder viewHolder = (ReportSimpleViewHolder) holder;
                ReportTextModel keyValueModel = (ReportTextModel) objects.get(position);
                viewHolder.tvTitle.setText(keyValueModel.title);
                if(keyValueModel.isPaymentSection){
                    viewHolder.tvValue.setText(keyValueModel.orderCount);
                }else {
                    if(!Validators.isNullOrEmpty(keyValueModel.totalPrice)){
                        viewHolder.tvValue.setText(keyValueModel.totalPrice);
                    }else {
                        viewHolder.tvValue.setText(keyValueModel.orderCount);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_report_simple) {
            return new ReportSimpleViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else {
            return new EmptyViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        }
    }


    @Override
    public int getItemCount() {
        return objects.size();
    }

    class ReportSimpleViewHolder extends RecyclerView.ViewHolder {
        private TextView tvTitle, tvValue;

        public ReportSimpleViewHolder(@NonNull View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tvTitle);
            tvValue = itemView.findViewById(R.id.tvValue);
        }
    }

    class EmptyViewHolder extends RecyclerView.ViewHolder {

        public EmptyViewHolder(@NonNull @NotNull View itemView) {
            super(itemView);
        }
    }
}
