package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.RecyclerMenuItem;

import java.util.ArrayList;

public class HomeCategoriesAdapter extends RecyclerView.Adapter<HomeCategoriesAdapter.Holder> {
    private ArrayList<RecyclerMenuItem> items;
    private RecyclerviewItemClickListener itemClickListener;

    public HomeCategoriesAdapter(ArrayList<RecyclerMenuItem> items, RecyclerviewItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
        this.items = items;
    }

    @NonNull
    @Override
    public HomeCategoriesAdapter.Holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new Holder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_home_categories, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull HomeCategoriesAdapter.Holder holder, int position) {
        try {
            RecyclerMenuItem homeItems = items.get(position);
            holder.tvCategory.setText(homeItems.title);

            if (homeItems.count == 0) {
                holder.tvCount.setVisibility(View.INVISIBLE);
            } else {
                holder.tvCount.setVisibility(View.VISIBLE);
                String type;
                if (homeItems.id.equalsIgnoreCase("6")) {
                    type = " New Order";
                } else if (homeItems.id.equalsIgnoreCase("2") && !homeItems.id.equalsIgnoreCase("3") && !homeItems.id.equalsIgnoreCase("5")) {
                    type = " Active Orders";
                } else {
                    type = " Active " + homeItems.title;
                }
                holder.tvCount.setText(homeItems.count + type);
            }

            holder.cvCategroy.setOnClickListener(v -> {
                if (itemClickListener != null) {
                    itemClickListener.onItemClick(position, homeItems);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public class Holder extends RecyclerView.ViewHolder {
        TextView tvCategory, tvCount;
        MaterialCardView cvCategroy;

        public Holder(@NonNull View itemView) {
            super(itemView);
            tvCategory = itemView.findViewById(R.id.tvItem);
            tvCount = itemView.findViewById(R.id.tvCount);
            cvCategroy = itemView.findViewById(R.id.cvCategory);
        }
    }
}
