package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

/**
 * Created by Amrish on 23-06-2021.
 */
public class LogsAdapter extends RecyclerView.Adapter<LogsAdapter.LogsViewHolder> {
    ArrayList<String> logs;
    RecyclerviewItemClickListener recyclerviewItemClickListener;

    public LogsAdapter(ArrayList<String> logs, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.logs = logs;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public LogsViewHolder onCreateViewHolder(@NonNull @NotNull ViewGroup parent, int viewType) {
        return new LogsViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_log, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull @NotNull LogsViewHolder holder, int position) {
        try {
            holder.tvLog.setText(logs.get(position));
            holder.itemView.setOnClickListener(v -> {
                if (recyclerviewItemClickListener != null) {
                    recyclerviewItemClickListener.onItemClick(position, "clear");
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return logs.size();
    }

    protected static class LogsViewHolder extends RecyclerView.ViewHolder {
        TextView tvLog;

        public LogsViewHolder(@NonNull @NotNull View itemView) {
            super(itemView);
            tvLog = itemView.findViewById(R.id.tvLog);
        }
    }
}
