package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.ExclusionModel;

import java.util.ArrayList;

public class MenuAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private ArrayList<ExclusionModel> paymentList;
    private RecyclerviewItemClickListener recyclerviewItemClickListener;
    public String checkedId;
    private boolean checkable = false;
    private boolean isOuter = false;

    public MenuAdapter(ArrayList<ExclusionModel> paymentList, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.paymentList = paymentList;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    public MenuAdapter(ArrayList<ExclusionModel> paymentList, boolean isOuter, boolean checkable, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.paymentList = paymentList;
        this.checkable = checkable;
        this.isOuter = isOuter;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_grey_list_menu) {
            return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else
            return new MainItemViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder1, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_grey_list_menu) {
                ViewHolder holder = (ViewHolder) holder1;
                ExclusionModel exclusionModel = paymentList.get(position);
                holder.tvName.setText(exclusionModel.name);
                Context context = holder.itemView.getContext();
                if (exclusionModel.id.equalsIgnoreCase(checkedId)) {
                    holder.llMainLayout.getBackground().setColorFilter(Color.parseColor("#23A299"), PorterDuff.Mode.SRC_ATOP);
                    holder.imgItem.setColorFilter(ContextCompat.getColor(context, R.color.white), PorterDuff.Mode.MULTIPLY);
                    holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                } else {
                    holder.llMainLayout.getBackground().setColorFilter(Color.parseColor("#F5F5F5"), PorterDuff.Mode.SRC_ATOP);
                    holder.imgItem.setColorFilter(ContextCompat.getColor(context, R.color.img_dark_black), PorterDuff.Mode.MULTIPLY);
                    holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.black));
                }

                holder.itemView.setOnClickListener(v -> {
                    if (checkable && exclusionModel.isCheckable) {
                        checkedId = exclusionModel.id;
                        notifyDataSetChanged();
                    }
                    if (recyclerviewItemClickListener != null) {
                        recyclerviewItemClickListener.onItemClick(position, exclusionModel);
                    }
                });

            } else {
                MainItemViewHolder holder = (MainItemViewHolder) holder1;
                ExclusionModel exclusionModel = paymentList.get(position);
                holder.tvTitle.setText(exclusionModel.name);
                Context context = holder.itemView.getContext();
                if (exclusionModel.id.equalsIgnoreCase(checkedId)) {
                    holder.cvMain.setCardBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
                    holder.tvTitle.setTextColor(ContextCompat.getColor(context, R.color.white));
                } else {
                    holder.cvMain.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                    holder.tvTitle.setTextColor(ContextCompat.getColor(context, R.color.black));
                }

                holder.cvMain.setOnClickListener(v -> {
                    if (checkable && exclusionModel.isCheckable) {
                        checkedId = exclusionModel.id;
                        notifyDataSetChanged();
                    }
                    if (recyclerviewItemClickListener != null) {
                        recyclerviewItemClickListener.onItemClick(position, exclusionModel);
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public int getItemViewType(int position) {
        if (!isOuter) {
            return R.layout.item_grey_list_menu;
        } else {
            return R.layout.item_persian_white_list_menu;
        }
    }

    @Override
    public int getItemCount() {
        return paymentList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvName;
        private ImageView imgItem;
        private LinearLayout llMainLayout;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            imgItem = itemView.findViewById(R.id.imgItem);
            tvName = itemView.findViewById(R.id.tvName);
            llMainLayout = itemView.findViewById(R.id.llMainLayout);
        }
    }

    public static class MainItemViewHolder extends RecyclerView.ViewHolder {

        private LinearLayout llMain;
        private MaterialCardView cvMain;
        private TextView tvTitle;

        public MainItemViewHolder(@NonNull View itemView) {
            super(itemView);

            llMain = itemView.findViewById(R.id.llMainLayout);
            cvMain = itemView.findViewById(R.id.cvMain);
            tvTitle = itemView.findViewById(R.id.tvName);
        }
    }
}
