package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.models.MerchantStatement;
import com.ubsidi.epos_2021.online.interfaces.RecyclerViewItemClickListener;

import java.util.ArrayList;

/**
 * Created by Amrish on 23-06-2021.
 */
public class MerchantStatementAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<Object> data;
    private RecyclerViewItemClickListener viewItemClickListener, downloadItemClickListener;

    public MerchantStatementAdapter(ArrayList<Object> data, RecyclerViewItemClickListener viewItemClickListener, RecyclerViewItemClickListener downloadItemClickListener) {
        this.data = data;
        this.viewItemClickListener = viewItemClickListener;
        this.downloadItemClickListener = downloadItemClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        return R.layout.item_merchant_statement;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false);
        return new StatementViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_merchant_statement) {
                StatementViewHolder viewHolder = (StatementViewHolder) holder;
                MerchantStatement merchantStatement = (MerchantStatement) data.get(position);

                viewHolder.tvStatementId.setText("Statement #" + merchantStatement.id);
                viewHolder.tvDate.setText(CommonFunctions.formatUnknownDateTime(merchantStatement.to_date, "yyyy-MM-dd", "dd MMM yyyy"));
                viewHolder.tvType.setText(merchantStatement.transaction_type);
                viewHolder.tvTotal.setText(MyApp.currencySymbol + MyApp.df.format(merchantStatement.net_total));

                viewHolder.tvView.setOnClickListener(v -> {
                    if (viewItemClickListener != null) {
                        viewItemClickListener.onItemClick(position, merchantStatement);
                    }
                });

                viewHolder.tvDownload.setOnClickListener(v -> {
                    if (downloadItemClickListener != null) {
                        downloadItemClickListener.onItemClick(position, merchantStatement);
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

    private static class StatementViewHolder extends RecyclerView.ViewHolder {
        private TextView tvDate, tvView, tvDownload, tvTotal, tvType, tvStatementId;

        public StatementViewHolder(@NonNull View itemView) {
            super(itemView);
            tvStatementId = itemView.findViewById(R.id.tvStatementId);
            tvTotal = itemView.findViewById(R.id.tvTotal);
            tvType = itemView.findViewById(R.id.tvType);
            tvDate = itemView.findViewById(R.id.tvDate);
            tvView = itemView.findViewById(R.id.tvView);
            tvDownload = itemView.findViewById(R.id.tvDownload);
        }
    }
}
