package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.User;

import java.util.ArrayList;

public class MiniUserAdapter extends RecyclerView.Adapter<MiniUserAdapter.ViewHolder> {
    private ArrayList<User> users;
    private RecyclerviewItemClickListener itemClickListener, switchClickListener;
    private String selectedUsername = "";
    public String syncMode ="";

    public MiniUserAdapter(Activity activity,String syncMode, ArrayList<User> users, RecyclerviewItemClickListener itemClickListener, RecyclerviewItemClickListener switchClickListener) {
        this.syncMode = syncMode;
        this.switchClickListener = switchClickListener;
        this.users = users;
        this.itemClickListener = itemClickListener;

    }

    @NonNull
    @Override
    public MiniUserAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_login_users, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull MiniUserAdapter.ViewHolder holder, int position) {
        try {
            User userModel = users.get(position);
            holder.tvUserName.setText(userModel.username);
            holder.cvUser.setOnClickListener(v -> {
                if (itemClickListener != null) {
                    selectedUsername = userModel.username;
                    itemClickListener.onItemClick(position, userModel);
                    notifyDataSetChanged();
                }

            });
            if(!Validators.isNullOrEmpty(syncMode) && syncMode.equalsIgnoreCase("auto")){
                holder.switchUser.setVisibility(View.VISIBLE);
                holder.switchUser.setChecked(userModel.is_loggin);
                holder.switchUser.setOnCheckedChangeListener((compoundButton, b) -> {
                    if (compoundButton.isPressed()) {
                        switchClickListener.onItemClick(position, userModel);
                        holder.switchUser.setChecked(!holder.switchUser.isChecked());
                    }
                });
            }else {
                holder.switchUser.setVisibility(View.GONE);
            }
            Context context = holder.itemView.getContext();
            if (selectedUsername.equalsIgnoreCase(userModel.username)) {
                holder.cvUser.setCardBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
                holder.tvUserName.setTextColor(ContextCompat.getColor(context, R.color.white));
            } else {
                holder.cvUser.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                holder.tvUserName.setTextColor(ContextCompat.getColor(context, R.color.black));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return users.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvUserName;
        private MaterialCardView cvUser;
        private SwitchCompat switchUser;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            switchUser = itemView.findViewById(R.id.switchUser);
            tvUserName = itemView.findViewById(R.id.tvUserName);
            cvUser = itemView.findViewById(R.id.cvUser);
        }
    }
}
