package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.ExclusionModel;

import java.util.ArrayList;

public class MinimumOrderAdapter extends RecyclerView.Adapter<MinimumOrderAdapter.ViewHolder> {

    private ArrayList<ExclusionModel> minimumOrderList;
    private RecyclerviewItemClickListener recyclerviewItemClickListener;
    public int lastCheckedPosition = -1;

    public MinimumOrderAdapter(ArrayList<ExclusionModel> minimumOrderList, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.minimumOrderList = minimumOrderList;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.exclusive_item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull MinimumOrderAdapter.ViewHolder holder, int position) {
        try {
            ExclusionModel exclusionModel = minimumOrderList.get(position);
            if(position==0){
                holder.itemView.getRootView().setVisibility(View.GONE);
            }else {
                holder.itemView.getRootView().setVisibility(View.VISIBLE);
            }
            if (exclusionModel.name.equalsIgnoreCase("None") || exclusionModel.name.equalsIgnoreCase("Custom")) {
                holder.chkExclusive.setText(exclusionModel.name);
            } else {
                holder.chkExclusive.setText(MyApp.currencySymbol + "" + exclusionModel.name);
            }

            holder.chkExclusive.setChecked(position == lastCheckedPosition);

            holder.chkExclusive.setOnClickListener(v -> {
                int copyOfLastCheckedPosition = lastCheckedPosition;
                lastCheckedPosition = position;
                notifyItemChanged(copyOfLastCheckedPosition);
                notifyItemChanged(lastCheckedPosition);
                if (recyclerviewItemClickListener != null) {
                    recyclerviewItemClickListener.onItemClick(position, exclusionModel);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return minimumOrderList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private CheckBox chkExclusive;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            chkExclusive = itemView.findViewById(R.id.chkExclusive);
        }
    }
}
