package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.OrderButton;

import java.util.ArrayList;

public class OrderButtonsAdapter extends RecyclerView.Adapter<OrderButtonsAdapter.ViewHolder> {
    private ArrayList<OrderButton> orderButtons;
    private RecyclerviewItemClickListener itemClickListener;
    private Activity activity;

    public OrderButtonsAdapter(Activity activity, ArrayList<OrderButton> orderButtons, RecyclerviewItemClickListener itemClickListener) {
        this.orderButtons = orderButtons;
        this.itemClickListener = itemClickListener;
        this.activity = activity;
    }

    @NonNull
    @Override
    public OrderButtonsAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_order_button, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull OrderButtonsAdapter.ViewHolder holder, int position) {
        try {
            OrderButton table = orderButtons.get(position);
            holder.btn.setText(table.title);

            if (table.key.equalsIgnoreCase("cancel_order"))
                holder.btn.setBackgroundColor(ContextCompat.getColor(activity, R.color.reject_color));

            if (table.key.equalsIgnoreCase("send_order"))
                holder.btn.setBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_indigo));

            if (table.key.equalsIgnoreCase("print_bill"))
                holder.btn.setBackgroundColor(ContextCompat.getColor(activity, R.color.persian_green));

            if (table.key.equalsIgnoreCase("pay_bill"))
                holder.btn.setBackgroundColor(ContextCompat.getColor(activity, R.color.orders_card_bg_green));


            holder.btn.setOnClickListener(v -> {
                if (itemClickListener != null) {
                    itemClickListener.onItemClick(position, table);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return orderButtons.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        MaterialButton btn;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            btn = itemView.findViewById(R.id.btn);

        }
    }
}
