package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.OrderItemIngredient;

import java.util.ArrayList;

public class OrderItemIngredientsAdapter extends RecyclerView.Adapter<OrderItemIngredientsAdapter.ViewHolder> {

    private ArrayList<OrderItemIngredient> orderItemIngredients;
    private RecyclerviewItemClickListener deleteClickListener;

    public OrderItemIngredientsAdapter(ArrayList<OrderItemIngredient> orderItemIngredients, RecyclerviewItemClickListener deleteClickListener) {
        this.orderItemIngredients = orderItemIngredients;
        this.deleteClickListener = deleteClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_selectedaddon, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull OrderItemIngredientsAdapter.ViewHolder holder, int position) {
        try {
            OrderItemIngredient orderItemIngredient = orderItemIngredients.get(position);

            holder.tvSelectedAddons.setText(orderItemIngredient.quantity + " " + orderItemIngredient.ingredient_name + " ( " + MyApp.currencySymbol + MyApp.df.format(orderItemIngredient.total) + " ) ");
            if (orderItemIngredient.with) {
                holder.tvSelectedAddons.setText("Add " + orderItemIngredient.quantity + " " + orderItemIngredient.ingredient_name + " ( " + MyApp.currencySymbol + MyApp.df.format(orderItemIngredient.total) + " ) ");
            }
            if (orderItemIngredient.without) {
                holder.tvSelectedAddons.setText("Remove " + orderItemIngredient.quantity + " " + orderItemIngredient.ingredient_name + " ( " + MyApp.currencySymbol + MyApp.df.format(orderItemIngredient.total) + " ) ");
            }

            holder.ivDelete.setOnClickListener(v -> {
                if (deleteClickListener != null) {
                    deleteClickListener.onItemClick(position, orderItemIngredient);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return orderItemIngredients.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        TextView tvSelectedAddons;
        ImageView ivDelete;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            ivDelete = itemView.findViewById(R.id.ivDelete);
            tvSelectedAddons = itemView.findViewById(R.id.tvSelectedAddons);
        }
    }
}
