package com.ubsidi.epos_2021.adapters;

import static com.ubsidi.epos_2021.utils.Constants.QUANTITY_MODIFIED_ADD;
import static com.ubsidi.epos_2021.utils.Constants.QUANTITY_MODIFIED_MINUS;

import android.app.Activity;
import android.content.Context;
import android.graphics.Paint;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.daimajia.swipe.SwipeLayout;
import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTag;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

public class OrderItemsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private OrderSplit selectedSplit;
    private Activity activity;
    private ArrayList<Object> objects;
    private ArrayList<OrderItem> products;
    private RecyclerviewItemClickListener deleteClickListener, viewMoreClickListener;
    private RecyclerviewItemClickListenerWithTag itemClickListenerWithTag;
    //  public boolean shouldEdit;

    public OrderItemsAdapter(Activity activity,ArrayList<Object> objects, RecyclerviewItemClickListenerWithTag itemClickListener, RecyclerviewItemClickListener deleteClickListener, RecyclerviewItemClickListener viewMoreClickListener) {
        this.objects = objects;
        this.activity = activity;
        this.itemClickListenerWithTag = itemClickListener;
        this.deleteClickListener = deleteClickListener;
        this.viewMoreClickListener = viewMoreClickListener;
    }

    /*public OrderItemsAdapter(Activity activity, ArrayList<OrderItem> orderItems, RecyclerviewItemClickListenerWithTag itemClickListener, RecyclerviewItemClickListener deleteClickListener, RecyclerviewItemClickListener viewMoreClickListener) {
        this.products = orderItems;
        this.activity = activity;
        this.itemClickListenerWithTag = itemClickListener;
        this.deleteClickListener = deleteClickListener;
        this.viewMoreClickListener = viewMoreClickListener;
    }*/

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_cart_product) {
            return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else if (viewType == R.layout.item_cart_split) {
            return new SplitViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else
            return new EmptyViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
    }


    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_cart_product) {
                ViewHolder holder = (ViewHolder) viewHolder;
                OrderItem orderItem = (OrderItem) objects.get(position);
                if(orderItem.is_delete){
                    holder.tvItemName.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                    holder.tvSubAddons.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                    holder.tvPrice.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                    holder.llEditQty.setVisibility(View.GONE);
                }else {
                    holder.tvItemName.setPaintFlags(0);
                    holder.tvSubAddons.setPaintFlags(0);
                    holder.tvPrice.setPaintFlags(0);
                    holder.llEditQty.setVisibility(View.VISIBLE);
                }
                holder.tvItemName.setText(orderItem.product_name);

                holder.tvPrice.setText(MyApp.currencySymbol + MyApp.df.format(orderItem.price));

                StringBuilder selectedProductAddons = new StringBuilder();
                int lines = 0;
                if (orderItem.order_item_addons != null && orderItem.order_item_addons.size() > 0) {
                    for (OrderItemAddon orderItemAddon : orderItem.order_item_addons) {
                        if (selectedProductAddons.length() > 0) {
                            selectedProductAddons.append("\n");
                        }
                        selectedProductAddons.append(orderItemAddon.addon_name).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItemAddon.price));
                        lines++;

                    }
                }
                if (orderItem.order_item_ingredients != null && orderItem.order_item_ingredients.size() > 0) {
                    for (OrderItemIngredient orderItemIngredient : orderItem.order_item_ingredients) {
                        if (selectedProductAddons.length() > 0) {
                            selectedProductAddons.append("\n");
                        }
                        if (orderItemIngredient.with) {
                            selectedProductAddons.append("Extra ");
                            selectedProductAddons.append(orderItemIngredient.quantity).append(" ");
                        }
                        if (orderItemIngredient.without) {
                            selectedProductAddons.append("No ");
                        }
                        selectedProductAddons.append(orderItemIngredient.ingredient_name).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItemIngredient.total));
                        lines++;
                    }
                }
                if (!Validators.isNullOrEmpty(orderItem.special_instruction)) {
                    if (selectedProductAddons.length() > 0) {
                        selectedProductAddons.append("\n");
                    }
                    if (orderItem.instruction_price > 0)
                        selectedProductAddons.append(orderItem.special_instruction).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItem.instruction_price));
                    else selectedProductAddons.append(orderItem.special_instruction);
                    lines++;
                }

                holder.tvSubAddons.setText(selectedProductAddons.toString());
                if (selectedProductAddons.length() > 0) {
                    holder.tvSubAddons.setVisibility(View.VISIBLE);
                } else {
                    holder.tvSubAddons.setVisibility(View.GONE);
                }

                holder.swipeRevealLayout.setSwipeEnabled(orderItem.shouldEdit);
                holder.swipeRevealLayout.addDrag(SwipeLayout.DragEdge.Right, holder.llDelete);

                holder.tvModifyQty.setText(orderItem.quantity + "");
                if (lines > 3) {
                    holder.tvViewMore.setVisibility(View.VISIBLE);
                } else {
                    holder.tvViewMore.setVisibility(View.GONE);
                }

                holder.tvModifyQty.addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {
                        if (!Validators.isNullOrEmpty(holder.tvModifyQty.getText().toString())) {
                            if (orderItem.quantity > 1) {
                                holder.ivMinus.setImageResource(R.drawable.ic_baseline_remove);
                            } else {
                                holder.ivMinus.setImageResource(R.drawable.ic_delete_black_24dp);
                            }
                        }
                    }
                });
                holder.tvModifyQty.setOnEditorActionListener((v, actionId, event) -> {
                    if (actionId == EditorInfo.IME_ACTION_DONE) {
                        try {
                            if (orderItem.shouldEdit) {
                                if (!Validators.isNullOrEmpty(holder.tvModifyQty.getText().toString())) {
                                    orderItem.quantity = Integer.parseInt(holder.tvModifyQty.getText().toString());
                                    if (orderItem.quantity > 1) {
                                        holder.ivMinus.setImageResource(R.drawable.ic_baseline_remove);
                                    } else {
                                        holder.ivMinus.setImageResource(R.drawable.ic_delete_black_24dp);
                                    }
                                    if (itemClickListenerWithTag != null)
                                        itemClickListenerWithTag.onItemClick(position, "quantity_modified", orderItem);

                                    //activity.onBackPressed();
                                    holder.tvPrice.clearFocus();
                                    if (itemClickListenerWithTag != null)
                                        itemClickListenerWithTag.onItemClick(position, Constants.QUANTITY_MODIFIED_CHANGE, orderItem);
                                } else {
                                    ToastUtils.makeToast(v.getContext(), "Please enter quantity");
                                }
                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        //   CommonFunctions.hideKeyboard(activity, holder.tvModifyQty);
                        try {
                            if (holder.itemView.getContext() != null) {
                                InputMethodManager imm = (InputMethodManager) holder.itemView.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
                                imm.hideSoftInputFromWindow(holder.tvModifyQty.getWindowToken(), 0);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        return true;
                    }

                    return false;
                });

                holder.rlPlusModify.setOnClickListener(v -> {
                    if (selectedSplit != null && selectedSplit.paid_amount > 0) {
                        ToastUtils.showSnackBar(activity, holder.itemView.getRootView(),"Cannot change in paid split group","failed");
                    }else {
                        if (orderItem.shouldEdit) {
                            orderItem.quantity++;
                            holder.tvModifyQty.setText(orderItem.quantity + "");
                            holder.ivMinus.setImageResource(R.drawable.ic_baseline_remove);
                            if (itemClickListenerWithTag != null)
                                itemClickListenerWithTag.onItemClick(position, QUANTITY_MODIFIED_ADD, orderItem);
                        }

                    }
                });
                holder.rlMinusModify.setOnClickListener(v -> {
                    try {
                        if (selectedSplit != null && selectedSplit.paid_amount > 0) {
                            ToastUtils.showSnackBar(activity, holder.itemView.getRootView(),"Cannot change in paid split group","failed");
                        } else {
                            if (orderItem.shouldEdit) {
                                if (orderItem.quantity > 1) {
                                    orderItem.quantity--;
                                    holder.tvModifyQty.setText(orderItem.quantity + "");
                                    if (itemClickListenerWithTag != null)
                                        itemClickListenerWithTag.onItemClick(position, QUANTITY_MODIFIED_MINUS, orderItem);

                                } else {
                                    holder.ivMinus.setImageResource(R.drawable.ic_delete_black_24dp);
                                    if (!objects.isEmpty()) {
                                        objects.remove(position);
                                        //notifyItemRemoved(position); - For Testing
                                    }
                                    // notifyItemRemoved(position);
                                    if (deleteClickListener != null) {
                                        deleteClickListener.onItemClick(position, orderItem);
                                    }
                                }
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                holder.tvViewMore.setOnClickListener(v -> {
                    if (viewMoreClickListener != null)
                        viewMoreClickListener.onItemClick(position, orderItem);
                });

                if (orderItem.quantity == 1) {
                    holder.ivMinus.setImageResource(R.drawable.ic_delete_black_24dp);
                } else {
                    holder.ivMinus.setImageResource(R.drawable.ic_baseline_remove);
                }

                holder.llDelete.setOnClickListener(view -> {
                    try {
                        if (selectedSplit != null && selectedSplit.paid_amount > 0) {
                            ToastUtils.showSnackBar(activity, holder.itemView.getRootView(),"Cannot change in paid split group","failed");
                        }else {
                            if (orderItem.shouldEdit && !orderItem.is_delete) {
                                holder.swipeRevealLayout.close(true);
                                if (deleteClickListener != null) {
                                    deleteClickListener.onItemClick(position, orderItem);
                                }
                                objects.remove(position);
                                // notifyItemRemoved(position);
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });

                holder.llProduct.setOnClickListener(view -> {
                    try {
                        if (orderItem.shouldEdit && !orderItem.is_delete) {
                            if (itemClickListenerWithTag != null)
                                itemClickListenerWithTag.onItemClick(position, "view", orderItem);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                //            viewBinderHelper.setOpenOnlyOne(true);
                //            viewBinderHelper.bind(holder.swipeRevealLayout, orderItem._id+"");
                //            viewBinderHelper.closeLayout(orderItem._id+"");
            } else if (getItemViewType(position) == R.layout.item_cart_split) {
                SplitViewHolder splitViewHolder = (SplitViewHolder) viewHolder;
                OrderSplit orderSplit = (OrderSplit) objects.get(position);
                splitViewHolder.tvName.setText(orderSplit.group_name + " (" + MyApp.currencySymbol + MyApp.df.format(orderSplit.paid_amount) + "/" + MyApp.currencySymbol + MyApp.df.format(orderSplit.total) + ")");

                splitViewHolder.cvSplit.setEnabled(true);
                Context context = splitViewHolder.itemView.getContext();
                if (orderSplit.selected) {
                    splitViewHolder.cvSplit.setCardBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
                    splitViewHolder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                } else {
                    splitViewHolder.cvSplit.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                    splitViewHolder.tvName.setTextColor(ContextCompat.getColor(context, R.color.persian_green));
                }
                splitViewHolder.cvSplit.setOnClickListener(v -> {
                    orderSplit.selected = !orderSplit.selected;
                    selectedSplit = orderSplit.selected ? orderSplit : null;
                    if (itemClickListenerWithTag != null)
                        itemClickListenerWithTag.onItemClick(position, "split_click", orderSplit);
                });
            } else {
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemViewType(int position) {
        Object object = objects.get(position);
        if (object instanceof OrderItem) {
            return R.layout.item_cart_product;
        } else if (object instanceof OrderSplit) {
            return R.layout.item_cart_split;
        } else {
            return R.layout.item_cart_product_empty;
        }
    }


    @Override
    public int getItemCount() {
        return objects.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvItemName, tvPrice, tvSubAddons, tvModifyQty, tvViewMore;
        ImageView ivPlus, ivMinus;
        LinearLayout llMain;
        SwipeLayout swipeRevealLayout;
        LinearLayout llEditQty, llProduct;
        LinearLayout llDelete;
        RelativeLayout rlPlusModify, rlMinusModify;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvViewMore = itemView.findViewById(R.id.tvViewMore);
            tvItemName = itemView.findViewById(R.id.tvItemName);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            llMain = itemView.findViewById(R.id.llMain);
            tvSubAddons = itemView.findViewById(R.id.tvSubAddons);
            swipeRevealLayout = itemView.findViewById(R.id.swipeRevealLayout);
            llEditQty = itemView.findViewById(R.id.llEditQty);
            tvModifyQty = itemView.findViewById(R.id.tvModifiedQuantity);
            rlPlusModify = itemView.findViewById(R.id.rlPlusModified);
            rlMinusModify = itemView.findViewById(R.id.rlMinusModified);
            ivPlus = itemView.findViewById(R.id.ivPlusModified);
            ivMinus = itemView.findViewById(R.id.ivMinusModified);
            llDelete = itemView.findViewById(R.id.llDelete);
            llProduct = itemView.findViewById(R.id.llProduct);
        }
    }

    private static class SplitViewHolder extends RecyclerView.ViewHolder {
        private TextView tvName;
        private MaterialCardView cvSplit;

        public SplitViewHolder(@NonNull @NotNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
            cvSplit = itemView.findViewById(R.id.cvSplit);
        }
    }

    public static class EmptyViewHolder extends RecyclerView.ViewHolder {

        public EmptyViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }
}
