package com.ubsidi.epos_2021.adapters;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.CustomMenuItem;

import java.util.ArrayList;

public class OrderOptionMenuAdapter extends RecyclerView.Adapter<OrderOptionMenuAdapter.ViewHolder> {
    private ArrayList<CustomMenuItem> customMenuItems;
    private RecyclerviewItemClickListener itemClickListener;

    public OrderOptionMenuAdapter(ArrayList<CustomMenuItem> customMenuItems, RecyclerviewItemClickListener itemClickListener) {
        this.customMenuItems = customMenuItems;
        this.itemClickListener = itemClickListener;
    }

    @NonNull
    @Override
    public OrderOptionMenuAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_order_menu, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull OrderOptionMenuAdapter.ViewHolder holder, int position) {
        try {
            CustomMenuItem table = customMenuItems.get(position);
            holder.tvMenu.setText(table.title);
            LinearLayout.LayoutParams param = null;
            if (table.icon != 0) {
                holder.ivMenu.setVisibility(View.VISIBLE);
                holder.ivMenu.setImageResource(table.icon);
                holder.llItem.setOrientation(LinearLayout.VERTICAL);
                param = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            }
            else {
                param = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                holder.ivMenu.setVisibility(View.GONE);
                holder.llItem.setOrientation(LinearLayout.HORIZONTAL);
            }
            holder.cvMenu.setOnClickListener(v -> {
                if (itemClickListener != null) {
                    itemClickListener.onItemClick(position, table);
                }
            });
            holder.llMain.setLayoutParams(param);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        Log.e("Type_option",""+customMenuItems.size());
        return customMenuItems.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        private LinearLayout llMain, llItem;
        private MaterialCardView cvMenu;
        private TextView tvMenu;
        private ImageView ivMenu;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            llMain = itemView.findViewById(R.id.llMain);
            llItem = itemView.findViewById(R.id.llItem);
            cvMenu = itemView.findViewById(R.id.cvMain);
            tvMenu = itemView.findViewById(R.id.tvMenu);
            ivMenu = itemView.findViewById(R.id.ivMenu);
        }
    }
}
