package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.OrderPayment;

import java.util.ArrayList;

public class OrderPaymentsAdapter extends RecyclerView.Adapter<OrderPaymentsAdapter.ViewHolder> {

    private ArrayList<OrderPayment> orderPayments;
    private boolean fromEposOrder;

    public OrderPaymentsAdapter(ArrayList<OrderPayment> orderPayments, boolean fromEposOrder) {
        this.orderPayments = orderPayments;
        this.fromEposOrder = fromEposOrder;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_order_payment, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull OrderPaymentsAdapter.ViewHolder holder, int position) {
        try {
            Context context = holder.itemView.getContext();
            OrderPayment orderPayment = orderPayments.get(position);
            if (fromEposOrder) {
                holder.tvName.setText("Paid via " + orderPayment.payment_method_name);
            } else {
                holder.tvName.setText(orderPayment.payment_method_name);
            }

            if (!Validators.isNullOrEmpty(orderPayment.cheque_number)) {
                holder.tvInfo.setText(orderPayment.cheque_number);
                holder.tvInfo.setVisibility(View.VISIBLE);
            } else if (!Validators.isNullOrEmpty(orderPayment.cc_number)) {
                holder.tvInfo.setText(orderPayment.cc_number);
                holder.tvInfo.setVisibility(View.VISIBLE);
            } else {
                holder.tvInfo.setVisibility(View.GONE);
            }

            if (orderPayment.payment_method_name.toLowerCase().contains("discount") || orderPayment.payment_method_name.toLowerCase().contains("voucher")) {
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.dialog_title_reject));
                holder.tvAmount.setTextColor(ContextCompat.getColor(context, R.color.dialog_title_reject));
            } else {
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
                holder.tvAmount.setTextColor(ContextCompat.getColor(context, R.color.chip_green_color));
            }

            holder.tvAmount.setText(MyApp.currencySymbol + MyApp.df.format(orderPayment.amount));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return orderPayments.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvName, tvAmount, tvInfo;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
            tvAmount = itemView.findViewById(R.id.tvAmount);
            tvInfo = itemView.findViewById(R.id.tvInfo);
        }
    }
}
