package com.ubsidi.epos_2021.adapters;

import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;

import java.util.ArrayList;

public class OrderReviewItemsAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<OrderItem> products;
    private RecyclerviewItemClickListener itemClickListener, deleteClickListener, viewMoreClickListener;
   // public boolean shouldEdit, shouldClick = false;

    public OrderReviewItemsAdapter(ArrayList<OrderItem> orderItems, RecyclerviewItemClickListener itemClickListener, RecyclerviewItemClickListener deleteClickListener) {
        this.products = orderItems;
        this.itemClickListener = itemClickListener;
        this.deleteClickListener = deleteClickListener;
    }

    public OrderReviewItemsAdapter(ArrayList<OrderItem> orderItems, RecyclerviewItemClickListener itemClickListener, RecyclerviewItemClickListener deleteClickListener, RecyclerviewItemClickListener viewMoreClickListener) {
        this.products = orderItems;
        this.itemClickListener = itemClickListener;
        this.deleteClickListener = deleteClickListener;
        this.viewMoreClickListener = viewMoreClickListener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_cart_review_product) {
            return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        } else
            return new EmptyViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));

    }


    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_cart_review_product) {
                ViewHolder holder = (ViewHolder) viewHolder;
                OrderItem orderItem = products.get(position);
                if(orderItem.is_delete){
                    holder.tvItemName.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                    holder.tvSubAddons.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                    holder.tvPrice.setPaintFlags(holder.tvItemName.getPaintFlags() | Paint.STRIKE_THRU_TEXT_FLAG);
                    holder.llEditQty.setVisibility(View.GONE);
                }else {
                    holder.tvItemName.setPaintFlags(0);
                    holder.tvSubAddons.setPaintFlags(0);
                    holder.tvPrice.setPaintFlags(0);
                    if(orderItem.shouldEdit){
                        holder.llEditQty.setVisibility(View.VISIBLE);
                    }
                }
                holder.tvItemName.setText(orderItem.product_name);


                holder.tvQty.setText(orderItem.quantity + "x");
                holder.tvPrice.setText(MyApp.currencySymbol + MyApp.df.format(orderItem.price));

                StringBuilder selectedProductAddons = new StringBuilder();
                int lines = 0;
                if (orderItem.order_item_addons != null && orderItem.order_item_addons.size() > 0) {
                    for (OrderItemAddon orderItemAddon : orderItem.order_item_addons) {
                        if (selectedProductAddons.length() > 0) {
                            selectedProductAddons.append("\n");
                        }
                        selectedProductAddons.append(orderItemAddon.addon_name).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItemAddon.price));
                        lines++;
                    }
                }
                if (orderItem.order_item_ingredients != null && orderItem.order_item_ingredients.size() > 0) {
                    for (OrderItemIngredient orderItemIngredient : orderItem.order_item_ingredients) {
                        if (selectedProductAddons.length() > 0) {
                            selectedProductAddons.append("\n");
                        }
                        if (orderItemIngredient.with) {
                            selectedProductAddons.append("Extra ");
                            selectedProductAddons.append(orderItemIngredient.quantity).append(" ");
                        }
                        if (orderItemIngredient.without) {
                            selectedProductAddons.append("No ");
                        }
                        selectedProductAddons.append(orderItemIngredient.ingredient_name).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItemIngredient.total));
                        lines++;
                    }
                }
                if (!Validators.isNullOrEmpty(orderItem.special_instruction)) {
                    if (selectedProductAddons.length() > 0) {
                        selectedProductAddons.append("\n");
                    }
                    selectedProductAddons.append(orderItem.special_instruction).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItem.instruction_price));
                    lines++;
                }
                if (lines > 3) {
                    holder.tvViewMore.setVisibility(View.VISIBLE);
                } else {
                    holder.tvViewMore.setVisibility(View.GONE);
                }
                holder.tvSubAddons.setText(selectedProductAddons.toString());
                if (selectedProductAddons.length() > 0) {
                    holder.tvSubAddons.setVisibility(View.VISIBLE);
                } else {
                    holder.tvSubAddons.setVisibility(View.GONE);
                }

                if (orderItem.shouldEdit && !orderItem.is_delete) {
                    holder.llEditQty.setVisibility(View.VISIBLE);
                    holder.tvModifyQty.setVisibility(View.VISIBLE);
                    holder.tvQty.setVisibility(View.GONE);
                } else {
                    holder.llEditQty.setVisibility(View.GONE);
                    holder.tvQty.setVisibility(View.VISIBLE);
                }
                holder.tvModifyQty.setText(orderItem.quantity + "");
                holder.rlPlusModify.setOnClickListener(v -> {
                    if (orderItem.shouldEdit) {
                        orderItem.quantity++;
                        holder.tvModifyQty.setText(orderItem.quantity + "");
                        holder.ivMinus.setImageResource(R.drawable.ic_baseline_remove);
                      //  holder.itemView.performClick();
                        if (itemClickListener != null)
                            itemClickListener.onItemClick(position, orderItem);
                    }
                });
                holder.rlMinusModify.setOnClickListener(v -> {
                    if (orderItem.shouldEdit) {
                        if (orderItem.quantity > 1) {
                            orderItem.quantity--;
                            holder.tvModifyQty.setText(orderItem.quantity + "");
                        //    holder.itemView.performClick();
                            if (itemClickListener != null)
                                itemClickListener.onItemClick(-100, orderItem);
                        } else {
                            holder.ivMinus.setImageResource(R.drawable.ic_delete_black_24dp);
                            products.remove(position);
                            notifyDataSetChanged();
                            if (deleteClickListener != null) {
                                deleteClickListener.onItemClick(position, orderItem);
                            }
                        }

                    }
                });

                if (orderItem.quantity == 1) {
                    holder.ivMinus.setImageResource(R.drawable.ic_delete_black_24dp);
                } else {
                    holder.ivMinus.setImageResource(R.drawable.ic_baseline_remove);
                }

                holder.itemView.setOnClickListener(view -> {
                    if (orderItem.shouldClick) {
                        if (itemClickListener != null)
                            itemClickListener.onItemClick(position, orderItem);
                    }
                });
                holder.tvViewMore.setOnClickListener(v -> {
                    if (viewMoreClickListener != null)
                        viewMoreClickListener.onItemClick(position, orderItem);
                });
            } else {

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemViewType(int position) {
//        if (products.get(position)._order_split_id != 0) {
//            return R.layout.item_cart_product_empty;
//        } else {
//        }
        return R.layout.item_cart_review_product;
    }


    @Override
    public int getItemCount() {
        return products.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvQty, tvItemName, tvPrice, tvSubAddons, tvModifyQty, tvViewMore;
        ImageView ivPlus, ivMinus;
        LinearLayout llMain;
        LinearLayout llEditQty;
        RelativeLayout rlPlusModify, rlMinusModify;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvQty = itemView.findViewById(R.id.tvQty);
            tvItemName = itemView.findViewById(R.id.tvItemName);
            tvPrice = itemView.findViewById(R.id.tvPrice);
            llMain = itemView.findViewById(R.id.llMain);
            tvSubAddons = itemView.findViewById(R.id.tvSubAddons);
            llEditQty = itemView.findViewById(R.id.llEditQty);
            tvModifyQty = itemView.findViewById(R.id.tvModiefiedQuantity);
            rlPlusModify = itemView.findViewById(R.id.rlPlusModified);
            rlMinusModify = itemView.findViewById(R.id.rlMinusModified);
            ivPlus = itemView.findViewById(R.id.ivPlusModified);
            ivMinus = itemView.findViewById(R.id.ivMinusModified);
            tvViewMore = itemView.findViewById(R.id.tvViewMore);
        }
    }

    public static class EmptyViewHolder extends RecyclerView.ViewHolder {

        public EmptyViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }
}
