package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.OrderType;

import java.util.ArrayList;

/**
 * Created by Amrish on 23-04-2021.
 */
public class OrderTypesAdapter extends RecyclerView.Adapter<OrderTypesAdapter.BusinessViewHolder> {
    public ArrayList<OrderType> orderTypes;
    private final RecyclerviewItemClickListener recyclerviewItemClickListener;
    private final RecyclerviewItemClickListener recyclerviewItemPaidUnPaidClickListener;
    public String selectedOrderTypeId = "";
    public RadioButton checkedRadioButton;

    public OrderTypesAdapter(ArrayList<OrderType> orderTypes, RecyclerviewItemClickListener recyclerviewItemClickListener, RecyclerviewItemClickListener recyclerviewItemPaidUnPaidClickListener) {
        this.orderTypes = orderTypes;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
        this.recyclerviewItemPaidUnPaidClickListener = recyclerviewItemPaidUnPaidClickListener;
    }

    @NonNull
    @Override
    public BusinessViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new BusinessViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_order_type, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull BusinessViewHolder holder, int position) {
        try {
            holder.tvOrderType.setText(orderTypes.get(position).type);
            if (orderTypes.get(position).count > 0)
                holder.tvCount.setText(orderTypes.get(position).count + " Active orders");
            else holder.tvCount.setText("No Active orders");
            holder.itemView.setOnClickListener(view -> {
                selectedOrderTypeId = orderTypes.get(position).id;
                notifyDataSetChanged();
                notifyItemChanged(position);
                if (recyclerviewItemClickListener != null) {
                    recyclerviewItemClickListener.onItemClick(position, orderTypes.get(position));
                }
            });
            holder.vSelector.setOnClickListener(view -> {
                if (recyclerviewItemPaidUnPaidClickListener != null) {
                    if(!orderTypes.get(position).isSelected){
                        holder.vSelector.setBackgroundResource(R.color.dialog_title_accept);
                    }else {
                        holder.vSelector.setBackgroundResource(R.color.persian_green);
                    }
                    holder.tvOrderType.setAlpha(1f);
                    holder.tvCount.setAlpha(1f);
                    recyclerviewItemPaidUnPaidClickListener.onItemClick(position, orderTypes.get(position));
                }
            });
            Context context = holder.itemView.getContext();
            if (orderTypes.get(position).isSelected) {
                holder.vSelector.setBackgroundResource(R.color.dialog_title_accept);
                holder.tvOrderType.setAlpha(1f);
                holder.tvCount.setAlpha(1f);
            } else if (selectedOrderTypeId.equalsIgnoreCase(orderTypes.get(position).id)) {
                holder.vSelector.setBackgroundResource(R.color.persian_green);
                holder.tvOrderType.setAlpha(1f);
                holder.tvCount.setAlpha(1f);
            } else {
                holder.vSelector.setBackgroundResource(R.color.light_gray);
                holder.tvOrderType.setAlpha(0.5f);
                holder.tvCount.setAlpha(0.5f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return orderTypes.size();
    }

    protected static class BusinessViewHolder extends RecyclerView.ViewHolder {
        private TextView tvCount, tvOrderType;
        private View vSelector;

        public BusinessViewHolder(@NonNull View itemView) {
            super(itemView);
            tvOrderType = itemView.findViewById(R.id.tvOrderType);
            tvCount = itemView.findViewById(R.id.tvCountOType);
            vSelector = itemView.findViewById(R.id.vSelectorOType);
        }
    }
}
