package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.CallLogs;

import java.util.ArrayList;

public class ParkCallAdapter extends RecyclerView.Adapter<ParkCallAdapter.ViewHolder> {

    public ArrayList<CallLogs> callLogs;
    private final RecyclerviewItemClickListener recyclerviewItemClickListener;

    public ParkCallAdapter(ArrayList<CallLogs> callLogs, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.callLogs = callLogs;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_park_call, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ParkCallAdapter.ViewHolder holder, int position) {
        try {
            CallLogs callLog = callLogs.get(position);
            holder.tvNumber.setText(callLog.number);
            holder.tvid.setText(String.valueOf(position + 1));
            holder.tvAccept.setOnClickListener(v -> {
                callLog.status = "accepted";
                if (recyclerviewItemClickListener != null)
                    recyclerviewItemClickListener.onItemClick(position, callLog);
            });
            holder.tvCancel.setOnClickListener(v -> {
                callLog.status = "rejected";
                if (recyclerviewItemClickListener != null)
                    recyclerviewItemClickListener.onItemClick(position, callLog);
            });
            if (callLog.customer != null) {
                holder.tvAddress.setText(callLog.customer.street);
                holder.tvDistance.setText(callLog.customer.distance + " miles");
                holder.tvName.setText(callLog.customer.name);
            } else {
                holder.tvDistance.setText("-");
                holder.tvName.setText("-");
                holder.tvAddress.setText("-");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return callLogs.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvAccept, tvCancel, tvNumber, tvid, tvAddress, tvDistance, tvName;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvid = itemView.findViewById(R.id.tvid);
            tvNumber = itemView.findViewById(R.id.tvNumber);
            tvCancel = itemView.findViewById(R.id.tvCancel);
            tvAccept = itemView.findViewById(R.id.tvAccept);
            tvName = itemView.findViewById(R.id.tvName);
            tvDistance = itemView.findViewById(R.id.tvDistance);
            tvAddress = itemView.findViewById(R.id.tvAddress);
        }
    }
}
