package com.ubsidi.epos_2021.adapters;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.PaymentMethod;

import java.util.ArrayList;

public class PaymentMethodAdapter extends RecyclerView.Adapter<PaymentMethodAdapter.ViewHolder> {
    private Activity activity;
    private ArrayList<PaymentMethod> users;
    private RecyclerviewItemClickListener recyclerviewItemClickListener;
    private RadioButton checkedRadio;
    public String selectedMethod;

    public PaymentMethodAdapter(ArrayList<PaymentMethod> users, RecyclerviewItemClickListener itemClickListener) {
        this.users = users;
        this.recyclerviewItemClickListener = itemClickListener;
    }

    @NonNull
    @Override
    public PaymentMethodAdapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_payment_option, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull PaymentMethodAdapter.ViewHolder holder, int position) {
        try {
            PaymentMethod paymentMethod = users.get(position);
            if (selectedMethod != null)
                holder.rbOption.setChecked(selectedMethod.equalsIgnoreCase(paymentMethod.id));
            else holder.rbOption.setChecked(false);

            holder.rbOption.setText(paymentMethod.name);
            holder.rbOption.setOnClickListener((view) -> {
                selectedMethod = paymentMethod.id;
                notifyDataSetChanged();
                if (checkedRadio != null) checkedRadio.setChecked(false);
                checkedRadio = holder.rbOption;
                holder.rbOption.setChecked(true);
                if (recyclerviewItemClickListener != null)
                    recyclerviewItemClickListener.onItemClick(position, paymentMethod);

            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return users.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {

        RadioButton rbOption;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            rbOption = itemView.findViewById(R.id.rbOption);

        }
    }
}
