package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.PaymentMethod;

import java.util.ArrayList;

public class PaymentMethodSelectionAdapter extends RecyclerView.Adapter<PaymentMethodSelectionAdapter.ViewHolder> {
    private ArrayList<Object> customMenuItems;
    private RecyclerviewItemClickListener itemClickListener;
    public String selectedMethod;

    public PaymentMethodSelectionAdapter(ArrayList<Object> customMenuItems, RecyclerviewItemClickListener itemClickListener) {
        this.customMenuItems = customMenuItems;
        this.itemClickListener = itemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_order_payment_method_selection, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        try {
            if (customMenuItems.get(position) instanceof PaymentMethod) {
                PaymentMethod paymentMethod = (PaymentMethod) customMenuItems.get(position);
                Context context = holder.itemView.getContext();
                if (selectedMethod != null) {
                    if (selectedMethod.equalsIgnoreCase(paymentMethod.id)) {
                        holder.cvMain.setCardBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
                        holder.ivMenu.setColorFilter(ContextCompat.getColor(context, R.color.white));
                        holder.tvMenu.setTextColor(ContextCompat.getColor(context, R.color.white));
                    } else {
                        holder.cvMain.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                        holder.ivMenu.setColorFilter(ContextCompat.getColor(context, R.color.black));
                        holder.tvMenu.setTextColor(ContextCompat.getColor(context, R.color.black));
                    }
                } else {
                    holder.cvMain.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                    holder.ivMenu.setColorFilter(ContextCompat.getColor(context, R.color.black));
                    holder.tvMenu.setTextColor(ContextCompat.getColor(context, R.color.black));
                }

                holder.tvMenu.setText(paymentMethod.name);
                if (paymentMethod.id.equalsIgnoreCase("1")) {
                    holder.ivMenu.setImageResource(R.drawable.icon_pound_sign);
                } else if (paymentMethod.id.equalsIgnoreCase("cc")) {
                    holder.ivMenu.setImageResource(R.drawable.ic_baseline_payment_24);
                } else if (paymentMethod.id.equalsIgnoreCase("3")) {
                    holder.ivMenu.setImageResource(R.drawable.ic_outline_note_24);
                }else if (paymentMethod.id.equalsIgnoreCase("4")) {
                    holder.ivMenu.setImageResource(R.drawable.ic_baseline_payment_24);
                }

                holder.cvMain.setOnClickListener(v -> {
                    selectedMethod = paymentMethod.id;
                    notifyDataSetChanged();
                    if (itemClickListener != null)
                        itemClickListener.onItemClick(position, paymentMethod);
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return customMenuItems.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        MaterialCardView cvMain;
        ImageView ivMenu;
        TextView tvMenu;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            cvMain = itemView.findViewById(R.id.cvMain);
            ivMenu = itemView.findViewById(R.id.ivMenu);
            tvMenu = itemView.findViewById(R.id.tvMenu);
        }
    }
}
