package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ubsidi.R;
import com.ubsidi.epos_2021.models.PrepLocation;

import java.util.ArrayList;

public class PrepLocationAdapter extends ArrayAdapter<PrepLocation> {

    private Context context;
    private ArrayList<PrepLocation> prepLocation;

    public PrepLocationAdapter(@NonNull Context context, int resource, @NonNull ArrayList<PrepLocation> objects) {
        super(context, resource, objects);
        this.context = context;
        this.prepLocation = objects;
    }

    @Override
    public int getCount() {
        return prepLocation.size();
    }

    @Nullable
    @Override
    public PrepLocation getItem(int position) {
        return prepLocation.get(position);
    }

    @Override
    public long getItemId(int position){
        return position;
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());

        View view;
        if (convertView == null) {
            view = layoutInflater.inflate(R.layout.custom_spinner_item, parent, false);
        } else {
            view = convertView;
        }
        TextView label = (TextView) view.findViewById(R.id.tvDeposit);
        ImageView icon = (ImageView) view.findViewById(R.id.ivDeposit);
        icon.setVisibility(View.INVISIBLE);
        label.setText(prepLocation.get(position).name);

        return view;
    }

    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from(parent.getContext());
        View view;
        if (convertView == null) {
            view = layoutInflater.inflate(R.layout.custom_spinner_item, parent, false);
        } else {
            view = convertView;
        }
        TextView label = (TextView) view.findViewById(R.id.tvDeposit);
        ImageView icon = (ImageView) view.findViewById(R.id.ivDeposit);
        icon.setVisibility(View.INVISIBLE);
        label.setText(prepLocation.get(position).name);
        return view;
    }
}
