package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.RecyclerviewAddonItemClickListener;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.ProductAddon;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Created by Amrish on 29-05-2021.
 */
public class ProductAddonAdapterOldDesign extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<ProductAddon> productAddons;
    private RecyclerviewItemClickListener recyclerviewItemClickListener, subAddonClickListener;
    private RecyclerView.RecycledViewPool viewPool;
    public int expandedPosition = -1;
    private String orderTypeId;
    private Context mContext;

    public ProductAddonAdapterOldDesign(@NonNull Context context, ArrayList<ProductAddon> productAddons, String orderTypeId, RecyclerviewItemClickListener recyclerviewItemClickListener, RecyclerviewItemClickListener subAddonClickListener) {
        this.expandedPosition = 0;
        this.productAddons = productAddons;
        this.orderTypeId = orderTypeId;
        this.mContext = context;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
        this.subAddonClickListener = subAddonClickListener;
        viewPool = new RecyclerView.RecycledViewPool();
    }

    @Override
    public int getItemViewType(int position) {
        return R.layout.item_product_addon_old_designb;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == R.layout.item_product_addon_old_designb) {
            return new ProductAddonViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
        }
        return new EmptyViewHolder(LayoutInflater.from(parent.getContext()).inflate(viewType, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        try {
            if (getItemViewType(position) == R.layout.item_product_addon_old_designb) {
                ProductAddonViewHolder addonViewHolder = (ProductAddonViewHolder) holder;
                ProductAddon productAddon = productAddons.get(position);
                Addon addon = productAddon.addon;
                Context context = holder.itemView.getContext();
                if (expandedPosition == position || productAddon.isExpended) {
                    addonViewHolder.rvSubAddons.setVisibility(View.VISIBLE);
                    addonViewHolder.ivCollapseImage.setRotation(270);
                    addonViewHolder.tvAddonName.setTextColor(ContextCompat.getColor(context, R.color.persian_green));
                    addonViewHolder.ivCollapseImage.setColorFilter(ContextCompat.getColor(context, R.color.persian_green), PorterDuff.Mode.SRC_IN);
                    addonViewHolder.tvMaxQty.setTextColor(ContextCompat.getColor(context, R.color.persian_green));
                } else {
                    addonViewHolder.rvSubAddons.setVisibility(View.GONE);
                    addonViewHolder.ivCollapseImage.setRotation(90);
                    addonViewHolder.tvAddonName.setTextColor(ContextCompat.getColor(context, R.color.black));
                    addonViewHolder.ivCollapseImage.setColorFilter(ContextCompat.getColor(context, R.color.black), PorterDuff.Mode.SRC_IN);
                    addonViewHolder.tvMaxQty.setTextColor(ContextCompat.getColor(context, R.color.black));
                }
                if (addon != null) {
                    if (productAddon.min_quantity > 0) {
                        addonViewHolder.tvAddonName.setText(addon.name + " (Required)");
                        addonViewHolder.tvMaxQty.setText("Max. " + productAddon.max_quantity);
                        addonViewHolder.tvMaxQty.setVisibility(View.VISIBLE);
                    } else {
                        addonViewHolder.tvAddonName.setText(addon.name + " (Optional)");
                        addonViewHolder.tvMaxQty.setVisibility(View.INVISIBLE);
                    }
                    addonViewHolder.subAddons.clear();
                    if (addon.children != null && addon.children.size() > 0) {
                        addonViewHolder.subAddons.addAll(addon.children);
                    }
                    addonViewHolder.subAddonAdapter.notifyDataSetChanged();
                    addonViewHolder.rvSubAddons.setRecycledViewPool(viewPool);
                } else {
                    LogUtils.e("Addon null");
                }

                addonViewHolder.tvAddonName.setOnClickListener(view -> {
                    if (expandedPosition == position) {
                        expandedPosition = -1;
                    } else {
                        expandedPosition = position;
                    }
                    notifyDataSetChanged();
                });
                addonViewHolder.ivCollapseImage.setOnClickListener(view -> {
                    if (expandedPosition == position) {
                        productAddon.isExpended = false;
                        expandedPosition = -1;
                    } else {
                        expandedPosition = position;
                    }
                    notifyDataSetChanged();
                });
                addonViewHolder.subAddonListener = new RecyclerviewAddonItemClickListener() {
                    @Override
                    public void onItemClick(int subAddonPosition, Object data) {
                      /*  Addon subAddon = (Addon) data;
                        subAddon.selected = !subAddon.selected;
                        if (subAddon.selected) {
                            if (productAddon.selectedQuantity >= productAddon.max_quantity) {
                                subAddon.selected = false;
                                ToastUtils.makeLongToast(mContext, "You can select maximum " + productAddon.max_quantity + " addons");
                                addonViewHolder.subAddonAdapter.notifyDataSetChanged();
                                return;
                            }
                        }

                        if (!subAddon.selected) {
                            productAddon.selectedQuantity = productAddon.selectedQuantity - 1;
                            productAddons.get(position).selectedQuantity = productAddon.selectedQuantity;

                            OrderItemAddon orderItemAddon = new OrderItemAddon();
                            orderItemAddon.addon_id = subAddon.id;
                            productAddon.selectedOrderItemAddon.remove(orderItemAddon);
                        } else {
                            productAddon.selectedQuantity = productAddon.selectedQuantity + 1;
                            productAddons.get(position).selectedQuantity = productAddon.selectedQuantity;
                            subAddon.selected_price = MyApp.calculatedAddonPrice(orderTypeId, subAddon);
                            OrderItemAddon orderItemAddon = new OrderItemAddon();
                            orderItemAddon.addon_id = subAddon.id;
                            orderItemAddon.addon_name = subAddon.name;
                            orderItemAddon.price = subAddon.selected_price;
                            orderItemAddon.quantity = 1;
                            orderItemAddon.total = orderItemAddon.price * orderItemAddon.quantity;
                            orderItemAddon.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
                            productAddon.selectedOrderItemAddon.add(orderItemAddon);
                            if (productAddon.selectedQuantity == productAddon.max_quantity && (position + 1) < getItemCount()) {
                                expandedPosition = expandedPosition + 1;
                            }
                        }

                        notifyDataSetChanged();
                        addonViewHolder.subAddonAdapter.notifyDataSetChanged();*/
                    }

                    @Override
                    public void onAddAddonClick(int subAddonPosition, Object data) {
                        Addon subAddon = (Addon) data;
                        subAddon.selected = !subAddon.selected;
                        // if (subAddon.selected) {
                        if (productAddon.selectedQuantity >= productAddon.max_quantity) {
                            subAddon.selected = false;
                            ToastUtils.makeLongToast(mContext, "You can select maximum " + productAddon.max_quantity + " addons");
                            addonViewHolder.subAddonAdapter.notifyDataSetChanged();
                            return;
                        }
                        //}

                       /* if (!subAddon.selected) {
                            productAddon.selectedQuantity = productAddon.selectedQuantity - 1;
                            productAddons.get(position).selectedQuantity = productAddon.selectedQuantity;

                            OrderItemAddon orderItemAddon = new OrderItemAddon();
                            orderItemAddon.addon_id = subAddon.id;
                            productAddon.selectedOrderItemAddon.remove(orderItemAddon);
                        } else {*/
                        subAddon.quantity = subAddon.quantity + 1;

                        productAddon.selectedQuantity = productAddon.selectedQuantity + 1;
                        productAddons.get(position).selectedQuantity = productAddon.selectedQuantity;
                        subAddon.selected_price = MyApp.calculatedAddonPrice(orderTypeId, subAddon);
                        List<OrderItemAddon> orderItemAddonsList = productAddon.selectedOrderItemAddon.stream().filter(obj -> Objects.equals(obj.addon_id, subAddon.id)).collect(Collectors.toList());
                        if (orderItemAddonsList.isEmpty()) {
                            OrderItemAddon orderItemAddon = new OrderItemAddon();
                            orderItemAddon.addon_id = subAddon.id;
                            orderItemAddon.addon_name = subAddon.name;
                            orderItemAddon.price = subAddon.selected_price;
                            orderItemAddon.quantity = 1;
                            orderItemAddon.total = orderItemAddon.price * orderItemAddon.quantity;
                            orderItemAddon.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
                            productAddon.selectedOrderItemAddon.add(orderItemAddon);
                        } else {
                            OrderItemAddon orderItemAddon = orderItemAddonsList.get(0);
                            orderItemAddon.quantity = orderItemAddon.quantity + 1;
                            orderItemAddon.total = orderItemAddon.price * orderItemAddon.quantity;
                        }
                        if (productAddon.selectedQuantity == productAddon.max_quantity && (position + 1) < getItemCount()) {
                            productAddon.isExpended = false;
                            expandedPosition = expandedPosition + 1;
                        }
//                        }

                        notifyDataSetChanged();
                        addonViewHolder.subAddonAdapter.notifyDataSetChanged();
                    }

                    @Override
                    public void onMinusAddonClick(int subAddonPosition, Object data) {
                        Addon subAddon = (Addon) data;
                        /*if (productAddon.selectedQuantity >= productAddon.max_quantity) {
                            ToastUtils.makeLongToast(mContext, "You can select maximum " + productAddon.max_quantity + " addons");
                            addonViewHolder.subAddonAdapter.notifyDataSetChanged();
                            return;
                        }*/
                        subAddon.quantity = subAddon.quantity - 1;

                        productAddon.selectedQuantity = productAddon.selectedQuantity - 1;
                        productAddons.get(position).selectedQuantity = productAddon.selectedQuantity;
                        subAddon.selected_price = MyApp.calculatedAddonPrice(orderTypeId, subAddon);
                        List<OrderItemAddon> orderItemAddonsList = productAddon.selectedOrderItemAddon.stream().filter(obj -> Objects.equals(obj.addon_id, subAddon.id)).collect(Collectors.toList());
                        if (!orderItemAddonsList.isEmpty()) {
                            OrderItemAddon orderItemAddon = orderItemAddonsList.get(0);
                            orderItemAddon.quantity = orderItemAddon.quantity - 1;
                            if (orderItemAddon.quantity == 0) {
                                productAddon.selectedOrderItemAddon.remove(orderItemAddon);
                            } else {
                                orderItemAddon.total = orderItemAddon.price * orderItemAddon.quantity;
                            }
                        }
                        if (productAddon.selectedQuantity == productAddon.max_quantity && (position + 1) < getItemCount()) {
                            expandedPosition = expandedPosition + 1;
                        }
//                        }

                        notifyDataSetChanged();
                        addonViewHolder.subAddonAdapter.notifyDataSetChanged();
                    }
                };
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return productAddons.size();
    }

    private static class ProductAddonViewHolder extends RecyclerView.ViewHolder {
        private TextView tvAddonName, tvMaxQty;
        private ImageView ivCollapseImage;
        private RecyclerView rvSubAddons;
        private SubAddonAdapterOldDesign subAddonAdapter;
        private MaterialCardView cvMainAddon;
        private ArrayList<Addon> subAddons = new ArrayList<>();
        private RecyclerviewAddonItemClickListener subAddonListener;

        public ProductAddonViewHolder(@NonNull View itemView) {
            super(itemView);
            cvMainAddon = itemView.findViewById(R.id.cvMainAddon);
            rvSubAddons = itemView.findViewById(R.id.rvSubAddons);
            tvAddonName = itemView.findViewById(R.id.tvAddonName);
            ivCollapseImage = itemView.findViewById(R.id.ivCollapseIcon);
            tvMaxQty = itemView.findViewById(R.id.tvMax);

            subAddonAdapter = new SubAddonAdapterOldDesign(subAddons, new RecyclerviewAddonItemClickListener() {
                @Override
                public void onItemClick(int position, Object data) {
                    if (subAddonListener != null) subAddonListener.onItemClick(position, data);
                }

                @Override
                public void onAddAddonClick(int position, Object data) {
                    if (subAddonListener != null) subAddonListener.onAddAddonClick(position, data);
                }

                @Override
                public void onMinusAddonClick(int position, Object data) {
                    if (subAddonListener != null)
                        subAddonListener.onMinusAddonClick(position, data);
                }
            });
            rvSubAddons.setAdapter(subAddonAdapter);
            rvSubAddons.setLayoutManager(new GridLayoutManager(itemView.getContext(), 4));
        }
    }

    public static class EmptyViewHolder extends RecyclerView.ViewHolder {

        public EmptyViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }
}
