package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.ProductIngredient;

import java.util.ArrayList;

public class ProductIngredientsAdapter extends RecyclerView.Adapter<ProductIngredientsAdapter.ViewHolder> {

    private ArrayList<ProductIngredient> productIngredients;
    private RecyclerviewItemClickListener withItemClickListener;
    private RecyclerviewItemClickListener withoutItemClickListener;

    public ProductIngredientsAdapter(ArrayList<ProductIngredient> productIngredients, RecyclerviewItemClickListener withItemClickListener, RecyclerviewItemClickListener withoutItemClickListener) {
        this.productIngredients = productIngredients;
        this.withItemClickListener = withItemClickListener;
        this.withoutItemClickListener = withoutItemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_ingredients, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ProductIngredientsAdapter.ViewHolder holder, int position) {
        try {
            ProductIngredient productIngredient = productIngredients.get(position);
            if(productIngredient.contain){
                holder.cardMain.setCardBackgroundColor(ContextCompat.getColor(holder.cardMain.getContext(),R.color.persian_green));
            }else {
                holder.cardMain.setCardBackgroundColor(ContextCompat.getColor(holder.cardMain.getContext(),R.color.white));
            }
            holder.tvIngredientName.setText(productIngredient.ingredient_name);
            holder.tvIngredientPrice.setText(MyApp.currencySymbol + productIngredient.price);
            holder.tvIngredientQty.setText(String.valueOf(productIngredient.quantity));
            Context context = holder.itemView.getContext();

            if (productIngredient.quantity > 0) {
                if (productIngredient.isAlreadyRemoved) {
                    holder.tvRemoved.setVisibility(View.VISIBLE);
                    holder.tvRemove.setVisibility(View.INVISIBLE);
                    holder.rlPlusModified.setVisibility(View.VISIBLE);
                    holder.rlMinusModify.setVisibility(View.INVISIBLE);
                    holder.tvIngredientQty.setVisibility(View.GONE);
                } else {
                    holder.tvRemoved.setVisibility(View.GONE);
                    if (productIngredient.without) {
                        holder.tvRemove.setVisibility(View.VISIBLE);
                    } else {
                        holder.tvRemove.setVisibility(View.INVISIBLE);
                    }
                    if (productIngredient.with) {
                        holder.rlPlusModified.setVisibility(View.VISIBLE);
                    } else {
                        holder.rlPlusModified.setVisibility(View.INVISIBLE);
                    }
                    holder.rlMinusModify.setVisibility(View.VISIBLE);
                    holder.tvIngredientQty.setVisibility(View.VISIBLE);

                }
            } else {
                holder.tvRemoved.setVisibility(View.GONE);
                holder.tvIngredientQty.setVisibility(View.VISIBLE);
                if (productIngredient.with) {
                    holder.rlPlusModified.setVisibility(View.VISIBLE);
                } else {
                    holder.rlPlusModified.setVisibility(View.INVISIBLE);
                }
                if (productIngredient.without) {
                    holder.rlMinusModify.setVisibility(View.VISIBLE);
                    holder.tvRemove.setVisibility(View.VISIBLE);
                } else {
                    holder.rlMinusModify.setVisibility(View.INVISIBLE);
                    holder.tvRemove.setVisibility(View.INVISIBLE);
                }
            }

            if (!holder.ivMinus.isEnabled()) {
                holder.rlMinusModify.getBackground().setTint(context.getResources().getColor(R.color.light_gray));
            } else {
                holder.rlMinusModify.getBackground().setTint(context.getResources().getColor(R.color.reject_color));
            }

            holder.rlPlusModified.setOnClickListener(v -> {
                if (productIngredient.isAlreadyRemoved) {
                    productIngredient.quantity = 0;
                    productIngredient.isAlreadyRemoved = false;
                } else {
                    productIngredient.quantity++;
                }
                notifyDataSetChanged();
            });

            holder.rlMinusModify.setOnClickListener(v -> {
                if (productIngredient.quantity > 0 && !productIngredient.isAlreadyRemoved) {
                    productIngredient.quantity--;
                    productIngredient.isAlreadyRemoved = false;
                } else {
                    // Without
                    productIngredient.quantity = 1;
                    productIngredient.isAlreadyRemoved = true;

                }
                if (withoutItemClickListener != null) {
                    withoutItemClickListener.onItemClick(position, productIngredient);
                }
                notifyDataSetChanged();
            });
            holder.tvRemove.setOnClickListener(view -> {
                productIngredient.quantity = 1;
                holder.tvRemove.setVisibility(View.INVISIBLE);
                productIngredient.isAlreadyRemoved = true;
                notifyDataSetChanged();

                if (withoutItemClickListener != null) {
                    withoutItemClickListener.onItemClick(position, productIngredient);
                }
            });
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return productIngredients.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvIngredientName, tvIngredientPrice, tvRemove, tvRemoved, tvIngredientQty;
        ImageView ivMinus, ivPlus;
        MaterialCardView cardMain;
        RelativeLayout rlMinusModify, rlPlusModified;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvRemove = itemView.findViewById(R.id.tvRemove);
            tvRemoved = itemView.findViewById(R.id.tvRemoved);
            cardMain = itemView.findViewById(R.id.cardMain);
            tvIngredientName = itemView.findViewById(R.id.tvIngredientName);
            tvIngredientPrice = itemView.findViewById(R.id.tvIngredientPrice);
            ivMinus = itemView.findViewById(R.id.ivMinusModified);
            ivPlus = itemView.findViewById(R.id.ivPlusModified);
            rlMinusModify = itemView.findViewById(R.id.rlMinusModified);
            rlPlusModified = itemView.findViewById(R.id.rlPlusModified);
            tvIngredientQty = itemView.findViewById(R.id.tvIngredientQty);
        }
    }
}
