package com.ubsidi.epos_2021.adapters;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.OrderHistory;

import java.util.ArrayList;

/**
 * Created by Amrish on 18-09-2020.
 */
public class RecentOrdersAdapter extends RecyclerView.Adapter<RecentOrdersAdapter.RestaurantViewHolder> {


    private ArrayList<OrderHistory> recentOrders;
    private RecyclerviewItemClickListener recyclerViewItemClickListener;

    public RecentOrdersAdapter(ArrayList<OrderHistory> recentOrders, RecyclerviewItemClickListener recyclerViewItemClickListener) {
        this.recentOrders = recentOrders;
        this.recyclerViewItemClickListener = recyclerViewItemClickListener;
    }

    @NonNull
    @Override
    public RestaurantViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new RestaurantViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_recent_orders_customer, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RestaurantViewHolder holder, int position) {
        try {
            OrderHistory order = recentOrders.get(position);
            holder.tvRestaurant.setText(order.customer_name);
            holder.tvOrderId.setText("Order #" + order.id);

            if (!Validators.isNullOrEmpty(order.payment_method)) {

                if (order.payment_method.equalsIgnoreCase("stripe"))
                    holder.tvPaymentMode.setText("Credit/Debit Card");

                else if (order.payment_method.equalsIgnoreCase("paypal"))
                    holder.tvPaymentMode.setText("PayPal");

                else if (order.payment_method.equalsIgnoreCase("credit") || order.payment_method.equalsIgnoreCase("wallet"))
                    holder.tvPaymentMode.setText("TiffinTom credit");

                else
                    holder.tvPaymentMode.setText("Cash on delivery");
            }

            holder.tvOrderTotal.setText("Total: " + MyApp.currencySymbol + MyApp.df.format(order.order_grand_total));

            holder.itemView.setOnClickListener(view -> {
                if (recyclerViewItemClickListener != null)
                    recyclerViewItemClickListener.onItemClick(position, order);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return recentOrders.size();
    }

    protected static class RestaurantViewHolder extends RecyclerView.ViewHolder {
        private TextView tvRestaurant, tvOrderId, tvOrderDate, tvOrderTotal, tvPaymentMode;

        public RestaurantViewHolder(@NonNull View itemView) {
            super(itemView);
            tvOrderId = itemView.findViewById(R.id.tvOrderNumber);
            tvOrderTotal = itemView.findViewById(R.id.tvOrderTotal);
            tvOrderDate = itemView.findViewById(R.id.tvOrderDate);
            tvRestaurant = itemView.findViewById(R.id.tvRestaurant);
            tvPaymentMode = itemView.findViewById(R.id.tvPaymentType);
        }
    }
}
