package com.ubsidi.epos_2021.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListener;
import com.ubsidi.epos_2021.models.RecyclerMenuItem;

import java.util.ArrayList;

public class RecyclerMenuAdapter extends RecyclerView.Adapter<RecyclerMenuAdapter.ViewHolder> {

    private ArrayList<RecyclerMenuItem> paymentList;
    private RecyclerviewItemClickListener recyclerviewItemClickListener;
    public String checkedId=""; // assigning blank , ref from firebase issue
    private boolean checkable = false;
    public boolean collapsed = false;

    public RecyclerMenuAdapter(ArrayList<RecyclerMenuItem> paymentList, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.paymentList = paymentList;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    public RecyclerMenuAdapter(ArrayList<RecyclerMenuItem> paymentList, boolean checkable, RecyclerviewItemClickListener recyclerviewItemClickListener) {
        this.paymentList = paymentList;
        this.checkable = checkable;
        this.recyclerviewItemClickListener = recyclerviewItemClickListener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_recycler_menu, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerMenuAdapter.ViewHolder holder, int position) {

        try {
            RecyclerMenuItem exclusionModel = paymentList.get(position);
            holder.tvName.setText(exclusionModel.title);
            holder.tvCount.setText(String.valueOf(exclusionModel.count));

            Context context = holder.itemView.getContext();
            if (exclusionModel.drawable == 0) {
                holder.ivMenu.setVisibility(View.GONE);
            } else {
                holder.ivMenu.setImageResource(exclusionModel.drawable);
                holder.ivMenu.setVisibility(View.VISIBLE);
            }
            if (exclusionModel.count == 0) {
                holder.tvCount.setVisibility(View.GONE);
                holder.vDot.setVisibility(View.GONE);
            } else {
                holder.tvCount.setText(String.valueOf(exclusionModel.count));
                if (collapsed) {
                    holder.vDot.setVisibility(View.VISIBLE);
                    holder.tvCount.setVisibility(View.GONE);
                } else {
                    holder.tvCount.setVisibility(View.VISIBLE);
                    holder.vDot.setVisibility(View.GONE);
                }
            }

            if (exclusionModel.id.equalsIgnoreCase(checkedId)) {
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.white));
                holder.cvMenu.setCardBackgroundColor(ContextCompat.getColor(context, R.color.persian_green));
    //            holder.vDot.setBackgroundResource(R.drawable.dot_white_circle);
                holder.tvCount.setBackgroundResource(R.drawable.dot_white_circle);
                holder.tvCount.setTextColor(ContextCompat.getColor(context, R.color.persian_green));
                holder.ivMenu.setColorFilter(ContextCompat.getColor(context, R.color.white));
                if (collapsed && exclusionModel.count > 0) {
                    holder.cvMenu.setCardElevation(4);
                } else {
                    holder.cvMenu.setCardElevation(0);
                }
            } else {
                holder.cvMenu.setCardElevation(0);
                holder.tvName.setTextColor(ContextCompat.getColor(context, R.color.light_black));
    //            holder.vDot.setBackgroundResource(R.drawable.dot_perisian_green_circle);
                holder.tvCount.setBackgroundResource(R.drawable.dot_perisian_green_circle);
                holder.tvCount.setTextColor(ContextCompat.getColor(context, R.color.white));
                holder.cvMenu.setCardBackgroundColor(ContextCompat.getColor(context, R.color.white));
                holder.ivMenu.setColorFilter(ContextCompat.getColor(context, R.color.light_black));
            }

            if (collapsed) {
                holder.tvName.setVisibility(View.GONE);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                holder.cvMenu.setLayoutParams(layoutParams);
            } else {
                holder.tvName.setVisibility(View.VISIBLE);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                holder.cvMenu.setLayoutParams(layoutParams);
            }
            holder.cvMenu.setOnClickListener(v -> {
                if (checkable && exclusionModel.isCheckable) {
                    checkedId = exclusionModel.id;
                    notifyDataSetChanged();
                }
                if (recyclerviewItemClickListener != null) {
                    recyclerviewItemClickListener.onItemClick(position, exclusionModel);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return paymentList.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvName, tvCount;
        private ImageView ivMenu;
        private MaterialCardView cvMenu;
        private LinearLayout llMenu;
        private View vDot;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tvName);
            tvCount = itemView.findViewById(R.id.tvCount);
            ivMenu = itemView.findViewById(R.id.ivMenu);
            cvMenu = itemView.findViewById(R.id.cvMenu);
            vDot = itemView.findViewById(R.id.vDot);
            llMenu = itemView.findViewById(R.id.llMenu);
        }
    }
}
